/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.gui.dialogs.permissionsadmin.groups;

import com.arcway.cockpit.client.base.interfaces.frame.IProjectAgent;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeType;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.ICockpitDataType;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.core.permissions.AllAttributeModificationPermissionTemplate;
import com.arcway.cockpit.frame.client.project.core.permissions.AttributeModificationPermissionTemplate;
import com.arcway.cockpit.frame.client.project.core.permissions.CockpitPermissionTemplate;
import com.arcway.cockpit.frame.client.project.modules.IModuleProjectAgent;
import com.arcway.cockpit.frame.client.project.modules.permissionproviders.IPermissionTemplateCategory;
import com.arcway.cockpit.frame.client.project.modules.permissionproviders.IProjectPermissionsGroup;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractPermissionsGroup
implements IProjectPermissionsGroup {
    private final Map categories = new HashMap();

    protected Collection getAttributeTemplates(IFrameProjectAgent projectAgent, ICockpitDataType dataType, String parentOperandTypeID) {
        ArrayList<CockpitPermissionTemplate> templates = new ArrayList<CockpitPermissionTemplate>();
        templates.add(AllAttributeModificationPermissionTemplate.getAllAttrTemplate(dataType, parentOperandTypeID, true));
        ArrayList attributeTypes = new ArrayList(dataType.getAttributeTypes((IProjectAgent)projectAgent));
        for (Object element : attributeTypes) {
            IAttributeType attributeType = (IAttributeType)element;
            if (!attributeType.restrictedAccess()) continue;
            templates.add(AbstractPermissionsGroup.getAttributeTemplates(projectAgent, attributeType, parentOperandTypeID));
        }
        return templates;
    }

    private static AttributeModificationPermissionTemplate getAttributeTemplates(IFrameProjectAgent projectAgent, IAttributeType attributeType, String parentOperandTypeID) {
        AttributeModificationPermissionTemplate template = projectAgent.getFrameUserDefinedAttributeTypesManager().getPermissionsTemplate(attributeType, parentOperandTypeID);
        return template;
    }

    protected IPermissionTemplateCategory getCategory(final String id, final String displayName) {
        IPermissionTemplateCategory category = (IPermissionTemplateCategory)this.categories.get(id);
        if (category == null) {
            category = new IPermissionTemplateCategory(){

                @Override
                public String getID() {
                    return id;
                }

                @Override
                public String getDisplayName() {
                    return displayName;
                }
            };
            this.categories.put(id, category);
        }
        return category;
    }

    @Override
    public Object getTreeViewerInput(IModuleProjectAgent projectAgent) {
        return projectAgent;
    }
}

