/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.gui.dialogs;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.ObjectTypeCategoryID;
import com.arcway.cockpit.frame.client.global.Messages;
import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.global.gui.views.project.ProjectTreeContentProvider;
import com.arcway.cockpit.frame.client.global.gui.views.project.ProjectViewSorter;
import com.arcway.cockpit.frame.client.global.gui.views.uniqueelement2.UEListLabelProvider;
import com.arcway.cockpit.frame.client.project.ProjectAgent;
import com.arcway.cockpit.frame.client.project.core.categories.ObjectTypeCategory;
import com.arcway.cockpit.frame.client.project.core.constructionelements.IConstructionElementTypeDescription;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.IUniqueElement;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.detailsprovider.ContainingPlansContentProvider;
import com.arcway.cockpit.frame.client.project.planagents.IPlanAgentProjectAgent;
import com.arcway.cockpit.frame.client.project.planagents.IPlanAgentUniqueElementManager;
import com.arcway.lib.eclipse.gui.viewers.CachingLabelProvider;
import com.arcway.lib.java.Equals;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.ui.editor.ObjectTypeCategoryLabels;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.internal.misc.StringMatcher;

public class CreatePlanElementDialog
extends Dialog
implements IDoubleClickListener,
ISelectionChangedListener,
ModifyListener {
    private static final ILogger logger = Logger.getLogger(CreatePlanElementDialog.class);
    public static final int MODE_CREATE_PLAN_ELEMENT = 1;
    public static final int MODE_MAKE_UNIQUE = 2;
    public static final int MODE_RENAME_UNIQUE_ELEMENT = 3;
    public static final int MODE_RENAME_LOCAL_ELEMENT = 4;
    public static final int BUTTON_ASSIGN = 16000;
    public static final int BUTTON_CREATE = 16001;
    public static final int BUTTON_RENAME = 16002;
    private final String initialName;
    private final IUniqueElement[] uniqueElements;
    private final Map<String, IUniqueElement> uniqueElementsMap;
    private final IConstructionElementTypeDescription constructionElementType;
    private String typedElementName = "";
    private final IUniqueElement originalUE;
    private boolean makeUnique;
    private final boolean canSwitchMakeUnique;
    private final boolean allowInitialName;
    private final boolean allowAssign;
    private final boolean allowCreate;
    private final boolean allowRename;
    private Text elementNameWidget;
    private Button makeUniqueButton;
    private TreeViewer uniqueElementListViewer;
    private IUniqueElement selectedElement = null;
    private final String projectUID;
    private final String dialogTitle;
    private final String renameLabel;
    private final List<ObjectTypeCategory> categories;
    private Combo categoryCombo;
    private ObjectTypeCategory selectedCategory = null;
    private ObjectTypeCategoryID lastManuallySelectedCategoryID = null;
    private TreeViewer occurencesTreeViewer;

    public CreatePlanElementDialog(Shell parentShell, IUniqueElement originalUE, List<? extends IUniqueElement> uniqueElements, IConstructionElementTypeDescription constructionElementType, String defaultName, IPlanAgentProjectAgent projectAgent, int operationType) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        assert (projectAgent != null);
        assert (projectAgent.isOpened());
        this.projectUID = projectAgent.getProjectUID();
        this.originalUE = originalUE;
        this.uniqueElements = uniqueElements.toArray(new IUniqueElement[uniqueElements.size()]);
        this.uniqueElementsMap = new HashMap<String, IUniqueElement>(uniqueElements.size());
        for (IUniqueElement iUniqueElement : uniqueElements) {
            this.uniqueElementsMap.put(iUniqueElement.getElementName(), iUniqueElement);
        }
        this.constructionElementType = constructionElementType;
        this.initialName = defaultName;
        switch (operationType) {
            case 1: {
                this.makeUnique = constructionElementType.isOfCategoryAlwaysUnique() || constructionElementType.isOfCategoryPreferredUnique();
                this.canSwitchMakeUnique = constructionElementType.isOfCategoryPreferredNotUnique() || constructionElementType.isOfCategoryPreferredUnique();
                this.allowInitialName = true;
                this.allowAssign = true;
                this.allowCreate = true;
                this.allowRename = false;
                this.dialogTitle = Messages.getString("CreatePlanElementDialog.Create_7");
                this.renameLabel = Messages.getString("CreatePlanElementDialog.Button.renameGlobally");
                break;
            }
            case 2: {
                this.makeUnique = !constructionElementType.isOfCategoryNeverUnique();
                this.canSwitchMakeUnique = constructionElementType.isOfCategoryPreferredNotUnique() || constructionElementType.isOfCategoryPreferredUnique();
                this.allowInitialName = true;
                this.allowAssign = true;
                this.allowCreate = true;
                this.allowRename = false;
                this.dialogTitle = Messages.getString("CreatePlanElementDialog.make_unique");
                this.renameLabel = Messages.getString("CreatePlanElementDialog.Button.renameGlobally");
                break;
            }
            case 3: {
                this.makeUnique = true;
                this.canSwitchMakeUnique = false;
                this.allowInitialName = false;
                this.allowAssign = true;
                this.allowCreate = true;
                this.allowRename = true;
                this.dialogTitle = Messages.getString("CreatePlanElementDialog.rename");
                this.renameLabel = Messages.getString("CreatePlanElementDialog.Button.renameGlobally");
                break;
            }
            case 4: {
                this.makeUnique = false;
                this.canSwitchMakeUnique = false;
                this.allowInitialName = true;
                this.allowAssign = false;
                this.allowCreate = false;
                this.allowRename = true;
                this.dialogTitle = Messages.getString("CreatePlanElementDialog.rename");
                this.renameLabel = Messages.getString("CreatePlanElementDialog.Button.renameLocally");
                break;
            }
            default: {
                assert (false) : "CreatePlanElementDialog - Invalid operation mode!";
                this.makeUnique = false;
                this.canSwitchMakeUnique = false;
                this.allowInitialName = false;
                this.allowAssign = false;
                this.allowCreate = false;
                this.allowRename = false;
                this.dialogTitle = "CreatePlanElementDialog - Invalid operation mode!";
                this.renameLabel = Messages.getString("CreatePlanElementDialog.Button.renameGlobally");
            }
        }
        this.categories = ProjectMgr.getProjectMgr().getProjectAgent(this.projectUID).getObjectTypeCategoriesManager().getAllCategoriesForObjectTypeSorted("com.arcway.cockpit.uniqueelement");
        this.categories.add(0, null);
        IUniqueElement iUniqueElement = this.uniqueElementsMap.get(defaultName);
        if (iUniqueElement != null) {
            this.lastManuallySelectedCategoryID = iUniqueElement.getCategoryID();
        }
    }

    protected Control createDialogArea(Composite parent) {
        parent.getShell().setText(this.dialogTitle);
        Composite childComposite = new Composite(parent, 16);
        childComposite.setLayout((Layout)new GridLayout());
        GridData layoutData = new GridData(1808);
        childComposite.setLayoutData((Object)layoutData);
        Label lblElementName = new Label(childComposite, 0);
        lblElementName.setLayoutData((Object)new GridData());
        this.elementNameWidget = new Text(childComposite, 2048);
        this.elementNameWidget.setLayoutData((Object)new GridData(768));
        this.elementNameWidget.addModifyListener((ModifyListener)this);
        if (this.makeUnique || this.canSwitchMakeUnique) {
            lblElementName.setText(Messages.getString("CreatePlanElementDialog.Element_Name_(__any_character,_*_any_string)_2"));
            Label lblCategory = new Label(childComposite, 0);
            lblCategory.setText(Messages.getString("CreatePlanElementDialog.SelectCategory"));
            this.categoryCombo = new Combo(childComposite, 8);
            this.categoryCombo.add(ObjectTypeCategoryLabels.LABEL_DEFAULTCATEGORY);
            int i = 1;
            while (i < this.categories.size()) {
                this.categoryCombo.add(this.categories.get(i).getDisplayName());
                ++i;
            }
            this.categoryCombo.setLayoutData((Object)new GridData(4, 4, true, false));
            this.categoryCombo.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    CreatePlanElementDialog.this.selectedCategory = (ObjectTypeCategory)CreatePlanElementDialog.this.categories.get(CreatePlanElementDialog.this.categoryCombo.getSelectionIndex());
                    if (CreatePlanElementDialog.this.selectedCategory != null) {
                        CreatePlanElementDialog.this.lastManuallySelectedCategoryID = CreatePlanElementDialog.this.selectedCategory.getObjectTypeCategoryID();
                    } else {
                        CreatePlanElementDialog.this.lastManuallySelectedCategoryID = null;
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }
            });
            this.categoryCombo.select(0);
            this.makeUniqueButton = new Button(childComposite, 32);
            this.makeUniqueButton.setSelection(this.makeUnique);
            this.makeUniqueButton.setText(Messages.getString("CreatePlanElementDialog.Make_Unique_3"));
            this.makeUniqueButton.setEnabled(this.canSwitchMakeUnique);
            this.makeUniqueButton.setLayoutData((Object)new GridData());
            this.makeUniqueButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    CreatePlanElementDialog.this.uniqueElementListViewer.resetFilters();
                    CreatePlanElementDialog.this.uniqueElementListViewer.addFilter((ViewerFilter)new UEListChosenNameFilter());
                    CreatePlanElementDialog.this.updateWidgets(true);
                }
            });
            Label availableUniqueElements = new Label(childComposite, 0);
            availableUniqueElements.setText(Messages.getString("CreatePlanElementDialog.Existing_Unique_Elements__4"));
            GridData gd = new GridData(512);
            gd.horizontalSpan = 2;
            availableUniqueElements.setLayoutData((Object)gd);
            Composite uniqueElementComposite = new Composite(childComposite, 0);
            uniqueElementComposite.setLayout((Layout)new FillLayout());
            GridData gd2 = new GridData(1808);
            gd2.horizontalSpan = 2;
            gd2.heightHint = 250;
            gd2.minimumHeight = 250;
            uniqueElementComposite.setLayoutData((Object)gd2);
            this.uniqueElementListViewer = new TreeViewer(uniqueElementComposite, 2816);
            this.uniqueElementListViewer.setContentProvider((IContentProvider)new ContentProvider());
            ProjectAgent project = ProjectMgr.getProjectMgr().getProjectAgent(this.projectUID);
            this.uniqueElementListViewer.setLabelProvider((IBaseLabelProvider)new CachingLabelProvider((ILabelProvider)new UEListLabelProvider(project)));
            this.uniqueElementListViewer.addSelectionChangedListener((ISelectionChangedListener)this);
            this.uniqueElementListViewer.addDoubleClickListener((IDoubleClickListener)this);
            this.uniqueElementListViewer.setSorter((ViewerSorter)new UESorter());
            this.uniqueElementListViewer.addFilter((ViewerFilter)new UEListChosenNameFilter());
            this.uniqueElementListViewer.setInput((Object)this);
            if (this.originalUE != null) {
                Label lowerTitle = new Label(childComposite, 0);
                lowerTitle.setText(NLS.bind((String)Messages.getString("CreatePlanElementDialog.Occurrences"), (Object)this.originalUE.getElementName()));
                this.occurencesTreeViewer = new TreeViewer(childComposite, 2816);
                GridData layoutData2 = new GridData(4, 128, true, false);
                layoutData2.minimumHeight = 100;
                layoutData2.heightHint = 100;
                this.occurencesTreeViewer.getTree().setLayoutData((Object)layoutData2);
                this.occurencesTreeViewer.getTree().setLayout((Layout)new GridLayout());
                this.occurencesTreeViewer.setContentProvider((IContentProvider)new ContainingPlansContentProvider(this.originalUE));
                this.occurencesTreeViewer.setLabelProvider((IBaseLabelProvider)new ProjectTreeContentProvider(null));
                this.occurencesTreeViewer.setSorter((ViewerSorter)ProjectViewSorter.getSingleton());
                ProjectAgent projectAgent = ProjectMgr.getProjectMgr().getProjectAgent(this.projectUID);
                this.occurencesTreeViewer.setInput((Object)projectAgent);
                this.occurencesTreeViewer.expandAll();
            }
        } else {
            lblElementName.setText("");
        }
        this.updateWidgets(false);
        return childComposite;
    }

    public void modifyText(ModifyEvent e) {
        this.selectedElement = null;
        this.updateWidgets(true);
    }

    private void updateWidgets(boolean refresh) {
        boolean renameEnabled;
        this.uniqueElementListViewer.getTree().setRedraw(false);
        this.typedElementName = this.elementNameWidget.getText().trim();
        assert (this.typedElementName != null) : "element name must not be null";
        if (refresh && this.uniqueElementListViewer != null) {
            this.uniqueElementListViewer.refresh(true);
        }
        if (this.makeUniqueButton != null) {
            this.makeUnique = this.makeUniqueButton.getSelection();
        }
        ProjectAgent projectAgent = ProjectMgr.getProjectMgr().getProjectAgent(this.projectUID);
        IPlanAgentUniqueElementManager ueMgr = projectAgent.getPlanAgentUniqueElementManager();
        IUniqueElement existingUE = ueMgr.getUniqueElement(this.typedElementName, this.constructionElementType.getConstructionElementTypeID());
        Button assignButton = this.getButton(16000);
        boolean assignEnabled = assignButton != null && this.makeUnique && existingUE != null && (this.allowInitialName || !this.typedElementName.equals(this.initialName));
        Button createButton = this.getButton(16001);
        boolean createEnabled = !(createButton == null || this.makeUnique && existingUE != null || this.makeUnique && this.typedElementName.length() <= 0 || !this.allowInitialName && this.typedElementName.equals(this.initialName));
        Button renameButton = this.getButton(16002);
        boolean bl = renameEnabled = !(renameButton == null || this.makeUnique && existingUE != null || this.makeUnique && this.typedElementName.length() <= 0 || !this.allowInitialName && this.typedElementName.equals(this.initialName));
        if (assignButton != null) {
            assignButton.setEnabled(assignEnabled);
        }
        if (createButton != null) {
            createButton.setEnabled(createEnabled);
        }
        if (renameButton != null) {
            renameButton.setEnabled(renameEnabled);
        }
        Button defaultButton = assignButton;
        if (!assignEnabled) {
            if (createEnabled && !renameEnabled) {
                defaultButton = createButton;
            } else if (!createEnabled && renameEnabled) {
                defaultButton = renameButton;
            }
        }
        this.getShell().setDefaultButton(defaultButton);
        IUniqueElement existantUniqueElement = this.uniqueElementsMap.get(this.typedElementName);
        if (existantUniqueElement != null) {
            this.setCategoryComboy(existantUniqueElement.getCategoryID());
        } else {
            this.setCategoryComboy(this.lastManuallySelectedCategoryID);
        }
        if (existantUniqueElement != null || !this.makeUnique) {
            if (this.categoryCombo.isEnabled()) {
                this.categoryCombo.setEnabled(false);
            }
        } else if (!this.categoryCombo.isEnabled()) {
            this.categoryCombo.setEnabled(true);
        }
        this.uniqueElementListViewer.getTree().setRedraw(true);
    }

    public String getElementName() {
        if (this.selectedElement != null) {
            return this.selectedElement.getElementName();
        }
        return this.typedElementName;
    }

    public boolean makeUnique() {
        return this.makeUnique;
    }

    public ObjectTypeCategory getObjectTypeCategory() {
        return this.selectedCategory;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        IStructuredSelection sel = (IStructuredSelection)event.getSelection();
        if (sel.isEmpty()) {
            this.selectedElement = null;
        } else {
            this.makeUniqueButton.setSelection(true);
            this.selectedElement = (IUniqueElement)sel.getFirstElement();
            this.elementNameWidget.removeModifyListener((ModifyListener)this);
            this.elementNameWidget.setText(this.selectedElement.getElementName());
            this.elementNameWidget.addModifyListener((ModifyListener)this);
        }
        this.updateWidgets(false);
    }

    public void doubleClick(DoubleClickEvent event) {
        if (this.uniqueElementListViewer == null) {
            logger.error("CreatePlanElementDialog.selectionChanged() - uniqueElementList was null!");
            return;
        }
        IStructuredSelection selection = (IStructuredSelection)this.uniqueElementListViewer.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        IUniqueElement selectedUniqueElement = (IUniqueElement)selection.getFirstElement();
        this.elementNameWidget.setText(selectedUniqueElement.getElementName());
        this.makeUniqueButton.setSelection(true);
        this.makeUnique = true;
        this.close();
    }

    protected Point getInitialSize() {
        return new Point(600, 640);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        if (this.allowAssign) {
            this.createButton(parent, 16000, Messages.getString("CreatePlanElementDialog.Button.assign"), this.allowAssign);
        }
        if (this.allowCreate) {
            this.createButton(parent, 16001, Messages.getString("CreatePlanElementDialog.Button.create"), false);
        }
        if (this.allowRename) {
            this.createButton(parent, 16002, this.renameLabel, !this.allowAssign && !this.allowCreate && this.allowRename);
        }
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void buttonPressed(int buttonId) {
        this.setReturnCode(buttonId);
        this.close();
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        if (this.initialName != null) {
            this.elementNameWidget.setFocus();
            this.elementNameWidget.removeModifyListener((ModifyListener)this);
            this.elementNameWidget.setText(this.initialName);
            this.elementNameWidget.selectAll();
            this.typedElementName = this.initialName;
            this.elementNameWidget.addModifyListener((ModifyListener)this);
        }
        this.updateWidgets(false);
        return control;
    }

    private void setCategoryComboy(ObjectTypeCategoryID catID) {
        if (catID == null) {
            this.categoryCombo.select(0);
            this.selectedCategory = null;
        } else {
            int i = 1;
            while (i < this.categories.size()) {
                if (Equals.equals((Object)catID, (Object)this.categories.get(i).getObjectTypeCategoryID())) {
                    this.categoryCombo.select(i);
                    this.selectedCategory = this.categories.get(i);
                    break;
                }
                ++i;
            }
        }
    }

    private class ContentProvider
    implements ITreeContentProvider {
        private ContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            assert (inputElement == CreatePlanElementDialog.this);
            return CreatePlanElementDialog.this.uniqueElements;
        }

        public Object[] getChildren(Object parentElement) {
            return null;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return false;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class UEListChosenNameFilter
    extends ViewerFilter {
        private final HashMap<String, StringMatcher> matcherCache = new HashMap();

        private UEListChosenNameFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            assert (element instanceof IUniqueElement);
            IUniqueElement ue = (IUniqueElement)element;
            String chosenName = CreatePlanElementDialog.this.elementNameWidget.getText();
            if (chosenName.length() < 2) {
                return true;
            }
            String name = ue.getElementName();
            String pattern = "*" + chosenName + "*";
            StringMatcher sm = this.matcherCache.get(pattern);
            if (sm == null) {
                sm = new StringMatcher(pattern, true, false);
                this.matcherCache.put(pattern, sm);
            }
            return sm.match(name);
        }
    }

    private static class UESorter
    extends ViewerSorter {
        private UESorter() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            IUniqueElement ue1 = (IUniqueElement)e1;
            IUniqueElement ue2 = (IUniqueElement)e2;
            return ue1.getElementName().compareToIgnoreCase(ue2.getElementName());
        }
    }
}

