/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.gui.dialogs;

import com.arcway.cockpit.frame.client.global.Messages;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import de.plans.psc.shared.message.EOGroup;
import de.plans.psc.shared.message.EOUser;
import de.plans.psc.shared.message.IPermissionOwner;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.FilteredList;
import org.eclipse.ui.dialogs.SelectionDialog;

public class ChoosePermissionOwnerDialog
extends SelectionDialog {
    public static final int TYPE_USER = 0;
    public static final int TYPE_GROUP = 1;
    public static final int TYPE_STAKEHOLDER_ROLE = 2;
    private static final int MIN_SHELL_SIZE_X = 470;
    private static final int MIN_SHELL_SIZE_Y = 350;
    private static final int widthInChars = 80;
    private static final int heightInChars = 20;
    private ILabelProvider fLabelProvider;
    private Object[] fElements;
    private FilteredList fList;

    public ChoosePermissionOwnerDialog(Shell parentShell, IFrameProjectAgent projectAgent, String title, String message, int permissionOwnerType, boolean showAdministrators) {
        super(parentShell);
        this.setTitle(title);
        this.setMessage(message);
        this.fLabelProvider = new LabelProvider(){

            public String getText(Object element) {
                if (!$assertionsDisabled && !(element instanceof IPermissionOwner)) {
                    throw new AssertionError();
                }
                IPermissionOwner pOwner = (IPermissionOwner)element;
                return pOwner.getPermissionOwnerName();
            }
        };
        TreeSet<IPermissionOwner> sortedList = new TreeSet<IPermissionOwner>(new Comparator<IPermissionOwner>(){

            @Override
            public int compare(IPermissionOwner p0, IPermissionOwner p1) {
                return p0.getPermissionOwnerName().compareToIgnoreCase(p1.getPermissionOwnerName());
            }
        });
        switch (permissionOwnerType) {
            case 0: {
                for (EOUser user : projectAgent.getFrameServerProxy().getAllServerUsers()) {
                    if (!showAdministrators && user.getUserName().equals("Administrator")) continue;
                    sortedList.add((IPermissionOwner)user);
                }
                break;
            }
            case 1: {
                for (EOGroup group : projectAgent.getFrameServerProxy().getAllServerGroups()) {
                    if (!showAdministrators && group.getGroupName().equals("Administrators")) continue;
                    sortedList.add((IPermissionOwner)group);
                }
                break;
            }
            case 2: {
                sortedList.addAll(projectAgent.getFrameStakeholderManager().getRoles());
            }
        }
        this.fElements = sortedList.toArray();
    }

    protected Point getInitialSize() {
        return new Point(40 + this.convertWidthInCharsToPixels(80), 100 + this.convertHeightInCharsToPixels(20));
    }

    protected Control createDialogArea(Composite container) {
        this.getShell().setMinimumSize(470, 350);
        Composite parent = (Composite)super.createDialogArea(container);
        Label messageLabel = this.createMessageArea(parent);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).applyTo((Control)messageLabel);
        Composite childComposite = new Composite(parent, 16);
        childComposite.setLayout((Layout)new GridLayout(2, false));
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).applyTo((Control)childComposite);
        Label lblFilter = new Label(childComposite, 0);
        GridDataFactory.fillDefaults().align(1, 4).grab(false, false).applyTo((Control)lblFilter);
        lblFilter.setText(Messages.getString("ChoosePermissionOwnerDialog.Filter"));
        final Text txtFilter = new Text(childComposite, 2048);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).applyTo((Control)txtFilter);
        this.fList = new FilteredList(parent, 2050, this.fLabelProvider, true, true, true);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)this.fList);
        this.fList.setElements(this.fElements);
        this.fList.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                ChoosePermissionOwnerDialog.this.okPressed();
            }

            public void widgetSelected(SelectionEvent e) {
            }
        });
        List initialSelection = this.getInitialElementSelections();
        if (initialSelection != null) {
            this.fList.setSelection(initialSelection.toArray());
        }
        this.fList.setFont(container.getFont());
        txtFilter.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String filterText = "*" + txtFilter.getText().toLowerCase();
                ChoosePermissionOwnerDialog.this.fList.setFilter(filterText);
            }
        });
        return parent;
    }

    protected void okPressed() {
        this.setResult(Arrays.asList(this.fList.getSelection()));
        super.okPressed();
    }
}

