/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.gui.copypaste;

import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.global.gui.Messages;
import com.arcway.cockpit.frame.client.global.gui.ProjectSelectionAnalyser;
import com.arcway.cockpit.frame.client.global.gui.copypaste.ClipboardManager;
import com.arcway.cockpit.frame.client.global.gui.copypaste.CopyManager;
import com.arcway.cockpit.frame.client.global.gui.copypaste.ICopyConfiguration;
import com.arcway.cockpit.frame.client.global.gui.dialogs.SaveDirtyEditorsDialogUtil;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.lib.java.collections.HashSet_;
import com.arcway.lib.java.collections.IHasher_;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.repository.interFace.data.attributeset.IRepositoryPropertySetSample;
import com.arcway.repository.interFace.data.object.IRepositoryObjectReference;
import com.arcway.repository.interFace.data.object.IRepositoryObjectSample;
import com.arcway.repository.interFace.dataaccess.IRepositoryInterfaceRO;
import com.arcway.repository.interFace.declaration.type.object.IRepositoryObjectTypeID;
import com.arcway.repository.interFace.importexport.IRepositorySnippetRO;
import com.arcway.repository.interFace.importexport.ImportExportException;
import com.arcway.repository.interFace.registration.type.IRepositoryTypeManagerRO;
import com.arcway.repository.lib.high.genericmodifications.interFace.transactions.RepositoryObjectSampleWithParentObjectReference;
import com.arcway.repository.lib.high.implementation.access.RepositoryObjectReference;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;

public abstract class AbstractCHCopy_NonPlatformUI
extends AbstractHandler {
    private static final ILogger LOGGER = Logger.getLogger(AbstractCHCopy_NonPlatformUI.class);

    public final Object execute(ExecutionEvent event) throws ExecutionException {
        String projectUID;
        ArrayList<IRepositoryObjectReference> selectedObjects = new ArrayList<IRepositoryObjectReference>();
        ISelection selection = HandlerUtil.getActiveMenuSelection((ExecutionEvent)event);
        if (selection == null) {
            selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        }
        IFrameProjectAgent projectAgent = null;
        if (selection instanceof IStructuredSelection && (projectUID = ProjectSelectionAnalyser.extractProjectUID(selection)) != null && (projectAgent = ProjectMgr.getProjectMgr().getProjectAgent(projectUID)) != null) {
            for (Object selectedObject : ((IStructuredSelection)selection).toList()) {
                assert (selectedObject instanceof ICockpitProjectData);
                ICockpitProjectData selectedCockpitObject = (ICockpitProjectData)selectedObject;
                if (!selectedCockpitObject.getProjectUID().equals(projectAgent.getProjectUID())) {
                    assert (false);
                    return null;
                }
                IRepositoryObjectTypeID objectTypeID = this.getRepositoryObjectTypeIDForCockpitTypeID(selectedCockpitObject.getTypeID());
                if (objectTypeID == null) {
                    assert (false);
                    return null;
                }
                IRepositoryPropertySetSample objectID = projectAgent.getRepositoryObjectID(selectedCockpitObject.getUID());
                RepositoryObjectReference objectReference = new RepositoryObjectReference(objectTypeID, objectID);
                selectedObjects.add((IRepositoryObjectReference)objectReference);
            }
        }
        if (!selectedObjects.isEmpty()) {
            try {
                IRepositoryInterfaceRO repositoryInterface = projectAgent.getRepositoryInterface();
                IRepositorySnippetRO repositorySnippet = CopyManager.getCopy(selectedObjects, repositoryInterface, this.getCopyConfiguration());
                Collection<IRepositoryObjectReference> dirtyObjectReferences = AbstractCHCopy_NonPlatformUI.doesSnippetContainDataRelatedToDirtyEditors(projectAgent, repositorySnippet);
                if (!dirtyObjectReferences.isEmpty()) {
                    SaveDirtyEditorsDialogUtil.showSaveDirtyEditorsDialog(HandlerUtil.getActiveShell((ExecutionEvent)event), Messages.getString("CopyAction.Info.DirtyEditors.Title"), Messages.getString("CopyAction.Info.DirtyEditors.Message"), projectAgent, dirtyObjectReferences);
                } else {
                    ClipboardManager.setToClipboard(repositoryInterface, repositorySnippet);
                }
            }
            catch (ImportExportException ieE) {
                LOGGER.warn("Copying failed", (Throwable)ieE);
                String message = ieE.getLocalizedMessage() != null && ieE.getLocalizedMessage().trim().length() > 0 ? NLS.bind((String)Messages.getString("CopyAction.Error.CopyFailed.MessageWithDetails"), (Object)ieE.getLocalizedMessage()) : Messages.getString("CopyAction.Error.CopyFailed.MessageWithoutDetails");
                MessageDialog.openError((Shell)HandlerUtil.getActiveShell((ExecutionEvent)event), (String)Messages.getString("CopyAction.Error.CopyFailed.Title"), (String)message);
            }
        }
        return null;
    }

    private static Collection<IRepositoryObjectReference> doesSnippetContainDataRelatedToDirtyEditors(IFrameProjectAgent projectAgent, IRepositorySnippetRO repositorySnippet) {
        IRepositoryObjectReference objectReference;
        IRepositoryObjectSample objectSample;
        IRepositoryInterfaceRO repositoryInterface = projectAgent.getRepositoryInterface();
        IRepositoryTypeManagerRO typeManager = repositoryInterface.getTypeManager();
        HashSet_<IRepositoryObjectReference> dirtyEditorObjectReferences = projectAgent.getObjectsShownInDirtyEditors();
        IHasher_ referencingEqualObjectsHasher = RepositoryObjectReference.get_REFERENCING_EQUAL_OBJECTS_HASHER((IRepositoryTypeManagerRO)typeManager);
        HashSet_ problemObjectReferences = new HashSet_(referencingEqualObjectsHasher);
        for (RepositoryObjectSampleWithParentObjectReference spr : repositorySnippet.getExplicitObjects()) {
            objectSample = spr.getObjectSample();
            objectReference = objectSample.getObjectReference(typeManager);
            if (!dirtyEditorObjectReferences.contains((Object)objectReference)) continue;
            problemObjectReferences.add((Object)objectReference);
        }
        for (RepositoryObjectSampleWithParentObjectReference spr : repositorySnippet.getImplicitObjects()) {
            objectSample = spr.getObjectSample();
            objectReference = objectSample.getObjectReference(typeManager);
            if (!dirtyEditorObjectReferences.contains((Object)objectReference)) continue;
            problemObjectReferences.add((Object)objectReference);
        }
        ArrayList<IRepositoryObjectReference> returnValue = new ArrayList<IRepositoryObjectReference>(problemObjectReferences.size());
        returnValue.addAll(problemObjectReferences.asJavaCollection());
        return returnValue;
    }

    protected abstract ICopyConfiguration getCopyConfiguration();

    protected abstract IRepositoryObjectTypeID getRepositoryObjectTypeIDForCockpitTypeID(String var1);
}

