/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.gui;

import com.arcway.cockpit.frame.client.global.ExtensionMgr;
import com.arcway.cockpit.frame.client.global.FramePlugin;
import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.global.gui.Messages;
import com.arcway.cockpit.frame.client.global.gui.dialogs.LicenseHintDialog;
import com.arcway.cockpit.frame.client.global.gui.preferencePages.AbstractLicensesPreferencePage;
import com.arcway.cockpit.frame.client.global.license.ClientProductLicenseTypes;
import com.arcway.cockpit.frame.client.global.license.IClientProductLicense;
import com.arcway.cockpit.frame.client.global.license.IClientProductLicenseManager;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import de.plans.lib.eclipse.ProcessorWithProgressDialog;
import de.plans.lib.util.gui.IProgressDisplay;
import de.plans.lib.util.gui.IRunnableWithProgressDisplay;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.bindings.Binding;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.bindings.keys.KeySequence;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveRegistry;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.keys.IBindingService;

public class WorkspaceInitializer
implements IStartup,
Runnable {
    private static final ILogger logger = Logger.getLogger(WorkspaceInitializer.class);
    private static final String[] OLD_VERSION_WORKSPACE_FOLDERS = new String[0];
    private static final String METADATA_FOLDER = ".metadata";
    private static final String PLUGINS_FOLDER = ".plugins";
    private static final String OLD_VERSION_FMCA_FOLDER = "de.plans.fmca";
    private static final String CURRENT_FMCA_FOLDER = "com.arcway.cockpit.fmca";
    private static final String SRV_FOLDER = "SRV";
    private static final String OLD_VERSION_PROJECTS_FOLDER = "Projects";
    private static final String OLD_VERSION_FMCA_INI = "FMCA.ini";
    private static final String OLD_VERSION_FMCA_XML = "FMCA.xml";
    private static final String OLD_VERSION_IDE_FOLDER = "org.eclipse.core.runtime";
    private static final String OLD_VERSION_IDE_SETTINGS = ".settings";
    private static final String SYS_PROP_COCKPIT_OPENPERSPECTIVE = "cockpit.perspective.open";
    private static final String[] PREFERENCE_KEY_OLD_VERSIONS = new String[]{"com.arcway.cockpit.frame.workspace.initialized", "com.arcway.cockpit.frame.workspace.initialized.3.6"};
    private static final String PREFERENCE_KEY_NEW_VERSION = "com.arcway.cockpit.frame.workspace.initialized.3.7";
    private static final String PREFERENCE_KEY_CLOB = "com.arcway.cockpit.frame.workspace.initialized.localModClob";
    private static final String PREFERENCE_KEY_BINDINGS = "com.arcway.cockpit.frame.workspace.bindings.initialized";
    private int remainingRetrys = 100;
    private static final int DAYS_IN_MSEC = 86400000;

    private static File calculateSRVFolder(File workspaceFolder) {
        File workspaceFMCAFolder = WorkspaceInitializer.calculateCurrentFMCAFolder(workspaceFolder);
        File workspaceSRVFolder = new File(workspaceFMCAFolder, SRV_FOLDER);
        return workspaceSRVFolder;
    }

    public static File calculateCurrentFMCAFolder(File workspaceFolder) {
        File workspaceMetatdataFolder = new File(workspaceFolder, METADATA_FOLDER);
        File workspacePluginsFolder = new File(workspaceMetatdataFolder, PLUGINS_FOLDER);
        File workspaceFMCAFolder = new File(workspacePluginsFolder, CURRENT_FMCA_FOLDER);
        return workspaceFMCAFolder;
    }

    public static File calculateOldVersionFMCAFolder(File workspaceFolder) {
        File workspaceMetatdataFolder = new File(workspaceFolder, METADATA_FOLDER);
        File workspacePluginsFolder = new File(workspaceMetatdataFolder, PLUGINS_FOLDER);
        File workspaceFMCAFolder = new File(workspacePluginsFolder, OLD_VERSION_FMCA_FOLDER);
        return workspaceFMCAFolder;
    }

    public static File calculateFMCAXML(File workspaceFolder) {
        File workspaceFMCAFolder = WorkspaceInitializer.calculateOldVersionFMCAFolder(workspaceFolder);
        File workspaceFMCAXML = new File(workspaceFMCAFolder, OLD_VERSION_FMCA_XML);
        return workspaceFMCAXML;
    }

    public static File calculateFMCAINI(File workspaceFolder) {
        File workspaceFMCAFolder = WorkspaceInitializer.calculateOldVersionFMCAFolder(workspaceFolder);
        File workspaceFMCAXML = new File(workspaceFMCAFolder, OLD_VERSION_FMCA_INI);
        return workspaceFMCAXML;
    }

    public static File calculateProjectsFolder(File workspaceFolder) {
        File workspaceFMCAFolder = WorkspaceInitializer.calculateOldVersionFMCAFolder(workspaceFolder);
        File workspaceProjectsFolder = new File(workspaceFMCAFolder, OLD_VERSION_PROJECTS_FOLDER);
        return workspaceProjectsFolder;
    }

    public static File calculateSettingsFolder(File workspaceFolder) {
        File workspaceMetatdataFolder = new File(workspaceFolder, METADATA_FOLDER);
        File workspacePluginsFolder = new File(workspaceMetatdataFolder, PLUGINS_FOLDER);
        File workspaceIDEFolder = new File(workspacePluginsFolder, OLD_VERSION_IDE_FOLDER);
        File workspaceSettingsFolder = new File(workspaceIDEFolder, OLD_VERSION_IDE_SETTINGS);
        return workspaceSettingsFolder;
    }

    public static File calculateServerFolder(File workspaceFolder, String serverID) throws IOException {
        File workspaceProjectsFolder = WorkspaceInitializer.calculateProjectsFolder(workspaceFolder);
        File workspaceServerFolder = new File(workspaceProjectsFolder, ProjectMgr.calculateServerFolderName(serverID));
        return workspaceServerFolder;
    }

    public void earlyStartup() {
        Display.getDefault().asyncExec((Runnable)this);
    }

    @Override
    public void run() {
        IWorkbenchWindow workbenchWindow;
        IWorkbenchPage workbenchPage;
        IBindingService bindingService;
        boolean everyThingIsInitialized = false;
        if (!FramePlugin.getDefault().getPreferenceStore().getBoolean(PREFERENCE_KEY_BINDINGS) && (bindingService = (IBindingService)FramePlugin.getDefault().getWorkbench().getAdapter(IBindingService.class)) != null) {
            this.setupBindings(bindingService);
            FramePlugin.getDefault().getPreferenceStore().setValue(PREFERENCE_KEY_BINDINGS, true);
        }
        if ((workbenchPage = (workbenchWindow = FramePlugin.getDefault().getWorkbench().getActiveWorkbenchWindow()) != null ? workbenchWindow.getActivePage() : null) != null) {
            IPerspectiveRegistry registry;
            IPerspectiveDescriptor initialPerspective;
            File currentWorkspaceLocation;
            boolean oldVersionInitialized = false;
            String[] stringArray = PREFERENCE_KEY_OLD_VERSIONS;
            int n = PREFERENCE_KEY_OLD_VERSIONS.length;
            int n2 = 0;
            while (n2 < n) {
                String key = stringArray[n2];
                oldVersionInitialized |= FramePlugin.getDefault().getPreferenceStore().getBoolean(key);
                ++n2;
            }
            boolean newVersionInitialized = FramePlugin.getDefault().getPreferenceStore().getBoolean(PREFERENCE_KEY_NEW_VERSION);
            boolean clobInitialized = FramePlugin.getDefault().getPreferenceStore().getBoolean(PREFERENCE_KEY_CLOB);
            if ((oldVersionInitialized || newVersionInitialized) && !clobInitialized && (currentWorkspaceLocation = WorkspaceInitializer.findCurrentWorkspaceLocation()) != null) {
                WorkspaceInitializer.migrateWorkspace370to371(currentWorkspaceLocation);
                FramePlugin.getDefault().getPreferenceStore().setValue(PREFERENCE_KEY_CLOB, true);
            }
            if (!newVersionInitialized) {
                File oldWorkspaceLocation = WorkspaceInitializer.findOldWorkspaceLocation();
                this.setupWorkspace(workbenchPage, oldWorkspaceLocation, oldVersionInitialized);
                FramePlugin.getDefault().getPreferenceStore().setValue(PREFERENCE_KEY_NEW_VERSION, true);
            }
            if ((initialPerspective = (registry = PlatformUI.getWorkbench().getPerspectiveRegistry()).findPerspectiveWithId("com.arcway.cockpit.frame.mainperspective")) != null) {
                workbenchPage.setPerspective(initialPerspective);
            }
            if (ProjectMgr.getProjectMgr().isInitalized()) {
                int licenseConfiguration = ProjectMgr.getProjectMgr().getLicenseConfiguration();
                IClientProductLicenseManager productLicenseManager = ProjectMgr.getProjectMgr().getGeneralServerProxy().getProductLicenseManager();
                if (licenseConfiguration == 2) {
                    if (!productLicenseManager.hasProductLicense(ClientProductLicenseTypes.READER_LICENSE_CS)) {
                        LicenseHintDialog dialog = new LicenseHintDialog(workbenchPage.getWorkbenchWindow().getShell(), AbstractLicensesPreferencePage.getHTMLTextForReaderVersion(Display.getDefault().getSystemColor(1), 2), 0);
                        dialog.open();
                    } else {
                        IClientProductLicense license = productLicenseManager.getProductLicense(ClientProductLicenseTypes.READER_LICENSE_CS);
                        this.checkLicenseEndDate(license, workbenchPage);
                    }
                } else if (licenseConfiguration == 1) {
                    IClientProductLicense license = productLicenseManager.getProductLicense(ClientProductLicenseTypes.FULL_LICENSE);
                    if (license == null) {
                        license = productLicenseManager.getProductLicense(ClientProductLicenseTypes.FULL_LICENSE_SA);
                    }
                    if (license == null) {
                        license = productLicenseManager.getProductLicense(ClientProductLicenseTypes.DESIGNER_LICENSE);
                    }
                    this.checkLicenseEndDate(license, workbenchPage);
                } else if (licenseConfiguration == 3) {
                    LicenseHintDialog dialog = new LicenseHintDialog(workbenchPage.getWorkbenchWindow().getShell(), AbstractLicensesPreferencePage.getHTMLTextForLimitedVersion(Display.getDefault().getSystemColor(1), 2), 0);
                    dialog.open();
                }
                everyThingIsInitialized = true;
            }
        }
        if (!everyThingIsInitialized) {
            --this.remainingRetrys;
            if (this.remainingRetrys > 0) {
                Display.getDefault().asyncExec((Runnable)this);
            }
        }
    }

    private void checkLicenseEndDate(IClientProductLicense license, IWorkbenchPage workbenchPage) {
        Timestamp endDate = license.getEndDate();
        if (endDate != null) {
            long validPeriodInMillis = endDate.getTime() - System.currentTimeMillis();
            int warningPeriodInDays = FramePlugin.getDefault().getPreferenceStore().getInt("License.WarningBeforeExpiration");
            long validPeriodInDays = validPeriodInMillis / 86400000L;
            if (warningPeriodInDays > 0 && validPeriodInDays <= (long)warningPeriodInDays) {
                LicenseHintDialog dialog = new LicenseHintDialog(workbenchPage.getWorkbenchWindow().getShell(), AbstractLicensesPreferencePage.getHTMLTextForExpirationPeriod(Display.getDefault().getSystemColor(1), 2, validPeriodInDays), 0);
                dialog.open();
            }
        }
    }

    private void setupBindings(IBindingService bindingService) {
        ArrayList<KeySequence> triggerSequencesToDelete = new ArrayList<KeySequence>();
        triggerSequencesToDelete.add(KeySequence.getInstance((KeyStroke[])new KeyStroke[]{KeyStroke.getInstance((int)SWT.MOD1, (int)49)}));
        triggerSequencesToDelete.add(KeySequence.getInstance((KeyStroke[])new KeyStroke[]{KeyStroke.getInstance((int)SWT.MOD1, (int)45)}));
        ArrayList<Binding> bindingList = new ArrayList<Binding>(Arrays.asList(bindingService.getBindings()));
        Iterator i = bindingList.iterator();
        while (i.hasNext()) {
            Binding currentBinding = (Binding)i.next();
            TriggerSequence triggerSequence = currentBinding.getTriggerSequence();
            if (!triggerSequencesToDelete.contains(triggerSequence)) continue;
            i.remove();
        }
        Binding[] bindings = new Binding[bindingList.size()];
        bindingList.toArray(bindings);
        try {
            bindingService.savePreferences(bindingService.getActiveScheme(), bindings);
        }
        catch (IOException e) {
            logger.error("Error while updating shortcut list.", (Throwable)e);
        }
    }

    private static File findOldWorkspaceLocation() {
        File parentDirectory;
        File oldWorkspaceLocation = null;
        File currentWorkspaceLocation = WorkspaceInitializer.findCurrentWorkspaceLocation();
        if (currentWorkspaceLocation != null && (parentDirectory = currentWorkspaceLocation.getParentFile()) != null) {
            int i = 0;
            while (oldWorkspaceLocation == null && i < OLD_VERSION_WORKSPACE_FOLDERS.length) {
                File assumedOldWorkspaceProjectsFolder;
                File assumedOldWorkspaceLocation = new File(parentDirectory, OLD_VERSION_WORKSPACE_FOLDERS[i]);
                if (assumedOldWorkspaceLocation.exists() && assumedOldWorkspaceLocation.isDirectory() && (assumedOldWorkspaceProjectsFolder = WorkspaceInitializer.calculateProjectsFolder(assumedOldWorkspaceLocation)).exists() && assumedOldWorkspaceProjectsFolder.isDirectory() && ProjectMgr.getProjectMgr().getGeneralServerProxy().isOldWorkspaceMigratable(assumedOldWorkspaceLocation)) {
                    oldWorkspaceLocation = assumedOldWorkspaceLocation;
                }
                ++i;
            }
        }
        return oldWorkspaceLocation;
    }

    private static File findCurrentWorkspaceLocation() {
        File file;
        String newLocationPathString;
        URL newLocationURL;
        File currentWorkspaceLocation = null;
        Location newLocation = Platform.getInstanceLocation();
        if (newLocation != null && (newLocationURL = newLocation.getURL()) != null && (newLocationPathString = newLocationURL.getPath()) != null && (file = new File(newLocationPathString)).exists() && file.isDirectory()) {
            currentWorkspaceLocation = file;
        }
        return currentWorkspaceLocation;
    }

    private void setupWorkspace(IWorkbenchPage workbenchPage, File oldWorkspaceLocation, boolean oldVersionInitialized) {
        this.setupPerspectives(workbenchPage);
        if (!oldVersionInitialized) {
            WorkspaceInitializer.setupServers(workbenchPage, oldWorkspaceLocation);
        }
        workbenchPage.getWorkbenchWindow().getWorkbench().getIntroManager().showIntro(workbenchPage.getWorkbenchWindow(), false);
    }

    private void setupPerspectives(final IWorkbenchPage workbenchPage) {
        try {
            ArrayList<ExtensionMgr.IPerspectiveInformation> openPerspectives;
            Shell shell = workbenchPage.getWorkbenchWindow().getShell();
            List<ExtensionMgr.IPerspectiveInformation> allPerspectives = ExtensionMgr.getPerspectives();
            HashMap<String, ExtensionMgr.IPerspectiveInformation> perspectiveID2perspective = new HashMap<String, ExtensionMgr.IPerspectiveInformation>(allPerspectives.size() * 2);
            for (ExtensionMgr.IPerspectiveInformation perspective : allPerspectives) {
                perspectiveID2perspective.put(perspective.getPerspectiveID(), perspective);
            }
            ArrayList<ExtensionMgr.IPerspectiveInformation> configuredOpenPerspectives = new ArrayList<ExtensionMgr.IPerspectiveInformation>(allPerspectives.size());
            int perspectiveNr = 0;
            while (perspectiveNr < 10) {
                String numberdsysprop = perspectiveNr == 0 ? SYS_PROP_COCKPIT_OPENPERSPECTIVE : SYS_PROP_COCKPIT_OPENPERSPECTIVE + Integer.toString(perspectiveNr);
                String perspectiveID = System.getProperty(numberdsysprop);
                if (perspectiveID != null) {
                    ExtensionMgr.IPerspectiveInformation perspective = (ExtensionMgr.IPerspectiveInformation)perspectiveID2perspective.get(perspectiveID);
                    if (perspective != null) {
                        configuredOpenPerspectives.add(perspective);
                    } else {
                        logger.warn("Workspace initialisation problem - Perspective with ID " + perspectiveID + " as referenced by system property " + numberdsysprop + " does not exist", (Throwable)new IllegalArgumentException(perspectiveID));
                    }
                }
                ++perspectiveNr;
            }
            if (configuredOpenPerspectives.isEmpty()) {
                openPerspectives = new ArrayList(allPerspectives.size());
                for (ExtensionMgr.IPerspectiveInformation perspective : allPerspectives) {
                    if (!perspective.createButton()) continue;
                    openPerspectives.add(perspective);
                }
            } else {
                openPerspectives = configuredOpenPerspectives;
            }
            ProcessorWithProgressDialog.process((Shell)shell, (boolean)true, (IRunnableWithProgressDisplay)new IRunnableWithProgressDisplay(){

                public void process(IProgressDisplay progressDisplay) throws Exception {
                    int numberOfPerspectives = openPerspectives.size();
                    progressDisplay.beginQuantifiedTask(Messages.getString("PerspectiveOpener.setupPerspectives"), numberOfPerspectives, false);
                    progressDisplay.reportQuantifiedProgress(0, Messages.getString("PerspectiveOpener.closingAllPerspectives"));
                    workbenchPage.closeAllPerspectives(false, false);
                    int i = 0;
                    ListIterator p = openPerspectives.listIterator(openPerspectives.size());
                    while (p.hasPrevious()) {
                        ExtensionMgr.IPerspectiveInformation currentPerspective = (ExtensionMgr.IPerspectiveInformation)p.previous();
                        String currentPerspectiveID = currentPerspective.getPerspectiveID();
                        IPerspectiveDescriptor currentPerspectiveDescriptor = PlatformUI.getWorkbench().getPerspectiveRegistry().findPerspectiveWithId(currentPerspectiveID);
                        if (currentPerspectiveDescriptor != null) {
                            progressDisplay.reportQuantifiedProgress(i, String.valueOf(Messages.getString("PerspectiveOpener.openingPerspective")) + currentPerspectiveDescriptor.getLabel());
                            try {
                                workbenchPage.setPerspective(currentPerspectiveDescriptor);
                                List<String> fastViewIds = currentPerspective.getFastViewIDs();
                                WorkspaceInitializer.this.handleFastViews(workbenchPage, fastViewIds);
                                workbenchPage.savePerspective();
                            }
                            catch (Throwable e) {
                                logger.error("Error when opening perspective " + currentPerspectiveDescriptor.getId() + ": ", e);
                                workbenchPage.closePerspective(currentPerspectiveDescriptor, false, false);
                            }
                        }
                        ++i;
                    }
                    progressDisplay.endTask();
                }
            });
        }
        catch (InterruptedException e) {
            logger.error("InterruptedException", (Throwable)e);
        }
        catch (Exception e) {
            logger.error("Exception", (Throwable)e);
        }
    }

    private void handleFastViews(IWorkbenchPage workbenchPage, List<String> fastViewIds) throws PartInitException {
        IWorkbenchPart currentPart = workbenchPage.getActivePart();
        for (String fastViewId : fastViewIds) {
            IViewPart projectView = workbenchPage.findView(fastViewId);
            if (projectView != null) continue;
            IPreferenceStore store = WorkbenchPlugin.getDefault().getPreferenceStore();
            int openViewMode = store.getInt("OPEN_VIEW_MODE");
            store.setValue("OPEN_VIEW_MODE", 1);
            workbenchPage.showView(fastViewId);
            store.setValue("OPEN_VIEW_MODE", openViewMode);
        }
        workbenchPage.activate(currentPart);
    }

    private static void setupServers(IWorkbenchPage workbenchPage, File oldWorkspaceLocation) {
        assert (workbenchPage != null);
        ProjectMgr.getProjectMgr().getGeneralServerProxy().setupWorkspace(workbenchPage, oldWorkspaceLocation);
    }

    private static void migrate(File dbPath, IJPADBMigrator migrator) {
        try {
            Class.forName("org.hsqldb.jdbc.JDBCDriver");
            Connection connection = DriverManager.getConnection("jdbc:hsqldb:file:" + dbPath + ";shutdown=true", "SA", "");
            migrator.migrate(connection);
            connection.close();
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private static void migrateWorkspace370to371(File workspaceLocation) {
        File srvFolder = WorkspaceInitializer.calculateSRVFolder(workspaceLocation);
        if (srvFolder.exists()) {
            File[] srvs;
            File[] fileArray = srvs = srvFolder.listFiles();
            int n = srvs.length;
            int n2 = 0;
            while (n2 < n) {
                File srv = fileArray[n2];
                if (srv.isDirectory()) {
                    File[] fileArray2 = srv.listFiles();
                    int n3 = fileArray2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        File prj = fileArray2[n4];
                        if (prj.isDirectory()) {
                            File dbFolder = new File(prj, "mod");
                            IJPADBMigrator dbMigrator = new IJPADBMigrator(){

                                @Override
                                public void migrate(Connection connection) throws SQLException {
                                    connection.createStatement().execute("ALTER TABLE PUBLIC.OPAQUEMODIFICATIONSTRING ALTER COLUMN MODIFICATIONDATA CLOB(1G)");
                                    connection.commit();
                                }
                            };
                            File db = new File(dbFolder, "modDB");
                            WorkspaceInitializer.migrate(db, dbMigrator);
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
    }

    public static interface IJPADBMigrator {
        public void migrate(Connection var1) throws SQLException;
    }
}

