/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttribute;
import com.arcway.cockpit.client.base.interfaces.frame.propertychanges.IPropertyChanges;
import com.arcway.cockpit.client.base.interfaces.frame.propertychanges.PropertyChanges;
import com.arcway.cockpit.frame.client.global.EXModuleUnknown;
import com.arcway.cockpit.frame.client.global.EXProjectNotOpen;
import com.arcway.cockpit.frame.client.global.EXProjectUnknown;
import com.arcway.cockpit.frame.client.global.ExtensionMgr;
import com.arcway.cockpit.frame.client.global.FetchedNotificationExhausetdListener;
import com.arcway.cockpit.frame.client.global.FramePlugin;
import com.arcway.cockpit.frame.client.global.IModuleProjectManager;
import com.arcway.cockpit.frame.client.global.IProjectExistenceListener;
import com.arcway.cockpit.frame.client.global.Icons;
import com.arcway.cockpit.frame.client.global.Messages;
import com.arcway.cockpit.frame.client.global.ServerPermissionChecker;
import com.arcway.cockpit.frame.client.global.consoleui.ConsoleFromFileReader;
import com.arcway.cockpit.frame.client.global.gui.views.linkview.LinkView;
import com.arcway.cockpit.frame.client.global.gui.views.project.ProjectView;
import com.arcway.cockpit.frame.client.global.license.ClientProductLicenseTypes;
import com.arcway.cockpit.frame.client.global.license.IClientFunctionLicense;
import com.arcway.cockpit.frame.client.global.license.IClientProductLicenseManager;
import com.arcway.cockpit.frame.client.global.license.licensetypes.ClientFunctionLicenseTypeProjectsCreate;
import com.arcway.cockpit.frame.client.global.license.licensetypes.ClientFunctionLicenseTypeProjectsLoad;
import com.arcway.cockpit.frame.client.global.license.licensetypes.ClientFunctionLicenseTypeProjectsNumber;
import com.arcway.cockpit.frame.client.project.ExProjectOpenAbortWithMessage;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.Project;
import com.arcway.cockpit.frame.client.project.ProjectAgent;
import com.arcway.cockpit.frame.client.project.ProjectAttributeModificationManager;
import com.arcway.cockpit.frame.client.project.ProjectAttributeTypeProvider;
import com.arcway.cockpit.frame.client.project.core.files.FileID;
import com.arcway.cockpit.frame.client.project.core.files.IFilesManager;
import com.arcway.cockpit.frame.client.project.core.framedata.Attribute;
import com.arcway.cockpit.frame.client.project.core.framedata.IAttributeModificationManager;
import com.arcway.cockpit.frame.client.project.core.framedata.ModificationProblem;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.DataTypeText;
import com.arcway.cockpit.frame.client.project.core.reporttemplates.ReportTemplateFoldersManager;
import com.arcway.cockpit.frame.client.project.core.serverproxy.IGeneralServerProxy;
import com.arcway.cockpit.frame.client.project.core.serverproxy.IProjectManagerServerProxy;
import com.arcway.cockpit.frame.client.project.datainterchange.ImportFailedException;
import com.arcway.cockpit.frame.client.project.datainterchange.ProjectFileAccess;
import com.arcway.cockpit.frame.client.project.modules.IFMCAModule;
import com.arcway.cockpit.frame.client.project.offlinemode.exceptions.EXOfflineMode;
import com.arcway.cockpit.frame.client.project.planeditors.IExternalPlanEditorControllerExtension;
import com.arcway.cockpit.frame.shared.message.EOProject;
import com.arcway.cockpit.frame.shared.message.genericframedata.EOAttribute;
import com.arcway.cockpit.frame.shared.message.genericframedata.EOAttributeTypeID;
import com.arcway.cockpit.frame.shared.serverexceptions.EXProjectDoesNotExist;
import com.arcway.lib.eclipse.gui.EclipseSWTHelper;
import com.arcway.lib.eclipse.gui.ModificationProblemsDialog;
import com.arcway.lib.eclipse.gui.dialogs.FileSystemErrorMessageDialogue;
import com.arcway.lib.eclipse.gui.dialogs.MessageDialogWithHyperlink;
import com.arcway.lib.io.FileHelper;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.resource.IStreamResource;
import com.arcway.lib.resource.JvmExternalResourceInteractionException;
import de.plans.fmca.client.FMCAPlugin;
import de.plans.fmca.client.PSCServices;
import de.plans.lib.eclipse.JFaceProgressMonitorToProgressDisplayAdapter;
import de.plans.lib.eclipse.ProgressDisplayToJFaceProgressMonitorAdapter;
import de.plans.lib.util.INotificationBusListener;
import de.plans.lib.util.Notification;
import de.plans.lib.util.gui.IProgressDisplay;
import de.plans.lib.xml.encoding.EOEncodableObject;
import de.plans.lib.xml.encoding.EOGenericMessage;
import de.plans.lib.xml.encoding.EOList;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.lib.xml.primitiveTypes.EOString;
import de.plans.psc.client.PSCApplicationIdentifier;
import de.plans.psc.client.PSCClientNotificationBus;
import de.plans.psc.client.WorkspaceUIDAccessAgent;
import de.plans.psc.client.communication.ExPrematureEndOfTransfer;
import de.plans.psc.client.communication.IServerStatusChangedListener;
import de.plans.psc.client.communication.LoginCanceledException;
import de.plans.psc.client.communication.ServerConnection;
import de.plans.psc.client.communication.ServerNotAvailableException;
import de.plans.psc.client.communication.UnknownServerException;
import de.plans.psc.client.dialogs.swt.ServerConnectionFailureUI;
import de.plans.psc.shared.message.EOServerResponse;
import de.plans.psc.shared.serverexceptions.EXServerException;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;

public class ProjectMgr
implements IWindowListener,
IWorkbenchListener,
IModuleProjectManager {
    private static final Set<String> FURTHER_SUPPORTED_WORKSPACE_VERSIONS = new HashSet<String>();
    private static final ILogger logger;
    private static boolean isInScriptMode;
    public static final int CREATE_PROJECT_MODE_CREATE_NEW = 1;
    public static final int CREATE_PROJECT_MODE_CHECKOUT = 2;
    private boolean initalized = false;
    private String workspaceUID = null;
    private static ProjectMgr singleInstance;
    private final File rootDirectory;
    private static File serversDirectory;
    private static final String OPEN_PROJECTS_PREF_KEY = "openprojects";
    private final Map<String, ProjectAgent> projectAgents = new HashMap<String, ProjectAgent>();
    private ProjectAgent activeProject;
    private final Map<String, IProjectManagerServerProxy> serverProxies = new HashMap<String, IProjectManagerServerProxy>();
    private final ExtensionMgr extensionMgr = ExtensionMgr.getDefault();
    private IWorkbenchWindow lastActivatedWindow;
    private final IGeneralServerProxy generalServerProxy;
    private final List<IProjectExistenceListener> existanceListeners = new ArrayList<IProjectExistenceListener>();
    private final Set<IProjectClosedListener> projectClosedListeners = new HashSet<IProjectClosedListener>();
    public static final int LICENSECONFIGURATION_FULL_VERSION = 1;
    public static final int LICENSECONFIGURATION_READER_VERSION = 2;
    public static final int LICENSECONFIGURATION_EXPIRED_FREE_VERSION = 3;
    public static final int LICENSECONFIGURATION_CLIENTSERVER_VERSION_WITHOUT_CLIENTLICENSE = 4;

    static {
        FURTHER_SUPPORTED_WORKSPACE_VERSIONS.add("3.5.0");
        FURTHER_SUPPORTED_WORKSPACE_VERSIONS.add("3.6.0");
        FURTHER_SUPPORTED_WORKSPACE_VERSIONS.add("3.7.0");
        logger = Logger.getLogger(ProjectMgr.class);
        isInScriptMode = false;
    }

    public static void setIsInScriptMode(boolean value) {
        assert (singleInstance == null);
        isInScriptMode = value;
    }

    private ProjectMgr() {
        PlatformUI.getWorkbench().addWindowListener((IWindowListener)this);
        PlatformUI.getWorkbench().addWorkbenchListener((IWorkbenchListener)this);
        this.rootDirectory = FMCAPlugin.getWorkspaceRootDirectory();
        List<?> container = this.extensionMgr.getExtension("generalserverproxy", "serverproxy", "serverproxy");
        assert (container.size() == 1);
        this.generalServerProxy = (IGeneralServerProxy)container.get(0);
        PSCServices.getServiceFacade().getNotificationBus().subscribeFetchedNotificationsExhaustedListener((PSCClientNotificationBus.IFetchedNotificationsExhaustedListener)new FetchedNotificationExhausetdListener());
        this.generalServerProxy.addServerStatusChangedListener(new IServerStatusChangedListener(){

            public void addedServer(ServerConnection serverConnection) {
            }

            public void modifiedServer(ServerConnection serverConnection) {
            }

            public void deletedServer(ServerConnection serverConnection) {
                ProjectMgr.this.serverProxies.remove(serverConnection.getServerID());
            }

            public void login(final ServerConnection serverConnection) {
                INotificationBusListener listener = new INotificationBusListener(){

                    public void receiveNotification(Notification notification) {
                        EOGenericMessage msg = (EOGenericMessage)notification.getParameter();
                        String projectUID = null;
                        String clientname = null;
                        String username = null;
                        for (EncodableObjectBase encodableObjectBase : msg.getChilds()) {
                            EOString string = (EOString)encodableObjectBase;
                            if (string.getRole().equals("uid")) {
                                projectUID = string.getString();
                                continue;
                            }
                            if (string.getRole().equals("clientname")) {
                                clientname = string.getString();
                                continue;
                            }
                            if (!string.getRole().equals("username")) continue;
                            username = string.getString();
                        }
                        ProjectMgr.this.projectDeletedOnServer(serverConnection, projectUID, clientname, username);
                    }
                };
                IProjectManagerServerProxy sp = ProjectMgr.this.getProjectManagerServerProxy(serverConnection.getServerID());
                try {
                    sp.subscribeListenerOnServer(listener, "cockpit.frame.project.deleted");
                }
                catch (ServerNotAvailableException e) {
                    logger.error("could register for project deletion notification", (Throwable)e);
                }
                catch (EXServerException e) {
                    logger.error("could register for project deletion notification", (Throwable)e);
                }
                catch (LoginCanceledException e) {
                    logger.error("could register for project deletion notification", (Throwable)e);
                }
                catch (UnknownServerException e) {
                    logger.error("could register for project deletion notification", (Throwable)e);
                }
            }

            public void logoff(ServerConnection serverConnection) {
                List<ProjectAgent> projectsOfServer = ProjectMgr.this.getConfiguredProjectsOfServer(serverConnection.getServerID());
                for (ProjectAgent projectAgent : projectsOfServer) {
                    if (!projectAgent.isOpened() || projectAgent.getOfflineModeManager().isInOfflineMode()) continue;
                    projectAgent.close(null);
                }
            }

            public boolean serverAboutToBeDeleted(ServerConnection serverConnection) {
                for (ProjectAgent projectAgent : ProjectMgr.this.getConfiguredProjectsOfServer(serverConnection.getServerID())) {
                    if (projectAgent.isOpened()) {
                        projectAgent.close(null);
                    }
                    if (ProjectMgr.this.removeProjectConfiguration(projectAgent)) continue;
                    return false;
                }
                return true;
            }
        });
    }

    private void projectDeletedOnServer(ServerConnection serverConnection, String projectUID, String clientname, String usernam) {
        ProjectAgent projectAgent = this.getProjectAgent(projectUID);
        if (projectAgent != null && projectAgent.getServerID().equals(serverConnection.getServerID()) && projectAgent.isOpened()) {
            String projectName = projectAgent.getProjectName();
            this.closeProject(projectAgent, false);
            if (this.lastActivatedWindow != null) {
                String msg = String.valueOf(Messages.getString("ProjectMgr.the_project")) + projectName + Messages.getString("ProjectMgr.server") + serverConnection.getServerName() + Messages.getString("ProjectMgr.was_deleted1") + usernam + Messages.getString("ProjectMgr.was_deleted2") + clientname + Messages.getString("ProjectMgr.was_deleted3");
                MessageDialog.openInformation((Shell)this.lastActivatedWindow.getShell(), (String)Messages.getString("ProjectMgr.project_deleted_or_replaced"), (String)msg);
            }
        }
    }

    public boolean isInScriptMode() {
        return isInScriptMode;
    }

    public static synchronized File getServersDirectory() throws IOException {
        if (serversDirectory == null) {
            File rootDirectory = FMCAPlugin.getWorkspaceRootDirectory();
            serversDirectory = new File(rootDirectory, "SRV");
            try {
                FileHelper.ensureDirectoryExistance((File)serversDirectory);
            }
            catch (JvmExternalResourceInteractionException jeri) {
                throw jeri.toIOException();
            }
            if (!serversDirectory.isDirectory()) {
                String msg = "ProjectMgr: \"" + serversDirectory.getAbsolutePath() + "\" is expected to be a directory but does not seem to be one.";
                logger.fatal(msg);
                throw new IOException(msg);
            }
        }
        return serversDirectory;
    }

    public static synchronized ProjectMgr getProjectMgr() {
        if (singleInstance == null) {
            singleInstance = new ProjectMgr();
            singleInstance.checkClientVersion();
            singleInstance.loadConfiguredProjects(PlatformUI.getWorkbench().getActiveWorkbenchWindow());
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!isInScriptMode) {
                        Shell shell = EclipseSWTHelper.getShell();
                        IWorkbenchPage currentPage = EclipseSWTHelper.getWorkbenchPage(null);
                        boolean triggerUserOnOpenActions = true;
                        ArrayList<ProjectAgent> openProjectsList = new ArrayList<ProjectAgent>();
                        IPreferenceStore prefStore = FramePlugin.getDefault().getPreferenceStore();
                        String openProjectsUIDs = prefStore.getString(ProjectMgr.OPEN_PROJECTS_PREF_KEY);
                        while (openProjectsUIDs.indexOf("-") > -1) {
                            int index = openProjectsUIDs.indexOf("-");
                            String uid = openProjectsUIDs.substring(0, index);
                            ProjectAgent projectAgent = ProjectMgr.getProjectMgr().getProjectAgent(uid);
                            if (projectAgent != null) {
                                openProjectsList.add(projectAgent);
                            }
                            openProjectsUIDs = openProjectsUIDs.substring(index + 1);
                        }
                        HashSet<String> serversNotToUseAgain = new HashSet<String>();
                        for (ProjectAgent projectAgent : openProjectsList) {
                            try {
                                if (projectAgent.getOfflineModeManager().isInOfflineMode()) {
                                    projectAgent.openWithProgressbar(false, triggerUserOnOpenActions, currentPage);
                                    continue;
                                }
                                if (serversNotToUseAgain.contains(projectAgent.getServerID())) continue;
                                serversNotToUseAgain.add(projectAgent.getServerID());
                                projectAgent.openWithProgressbar(false, triggerUserOnOpenActions, currentPage);
                                serversNotToUseAgain.remove(projectAgent.getServerID());
                            }
                            catch (LoginCanceledException uid) {
                            }
                            catch (ServerNotAvailableException e) {
                                logger.error("Could not open project " + projectAgent.getProjectName() + " do to the following Exception. Will skip trying to automatically open other projects on this server.", (Throwable)e);
                            }
                            catch (UnknownServerException e) {
                                logger.error("Could not open project " + projectAgent.getProjectName() + " do to the following Exception. Will skip trying to automatically open other projects on this server.", (Throwable)e);
                            }
                            catch (EXServerException e) {
                                logger.error("could not open project", (Throwable)e);
                                ServerConnectionFailureUI.troubleshootServerConnectionFailure((Shell)shell, (String)Messages.getString("ProjectMgr.CouldNotReopenProject"), (Throwable)e);
                            }
                            catch (InterruptedException e) {
                                logger.error("Could not open project " + projectAgent.getProjectName() + " do to the following Exception. Will skip trying to automatically open other projects on this server.", (Throwable)e);
                            }
                            catch (ExProjectOpenAbortWithMessage e) {
                                logger.error("Could not open project " + projectAgent.getProjectName() + " do to the following Exception. Will skip trying to automatically open other projects on this server.", (Throwable)e);
                                serversNotToUseAgain.remove(projectAgent.getServerID());
                            }
                        }
                        singleInstance.initalized = true;
                    }
                    ProjectView.refresh1();
                    ProjectAgent[] pa = ProjectMgr.getProjectMgr().getOpenedProjects();
                    if (pa.length > 0) {
                        ProjectView.select(pa[0]);
                    } else {
                        Collection<ServerConnection> serverConnections = ProjectMgr.getProjectMgr().getConfiguredServerConnections();
                        if (serverConnections.size() == 1) {
                            ProjectView.select(serverConnections.iterator().next());
                        }
                    }
                }
            });
        }
        return singleInstance;
    }

    public ConsoleFromFileReader getConsoleActionsFromFileReader(File file) {
        return new ConsoleFromFileReader(file);
    }

    public boolean isInitalized() {
        return this.initalized;
    }

    public IProjectManagerServerProxy getProjectManagerServerProxyByServerName(String servername) {
        String serverID = null;
        for (ServerConnection sc : this.getConfiguredServerConnections()) {
            if (!servername.equals(sc.getServerName())) continue;
            serverID = sc.getServerID();
        }
        return this.getProjectManagerServerProxy(serverID);
    }

    public IProjectManagerServerProxy getProjectManagerServerProxy(String serverID) {
        if (!this.serverProxies.containsKey(serverID)) {
            List<?> container = this.extensionMgr.getNewInstanceOfExtension("projectmanagerserverproxy", "ProjectManagerServerProxy", "ServerProxy");
            assert (container.size() == 1);
            IProjectManagerServerProxy serverProxy = (IProjectManagerServerProxy)container.get(0);
            ServerConnection serverConnection = this.getServerConnectionByServerID(serverID);
            if (serverConnection != null) {
                serverProxy.construct(serverConnection);
                this.serverProxies.put(serverID, serverProxy);
            }
        }
        return this.serverProxies.get(serverID);
    }

    public ServerConnection getServerConnectionByServerID(String serverID) {
        for (ServerConnection sc : this.getConfiguredServerConnections()) {
            if (!sc.getServerID().equals(serverID)) continue;
            return sc;
        }
        return null;
    }

    private void checkClientVersion() {
        String CLIENT_BUILD_NR = "ClientBuildNr";
        String CLIENT_VERSION_NR = "ClientVersionNr";
        PSCApplicationIdentifier applicationIdentifier = PSCServices.getServiceFacade().getApplicationIdentifier();
        String clientVersion = applicationIdentifier.getClientVersion();
        String clientBuild = applicationIdentifier.getClientBuild();
        logger.info("Starting ARCWAY COCKPIT (ClientVersionNr: " + clientVersion + ", " + "ClientBuildNr" + ": " + clientBuild + ")");
        IPreferenceStore preferences = FMCAPlugin.getDefault().getPreferenceStore();
        String workspaceVersion = preferences.getString("ClientVersionNr");
        String workspaceBuild = preferences.getString("ClientBuildNr");
        if ("".equals(workspaceBuild) || workspaceBuild == null || "".equals(workspaceVersion) || workspaceVersion == null) {
            preferences.setValue("ClientBuildNr", clientBuild);
            preferences.setValue("ClientVersionNr", clientVersion);
        } else {
            boolean isSupportedVersion;
            boolean bl = isSupportedVersion = clientVersion.equals(workspaceVersion) || FURTHER_SUPPORTED_WORKSPACE_VERSIONS.contains(workspaceVersion);
            if (!isSupportedVersion) {
                String message = String.valueOf(Messages.getString("DifferingClientVersion.Message")) + "\n\n" + Messages.getString("DifferingClientVersion.CurrentWorkspace") + "\n" + FramePlugin.getWorkspace().getRoot().getLocation() + "\n\n" + Messages.getString("DifferingClientVersion.OldVersion") + "\n\t" + workspaceVersion + " {" + workspaceBuild + "}\n\n" + Messages.getString("DifferingClientVersion.NewVersion") + "\n\t" + clientVersion + " {" + clientBuild + "}";
                logger.warn(message);
                if (!isInScriptMode) {
                    MessageDialog messageDialog = new MessageDialog(EclipseSWTHelper.getShell(), Messages.getString("DifferingClientVersion.Title"), null, message, 4, new String[]{Messages.getString("DifferingClientVersion.Ignore")}, 0);
                    messageDialog.setBlockOnOpen(true);
                    messageDialog.open();
                }
            }
        }
    }

    public ProjectAgent getProjectAgent(String projectUID) {
        return this.projectAgents.get(projectUID);
    }

    public IExternalPlanEditorControllerExtension getPlanEditorControllerExtension(IWorkbenchPart part) {
        for (ProjectAgent projectAgent : this.projectAgents.values()) {
            IExternalPlanEditorControllerExtension ctrl;
            if (!projectAgent.isOpened() || (ctrl = projectAgent.getPlanEditorManager().getPlanEditorControllerExtension(part)) == null) continue;
            return ctrl;
        }
        return null;
    }

    public void addProjectClosedListener(IProjectClosedListener projectListener) {
        boolean addedOne = this.projectClosedListeners.add(projectListener);
        assert (addedOne);
    }

    public void removeProjectClosedListener(IProjectClosedListener projectListener) {
        boolean removedOne = this.projectClosedListeners.remove(projectListener);
        assert (removedOne);
    }

    private void informProjectClosedListeners(String projectUID) {
        HashSet<IProjectClosedListener> localListeners = new HashSet<IProjectClosedListener>(this.projectClosedListeners);
        for (IProjectClosedListener projectListener : localListeners) {
            projectListener.projectClosed(projectUID);
        }
        assert (!localListeners.addAll(this.projectClosedListeners)) : "No projectClosedListeners must be added during informProjectClosedListeners.";
    }

    public boolean closeProject(IFrameProjectAgent projectAgent, boolean askUser) {
        boolean closingSucceeded = false;
        if (projectAgent.close((Shell)(askUser ? EclipseSWTHelper.getShell() : null))) {
            PropertyChanges changes = new PropertyChanges(null, (Object)projectAgent, null);
            projectAgent.getPropertyChangesProviderManager().modelRefreshed((IPropertyChanges)changes, IFrameProjectAgent.class);
            LinkView.clearAllLinkViews();
            this.informProjectClosedListeners(projectAgent.getProjectUID());
            closingSucceeded = true;
        }
        return closingSucceeded;
    }

    public ProjectAgent[] getOpenedProjects() {
        ProjectAgent[] configuredProjects = this.getConfiguredProjects();
        ArrayList<ProjectAgent> openedProjects = new ArrayList<ProjectAgent>();
        ProjectAgent[] projectAgentArray = configuredProjects;
        int n = configuredProjects.length;
        int n2 = 0;
        while (n2 < n) {
            ProjectAgent element = projectAgentArray[n2];
            if (element.isOpened()) {
                openedProjects.add(element);
            }
            ++n2;
        }
        return openedProjects.toArray(new ProjectAgent[openedProjects.size()]);
    }

    public boolean connectToServer(String serverID) {
        try {
            IProjectManagerServerProxy serverProxy = this.getProjectManagerServerProxy(serverID);
            serverProxy.getUserData(true);
            return true;
        }
        catch (LoginCanceledException lce) {
            return false;
        }
        catch (Throwable ta) {
            logger.error("could not connect to server ", ta);
            ServerConnectionFailureUI.troubleshootServerConnectionFailure((Shell)EclipseSWTHelper.getShell(), (String)Messages.getString("ProjectMgr.Error_connecting_to_server"), (Throwable)ta);
            return false;
        }
    }

    public void disconnectFromAllServers() {
        for (ServerConnection sc : this.getConfiguredServerConnections()) {
            this.disconnectFromServer(sc.getServerID());
        }
    }

    public void disconnectFromServer(String serverID) {
        this.generalServerProxy.disconnect(serverID);
    }

    public Collection<ServerConnection> getConfiguredServerConnections() {
        return this.generalServerProxy.getServerConnections();
    }

    public String getProjectName(String projectUID, String serverID) {
        try {
            for (EOProject project : this.getEOProjectsOnServer(serverID)) {
                if (!project.getProjectUID().equals(projectUID)) continue;
                return Project.getProjectName(project);
            }
        }
        catch (Throwable ta) {
            logger.error("could not retrieve projects", ta);
        }
        return Messages.getString("ProjectMgr.unknown_project_8");
    }

    public ProjectAgent[] getClosedProjects() {
        ProjectAgent[] configuredProjects = this.getConfiguredProjects();
        ArrayList<ProjectAgent> closedProjects = new ArrayList<ProjectAgent>();
        int i = 0;
        while (i < configuredProjects.length) {
            if (!configuredProjects[i].isOpened()) {
                closedProjects.add(configuredProjects[i]);
            }
            ++i;
        }
        ProjectAgent[] closedAgents = closedProjects.toArray(new ProjectAgent[closedProjects.size()]);
        return closedAgents;
    }

    private void loadConfiguredProjects(IWorkbenchWindow window) {
        File serversFolder;
        try {
            serversFolder = ProjectMgr.getServersDirectory();
        }
        catch (IOException e) {
            logger.error("loadConfiguredProjects() - Invalid project directory ", (Throwable)e);
            return;
        }
        if (!serversFolder.isDirectory()) {
            logger.error("loadConfiguredProjects() - Invalid project directory " + serversFolder.getAbsolutePath(), null);
            return;
        }
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                File[] serverDirectories = serversFolder.listFiles();
                if (serverDirectories.length > 0) {
                    JFaceProgressMonitorToProgressDisplayAdapter display = new JFaceProgressMonitorToProgressDisplayAdapter(monitor);
                    display.beginQuantifiedTask(Messages.getString("ProjectMgr.0"), serverDirectories.length * 100, false);
                    int i = 0;
                    while (i < serverDirectories.length) {
                        display.reportQuantifiedProgress(i * 100, Messages.getString("ProjectMgr.1"));
                        if (serverDirectories[i].isDirectory()) {
                            ProjectMgr.this.createProjectsFromDirectory(serverDirectories[i], display, i);
                        }
                        ++i;
                    }
                    display.endTask();
                }
            }
        };
        try {
            if (window == null) {
                runnable.run((IProgressMonitor)new ProgressDisplayToJFaceProgressMonitorAdapter(IProgressDisplay.DUMMY));
            } else {
                ProgressMonitorDialog dialog = new ProgressMonitorDialog(window.getShell());
                dialog.setOpenOnRun(true);
                dialog.run(false, false, runnable);
            }
        }
        catch (InvocationTargetException ite) {
            logger.error("could not load projects", (Throwable)ite);
        }
        catch (InterruptedException ie) {
            logger.error("coudl not load projects", (Throwable)ie);
        }
    }

    private void createProjectsFromDirectory(File directory, JFaceProgressMonitorToProgressDisplayAdapter display, int progressBase) {
        File[] projectDirectories = directory.listFiles();
        int step = 100 / (projectDirectories.length + 1);
        int progress = progressBase;
        int i = 0;
        while (i < projectDirectories.length) {
            if (projectDirectories[i].isDirectory()) {
                try {
                    File propertiesFile = new File(projectDirectories[i], "project.properties");
                    if (propertiesFile.exists()) {
                        ProjectAgent pc = ProjectAgent.recreateProjectAgent(projectDirectories[i]);
                        this.projectAgents.put(pc.getProjectUID(), pc);
                        display.reportQuantifiedProgress(progress += i * step, Messages.getString("ProjectMgr.2"));
                    }
                }
                catch (Exception e) {
                    logger.error("Error while reading project vom directory " + projectDirectories[i].getAbsolutePath(), (Throwable)e);
                }
            }
            ++i;
        }
    }

    public void configureProject(String serverID, String projectUID, String projectName) throws IOException {
        ProjectAgent existingProjectAgent = this.getProjectAgent(projectUID);
        if (existingProjectAgent == null) {
            File newProjectFolder = this.createProjectFolder(projectUID, serverID);
            ProjectAgent newProjectAgent = new ProjectAgent(projectUID, projectName, serverID, newProjectFolder);
            this.projectAgents.put(newProjectAgent.getProjectUID(), newProjectAgent);
        } else {
            logger.warn("Ignored to configure project " + projectUID + " / " + projectName + " on server " + serverID + ": Project UID already exists on this client");
        }
    }

    public boolean isConfiguredServer(String serverID) {
        for (ServerConnection con : this.generalServerProxy.getServerConnections()) {
            if (!con.getServerID().equals(serverID)) continue;
            return true;
        }
        return false;
    }

    public List<ProjectAgent> getConfiguredProjectsOfServer(String serverID) {
        assert (serverID != null) : "serverID is missing";
        ArrayList<ProjectAgent> projectsOnServer = new ArrayList<ProjectAgent>();
        for (ProjectAgent projectAgent : this.projectAgents.values()) {
            if (!projectAgent.getServerID().equals(serverID)) continue;
            projectsOnServer.add(projectAgent);
        }
        return projectsOnServer;
    }

    public boolean hasConfiguredProjects() {
        return !this.projectAgents.isEmpty();
    }

    public ProjectAgent[] getConfiguredProjects() {
        Collection<ProjectAgent> allProjectAgents = this.projectAgents.values();
        return allProjectAgents.toArray(new ProjectAgent[allProjectAgents.size()]);
    }

    @Deprecated
    public void setActiveProject1(ProjectAgent projectAgent) {
        this.activeProject = projectAgent;
    }

    @Deprecated
    public ProjectAgent getActiveProject1() {
        return this.activeProject;
    }

    public Collection<EOProject> getEOProjectsOnServer(String serverID) throws ServerNotAvailableException, EXServerException, LoginCanceledException, UnknownServerException {
        EOProject[] projects = this.getProjectManagerServerProxy(serverID).getAllProjectsOfServer();
        ArrayList<EOProject> projectsCol = new ArrayList<EOProject>(Arrays.asList(projects));
        return projectsCol;
    }

    public IFrameProjectAgent createNewProject(IWorkbenchPage currentPage, String serverID, String projectUID, String projectName, String projectDescription, String projectCopyrightNotice, String projectLanguage, IStreamResource logoFileResource, ProjectFileAccess projectTemplate) throws ServerNotAvailableException, EXServerException, LoginCanceledException, UnknownServerException, IOException, ExPrematureEndOfTransfer, ImportFailedException, ExProjectOpenAbortWithMessage {
        ProjectAgent newProjectAgent = null;
        try {
            Shell shell = currentPage == null ? null : currentPage.getWorkbenchWindow().getShell();
            boolean triggerUserOnOpenActions = false;
            newProjectAgent = this.createNewProject(projectUID, projectName, projectLanguage, serverID, 1, triggerUserOnOpenActions, currentPage);
            if (newProjectAgent != null) {
                String commitComment;
                if (!newProjectAgent.getFrameLockManager().setExclusiveProjectLock().wasSuccessful()) {
                    logger.error("A project was locked by another client, while this client was trying to create the project");
                }
                newProjectAgent.getFramePermissionManager().permissionOperandCreated(newProjectAgent);
                newProjectAgent.getFramePermissionManager().permissionOperandCreated(newProjectAgent.getFrameSectionManager().getRootSection());
                newProjectAgent.getFramePermissionManager().commit();
                ArrayList<IAttribute> attributes = new ArrayList<IAttribute>();
                Attribute name = new Attribute(ProjectAttributeTypeProvider.ATTRID_NAME, projectName);
                attributes.add(name);
                Attribute description = new Attribute(ProjectAttributeTypeProvider.ATTRID_DESCRIPTION, DataTypeText.getInstanceText().getAttributeValueFromString(projectDescription, null, null));
                attributes.add(description);
                Attribute copyright = new Attribute(ProjectAttributeTypeProvider.ATTRID_COPYRIGHT, projectCopyrightNotice);
                attributes.add(copyright);
                Attribute language = new Attribute(ProjectAttributeTypeProvider.ATTRID_LANGUAGE, projectLanguage);
                if (language.getAttributeValue() != null) {
                    attributes.add(language);
                }
                if (logoFileResource != null) {
                    IFilesManager filesManager = newProjectAgent.getFilesManager();
                    FileID imageFileID = filesManager.loadFileIntoTemporaryStorage(logoFileResource);
                    filesManager.markFileAsBeeingReferenced(imageFileID);
                    filesManager.removeFileFromTemporaryStorage(imageFileID);
                    Attribute logo = new Attribute(ProjectAttributeTypeProvider.ATTRID_LOGO, imageFileID);
                    attributes.add(logo);
                }
                ProjectAttributeModificationManager modManager = new ProjectAttributeModificationManager(newProjectAgent);
                Project project = new Project((IFrameProjectAgent)newProjectAgent, attributes, (IAttributeModificationManager)modManager);
                modManager.setProject(project);
                newProjectAgent.getProjectMetaDataManager().setNewProject(project);
                if (projectTemplate != null) {
                    newProjectAgent.getFrameDataImporter().importProjectTemplate(projectTemplate, shell);
                    commitComment = NLS.bind((String)Messages.getString("ProjectMgr.created_from_template", new Locale(projectLanguage)), (Object)projectTemplate.getProjectFileName());
                } else {
                    commitComment = Messages.getString("ProjectMgr.created", new Locale(projectLanguage));
                    ReportTemplateFoldersManager.createRootFolder(newProjectAgent);
                }
                newProjectAgent.getFramePermissionManager().commit();
                if (newProjectAgent.getFrameServerProxy().isCommitable()) {
                    newProjectAgent.commitProject(commitComment, false, true, shell);
                }
            }
            return newProjectAgent;
        }
        catch (IOException e1) {
            ProjectMgr.deleteProjectIfCreated(newProjectAgent, currentPage);
            throw e1;
        }
        catch (ImportFailedException e1) {
            ProjectMgr.deleteProjectIfCreated(newProjectAgent, currentPage);
            throw e1;
        }
        catch (JvmExternalResourceInteractionException jeriE) {
            ProjectMgr.deleteProjectIfCreated(newProjectAgent, currentPage);
            throw new ImportFailedException(FileSystemErrorMessageDialogue.getFileSystemErrorMessage());
        }
        catch (ExProjectOpenAbortWithMessage e1) {
            ProjectMgr.deleteProjectIfCreated(newProjectAgent, currentPage);
            throw e1;
        }
    }

    private static void deleteProjectIfCreated(IFrameProjectAgent projectAgent, IWorkbenchPage currentPage) {
        if (projectAgent != null) {
            ProjectMgr.getProjectMgr().deleteProjectOnServer(projectAgent, currentPage);
        }
    }

    public ProjectAgent createNewProject(String projectUID, String projectName, String projectLanguage, String serverID, int mode, boolean triggerUserOnOpenActions, IWorkbenchPage currentPage) throws ServerNotAvailableException, EXServerException, LoginCanceledException, UnknownServerException, IOException, ExProjectOpenAbortWithMessage {
        assert (serverID != null) : "serverID can't be null!";
        assert (mode == 1 || mode == 2);
        IProjectManagerServerProxy serverProxy = this.getProjectManagerServerProxy(serverID);
        int nrOfProjects = ProjectMgr.getProjectMgr().getConfiguredProjects().length;
        int maxProjects = 0;
        maxProjects = ClientFunctionLicenseTypeProjectsNumber.getMaxNumberOfProjects(serverProxy.getFunctionLicenseManager());
        IClientFunctionLicense createProjectLicense = serverProxy.getFunctionLicenseManager().findClientFunctionLicense(ClientFunctionLicenseTypeProjectsCreate.getInstance());
        IClientFunctionLicense loadProjectLicense = serverProxy.getFunctionLicenseManager().findClientFunctionLicense(ClientFunctionLicenseTypeProjectsLoad.getInstance());
        boolean hasCreateProjectLicense = maxProjects < 0 || maxProjects > nrOfProjects ? ((createProjectLicense == null || createProjectLicense.getValue().equals(Boolean.FALSE)) && loadProjectLicense != null && loadProjectLicense.getValue().equals(Boolean.TRUE) ? (mode == 1 ? serverProxy.canReaderCreateProjectsOnThisServer() : true) : mode == 1 && createProjectLicense != null && createProjectLicense.getValue().equals(Boolean.TRUE) || mode == 2 && loadProjectLicense != null && loadProjectLicense.getValue().equals(Boolean.TRUE)) : false;
        if (hasCreateProjectLicense) {
            if (mode == 1 && !ServerPermissionChecker.mayCreateProjects(serverID, true)) {
                MessageDialog mDialog = new MessageDialog(EclipseSWTHelper.getShell(), Messages.getString("ProjectMgr.NoPermissionToCreateProject"), null, Messages.getString("ProjectMgr.NoPermissionToCreateProject.Detailed"), 1, new String[]{IDialogConstants.OK_LABEL}, 0);
                mDialog.open();
                return null;
            }
            File newProjectFolder = this.createProjectFolder(projectUID, serverID);
            ProjectAgent newProjectAgent = new ProjectAgent(projectUID, projectName, serverID, newProjectFolder);
            this.projectAgents.put(newProjectAgent.getProjectUID(), newProjectAgent);
            if (mode == 1) {
                EOProject newProject = new EOProject();
                newProject.setUID(projectUID);
                EOAttributeTypeID nameAttributeTypeID = new EOAttributeTypeID(ProjectAttributeTypeProvider.ATTRID_NAME.getUID(), "name");
                EOString eoName = new EOString(projectName);
                EOAttribute eoNameAttribute = new EOAttribute();
                eoNameAttribute.setAttributeTypeID(nameAttributeTypeID);
                eoNameAttribute.setValueAsEO((EOEncodableObject)eoName);
                newProject.addAttribute(eoNameAttribute);
                EOAttributeTypeID languageAttributeTypeID = new EOAttributeTypeID(ProjectAttributeTypeProvider.ATTRID_LANGUAGE.getUID(), "language");
                EOString eoLanguage = new EOString(projectLanguage);
                EOAttribute eoLangaugeAttribute = new EOAttribute();
                eoLangaugeAttribute.setAttributeTypeID(languageAttributeTypeID);
                eoLangaugeAttribute.setValueAsEO((EOEncodableObject)eoLanguage);
                newProject.addAttribute(eoLangaugeAttribute);
                this.getProjectManagerServerProxy(serverID).createProjectOnServer(newProject, newProjectFolder);
            }
            try {
                newProjectAgent.openWithProgressbar(mode == 1, triggerUserOnOpenActions, currentPage);
                if (mode == 1 && newProjectAgent.isOpened()) {
                    newProjectAgent.getModuleController().projectCreated();
                }
            }
            catch (InterruptedException e) {
                logger.error("could not init project ", (Throwable)e);
            }
            ProjectView.select(newProjectAgent);
            for (IProjectExistenceListener projectExistanceListener : this.existanceListeners) {
                projectExistanceListener.projectCreated(newProjectAgent);
            }
            return newProjectAgent;
        }
        return null;
    }

    private File createProjectFolder(String projectUID, String serverID) throws IOException {
        File newProjectFolder = this.getProjectFolder(projectUID, serverID);
        try {
            if (newProjectFolder.exists()) {
                logger.warn("Obsolete project?-directory " + newProjectFolder.toString() + " for project with UID " + projectUID + " found. Will delete/recreate it now to ensure it is empty.");
                assert (false);
            }
            FileHelper.deleteFileOrDirectory((File)newProjectFolder);
            FileHelper.ensureDirectoryExistance((File)newProjectFolder);
        }
        catch (JvmExternalResourceInteractionException jeri) {
            throw jeri.toIOException();
        }
        return newProjectFolder;
    }

    public void deleteProjectOnClient(IFrameProjectAgent projectAgent, Shell parentShell) {
        this.deleteProjectOnClient(projectAgent, true, parentShell);
    }

    public void deleteProjectOnClient(IFrameProjectAgent projectAgent, boolean askUser, Shell parentShell) {
        int success;
        if (askUser) {
            String question = Messages.getString("ProjectMgr.Do_you_really_want_to_delete_the_project");
            if (this.getProjectManagerServerProxy(projectAgent.getServerID()).serverKeepsCopy()) {
                question = String.valueOf(question) + Messages.getString("ProjectMgr.The_project_will_only_be_deleted_on_the_client");
            }
            MessageDialog removeProjectDialog = new MessageDialog(EclipseSWTHelper.getShell(), Messages.getString("ProjectMgr.Delete_Project_29"), Icons.getArcWayLogo(), question, 3, new String[]{Messages.getString("ProjectMgr.Delete_31"), Messages.getString("ProjectMgr.Cancel_32")}, 1);
            success = removeProjectDialog.open();
        } else {
            success = 0;
        }
        if (success == 0) {
            this.removeProjectConfiguration(projectAgent);
            for (IProjectExistenceListener projectExistanceListener : this.existanceListeners) {
                projectExistanceListener.projectDeleted(projectAgent);
            }
        }
    }

    private boolean removeProjectConfiguration(IFrameProjectAgent projectAgent) {
        boolean success = true;
        success = projectAgent.getOfflineModeManager().isInOfflineMode() ? ProjectMgr.prepareRemoveProjectConfigurationInOfflineMode(projectAgent) : this.prepareRemoveProjectConfigurationInOnlineMode(projectAgent);
        if (success) {
            this.closeProject(projectAgent, false);
            this.projectAgents.remove(projectAgent.getProjectUID());
            File root = projectAgent.getProjectRoot();
            this.activeProject = null;
            ProjectView.refresh1();
            try {
                FileHelper.deleteExistingFileOrDirectory((File)root);
            }
            catch (JvmExternalResourceInteractionException e) {
                logger.error(e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return success;
    }

    private static boolean prepareRemoveProjectConfigurationInOfflineMode(IFrameProjectAgent projectAgent) {
        Shell parentShell = EclipseSWTHelper.getShell();
        IWorkbenchPage currentPage = EclipseSWTHelper.getWorkbenchPage(null);
        final boolean[] success = new boolean[]{true};
        final boolean[] forceDeletionWithoutConnection = new boolean[1];
        final MessageDialog removeProjectCorpseDialog = new MessageDialog(parentShell, Messages.getString("ProjectMgr.DeleteProject.InSpiteOfOfflineMode.Title"), Icons.getArcWayLogo(), Messages.getString("ProjectMgr.DeleteProject.InSpiteOfOfflineMode.Message"), 4, new String[]{IDialogConstants.PROCEED_LABEL, IDialogConstants.CANCEL_LABEL}, 1);
        IHyperlinkListener hyperlinkListener = new IHyperlinkListener(){

            public void linkEntered(HyperlinkEvent e) {
                Hyperlink hyperlink = (Hyperlink)e.getSource();
                hyperlink.setForeground(hyperlink.getDisplay().getSystemColor(1));
            }

            public void linkExited(HyperlinkEvent e) {
                Hyperlink hyperlink = (Hyperlink)e.getSource();
                hyperlink.setForeground(hyperlink.getDisplay().getSystemColor(9));
            }

            public void linkActivated(HyperlinkEvent e) {
                Hyperlink hyperlink = (Hyperlink)e.getSource();
                hyperlink.getShell().close();
                if (removeProjectCorpseDialog.open() == 1) {
                    success[0] = false;
                } else {
                    forceDeletionWithoutConnection[0] = true;
                }
            }
        };
        MessageDialogWithHyperlink removeProjectDialog = new MessageDialogWithHyperlink(parentShell, Messages.getString("ProjectMgr.DeleteProject.InOffModeNotPossible.Title"), Icons.getArcWayLogo(), Messages.getString("ProjectMgr.DeleteProject.InOffModeNotPossible.Message"), 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 1, hyperlinkListener, Messages.getString("ProjectMgr.DeleteProject.InOffModeNotPossible.HyperlinkLabel"), Messages.getString("ProjectMgr.DeleteProject.InOffModeNotPossible.HyperlinkText"));
        if (removeProjectDialog.open() == 0) {
            ExProjectOpenAbortWithMessage exceptionWhileOpeningProjectInOfflineMode = null;
            if (!projectAgent.isOpened()) {
                try {
                    boolean triggerUserOnOpenActions = false;
                    projectAgent.open(false, triggerUserOnOpenActions, currentPage);
                }
                catch (LoginCanceledException triggerUserOnOpenActions) {
                }
                catch (ServerNotAvailableException triggerUserOnOpenActions) {
                }
                catch (UnknownServerException triggerUserOnOpenActions) {
                }
                catch (EXServerException triggerUserOnOpenActions) {
                }
                catch (ExProjectOpenAbortWithMessage e1) {
                    exceptionWhileOpeningProjectInOfflineMode = e1;
                    logger.error("Exception while opening project in offline mode (project deletion)", (Throwable)e1);
                }
            }
            if (exceptionWhileOpeningProjectInOfflineMode == null) {
                try {
                    projectAgent.getOfflineModeManager().leaveMode(currentPage);
                    if (projectAgent.getOfflineModeManager().isInOfflineMode()) {
                        success[0] = false;
                    }
                }
                catch (EXOfflineMode exOM) {
                    int exceptionLevelForDialog;
                    String dialogTitle;
                    success[0] = false;
                    int exceptionLevel = exOM.getExceptionLevel();
                    switch (exceptionLevel) {
                        case 2: {
                            dialogTitle = Messages.getString("ProjectMgr.DeleteProject.ErrorLeavingOffMode.Warning");
                            exceptionLevelForDialog = 3;
                            break;
                        }
                        case 3: {
                            dialogTitle = Messages.getString("ProjectMgr.DeleteProject.ErrorLeavingOffMode.Information");
                            exceptionLevelForDialog = 4;
                            break;
                        }
                        default: {
                            dialogTitle = Messages.getString("ProjectMgr.DeleteProject.ErrorLeavingOffMode.Exception");
                            exceptionLevelForDialog = 2;
                        }
                    }
                    String humanReadableDescriptionOfConsequence = Messages.getString("ProjectMgr.DeleteProject.CannotLeaveOffMode");
                    ModificationProblem mProblem = new ModificationProblem(exOM, exceptionLevelForDialog, humanReadableDescriptionOfConsequence);
                    ArrayList<ModificationProblem> mProblems = new ArrayList<ModificationProblem>();
                    mProblems.add(mProblem);
                    ModificationProblemsDialog mpDialog = new ModificationProblemsDialog(mProblems, dialogTitle, parentShell);
                    mpDialog.open();
                }
            } else {
                MessageDialog errorOpeningOfflineProject = new MessageDialog(parentShell, Messages.getString("ProjectMgr.DeleteProject.ErrorOpeningOffProject.Title"), Icons.getArcWayLogo(), Messages.getString("ProjectMgr.DeleteProject.ErrorOpeningOffProject.Message"), 1, new String[]{IDialogConstants.OK_LABEL}, 1);
                errorOpeningOfflineProject.open();
            }
        } else if (!forceDeletionWithoutConnection[0]) {
            success[0] = false;
        }
        return success[0];
    }

    private boolean prepareRemoveProjectConfigurationInOnlineMode(IFrameProjectAgent projectAgent) {
        Shell parentShell = EclipseSWTHelper.getShell();
        IWorkbenchPage currentPage = EclipseSWTHelper.getWorkbenchPage(null);
        final boolean[] success = new boolean[]{true};
        final boolean[] continueDeletion = new boolean[]{true};
        final boolean[] forceDeletionWithoutConnection = new boolean[1];
        Throwable thrownServerExceptionWhileOpenProject = null;
        if (projectAgent.isOpened()) {
            projectAgent.switchAllEditorsIntoViewModeWithoutSaving(parentShell);
            success[0] = projectAgent.getLockManager().releaseAllLocks();
        } else {
            ServerConnection serverConnection = this.getGeneralServerProxy().getServerConnection(projectAgent.getServerID());
            if (!serverConnection.isConnected()) {
                final MessageDialog removeProjectDialog = new MessageDialog(parentShell, Messages.getString("ProjectMgr.DeleteProject.InSpiteOfNoConnection.Title"), Icons.getArcWayLogo(), Messages.getString("ProjectMgr.DeleteProject.InSpiteOfNoConnection.Message"), 4, new String[]{IDialogConstants.PROCEED_LABEL, IDialogConstants.CANCEL_LABEL}, 1);
                IHyperlinkListener hyperlinkListener = new IHyperlinkListener(){

                    public void linkEntered(HyperlinkEvent e) {
                        Hyperlink hyperlink = (Hyperlink)e.getSource();
                        hyperlink.setForeground(hyperlink.getDisplay().getSystemColor(1));
                    }

                    public void linkExited(HyperlinkEvent e) {
                        Hyperlink hyperlink = (Hyperlink)e.getSource();
                        hyperlink.setForeground(hyperlink.getDisplay().getSystemColor(9));
                    }

                    public void linkActivated(HyperlinkEvent e) {
                        Hyperlink hyperlink = (Hyperlink)e.getSource();
                        hyperlink.getShell().close();
                        if (removeProjectDialog.open() == 1) {
                            continueDeletion[0] = false;
                            success[0] = false;
                        } else {
                            forceDeletionWithoutConnection[0] = true;
                        }
                    }
                };
                MessageDialogWithHyperlink askForConnectToServer = new MessageDialogWithHyperlink(parentShell, Messages.getString("ProjectMgr.DeleteProject.ShallConnect.Title"), Icons.getArcWayLogo(), Messages.getString("ProjectMgr.DeleteProject.ShallConnect.Message"), 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 1, hyperlinkListener, Messages.getString("ProjectMgr.DeleteProject.ShallConnect.HyperlinkLabel"), Messages.getString("ProjectMgr.DeleteProject.ShallConnect.HyperlinkText"));
                if (askForConnectToServer.open() == 1) {
                    continueDeletion[0] = false;
                    success[0] = false;
                }
            }
            if (!forceDeletionWithoutConnection[0] && continueDeletion[0]) {
                String loggerMessage = null;
                try {
                    IProjectManagerServerProxy serverproxy = this.getProjectManagerServerProxy(projectAgent.getServerID());
                    serverproxy.forceLogin();
                    EOGenericMessage metadataReqContent = new EOGenericMessage();
                    metadataReqContent.addAttribute("uid", projectAgent.getProjectUID());
                    metadataReqContent.addChild((EncodableObjectBase)new EOList(0));
                    loggerMessage = "Check if project still exists on server fails. [project deletion]";
                    EOServerResponse response = serverproxy.sendRequest("frame.project", "frame.GetProject", (EncodableObjectBase)metadataReqContent);
                    if (response == null) {
                        throw new EXProjectDoesNotExist(projectAgent.getProjectUID());
                    }
                    loggerMessage = "Project cannot be opened, locks could not be released. [project deletion]";
                    boolean triggerUserOnOpenActions = false;
                    success[0] = projectAgent.open(false, triggerUserOnOpenActions, currentPage) ? projectAgent.getLockManager().releaseAllLocks() : false;
                }
                catch (LoginCanceledException e) {
                    success[0] = false;
                    thrownServerExceptionWhileOpenProject = e;
                    logger.error(loggerMessage, (Throwable)e);
                }
                catch (ServerNotAvailableException e) {
                    success[0] = false;
                    logger.error(loggerMessage, (Throwable)e);
                }
                catch (UnknownServerException e) {
                    success[0] = false;
                    thrownServerExceptionWhileOpenProject = e;
                    logger.error(loggerMessage, (Throwable)e);
                }
                catch (EXProjectDoesNotExist e) {
                }
                catch (EXServerException e) {
                    success[0] = false;
                    thrownServerExceptionWhileOpenProject = e;
                    logger.error(loggerMessage, (Throwable)e);
                }
                catch (ExProjectOpenAbortWithMessage e) {
                    success[0] = false;
                    thrownServerExceptionWhileOpenProject = e;
                    logger.error(loggerMessage, (Throwable)e);
                }
            }
        }
        if (!success[0] && continueDeletion[0]) {
            String dialogMessage = Messages.getString("ProjectMgr.DeleteProject.CantDeleteCauseException.StandardMessage");
            boolean showDialog = true;
            if (thrownServerExceptionWhileOpenProject != null) {
                if (thrownServerExceptionWhileOpenProject instanceof LoginCanceledException) {
                    showDialog = false;
                }
                dialogMessage = NLS.bind((String)Messages.getString("ProjectMgr.DeleteProject.CantDeleteCauseException.ServerExceptionMessage"), (Object)thrownServerExceptionWhileOpenProject.getMessage());
            }
            if (showDialog) {
                final MessageDialog removeProjectDialog = new MessageDialog(parentShell, Messages.getString("ProjectMgr.DeleteProject.InSpiteOfServerException.Title"), Icons.getArcWayLogo(), Messages.getString("ProjectMgr.DeleteProject.InSpiteOfServerException.Message"), 4, new String[]{IDialogConstants.PROCEED_LABEL, IDialogConstants.CANCEL_LABEL}, 1);
                IHyperlinkListener hyperlinkListener = new IHyperlinkListener(){

                    public void linkEntered(HyperlinkEvent e) {
                        Hyperlink hyperlink = (Hyperlink)e.getSource();
                        hyperlink.setForeground(hyperlink.getDisplay().getSystemColor(1));
                    }

                    public void linkExited(HyperlinkEvent e) {
                        Hyperlink hyperlink = (Hyperlink)e.getSource();
                        hyperlink.setForeground(hyperlink.getDisplay().getSystemColor(9));
                    }

                    public void linkActivated(HyperlinkEvent e) {
                        Hyperlink hyperlink = (Hyperlink)e.getSource();
                        hyperlink.getShell().close();
                        if (removeProjectDialog.open() == 0) {
                            success[0] = true;
                        }
                    }
                };
                MessageDialogWithHyperlink informAboutServerException = new MessageDialogWithHyperlink(parentShell, Messages.getString("ProjectMgr.DeleteProject.CantDeleteCauseException.Title"), Icons.getArcWayLogo(), dialogMessage, 1, new String[]{IDialogConstants.OK_LABEL}, 1, hyperlinkListener, Messages.getString("ProjectMgr.DeleteProject.InSpiteOfServerException.HyperlinkLabel"), Messages.getString("ProjectMgr.DeleteProject.InSpiteOfServerException.HyperlinkText"));
                informAboutServerException.open();
            }
        }
        return success[0];
    }

    public void deleteProjectOnServer(IFrameProjectAgent projectToDelete, IWorkbenchPage currentPage) {
        boolean isAdmin;
        boolean wasClosed;
        boolean delete;
        Shell shell;
        block22: {
            shell = currentPage == null ? null : currentPage.getWorkbenchWindow().getShell();
            IProjectManagerServerProxy sp = this.getProjectManagerServerProxy(projectToDelete.getServerID());
            delete = false;
            wasClosed = false;
            isAdmin = false;
            try {
                if (!sp.isAdminUser(false)) {
                    if (!projectToDelete.isOpened()) {
                        try {
                            boolean triggerUserOnOpenActions = false;
                            projectToDelete.openWithProgressbar(false, triggerUserOnOpenActions, currentPage);
                        }
                        catch (LoginCanceledException e) {
                            logger.error("could not execute", (Throwable)e);
                        }
                        catch (ServerNotAvailableException e) {
                            logger.error("could not execute", (Throwable)e);
                        }
                        catch (UnknownServerException e) {
                            logger.error("could not execute", (Throwable)e);
                        }
                        catch (EXServerException e) {
                            logger.error("could not execute", (Throwable)e);
                        }
                        catch (InterruptedException e) {
                            logger.error("could not execute", (Throwable)e);
                        }
                        catch (ExProjectOpenAbortWithMessage e) {
                            logger.error("could not execute", (Throwable)e);
                            projectToDelete.showProjectOpenAbortWithMessageDialog(shell, e);
                        }
                    }
                    wasClosed = delete = projectToDelete.isOpened();
                    break block22;
                }
                isAdmin = true;
                delete = true;
            }
            catch (ServerNotAvailableException e1) {
                logger.error("could not execute", (Throwable)e1);
            }
            catch (EXServerException e1) {
                logger.error("could not execute", (Throwable)e1);
            }
            catch (LoginCanceledException e1) {
                logger.error("could not execute", (Throwable)e1);
            }
        }
        if (delete) {
            if (!isAdmin && !projectToDelete.getFramePermissionChecker().hasPermission("deleteProjectOnServer", (String)null, projectToDelete)) {
                MessageDialog mDialog = new MessageDialog(shell, Messages.getString("ProjectMgr.cannot_delete_project"), null, Messages.getString("ProjectMgr.insufficient_permissions"), 1, new String[]{IDialogConstants.OK_LABEL}, 0);
                mDialog.open();
                if (wasClosed) {
                    projectToDelete.close(null);
                }
            } else {
                try {
                    this.removeProjectConfiguration(projectToDelete);
                    this.getProjectManagerServerProxy(projectToDelete.getServerID()).deleteProjectOnServer(projectToDelete.getProjectUID());
                }
                catch (EXServerException e) {
                    logger.error("deleteProjectOnServer() - Server Exception while deleting project", (Throwable)e);
                    PSCServices.getServiceFacade().showException((Exception)((Object)e), Messages.getString("ProjectMgr.Server_Exception_while_deleting_project_45"));
                }
                catch (ServerNotAvailableException e) {
                    logger.warn("deleteProjectOnServer() - Server not available while deleting project", (Throwable)e);
                }
                catch (UnknownServerException e) {
                    logger.warn("deleteProjectOnServer() - Server is unknown when deleting project", (Throwable)e);
                }
                catch (LoginCanceledException loginCanceledException) {
                    // empty catch block
                }
            }
        }
    }

    private File getProjectFolder(String projectUID, String serverID) throws IOException {
        File serverFolder = ProjectMgr.calculateServerFolder(serverID);
        File projectFolder = new File(serverFolder, projectUID);
        return projectFolder;
    }

    public static String calculateServerFolderName(String serverID) throws IOException {
        return ProjectMgr.calculateServerFolder(serverID).getName();
    }

    private static File calculateServerFolder(String serverID) throws IOException {
        assert (serverID != null);
        File serversFolder = ProjectMgr.getServersDirectory();
        String relTagFileName = String.valueOf(serverID) + ".serveruid";
        File serverFolder = null;
        File[] serversDirectoryContent = serversFolder.listFiles();
        if (serversDirectoryContent == null) {
            logger.fatal("ProjectMgr: \"" + serversFolder.getAbsolutePath() + "\" is expected to be a accessible directory but does not seem to be one.");
        }
        int i = 0;
        while (serverFolder == null && serversDirectoryContent != null && i < serversDirectoryContent.length) {
            File serverDirectoryCandidate = serversDirectoryContent[i];
            if (serverDirectoryCandidate.isDirectory() && new File(serverDirectoryCandidate, relTagFileName).exists()) {
                serverFolder = serverDirectoryCandidate;
            }
            ++i;
        }
        if (serverFolder == null) {
            int serverDirectoryNumber = 4096;
            while (serverFolder == null) {
                String serverDirectoryNumberString = Integer.toHexString(serverDirectoryNumber);
                File newServerFolderCandidate = new File(serversFolder, serverDirectoryNumberString);
                if (!newServerFolderCandidate.exists()) {
                    newServerFolderCandidate.mkdir();
                    new File(newServerFolderCandidate, relTagFileName).createNewFile();
                    serverFolder = newServerFolderCandidate;
                }
                ++serverDirectoryNumber;
            }
        }
        return serverFolder;
    }

    public IGeneralServerProxy getGeneralServerProxy() {
        return this.generalServerProxy;
    }

    public int getLicenseConfiguration() {
        IClientProductLicenseManager productLicenseManager = this.generalServerProxy.getProductLicenseManager();
        if (productLicenseManager.hasProductLicense(ClientProductLicenseTypes.FULL_LICENSE) || productLicenseManager.hasProductLicense(ClientProductLicenseTypes.FULL_LICENSE_SA) || productLicenseManager.hasProductLicense(ClientProductLicenseTypes.DESIGNER_LICENSE)) {
            return 1;
        }
        if (productLicenseManager.hasProductLicense(ClientProductLicenseTypes.READER_LICENSE_CS) || productLicenseManager.hasProductLicense(ClientProductLicenseTypes.READER_LICENSE_SA) || productLicenseManager.hasProductLicense(ClientProductLicenseTypes.DESIGNER_READER_LICENSE)) {
            return 2;
        }
        if (!this.generalServerProxy.canServerProvideLicenses()) {
            return 3;
        }
        return 4;
    }

    public boolean preShutdown(IWorkbench workbench, boolean forced) {
        boolean askUserOnExit;
        boolean allowShutdown = true;
        if (!isInScriptMode && !forced && (askUserOnExit = FramePlugin.getDefault().getPreferenceStore().getString("Behaviour.AskOnExit").equals("prompt"))) {
            boolean modificationsExist = false;
            for (ProjectAgent projectAgent : this.projectAgents.values()) {
                if (!projectAgent.isOpened() || !projectAgent.getFrameServerProxy().concurrentWorkPossible() || !projectAgent.getCommitMgr().areModificationsPresent()) continue;
                modificationsExist = true;
                break;
            }
            if (modificationsExist) {
                MessageDialogWithToggle dialogue;
                int result;
                Shell shell = null;
                if (workbench.getActiveWorkbenchWindow() != null) {
                    shell = workbench.getActiveWorkbenchWindow().getShell();
                } else if (workbench.getWorkbenchWindows() != null && workbench.getWorkbenchWindows().length >= 1) {
                    shell = workbench.getWorkbenchWindows()[0].getShell();
                }
                if (shell != null && (result = (dialogue = MessageDialogWithToggle.openOkCancelConfirm((Shell)shell, (String)Messages.getString("ProjectMgr.Warning.ModificationsOnExit.Title"), (String)Messages.getString("ProjectMgr.Warning.ModificationsOnExit.Message"), (String)Messages.getString("ProjectMgr.Warning.ModificationsOnExit.ToggleMessage"), (boolean)false, (IPreferenceStore)FramePlugin.getDefault().getPreferenceStore(), (String)"Behaviour.AskOnExit")).getReturnCode()) == 1) {
                    allowShutdown = false;
                }
            }
        }
        return allowShutdown;
    }

    public void postShutdown(IWorkbench workbench) {
        if (!isInScriptMode) {
            ProjectAgent[] agents;
            IPreferenceStore preferences = FramePlugin.getDefault().getPreferenceStore();
            String openProjectsPrefValue = "";
            ProjectAgent[] projectAgentArray = agents = this.getOpenedProjects();
            int n = agents.length;
            int n2 = 0;
            while (n2 < n) {
                ProjectAgent agent = projectAgentArray[n2];
                if (agent.isOpened()) {
                    openProjectsPrefValue = String.valueOf(openProjectsPrefValue) + agent.getProjectUID() + "-";
                }
                ++n2;
            }
            preferences.setValue(OPEN_PROJECTS_PREF_KEY, openProjectsPrefValue);
        }
        this.disconnectFromAllServers();
    }

    public void windowActivated(IWorkbenchWindow window) {
        this.lastActivatedWindow = window;
    }

    public void windowDeactivated(IWorkbenchWindow window) {
    }

    public void windowClosed(IWorkbenchWindow window) {
    }

    public void windowOpened(IWorkbenchWindow window) {
    }

    public IFrameProjectAgent getProjectAgent(String serverName, String projectName) {
        ServerConnection sc = this.getServerConnection(serverName);
        if (sc != null) {
            return this.getProjectAgent(sc, projectName);
        }
        return null;
    }

    public ServerConnection getServerConnection(String serverName) {
        for (ServerConnection sc : this.getConfiguredServerConnections()) {
            if (!sc.getServerName().trim().equalsIgnoreCase(serverName.trim())) continue;
            return sc;
        }
        return null;
    }

    private IFrameProjectAgent getProjectAgent(ServerConnection sc, String projectName) {
        if (sc.isConnected()) {
            try {
                for (EOProject project : this.getEOProjectsOnServer(sc.getServerID())) {
                    if (!Project.getProjectName(project).equalsIgnoreCase(projectName.trim())) continue;
                    return this.getProjectAgent(project.getProjectUID());
                }
            }
            catch (ServerNotAvailableException e) {
                logger.error("could not get projectagent", (Throwable)e);
            }
            catch (EXServerException e) {
                logger.error("could not get projectagent", (Throwable)e);
            }
            catch (LoginCanceledException e) {
                logger.error("could not get projectagent", (Throwable)e);
            }
            catch (UnknownServerException e) {
                logger.error("could not get projectagent", (Throwable)e);
            }
        }
        List<ProjectAgent> configuredProjectsOfServer = this.getConfiguredProjectsOfServer(sc.getServerID());
        for (ProjectAgent project : configuredProjectsOfServer) {
            if (!project.getProjectName().equalsIgnoreCase(projectName.trim())) continue;
            return project;
        }
        return null;
    }

    @Override
    public IFMCAModule getModule(String projectUID, String moduleID) throws EXProjectUnknown, EXProjectNotOpen, EXModuleUnknown {
        ProjectAgent projectAgent = this.getProjectAgent(projectUID);
        if (projectAgent == null) {
            throw new EXProjectUnknown();
        }
        if (!projectAgent.isOpened()) {
            throw new EXProjectNotOpen();
        }
        IFMCAModule module = projectAgent.getModuleController().getModule(moduleID);
        if (module == null) {
            throw new EXModuleUnknown();
        }
        return module;
    }

    public String getWorkspaceUID() {
        if (this.workspaceUID == null) {
            this.workspaceUID = WorkspaceUIDAccessAgent.getWorkspaceUID((File)this.rootDirectory);
        }
        return this.workspaceUID;
    }

    public Map<String, List<String>> getCurrentCommitVersions(String serverID) {
        HashMap<String, List<String>> projectUID2CommitVersionUIDs = new HashMap<String, List<String>>();
        for (Map.Entry<String, ProjectAgent> entry : this.projectAgents.entrySet()) {
            List<String> commitVersionUIDs;
            String projectUID = entry.getKey();
            ProjectAgent projectAgent = entry.getValue();
            if (!projectAgent.getServerID().equals(serverID) || (commitVersionUIDs = projectAgent.getCommitVersionUIDs()).isEmpty()) continue;
            projectUID2CommitVersionUIDs.put(projectUID, commitVersionUIDs);
        }
        return projectUID2CommitVersionUIDs;
    }

    public void refreshCommitVersions(String serverID, Map<String, List<String>> projectUID2CommitVersionUIDs) {
        if (!projectUID2CommitVersionUIDs.isEmpty()) {
            for (Map.Entry<String, ProjectAgent> entry : this.projectAgents.entrySet()) {
                List<String> commitUIDs;
                String projectUID = entry.getKey();
                ProjectAgent projectAgent = entry.getValue();
                if (!projectAgent.getServerID().equals(serverID) || (commitUIDs = projectUID2CommitVersionUIDs.get(projectUID)) == null) continue;
                projectAgent.refreshCommitVersionUIDs(commitUIDs);
            }
        }
    }

    public synchronized void addProjectExistanceListener(IProjectExistenceListener projectExistanceListener) {
        if (this.existanceListeners.contains(projectExistanceListener)) {
            throw new IllegalStateException("Argument listener already contained");
        }
        this.existanceListeners.add(projectExistanceListener);
    }

    public synchronized void removeProjectExistanceListener(IProjectExistenceListener projectExistanceListener) {
        if (!this.existanceListeners.contains(projectExistanceListener)) {
            throw new IllegalStateException("Argument listener not contained");
        }
        this.existanceListeners.remove(projectExistanceListener);
    }

    public static interface IProjectClosedListener {
        public void projectClosed(String var1);
    }
}

