/*
 * Decompiled with CFR 0.152.
 */
package de.plans.fmca.client;

import de.plans.fmca.client.Messages;
import de.plans.fmca.client.PSCServices;
import de.plans.lib.xml.parameter.XMLConfigParameterMgr;
import de.plans.psc.client.communication.EOTrustedParameter;
import java.io.File;
import java.io.IOException;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class FMCAPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Composite preferencePageParent;
    private Text fldTrustStoreFilePath;
    private Button btnBrowseTrustStoreFile;
    private Text fldTrustStorePassword;
    private XMLConfigParameterMgr parameterMgr;
    private EOTrustedParameter trustedParameter;

    public void init(IWorkbench workbench) {
        this.parameterMgr = PSCServices.getServiceFacade().getParameterManager();
        this.trustedParameter = (EOTrustedParameter)this.parameterMgr.getSubtree(EOTrustedParameter.XML_NAME);
    }

    protected Control createContents(Composite parent) {
        this.preferencePageParent = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.preferencePageParent.setLayout((Layout)layout);
        this.preferencePageParent.setFont(parent.getFont());
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        this.preferencePageParent.setLayoutData((Object)gridData);
        this.createContent();
        this.initializeValues();
        return this.preferencePageParent;
    }

    private void createContent() {
        Group sslGrp = new Group(this.preferencePageParent, 32);
        sslGrp.setText(Messages.getString("FMCAPreferencePage.0"));
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        layout.horizontalSpacing = 5;
        layout.verticalSpacing = 5;
        sslGrp.setLayout((Layout)layout);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        sslGrp.setLayoutData((Object)gridData);
        Label trustStoreFileLabel = new Label((Composite)sslGrp, 0);
        trustStoreFileLabel.setText(Messages.getString("FMCAPreferencePage.1"));
        trustStoreFileLabel.setLayoutData((Object)new GridData(128));
        this.fldTrustStoreFilePath = new Text((Composite)sslGrp, 2048);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.fldTrustStoreFilePath.setLayoutData((Object)gridData);
        this.btnBrowseTrustStoreFile = new Button((Composite)sslGrp, 8);
        this.btnBrowseTrustStoreFile.setText(Messages.getString("FMCAPreferencePage.Browse_7"));
        this.btnBrowseTrustStoreFile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FMCAPreferencePage.this.getTrustStoreFile();
            }
        });
        Label trusStorePasswordLabel = new Label((Composite)sslGrp, 0);
        trusStorePasswordLabel.setText(Messages.getString("FMCAPreferencePage.2"));
        this.fldTrustStorePassword = new Text((Composite)sslGrp, 2048);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.fldTrustStorePassword.setLayoutData((Object)gridData);
    }

    private void initializeValues() {
        if (this.trustedParameter != null) {
            if (this.trustedParameter.getTrustStore() != null) {
                this.fldTrustStoreFilePath.setText(this.trustedParameter.getTrustStore());
            }
            if (this.trustedParameter.getTrustStorePassword() != null) {
                this.fldTrustStorePassword.setText(this.trustedParameter.getTrustStorePassword());
            }
        }
    }

    protected void performDefaults() {
        this.fldTrustStoreFilePath.setText("");
        this.fldTrustStorePassword.setText("");
        super.performDefaults();
    }

    public boolean performOk() {
        if (this.trustedParameter != null) {
            if (this.fldTrustStoreFilePath.getText().trim().length() > 0) {
                this.trustedParameter.setTrustStore(this.fldTrustStoreFilePath.getText().trim());
            } else {
                this.trustedParameter.setTrustStore(null);
            }
            if (this.fldTrustStorePassword.getText().trim().length() > 0) {
                this.trustedParameter.setTrustStorePassword(this.fldTrustStorePassword.getText().trim());
            } else {
                this.trustedParameter.setTrustStorePassword(null);
            }
        }
        try {
            this.parameterMgr.commitParameters();
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    private void getTrustStoreFile() {
        File tempFile = this.getFile(new File(this.fldTrustStoreFilePath.getText()));
        if (tempFile != null) {
            this.fldTrustStoreFilePath.setText(tempFile.getAbsolutePath());
        }
    }

    private File getFile(File startingDirectory) {
        String file;
        FileDialog dialog = new FileDialog(this.getShell(), 4096);
        if (startingDirectory != null) {
            dialog.setFileName(startingDirectory.getPath());
        }
        if ((file = dialog.open()) != null && (file = file.trim()).length() > 0) {
            return new File(file);
        }
        return null;
    }
}

