/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.documentmodule.client.messages;

import com.arcway.cockpit.documentmodule.client.messages.description.CategoryDescription;
import com.arcway.cockpit.documentmodule.client.messages.description.DocumentContainerDescription;
import com.arcway.cockpit.documentmodule.client.messages.description.RLFileSystemLinkDescription;
import com.arcway.cockpit.documentmodule.client.messages.description.RLWebLinkDescription;
import com.arcway.cockpit.modulelib2.client.messages.DataTypesHelper;
import com.arcway.cockpit.modulelib2.client.messages.IDataTypesHelper;
import com.arcway.cockpit.modulelib2.client.messages.IDataTypesHelper_Core;
import com.arcway.cockpit.modulelib2.client.messages.description.IModuleDataTypeDescription;
import com.arcway.lib.java.collectionmaps.SetMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class DCMDataTypesHelper
implements IDataTypesHelper_Core {
    private static IDataTypesHelper singleton;
    private static final Collection<String> administrativeDataTypes;
    private static final Collection<String> documentationDataTypes;
    private static final Collection<String> virtualDataTypes;
    private static final SetMap<String, String> map_childTypeID_parentTypeIDs;
    private static final Map<String, IModuleDataTypeDescription> map_typeID_typeDescription;

    static {
        administrativeDataTypes = Collections.EMPTY_SET;
        documentationDataTypes = Arrays.asList("dcm.category", "dcm.documentcontainer", "dcm.weblink", "dcm.filesystemlink");
        virtualDataTypes = Arrays.asList("dcm.ResourceLocator");
        map_childTypeID_parentTypeIDs = new SetMap();
        map_childTypeID_parentTypeIDs.add((Object)"dcm.category", (Object)"hierarchyroot");
        map_childTypeID_parentTypeIDs.add((Object)"dcm.documentcontainer", (Object)"dcm.category");
        map_childTypeID_parentTypeIDs.add((Object)"dcm.filesystemlink", (Object)"dcm.documentcontainer");
        map_childTypeID_parentTypeIDs.add((Object)"dcm.weblink", (Object)"dcm.documentcontainer");
        map_typeID_typeDescription = new HashMap<String, IModuleDataTypeDescription>();
        map_typeID_typeDescription.put("dcm.category", (IModuleDataTypeDescription)new CategoryDescription());
        map_typeID_typeDescription.put("dcm.documentcontainer", (IModuleDataTypeDescription)new DocumentContainerDescription());
        map_typeID_typeDescription.put("dcm.filesystemlink", (IModuleDataTypeDescription)new RLFileSystemLinkDescription());
        map_typeID_typeDescription.put("dcm.weblink", (IModuleDataTypeDescription)new RLWebLinkDescription());
    }

    public static IDataTypesHelper getDefault() {
        if (singleton == null) {
            singleton = new DataTypesHelper((IDataTypesHelper_Core)new DCMDataTypesHelper());
        }
        return singleton;
    }

    private DCMDataTypesHelper() {
    }

    public Collection<String> getAdministrativeDataTypes() {
        return administrativeDataTypes;
    }

    public Collection<String> getDocumentationDataTypes() {
        return documentationDataTypes;
    }

    public Collection<String> getVirtualDataTypes() {
        return virtualDataTypes;
    }

    public Collection<String> getParentTypeIDs(String childTypeID) {
        return map_childTypeID_parentTypeIDs.get((Object)childTypeID);
    }

    public IModuleDataTypeDescription getTypeDescription(String typeID) {
        return map_typeID_typeDescription.get(typeID);
    }
}

