/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.documentmodule.client.gui.menu.actions;

import com.arcway.cockpit.documentmodule.client.DocumentModulePlugin;
import com.arcway.cockpit.documentmodule.client.Messages;
import com.arcway.cockpit.documentmodule.client.core.project.PermissionMgr;
import com.arcway.cockpit.documentmodule.client.gui.DataView;
import com.arcway.cockpit.documentmodule.client.gui.dialogs.EditDocumentContainerAdapter;
import com.arcway.cockpit.documentmodule.client.gui.dialogs.SelectCategoryDialogContentProvider;
import com.arcway.cockpit.documentmodule.client.gui.dialogs.SelectCategoryDialogLabelProvider;
import com.arcway.cockpit.documentmodule.client.gui.dialogs.SelectionStatusValidator;
import com.arcway.cockpit.documentmodule.client.messages.Category;
import com.arcway.cockpit.documentmodule.client.messages.DocumentContainer;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.IUniqueElement;
import com.arcway.cockpit.modulelib2.client.core.project.IModelController;
import com.arcway.cockpit.modulelib2.client.core.project.LockAccess;
import com.arcway.cockpit.modulelib2.client.core.project.ModuleLockManager;
import com.arcway.cockpit.modulelib2.client.gui.editdialogs.IModuleDataEditDialogProvider;
import com.arcway.cockpit.modulelib2.client.gui.editdialogs.ModuleDataCreationWizard;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;

public class ActionNewContainerViaModelElement
extends Action {
    private IModelController modelCtrl;
    private final List<IUniqueElement> uniqueElements;
    private final Shell activeShell;
    private final IWorkbenchPart activePart;

    public ActionNewContainerViaModelElement(Shell activeShell, IWorkbenchPart activePart, List<IUniqueElement> uniqueElements) {
        this.activeShell = activeShell;
        this.activePart = activePart;
        this.uniqueElements = uniqueElements;
        if (uniqueElements.size() > 0) {
            String projectUID = uniqueElements.get(0).getProjectUID();
            this.modelCtrl = DocumentModulePlugin.getDefault().getProjectManager().getModelController(projectUID);
        }
    }

    public void run() {
        assert (this.modelCtrl != null);
        SelectCategoryDialogContentProvider contentProvider = new SelectCategoryDialogContentProvider(this.activePart.getSite().getPage(), false);
        SelectCategoryDialogLabelProvider labelProvider = new SelectCategoryDialogLabelProvider();
        ElementTreeSelectionDialog selectionDialog = new ElementTreeSelectionDialog(this.activeShell, (ILabelProvider)labelProvider, (ITreeContentProvider)contentProvider);
        selectionDialog.setAllowMultiple(false);
        selectionDialog.setDoubleClickSelects(true);
        selectionDialog.setMessage(Messages.getString("ActionDelegateNewContainerViaUniqueElement.DialogMessage"));
        selectionDialog.setTitle(Messages.getString("ActionDelegateNewContainerViaUniqueElement.DialogTitle"));
        selectionDialog.setEmptyListMessage(Messages.getString("ActionDelegateNewContainerViaUniqueElement.NoDocumentSetsAvailable"));
        List input = new ArrayList(this.modelCtrl.getAllRootItems());
        IViewPart dataView = this.activePart.getSite().getPage().findView("com.arcway.cockpit.documentmodule.client.gui.dataview");
        if (dataView != null) {
            input = ((DataView)dataView).applySorters(input);
        }
        selectionDialog.setInput(input);
        ModuleLockManager lockManager = (ModuleLockManager)this.modelCtrl.getLockMgr();
        PermissionMgr permissionMgr = (PermissionMgr)this.modelCtrl.getPermissionMgr();
        SelectionStatusValidator validator = new SelectionStatusValidator(lockManager, permissionMgr);
        selectionDialog.setValidator((ISelectionStatusValidator)validator);
        if (selectionDialog.open() == 0) {
            Category newParent = (Category)((Object)selectionDialog.getFirstResult());
            EditDocumentContainerAdapter dialogProvider = new EditDocumentContainerAdapter(newParent);
            ModuleDataCreationWizard wizard = new ModuleDataCreationWizard((IModuleDataEditDialogProvider)dialogProvider, "dcm.documentcontainer", this.modelCtrl, Messages.getString("ActionDelegateNewContainerViaUniqueElement.WizardText"));
            DocumentContainer newItem = new DocumentContainer();
            newItem.setProjectUID(this.modelCtrl.getProjectUID());
            boolean creationPossible = wizard.initialiseWizard(new IModuleData[]{newItem}, new IModuleData[]{newParent});
            if (!creationPossible) {
                ActionNewContainerViaModelElement.releaseInsertLock(validator);
                return;
            }
            WizardDialog dialog = new WizardDialog(this.activeShell, (IWizard)wizard);
            if (dialog.open() == 0) {
                final DocumentContainer documentContainer = dialogProvider.getDocumentContainer();
                if (this.uniqueElements != null) {
                    final Iterator<IUniqueElement> i = this.uniqueElements.iterator();
                    this.modelCtrl.executeTransaction(new Runnable(){

                        @Override
                        public void run() {
                            while (i.hasNext()) {
                                IUniqueElement ue = (IUniqueElement)i.next();
                                ActionNewContainerViaModelElement.this.modelCtrl.createLink(ue.getUID(), (IModuleData)documentContainer, "DocumentContainerUE");
                            }
                        }
                    });
                }
            }
        } else {
            ActionNewContainerViaModelElement.releaseInsertLock(validator);
        }
    }

    private static void releaseInsertLock(SelectionStatusValidator validator) {
        LockAccess insertLock = validator.getLock();
        if (insertLock != null) {
            insertLock.releaseLocks();
        }
    }
}

