/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.documentmodule.client.gui.actions;

import com.arcway.cockpit.client.base.interfaces.frame.propertychanges.IPropertyChanges;
import com.arcway.cockpit.documentmodule.client.DocumentModulePlugin;
import com.arcway.cockpit.documentmodule.client.Messages;
import com.arcway.cockpit.documentmodule.client.core.licensetypes.ClientFunctionLicenseTypeDCMModifyItems;
import com.arcway.cockpit.documentmodule.client.core.project.PermissionMgr;
import com.arcway.cockpit.documentmodule.client.gui.actions.DCMModuleAction;
import com.arcway.cockpit.documentmodule.client.gui.dialogs.EditCategoryAdapter;
import com.arcway.cockpit.documentmodule.client.messages.Category;
import com.arcway.cockpit.frame.client.global.license.IClientFunctionLicenseType2;
import com.arcway.cockpit.frame.client.lib.dataviews.util.IModuleProjectSwitchListener;
import com.arcway.cockpit.modulelib2.client.core.project.IModelController;
import com.arcway.cockpit.modulelib2.client.gui.actions.IActionRunNotifier;
import com.arcway.cockpit.modulelib2.client.gui.editdialogs.IModuleDataEditDialogProvider;
import com.arcway.cockpit.modulelib2.client.gui.editdialogs.ModuleDataCreationWizard;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ui.IWorkbenchPart;

public class ActionNewCategory
extends DCMModuleAction
implements IModuleProjectSwitchListener,
IActionRunNotifier {
    private IModelController modelController;

    public ActionNewCategory() {
        this.setText(Messages.getString("ActionNewCategory.Text"));
        this.setToolTipText(Messages.getString("ActionNewCategory.ToolTip"));
        this.setEnabled(false);
        this.setImageDescriptor(DocumentModulePlugin.getImageDescriptor("Category.gif"));
    }

    protected void handleSelectionChanged(IWorkbenchPart part, ISelection selection) {
    }

    protected void handleProjectChanged(String newProjectUID) {
        boolean hasPermission = false;
        this.modelController = DocumentModulePlugin.getDefault().getProjectManager().getModelController(newProjectUID);
        if (this.modelController != null) {
            PermissionMgr permissionMgr = (PermissionMgr)this.modelController.getPermissionMgr();
            hasPermission = permissionMgr.mayCreateCategories();
        }
        this.setEnabled(hasPermission);
    }

    public void run() {
        assert (this.modelController != null) : "modelController must not be null";
        ModuleDataCreationWizard wizard = new ModuleDataCreationWizard((IModuleDataEditDialogProvider)new EditCategoryAdapter(true), "dcm.category", this.modelController, Messages.getString("ActionNewCategory.WizardText"));
        Category item = new Category();
        item.setProjectUID(this.modelController.getProjectUID());
        boolean creationPossible = wizard.initialiseWizard(new IModuleData[]{item}, new IModuleData[1]);
        if (!creationPossible) {
            return;
        }
        new WizardDialog(this.getContainingShell(), (IWizard)wizard).open();
        this.notifyRunListeners();
    }

    public void modelRefreshed(IPropertyChanges changes, Class clazz) {
        if (this.modelController != null) {
            this.projectSwitched(this.modelController.getProjectUID());
        }
    }

    protected IClientFunctionLicenseType2 getRequiredLicenseType() {
        return ClientFunctionLicenseTypeDCMModifyItems.getInstance();
    }
}

