/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.documentmodule.client.gui.actions;

import com.arcway.cockpit.client.base.interfaces.frame.propertychanges.IPropertyChanges;
import com.arcway.cockpit.documentmodule.client.DocumentModulePlugin;
import com.arcway.cockpit.documentmodule.client.Messages;
import com.arcway.cockpit.documentmodule.client.core.licensetypes.ClientFunctionLicenseTypeDCMModifyItems;
import com.arcway.cockpit.documentmodule.client.core.project.PermissionMgr;
import com.arcway.cockpit.documentmodule.client.gui.actions.DCMModuleActionDelegate;
import com.arcway.cockpit.documentmodule.client.messages.Category;
import com.arcway.cockpit.documentmodule.client.messages.DocumentContainer;
import com.arcway.cockpit.documentmodule.client.messages.IDocumentContainer;
import com.arcway.cockpit.documentmodule.client.messages.RLFileSystemLink;
import com.arcway.cockpit.documentmodule.client.messages.RLWebLink;
import com.arcway.cockpit.documentmodule.client.messages.ResourceLocator;
import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.global.gui.ProjectSelectionAnalyser;
import com.arcway.cockpit.frame.client.global.license.IClientFunctionLicenseType2;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.cockpit.modulelib2.client.core.project.IModelController;
import com.arcway.cockpit.modulelib2.client.core.project.LockAccess;
import com.arcway.cockpit.modulelib2.client.core.project.ModuleLockManager;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;

public class ActionDelegateDelete
extends DCMModuleActionDelegate {
    private static final ILogger logger = Logger.getLogger(ActionDelegateDelete.class);
    private boolean enabled;
    private final Runnable delete = new Runnable(){

        @Override
        public void run() {
            ActionDelegateDelete.this.deleteItems(ActionDelegateDelete.this.currentSelection);
        }
    };
    private Set currentSelection = null;
    private IModelController modelCtrl = null;

    public void run(IAction action) {
        assert (action != null);
        assert (this.currentSelection != null);
        this.modelCtrl.executeTransaction(this.delete);
    }

    public void deleteItems(Set items) {
        assert (this.modelCtrl != null);
        Shell shell = this.getIssuingShell();
        PermissionMgr permissionMgr = (PermissionMgr)this.modelCtrl.getPermissionMgr();
        boolean hasPermission = permissionMgr.mayDeleteItems(items);
        if (!hasPermission) {
            permissionMgr.showNoPermissionMsg(shell);
            return;
        }
        ModuleLockManager lockMgr = (ModuleLockManager)this.modelCtrl.getLockMgr();
        ArrayList<LockAccess> aquiredLocks = new ArrayList<LockAccess>();
        for (Object element : items) {
            Category category;
            LockAccess lock;
            if (element instanceof DocumentContainer) {
                DocumentContainer container = (DocumentContainer)element;
                lock = lockMgr.acquireRemoveLock((ICockpitProjectData)container);
                if (!lock.hasLock()) {
                    this.releaseLocks(aquiredLocks);
                    return;
                }
                aquiredLocks.add(lock);
                continue;
            }
            if (element instanceof ResourceLocator) {
                ResourceLocator resourceLocator = (ResourceLocator)((Object)element);
                lock = lockMgr.acquireRemoveLock((ICockpitProjectData)resourceLocator);
                if (!lock.hasLock()) {
                    this.releaseLocks(aquiredLocks);
                    return;
                }
                aquiredLocks.add(lock);
                continue;
            }
            if (!(element instanceof Category) || (lock = lockMgr.acquireRemoveLock((ICockpitProjectData)(category = (Category)((Object)element)))).hasLock()) continue;
            this.releaseLocks(aquiredLocks);
            return;
        }
        HashSet subItemsToBeDeleted = new HashSet();
        for (IModuleData element : items) {
            subItemsToBeDeleted.addAll(this.modelCtrl.getAllDescendants(element));
        }
        items.addAll(subItemsToBeDeleted);
        String text = Messages.getString("ActionDelegateDelete.DialogText");
        String message = Messages.getString("ActionDelegateDelete.DialogMessage");
        MessageDialog mDialog = new MessageDialog(shell, text, null, message, 2, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
        if (mDialog.open() == 0) {
            this.modelCtrl.deleteItems((Collection)items);
        } else {
            this.releaseLocks(aquiredLocks);
        }
    }

    private void releaseLocks(Collection aquiredLocks) {
        for (LockAccess currentLock : aquiredLocks) {
            currentLock.releaseLocks();
        }
    }

    protected boolean determineEnabledStatus(ISelection selection) {
        IStructuredSelection selectionContent;
        String projectUid;
        boolean enable = false;
        if (selection != null && selection instanceof IStructuredSelection && (projectUid = ProjectSelectionAnalyser.extractProjectUID((ISelection)(selectionContent = (IStructuredSelection)selection))) != null) {
            if (!ProjectMgr.getProjectMgr().getProjectAgent(projectUid).isOpened()) {
                enable = false;
            } else {
                this.modelCtrl = DocumentModulePlugin.getDefault().getProjectManager().getModelController(projectUid);
                if (this.modelCtrl == null) {
                    logger.error("selectionChanged() - modelCtrl for project " + projectUid + " is null!");
                } else {
                    PermissionMgr permissionMgr = (PermissionMgr)this.modelCtrl.getPermissionMgr();
                    this.currentSelection = new HashSet();
                    for (Object nextSelectionElement : selectionContent) {
                        IModuleData parent;
                        if (nextSelectionElement instanceof IDocumentContainer) {
                            DocumentContainer container = ((IDocumentContainer)nextSelectionElement).getDocumentContainer();
                            IModuleData category = (IModuleData)this.modelCtrl.getLinkableObjects((IModuleData)container, "ContainerCategory").iterator().next();
                            if (permissionMgr.mayEditContainer(container)) {
                                this.currentSelection.add(container);
                                continue;
                            }
                            this.currentSelection.clear();
                            break;
                        }
                        if (nextSelectionElement instanceof RLFileSystemLink) {
                            parent = this.modelCtrl.getParent((IModuleData)nextSelectionElement);
                            if (permissionMgr.mayEditResourceLocator((RLFileSystemLink)((Object)nextSelectionElement), parent)) {
                                this.currentSelection.add(nextSelectionElement);
                                continue;
                            }
                            this.currentSelection.clear();
                            break;
                        }
                        if (nextSelectionElement instanceof RLWebLink) {
                            parent = this.modelCtrl.getParent((IModuleData)nextSelectionElement);
                            if (permissionMgr.mayEditResourceLocator((RLWebLink)((Object)nextSelectionElement), parent)) {
                                this.currentSelection.add(nextSelectionElement);
                                continue;
                            }
                            this.currentSelection.clear();
                            break;
                        }
                        if (nextSelectionElement instanceof Category) {
                            if (permissionMgr.mayCreateCategories()) {
                                this.currentSelection.add(nextSelectionElement);
                                continue;
                            }
                            this.currentSelection.clear();
                            break;
                        }
                        this.currentSelection.clear();
                        break;
                    }
                    if (this.currentSelection.size() > 0) {
                        enable = true;
                    }
                }
            }
        }
        this.enabled = enable;
        return this.enabled;
    }

    protected boolean determineEnabledStatus(String newModel) {
        return this.enabled;
    }

    protected boolean determineEnabledStatus(IPropertyChanges changes, Class clazz) {
        return this.enabled;
    }

    protected IClientFunctionLicenseType2 getRequiredLicenseType() {
        return ClientFunctionLicenseTypeDCMModifyItems.getInstance();
    }
}

