/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.documentmodule.client.gui;

import com.arcway.cockpit.documentmodule.client.DocumentModulePlugin;
import com.arcway.cockpit.documentmodule.client.Messages;
import com.arcway.cockpit.documentmodule.client.messages.Category;
import com.arcway.cockpit.documentmodule.client.messages.DocumentContainer;
import com.arcway.cockpit.documentmodule.client.messages.RLFileSystemLink;
import com.arcway.cockpit.documentmodule.client.messages.RLWebLink;
import com.arcway.cockpit.modulelib2.client.gui.ImageDescriptorRegistry;
import com.arcway.cockpit.modulelib2.client.gui.dataview.jfaceviewer.tree.standard.IModuleFixColumnProvider;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;

public class DataViewLabelProvider
implements IModuleFixColumnProvider {
    private static final ILogger logger = Logger.getLogger(DataViewLabelProvider.class);
    private final ImageDescriptorRegistry imageDescriptorRegistry = DocumentModulePlugin.getDefault().getImageDescriptorRegistry();

    public Image getColumnImage(IModuleData element, String columnID) {
        IModuleData element_ = element;
        Image iconImage = null;
        if (columnID.equals("url")) {
            if (element_ instanceof RLFileSystemLink) {
                RLFileSystemLink fileLink = (RLFileSystemLink)element_;
                return fileLink.getIconForFile();
            }
            if (element_ instanceof RLWebLink) {
                ImageDescriptor desc = DocumentModulePlugin.getImageDescriptor("weblink_small.gif");
                iconImage = this.imageDescriptorRegistry.get(desc);
            }
        } else if (columnID.equals("link state")) {
            if (element_ instanceof RLFileSystemLink) {
                ImageDescriptor desc = ((RLFileSystemLink)element_).getLinkState().getDisplayImageDescriptor();
                iconImage = desc == null ? null : this.imageDescriptorRegistry.get(desc);
            }
        } else if (columnID.equals("tree")) {
            return element.getStatusDependentIcon().getImage();
        }
        return iconImage;
    }

    public String getColumnText(IModuleData element, String columnID) {
        String text = null;
        if (element instanceof DocumentContainer) {
            DocumentContainer container = (DocumentContainer)element;
            text = columnID.equals("tree") ? container.getName().getDisplayStringRepresentation() : (columnID.equals("url") ? "" : (columnID.equals("status") ? container.getState().getDisplayStringRepresentation() : (columnID.equals("keywords") ? container.getKeywords().getDisplayStringRepresentation() : "")));
        } else if (element instanceof RLFileSystemLink) {
            RLFileSystemLink fileLink = (RLFileSystemLink)element;
            text = columnID.equals("tree") ? Messages.getString("RLFileSystemLink.NAME_NAME") : (columnID.equals("url") ? fileLink.getLocalURL() : (columnID.equals("serverurl") ? fileLink.getURL().getDisplayStringRepresentation() : ""));
        } else if (element instanceof RLWebLink) {
            RLWebLink webLink = (RLWebLink)element;
            text = columnID.equals("tree") ? Messages.getString("RLWebLink.NAME_NAME") : (columnID.equals("url") || columnID.equals("serverurl") ? webLink.getURL().getDisplayStringRepresentation() : "");
        } else if (element instanceof Category) {
            if (columnID.equals("tree")) {
                text = ((Category)element).getName().getDisplayStringRepresentation();
            }
        } else {
            logger.error("DCM.DataViewLabelProvider.getColumnText() - Unexpected type: " + element.getClass().getName());
        }
        return text;
    }
}

