/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.documentmodule.client.core.project;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeType;
import com.arcway.cockpit.documentmodule.client.DocumentModulePlugin;
import com.arcway.cockpit.documentmodule.client.core.project.DocumentPermissionRootNode;
import com.arcway.cockpit.documentmodule.client.messages.Category;
import com.arcway.cockpit.documentmodule.client.messages.DocumentContainer;
import com.arcway.cockpit.documentmodule.client.messages.ResourceLocator;
import com.arcway.cockpit.frame.shared.IPermissionOperand;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.cockpit.modulelib2.client.core.project.IModelController;
import com.arcway.cockpit.modulelib2.client.core.project.permissions.AbstractPermissionMgr;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import java.util.Collection;

public class PermissionMgr
extends AbstractPermissionMgr {
    private static final ILogger logger = Logger.getLogger(PermissionMgr.class);
    private static final DocumentPermissionRootNode ALL_CATEGORIES = DocumentPermissionRootNode.ALL_CATEGORIES_INSTANCE;

    public boolean mayCreateCategories() {
        return this.getProjectAgent().hasPermission("dcm.createCategories", (IPermissionOperand)this.getProjectAgent());
    }

    public boolean mayEditAllCategories() {
        return this.getProjectAgent().hasPermission("dcm.editCategory", (IPermissionOperand)ALL_CATEGORIES);
    }

    public boolean mayEditCategory(Category category) {
        assert (category != null);
        boolean mayEdit = false;
        if (this.mayEditAllCategories() || this.getProjectAgent().hasPermission("dcm.editCategory", (IPermissionOperand)category)) {
            mayEdit = true;
        }
        return mayEdit;
    }

    /*
     * Unable to fully structure code
     */
    public boolean mayEditAnyCategories() {
        block1: {
            mayEdit = false;
            modelController = DocumentModulePlugin.getDefault().getProjectManager().getModelController(this.getProjectAgent().getProjectUID());
            categories = modelController.getAllItems("dcm.category");
            iterator = categories.iterator();
            if (!this.mayEditAllCategories()) ** GOTO lbl12
            mayEdit = true;
            break block1;
lbl-1000:
            // 1 sources

            {
                category = (Category)iterator.next();
                if (!this.mayEditCategory(category)) continue;
                mayEdit = true;
                break;
lbl12:
                // 2 sources

                ** while (iterator.hasNext())
            }
        }
        return mayEdit;
    }

    public boolean mayEditContainer(DocumentContainer container) {
        assert (container != null);
        IModelController modelController = DocumentModulePlugin.getDefault().getProjectManager().getModelController(container.getProjectUID());
        IModuleData parent = modelController.getParent((IModuleData)container);
        return this.mayEditCategory((Category)parent);
    }

    public boolean mayDeleteItem(IModuleData moduleData) {
        if (moduleData instanceof DocumentContainer) {
            return this.mayEditContainer((DocumentContainer)moduleData);
        }
        if (moduleData instanceof ResourceLocator) {
            IModuleData parent = this.getDataMgr().getParent(moduleData);
            return this.mayEditResourceLocator((ResourceLocator)moduleData, parent);
        }
        if (moduleData instanceof Category) {
            return this.mayEditCategory((Category)moduleData);
        }
        return false;
    }

    public boolean mayDeleteItems(Collection items) {
        assert (items != null);
        for (Object item : items) {
            if (!(item instanceof IModuleData) || this.mayDeleteItem((IModuleData)item)) continue;
            return false;
        }
        return true;
    }

    public boolean mayEditResourceLocator(ResourceLocator resourceLocator, IModuleData parent) {
        assert (resourceLocator != null);
        if (parent instanceof DocumentContainer) {
            DocumentContainer container = (DocumentContainer)parent;
            return this.mayEditContainer(container);
        }
        if (parent instanceof Category) {
            Category category = (Category)parent;
            return this.mayEditCategory(category);
        }
        return false;
    }

    public boolean mayEditItemStructurally(IModuleData moduleData, IModuleData parent) {
        return moduleData instanceof Category && this.mayEditCategory((Category)moduleData) || moduleData instanceof DocumentContainer && this.mayEditContainer((DocumentContainer)moduleData) || moduleData instanceof ResourceLocator && this.mayEditResourceLocator((ResourceLocator)moduleData, parent);
    }

    public boolean mayCreateChildren(IModuleData parent, String childDataType) {
        if (parent == null && childDataType.equals("dcm.category")) {
            return this.mayCreateCategories();
        }
        if (parent instanceof Category && childDataType.equals("dcm.documentcontainer")) {
            return this.mayEditCategory((Category)parent);
        }
        if (parent instanceof DocumentContainer && (childDataType.equals("dcm.filesystemlink") || childDataType.equals("dcm.weblink"))) {
            return this.mayEditContainer((DocumentContainer)parent);
        }
        return false;
    }

    public boolean mayEditAttribute(IModuleData moduleData, IModuleData parent, IAttributeType type) {
        return this.mayEditAttribute(moduleData, parent);
    }

    public boolean mayEditAttribute(IModuleData moduleData, IModuleData parent, String attributeType) {
        return this.mayEditAttribute(moduleData, parent);
    }

    public boolean mayEditAttribute(IModuleData moduleData, String attributeType) {
        return this.mayEditAttribute(moduleData, (IModuleData)null);
    }

    private boolean mayEditAttribute(IModuleData moduleData, IModuleData parent) {
        if (this.getDataMgr().isNew((ICockpitProjectData)moduleData)) {
            return true;
        }
        if (parent != null) {
            return this.mayEditItemStructurally(moduleData, parent);
        }
        return this.mayEditItemStructurally(moduleData);
    }

    public boolean mayLinkItemToPlanElement(String linkableItemTypeID, IModuleData permissionOperand) {
        return linkableItemTypeID.equals("dcm.documentcontainer");
    }
}

