/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.docgen.writer.docbook.model;

import com.arcway.cockpit.docgen.writer.docbook.model.EOAnchor;
import com.arcway.cockpit.docgen.writer.docbook.model.EOCommonObject;
import de.plans.lib.xml.encoding.EXEncoderException;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.lib.xml.encoding.XMLContext;
import java.util.ArrayList;

public class EOLink
extends EOCommonObject {
    public static String XML_NAME = "link";
    private static final String ATTR_TAG_ENDTERM = "endterm";
    private static final String ATTR_TAG_LINKEND = "linkend";
    private static final String ATTR_TAG_TYPE = "type";
    private String attrEndterm = null;
    private String attrLinkend = null;
    private String attrType = null;
    private final ArrayList content = new ArrayList();

    public EOLink() {
        super(XML_NAME);
    }

    public EOLink(XMLContext xmlContext) {
        super(XML_NAME, xmlContext);
    }

    @Override
    protected void appendAttributesToXML(EncodableObjectBase.WriteContext writeContext) throws EXEncoderException {
        super.appendAttributesToXML(writeContext);
        if (this.attrLinkend != null) {
            this.appendAttrToXML(writeContext, ATTR_TAG_LINKEND, this.attrLinkend);
        }
        if (this.attrEndterm != null) {
            this.appendAttrToXML(writeContext, ATTR_TAG_ENDTERM, this.attrEndterm);
        }
        if (this.attrType != null) {
            this.appendAttrToXML(writeContext, ATTR_TAG_TYPE, this.attrType);
        }
    }

    @Override
    protected boolean setAttributeFromXML(String name, String value) {
        boolean success = true;
        if (name.equals(ATTR_TAG_LINKEND)) {
            this.attrLinkend = value;
        } else if (name.equals(ATTR_TAG_ENDTERM)) {
            this.attrEndterm = value;
        } else if (name.equals(ATTR_TAG_TYPE)) {
            this.attrType = value;
        } else {
            success = super.setAttributeFromXML(name, value);
        }
        return success;
    }

    @Override
    protected boolean hasChildren() {
        return this.content.size() >= 1;
    }

    @Override
    protected void writeContentAndChildrenToXML(EncodableObjectBase.WriteContext writeContext, int depth) throws EXEncoderException {
        for (Object obj : this.content) {
            if (obj instanceof String) {
                String text = (String)obj;
                this.appendIndentToXML(writeContext, depth);
                this.appendContentToXML(writeContext, String.valueOf(text) + "\n");
                continue;
            }
            if (!(obj instanceof EOCommonObject)) continue;
            EOCommonObject eo = (EOCommonObject)((Object)obj);
            eo.writeXMLBody(writeContext, depth);
        }
    }

    @Override
    protected boolean addChildFromXML(EncodableObjectBase newChild) {
        boolean success = true;
        if (newChild instanceof EOAnchor) {
            this.content.add(newChild);
        } else if (newChild instanceof EOLink) {
            this.content.add(newChild);
        } else {
            success = false;
        }
        return success;
    }

    protected boolean addContentFromXML(String value) {
        String contentString;
        boolean success = false;
        if (value != null && (contentString = EOCommonObject.removeTabAndNewlineChars(value)).length() > 0) {
            this.content.add(contentString);
            success = true;
        }
        return success;
    }

    public void setEndterm(String string) {
        this.attrEndterm = string;
    }

    public void setLinkend(String string) {
        this.attrLinkend = string;
    }

    public void setType(String string) {
        this.attrType = string;
    }

    public void add(String text) {
        this.content.add(text);
    }

    public void add(EOAnchor anchor) {
        this.content.add(anchor);
    }

    public void add(EOLink link) {
        this.content.add(link);
    }

    public String getContentAsString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (Object contentElement : this.content) {
            if (!(contentElement instanceof String)) continue;
            if (stringBuffer.length() > 0) {
                stringBuffer.append(" ");
            }
            stringBuffer.append((String)contentElement);
        }
        return stringBuffer.toString();
    }

    public String getLinkend() {
        return this.attrLinkend;
    }
}

