/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.docgen.writer.docbook.model;

import com.arcway.cockpit.docgen.writer.docbook.model.EOCommonObject;
import de.plans.lib.xml.encoding.EXEncoderException;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.lib.xml.encoding.XMLContext;

public class EOImageData
extends EOCommonObject {
    public static final String XML_NAME = "imagedata";
    public static final String ATTR_TAG_FILEREF = "fileref";
    public static final String ATTR_TAG_ENTITYREF = "entityref";
    public static final String ATTR_TAG_FORMAT = "format";
    public static final String ATTR_TAG_ALIGN = "align";
    public static final String ATTR_TAG_VALIGN = "valign";
    public static final String ATTR_TAG_DEPTH = "depth";
    public static final String ATTR_TAG_WIDTH = "width";
    public static final String ATTR_TAG_CONTENT_DEPTH = "contentdepth";
    public static final String ATTR_TAG_CONTENT_WIDTH = "contentwidth";
    public static final String ATTR_TAG_SCALE = "scale";
    private static final String ATTR_VAL_0MM = "0.0mm";
    private String fileRef = null;
    private String entityRef = null;
    private String format = null;
    private String depth = null;
    private String width = null;
    private String contentDepth = null;
    private String contentWidth = null;
    private Integer scale = null;
    private String horizontalAlignment = null;
    private String verticalAlignment = null;

    public EOImageData() {
        super(XML_NAME);
    }

    public EOImageData(XMLContext xmlContext) {
        super(XML_NAME, xmlContext);
    }

    @Override
    protected void appendAttributesToXML(EncodableObjectBase.WriteContext writeContext) throws EXEncoderException {
        super.appendAttributesToXML(writeContext);
        if (this.fileRef != null) {
            this.appendAttrToXML(writeContext, ATTR_TAG_FILEREF, this.fileRef);
        }
        if (this.entityRef != null) {
            this.appendAttrToXML(writeContext, ATTR_TAG_ENTITYREF, this.entityRef);
        }
        if (this.format != null) {
            this.appendAttrToXML(writeContext, ATTR_TAG_FORMAT, this.format);
        }
        if (this.depth != null && !this.depth.equals(ATTR_VAL_0MM)) {
            this.appendAttrToXML(writeContext, ATTR_TAG_DEPTH, this.depth);
        }
        if (this.width != null && !this.width.equals(ATTR_VAL_0MM)) {
            this.appendAttrToXML(writeContext, ATTR_TAG_WIDTH, this.width);
        }
        if (this.contentDepth != null) {
            this.appendAttrToXML(writeContext, ATTR_TAG_CONTENT_DEPTH, this.contentDepth);
        }
        if (this.contentWidth != null) {
            this.appendAttrToXML(writeContext, ATTR_TAG_CONTENT_WIDTH, this.contentWidth);
        }
        if (this.scale != null) {
            this.appendAttrToXML(writeContext, ATTR_TAG_SCALE, this.scale);
        }
        if (this.horizontalAlignment != null) {
            this.appendAttrToXML(writeContext, ATTR_TAG_ALIGN, this.horizontalAlignment);
        }
        if (this.verticalAlignment != null) {
            this.appendAttrToXML(writeContext, ATTR_TAG_VALIGN, this.verticalAlignment);
        }
    }

    @Override
    protected boolean setAttributeFromXML(String name, String value) {
        boolean result = true;
        if (name.equals(ATTR_TAG_FILEREF)) {
            this.fileRef = value;
        } else if (name.equals(ATTR_TAG_ENTITYREF)) {
            this.entityRef = value;
        } else if (name.equals(ATTR_TAG_FORMAT)) {
            this.format = value;
        } else if (name.equals(ATTR_TAG_DEPTH)) {
            this.depth = value;
        } else if (name.equals(ATTR_TAG_WIDTH)) {
            this.width = value;
        } else if (name.equals(ATTR_TAG_CONTENT_DEPTH)) {
            this.contentDepth = value;
        } else if (name.equals(ATTR_TAG_CONTENT_WIDTH)) {
            this.contentWidth = value;
        } else if (name.equals(ATTR_TAG_SCALE)) {
            this.scale = Integer.valueOf(value);
        } else if (name.equals(ATTR_TAG_ALIGN)) {
            this.horizontalAlignment = value;
        } else if (name.equals(ATTR_TAG_VALIGN)) {
            this.verticalAlignment = value;
        } else {
            result = super.setAttributeFromXML(name, value);
        }
        return result;
    }

    @Override
    protected boolean hasChildren() {
        return false;
    }

    @Override
    protected void writeContentAndChildrenToXML(EncodableObjectBase.WriteContext writeContext, int p_depth) throws EXEncoderException {
    }

    @Override
    protected boolean addChildFromXML(EncodableObjectBase newChild) {
        return false;
    }

    public String getFileReference() {
        return this.fileRef;
    }

    public void setFileReference(String filename) {
        this.fileRef = filename;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String imageFormat) {
        this.format = imageFormat;
    }

    public double getDepth() {
        double d;
        if (this.depth == null) {
            d = 0.0;
        } else {
            String depthWithoutUnitOfMeasure = this.removeUnitOfMeasure(this.depth);
            d = Double.parseDouble(depthWithoutUnitOfMeasure);
        }
        return d;
    }

    public void setDepth(double depth, String unitOfMeasure) {
        this.depth = String.valueOf(Double.toString(depth)) + unitOfMeasure;
    }

    public double getWidth() {
        double w;
        if (this.width == null) {
            w = 0.0;
        } else {
            String depthWithoutUnitOfMeasure = this.removeUnitOfMeasure(this.width);
            w = Double.parseDouble(depthWithoutUnitOfMeasure);
        }
        return w;
    }

    public void setWidth(double width, String unitOfMeasure) {
        this.width = String.valueOf(Double.toString(width)) + unitOfMeasure;
    }

    public void setContentDepth(double contentDepth, String unitOfMeasure) {
        this.contentDepth = String.valueOf(Double.toString(contentDepth)) + unitOfMeasure;
    }

    public void setContentWidth(double contentWidth, String unitOfMeasure) {
        this.contentWidth = String.valueOf(Double.toString(contentWidth)) + unitOfMeasure;
    }

    public void setScale(int scaleFactor) {
        if (scaleFactor >= 0) {
            this.scale = new Integer(scaleFactor);
        }
    }

    public void setHorizontalAlignment(String horizontalAlignment) {
        this.horizontalAlignment = horizontalAlignment;
    }

    public void setVerticalAlignment(String verticalAlignment) {
        this.verticalAlignment = verticalAlignment;
    }

    private String removeUnitOfMeasure(String string) {
        assert (string != null);
        int index = 0;
        index = string.indexOf("mm");
        if (index >= 0) {
            return string.substring(0, index);
        }
        return null;
    }
}

