/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.docgen.provider.planagent;

import com.arcway.cockpit.docgen.graphicsandfiles.PlanImageSizeHint;
import com.arcway.cockpit.docgen.provider.planagent.AbstractGraphicAdapter;
import com.arcway.cockpit.docgen.provider.planagent.ForcedViewRectangle;
import com.arcway.cockpit.frame.client.lib.relationviews.IGraphicProvider;
import com.arcway.lib.geometry.Dimension;
import com.arcway.lib.geometry.Insets;
import com.arcway.lib.graphics.Alignment;
import com.arcway.lib.graphics.Color;
import com.arcway.lib.graphics.image.ImageCoDec;
import com.arcway.lib.graphics.print.EXEmptyResult;
import com.arcway.lib.graphics.print.IImagePrinterPageDescription;
import com.arcway.lib.graphics.print.IPrinter;
import com.arcway.lib.graphics.print.ImagePrinter;
import com.arcway.lib.graphics.print.ImagePrinterPageDescription;
import com.arcway.lib.graphics.print.PrintingFailure;
import com.arcway.planagent.controllinginterface.planviewer.PageSetup;
import de.plans.lib.svg.ILink;
import java.io.File;
import java.util.Map;

public class PNGGraphicsAdapter
extends AbstractGraphicAdapter {
    private ImagePrinter printer = null;

    @Override
    public Dimension export(PlanImageSizeHint preferredSize, IGraphicProvider graphicProvider, Map<String, String> roleMap, String styleSheetFilename, Map<String, ILink> linkMap, ForcedViewRectangle forcedViewRectangle) throws PrintingFailure, EXEmptyResult {
        boolean proceedIfPlanIsEmpty = false;
        Dimension planSizeInMM = PNGGraphicsAdapter.getPlanSizeInMM(graphicProvider, forcedViewRectangle, proceedIfPlanIsEmpty);
        Dimension limitedPlanSizeInMM = PNGGraphicsAdapter.calculateLimitedPlanSize(planSizeInMM, preferredSize);
        if (limitedPlanSizeInMM.width > 1.0E-10 && limitedPlanSizeInMM.height > 1.0E-10) {
            PageSetup pageSetup;
            double insetsInMM = 0.0;
            int widthInPixels = (int)Math.round(limitedPlanSizeInMM.width / 25.4 * preferredSize.getResolution());
            int heightInPixels = (int)Math.round(limitedPlanSizeInMM.height / 25.4 * preferredSize.getResolution());
            double horDPI = (double)widthInPixels / (planSizeInMM.width / 25.4);
            double vertDPI = (double)heightInPixels / (planSizeInMM.height / 25.4);
            int insetsInPixels = (int)Math.round(insetsInMM / 25.4 * horDPI);
            IImagePrinterPageDescription imageInfo = ImagePrinterPageDescription.createImageInfoInPixels((int)widthInPixels, (int)heightInPixels, (int)insetsInPixels, (double)horDPI, (double)vertDPI, (Color)Color.WHITE);
            this.printer = new ImagePrinter(imageInfo);
            int pageCountX = 1;
            int pageCountY = 1;
            Insets insets = new Insets(insetsInMM);
            if (forcedViewRectangle == null || forcedViewRectangle.getZoom() == null) {
                Alignment alignment = new Alignment();
                double zoom = 1.0;
                boolean fitHorizontal = true;
                boolean fitVertical = true;
                pageSetup = new PageSetup(pageCountX, pageCountY, alignment, zoom, fitHorizontal, fitVertical, insets);
            } else {
                Alignment alignment = new Alignment(1, 8);
                double zoom = forcedViewRectangle.getZoom();
                boolean fitHorizontal = false;
                boolean fitVertical = false;
                double offsetX = forcedViewRectangle.getOffsetX();
                double offsetY = forcedViewRectangle.getOffsetY();
                pageSetup = new PageSetup(pageCountX, pageCountY, alignment, zoom, fitHorizontal, fitVertical, insets, offsetX, offsetY);
            }
            graphicProvider.export((IPrinter)this.printer, pageSetup);
        }
        return limitedPlanSizeInMM;
    }

    @Override
    public void save(File image) throws PrintingFailure, EXEmptyResult {
        this.printer.saveImageDirectly(image, ImageCoDec.PNG);
    }

    @Override
    public void disposeImages() {
        this.printer.disposeImages();
    }
}

