/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.docgen.provider;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttribute;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeOwner;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeType;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeTypeID;
import com.arcway.cockpit.cockpitlib.client.filter.AbstractFilter;
import com.arcway.cockpit.docgen.graphicsandfiles.IGraphicsAndFilesHelper;
import com.arcway.cockpit.docgen.provider.AbstractAttributeOwnerDocGenProxy;
import com.arcway.cockpit.docgen.provider.AbstractCustomPropertiesAccessDocGenProxy;
import com.arcway.cockpit.docgen.provider.HistoryEntry;
import com.arcway.cockpit.docgen.provider.PlanDocGenProxy;
import com.arcway.cockpit.docgen.provider.interfaces.IFolder;
import com.arcway.cockpit.docgen.provider.interfaces.IPlan;
import com.arcway.cockpit.docgen.provider.interfaces.IRecord;
import com.arcway.cockpit.docgen.provider.utils.MultilineTextOutputHelper;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.core.framedata.AbstractAttributeTypesProvider;
import com.arcway.cockpit.frame.client.project.core.framedata.FrameDataTypes;
import com.arcway.cockpit.frame.client.project.core.framedata.IFrameDataTypeDescription;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.sections.ISection;
import com.arcway.cockpit.frame.client.project.docgenerator.IDocGeneratorProjectAgent;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.stringtools.StringUtil;
import de.plans.lib.util.HTMLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.eclipse.ui.IWorkbenchPage;

public class SectionDocGenProxy
extends AbstractCustomPropertiesAccessDocGenProxy
implements IFolder {
    private static final ILogger logger = Logger.getLogger(SectionDocGenProxy.class);
    private final IDocGeneratorProjectAgent projectAgent;
    private final ISection section;
    private final Collection<AbstractFilter> filters;
    private final Locale locale;
    private final IWorkbenchPage currentPage;

    public SectionDocGenProxy(ISection section, IDocGeneratorProjectAgent projectAgent, Collection<AbstractFilter> filters, IGraphicsAndFilesHelper fileAttributeProvider, Locale locale, IWorkbenchPage currentPage) {
        super((IAttributeOwner)section, fileAttributeProvider, (IFrameProjectAgent)projectAgent.getProjectAgent(), locale);
        this.section = section;
        this.projectAgent = projectAgent;
        this.filters = filters;
        this.locale = locale;
        this.currentPage = currentPage;
    }

    @Override
    public String getUniqueIdentifier() {
        return this.section.getUID();
    }

    @Override
    public String getDisplayName() {
        return HTMLEncoder.encode((String)this.section.getSectionName());
    }

    @Override
    public String getTypeID() {
        return "folder";
    }

    @Override
    public String getTypeName() {
        return ((IFrameDataTypeDescription)FrameDataTypes.getDataType((String)"com.arcway.cockpit.section")).getDisplayName(this.locale);
    }

    @Override
    public List<String> getDescription() {
        List descriptionList = StringUtil.splitTextLines((String)this.section.getDescription());
        List<String> resultAsList = MultilineTextOutputHelper.getHTMLEncodedNormalisedMultilineTextOutput(descriptionList);
        return resultAsList;
    }

    @Override
    public String getName() {
        return HTMLEncoder.encode((String)this.section.getSectionName());
    }

    @Deprecated
    public boolean hasSubSection(String sectionName) {
        logger.warn("The attribute \"subSection\" is deprecated. Please use \"subFolder\"!");
        return this.hasSubFolder(sectionName);
    }

    @Override
    public boolean hasSubFolder(String folderName) {
        boolean result = false;
        List subSections = this.projectAgent.getChildSections(this.section, this.filters);
        for (ISection subSection : subSections) {
            if (!subSection.getSectionName().equals(folderName)) continue;
            return true;
        }
        return result;
    }

    @Deprecated
    public IFolder getSubSection(String sectionName) {
        logger.warn("The attribute \"subSection\" is deprecated. Please use \"subFolder\"!");
        return this.getSubFolder(sectionName);
    }

    @Override
    public IFolder getSubFolder(String folderName) {
        SectionDocGenProxy result = null;
        List subSections = this.projectAgent.getChildSections(this.section, this.filters);
        for (ISection subSection : subSections) {
            if (!subSection.getSectionName().equals(folderName)) continue;
            result = new SectionDocGenProxy(subSection, this.projectAgent, this.filters, this.getGraphicsAndFilesHelper(), this.locale, this.currentPage);
        }
        return result;
    }

    @Override
    public boolean hasSubFolders() {
        boolean result = false;
        List subSections = this.projectAgent.getChildSections(this.section, this.filters);
        result = subSections.size() > 0;
        return result;
    }

    public List<IFolder> getSubFolders() {
        ArrayList<ISection> subSections = new ArrayList<ISection>(this.projectAgent.getChildSections(this.section, this.filters));
        List<IFolder> subSectionProxies = SectionDocGenProxy.transformSubFolderList(subSections, this.projectAgent, this.filters, this.getGraphicsAndFilesHelper(), this.locale, this.currentPage);
        return subSectionProxies;
    }

    public List<IFolder> getSubFolders(String sortingProperty) {
        ArrayList<ISection> subSections = new ArrayList<ISection>(this.projectAgent.getChildSections(this.section, this.filters));
        List<IFolder> subSectionProxies = SectionDocGenProxy.transformSubFolderList(subSections, this.projectAgent, this.filters, this.getGraphicsAndFilesHelper(), this.locale, this.currentPage);
        AbstractAttributeOwnerDocGenProxy.sortList(subSectionProxies, sortingProperty);
        return subSectionProxies;
    }

    public List<IFolder> getSubFoldersWithCategory(String categoryID) {
        List<IFolder> subSectionProxies = this.getSubFolders();
        return SectionDocGenProxy.filterByCategoryIDAsCustomPropertiesAccess(subSectionProxies, categoryID);
    }

    public List<IFolder> getSubFoldersWithCategory(String categoryID, String sortingProperty) {
        List<IFolder> subSectionProxies = this.getSubFoldersWithCategory(categoryID);
        AbstractAttributeOwnerDocGenProxy.sortList(subSectionProxies, sortingProperty);
        return subSectionProxies;
    }

    @Override
    public List<IFolder> getSubFoldersWithDefaultCategory() {
        return this.getSubFoldersWithCategory(null);
    }

    @Override
    public List<IFolder> getSubFoldersWithDefaultCategory(String sortingProperty) {
        List<IFolder> subSectionProxies = this.getSubFoldersWithDefaultCategory();
        AbstractAttributeOwnerDocGenProxy.sortList(subSectionProxies, sortingProperty);
        return subSectionProxies;
    }

    @Override
    public boolean containsPlans() {
        boolean result = false;
        List plans = this.projectAgent.getChildPlans(this.section, this.filters);
        result = plans.size() > 0;
        return result;
    }

    @Deprecated
    public List<? extends IPlan> getChildPlans() {
        return this.getPlans();
    }

    @Override
    public List<? extends IPlan> getPlans() {
        List plans = this.projectAgent.getChildPlans(this.section, this.filters);
        ArrayList<PlanDocGenProxy> result = new ArrayList<PlanDocGenProxy>(plans.size());
        for (com.arcway.cockpit.frame.client.project.core.sectionsandplans.plan.IPlan plan : plans) {
            PlanDocGenProxy planDescription = new PlanDocGenProxy(plan, this.projectAgent, this.filters, this.getGraphicsAndFilesHelper(), this.locale, this.currentPage);
            result.add(planDescription);
        }
        return result;
    }

    @Deprecated
    public List<? extends IPlan> getAllPlans() {
        return this.getAllPlansOfSubTree();
    }

    @Override
    public List<? extends IPlan> getAllPlansOfSubTree() {
        List plans = this.projectAgent.getAllPlans(this.section, this.filters);
        ArrayList<PlanDocGenProxy> result = new ArrayList<PlanDocGenProxy>(plans.size());
        for (com.arcway.cockpit.frame.client.project.core.sectionsandplans.plan.IPlan plan : plans) {
            PlanDocGenProxy planDescription = new PlanDocGenProxy(plan, this.projectAgent, this.filters, this.getGraphicsAndFilesHelper(), this.locale, this.currentPage);
            result.add(planDescription);
        }
        return result;
    }

    @Override
    public List<? extends IPlan> getPlansSortedBy(String propertyID) {
        List<? extends IPlan> result = this.getPlans();
        AbstractAttributeOwnerDocGenProxy.sortList(result, propertyID);
        return result;
    }

    @Override
    public List<? extends IPlan> getPlansWithCategory(String categoryID) {
        List<? extends IPlan> plans = this.getPlans();
        List<? extends IPlan> plansWithCategory = SectionDocGenProxy.filterByCategoryIDAsCustomPropertiesAccess(plans, categoryID);
        return plansWithCategory;
    }

    @Override
    public List<? extends IPlan> getAllPlansOfSubTreeWithCategory(String categoryID) {
        List<? extends IPlan> plans = this.getAllPlansOfSubTree();
        List<? extends IPlan> plansWithCategory = SectionDocGenProxy.filterByCategoryIDAsCustomPropertiesAccess(plans, categoryID);
        return plansWithCategory;
    }

    @Override
    public List<? extends IPlan> getPlansWithCategorySortedBy(String categoryID, String propertyID) {
        List<? extends IPlan> result = this.getPlansWithCategory(categoryID);
        AbstractAttributeOwnerDocGenProxy.sortList(result, propertyID);
        return result;
    }

    @Override
    public List<? extends IPlan> getPlansWithDefaultCategory() {
        return this.getPlansWithCategory(null);
    }

    @Override
    public List<? extends IPlan> getAllPlansOfSubTreeWithDefaultCategory() {
        return this.getAllPlansOfSubTreeWithCategory(null);
    }

    @Override
    public List<? extends IPlan> getPlansWithDefaultCategorySortedBy(String propertyID) {
        return this.getPlansWithCategorySortedBy(null, propertyID);
    }

    @Override
    public boolean hasParent() {
        return this.projectAgent.getParent(this.section, this.filters) != null;
    }

    @Override
    public IFolder getParent() {
        ISection parent = this.projectAgent.getParent(this.section, this.filters);
        if (parent != null) {
            return new SectionDocGenProxy(parent, this.projectAgent, this.filters, this.getGraphicsAndFilesHelper(), this.locale, this.currentPage);
        }
        return null;
    }

    @Override
    public String getCommitVersion() {
        int commitCount = this.section.getCommitCount();
        return HistoryEntry.getVersionForCommitCount(commitCount);
    }

    @Deprecated
    public List getSubSections() {
        logger.warn("The attribute \"subSections\" is deprecated. Please use \"subFolders\"!");
        return this.getSubFolders();
    }

    protected static List<IFolder> transformSubFolderList(List<ISection> subSections, IDocGeneratorProjectAgent projectAgent, Collection<AbstractFilter> filters, IGraphicsAndFilesHelper graphicsProvider, Locale locale, IWorkbenchPage currentPage) {
        ArrayList<IFolder> result = new ArrayList<IFolder>();
        for (ISection subSection : subSections) {
            SectionDocGenProxy sectionDescription = new SectionDocGenProxy(subSection, projectAgent, filters, graphicsProvider, locale, currentPage);
            result.add(sectionDescription);
        }
        return result;
    }

    @Override
    public String getDateOfLastModification() {
        String lastModDateHTML = this.getHTMLEncodeSingleLineAttributeValue(AbstractAttributeTypesProvider.ATTRID_LAST_EDIT_DATE);
        return lastModDateHTML;
    }

    @Override
    public Long getDateOfLastModification_MilliSecondsSince_01_01_1970() {
        return this.getDateTimeProperty_MilliSecondsSince_01_01_1970("lastEditDate");
    }

    @Override
    public String getLastModifier() {
        String lastModifierHTML = this.getHTMLEncodeSingleLineAttributeValue(AbstractAttributeTypesProvider.ATTRID_LAST_EDITOR);
        return lastModifierHTML;
    }

    @Override
    public String getCreationDate() {
        String creationDateHTML = this.getHTMLEncodeSingleLineAttributeValue(AbstractAttributeTypesProvider.ATTRID_CREATION_DATE);
        return creationDateHTML;
    }

    @Override
    public Long getCreationDate_MilliSecondsSince_01_01_1970() {
        return this.getDateTimeProperty_MilliSecondsSince_01_01_1970("creationDate");
    }

    @Override
    public String getCreator() {
        String creatorHTML = this.getHTMLEncodeSingleLineAttributeValue(AbstractAttributeTypesProvider.ATTRID_CREATOR);
        return creatorHTML;
    }

    private String getHTMLEncodeSingleLineAttributeValue(IAttributeTypeID attrType) {
        IAttributeType attributeType;
        String htmlString = "-";
        IAttribute attribute = this.section.getAttribute(attrType);
        if (attribute != null && (attributeType = this.section.getAttributeType(attrType)) != null) {
            htmlString = HTMLEncoder.encode((String)attributeType.getDataType().getValueAsSingleLineString(attribute.getAttributeValue(), attributeType.getValueRange(), null, this.locale));
        }
        return htmlString;
    }

    @Override
    public String getModificationCount() {
        return String.valueOf(this.section.getModificationCount());
    }

    @Override
    public IRecord toRecord(Set<String> keyWhiteList) {
        IRecord record = super.toRecord(keyWhiteList);
        if (keyWhiteList == null || keyWhiteList.contains("name")) {
            record.set("name", this.getName());
        }
        if (keyWhiteList == null || keyWhiteList.contains("description")) {
            record.set("description", this.getDescription());
        }
        return record;
    }
}

