/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.docgen.writer.word.docbook2word;

import com.arcway.cockpit.docgen.graphicsandfiles.GraphicsAndFilesStore;
import com.arcway.cockpit.docgen.writer.docbook.model.EOPara;
import com.arcway.cockpit.docgen.writer.docbook.model.EOPreface;
import com.arcway.cockpit.docgen.writer.docbook.model.EOSubtitle;
import com.arcway.cockpit.docgen.writer.docbook.model.EOTable;
import com.arcway.cockpit.docgen.writer.docbook.model.EOTitle;
import com.arcway.cockpit.docgen.writer.word.StyleMap;
import com.arcway.cockpit.docgen.writer.word.docbook2word.ParagraphWriter;
import com.arcway.cockpit.docgen.writer.word.docbook2word.ProcessingContext;
import com.arcway.cockpit.docgen.writer.word.docbook2word.SubTitleWriter;
import com.arcway.cockpit.docgen.writer.word.docbook2word.TableWriter;
import com.arcway.cockpit.docgen.writer.word.docbook2word.TitleWriter;
import com.arcway.cockpit.frame.client.project.docgenerator.ReportGenerationException;
import com.arcway.lib.eclipse.ole.word.Document;
import com.arcway.lib.eclipse.ole.word.Paragraph;
import com.arcway.lib.eclipse.ole.word.Paragraphs;
import com.arcway.lib.eclipse.ole.word.Range;

public class PrefaceWriter {
    private static PrefaceWriter writer;

    public static PrefaceWriter getInstance() {
        if (writer == null) {
            writer = new PrefaceWriter();
        }
        return writer;
    }

    private PrefaceWriter() {
    }

    public boolean write(EOPreface preface, Document document, Paragraphs paragraphs, Paragraph firstParagraphOfFormatTemplate, StyleMap styleMap, GraphicsAndFilesStore graphicsAndFilesStore, ProcessingContext processingContext) throws ReportGenerationException {
        EOSubtitle subtitle;
        boolean anyTitlePageContents = false;
        EOTitle title = preface.getTitle();
        if (title != null) {
            Range rangeForNewParagraph = firstParagraphOfFormatTemplate.get_Range();
            Paragraph titlePara = paragraphs.Add((Object)rangeForNewParagraph);
            titlePara.set_Style((Object)-63);
            TitleWriter.getInstance().write(title, titlePara, document, processingContext);
            anyTitlePageContents = true;
            titlePara.dispose();
            rangeForNewParagraph.dispose();
        }
        if ((subtitle = preface.getSubtitle()) != null) {
            Range rangeForNewParagraph = firstParagraphOfFormatTemplate.get_Range();
            Paragraph subtitlePara = paragraphs.Add((Object)rangeForNewParagraph);
            subtitlePara.set_Style((Object)-75);
            SubTitleWriter.getInstance().write(subtitle, subtitlePara, document, processingContext);
            anyTitlePageContents = true;
            subtitlePara.dispose();
            rangeForNewParagraph.dispose();
        }
        for (Object obj : preface.getContent()) {
            Paragraph chapterPara;
            Range rangeForNewParagraph;
            if (obj instanceof EOPara) {
                rangeForNewParagraph = firstParagraphOfFormatTemplate.get_Range();
                chapterPara = paragraphs.Add((Object)rangeForNewParagraph);
                chapterPara.set_Style((Object)-1);
                ParagraphWriter.getInstance().write((EOPara)obj, chapterPara, document, styleMap, graphicsAndFilesStore, processingContext);
                anyTitlePageContents = true;
                chapterPara.dispose();
                rangeForNewParagraph.dispose();
                continue;
            }
            if (!(obj instanceof EOTable)) continue;
            rangeForNewParagraph = firstParagraphOfFormatTemplate.get_Range();
            chapterPara = paragraphs.Add((Object)rangeForNewParagraph);
            chapterPara.set_Style((Object)-1);
            TableWriter.getInstance().write((EOTable)obj, chapterPara, document, styleMap, graphicsAndFilesStore, processingContext);
            anyTitlePageContents = true;
            chapterPara.dispose();
            rangeForNewParagraph.dispose();
        }
        return anyTitlePageContents;
    }
}

