/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.docgen.writer.word.docbook2word;

import com.arcway.cockpit.docgen.writer.docbook.model.EOAnchor;
import com.arcway.cockpit.docgen.writer.word.docbook2word.BreakType;
import com.arcway.cockpit.docgen.writer.word.docbook2word.DocumentWriter;
import com.arcway.cockpit.docgen.writer.word.docbook2word.ParagraphWriter;
import com.arcway.cockpit.docgen.writer.word.docbook2word.ProcessingContext;
import com.arcway.cockpit.docgen.writer.word.docbook2word.WriterUtil;
import com.arcway.lib.eclipse.ole.word.Bookmark;
import com.arcway.lib.eclipse.ole.word.Bookmarks;
import com.arcway.lib.eclipse.ole.word.Document;
import com.arcway.lib.eclipse.ole.word.PageSetup;
import com.arcway.lib.eclipse.ole.word.Paragraph;
import com.arcway.lib.eclipse.ole.word.Range;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import java.util.Enumeration;

public class AnchorWriter {
    private static final String COMMAND_ORIENTATION_LANDSCAPE = "orientation_landscape_";
    private static final String COMMAND_ORIENTATION_PORTRAIT = "orientation_portrait_";
    private static final String COMMAND_PAGEBREAK_CONTINOUS = "pagebreak_continous_";
    private static final String COMMAND_PAGEBREAK_NEXTPAGE = "pagebreak_nextpage_";
    private static final String COMMAND_PAGEBREAK_EVENPAGE = "pagebreak_evenpage_";
    private static final String COMMAND_PAGEBREAK_ODDPAGE = "pagebreak_oddpage_";
    private static final ILogger logger = Logger.getLogger(AnchorWriter.class);
    private static AnchorWriter writer;

    public static AnchorWriter getInstance() {
        if (writer == null) {
            writer = new AnchorWriter();
        }
        return writer;
    }

    private AnchorWriter() {
    }

    public void construct() {
    }

    public void write(EOAnchor anchor, Paragraph para, ProcessingContext processingContext) {
        Range range = para.get_Range();
        range.set_End(range.get_End() - 1);
        if (logger.isDebugEnabled(150)) {
            logger.debug(150, "[write anchor] got  range object ");
        }
        this.write(anchor, range, processingContext);
        range.dispose();
    }

    public void write(EOAnchor anchor, Range range, ProcessingContext processingContext) {
        String anchorId = anchor.getId();
        int orientation = -1;
        if (anchorId.startsWith(COMMAND_ORIENTATION_LANDSCAPE)) {
            orientation = 1;
            anchorId = anchorId.substring(COMMAND_ORIENTATION_LANDSCAPE.length());
        } else if (anchorId.startsWith(COMMAND_ORIENTATION_PORTRAIT)) {
            orientation = 0;
            anchorId = anchorId.substring(COMMAND_ORIENTATION_PORTRAIT.length());
        }
        BreakType breakType = null;
        if (anchorId.startsWith(COMMAND_PAGEBREAK_CONTINOUS)) {
            breakType = BreakType.sectionBreakContinuous;
            anchorId = anchorId.substring(COMMAND_PAGEBREAK_CONTINOUS.length());
        } else if (anchorId.startsWith(COMMAND_PAGEBREAK_NEXTPAGE)) {
            breakType = BreakType.sectionBreakToNextPage;
            anchorId = anchorId.substring(COMMAND_PAGEBREAK_NEXTPAGE.length());
        } else if (anchorId.startsWith(COMMAND_PAGEBREAK_EVENPAGE)) {
            breakType = BreakType.sectionBreakToEvenPage;
            anchorId = anchorId.substring(COMMAND_PAGEBREAK_EVENPAGE.length());
        } else if (anchorId.startsWith(COMMAND_PAGEBREAK_ODDPAGE)) {
            breakType = BreakType.sectionBreakToOddPage;
            anchorId = anchorId.substring(COMMAND_PAGEBREAK_ODDPAGE.length());
        }
        String bookmarkName = "ID" + anchorId;
        boolean bookmarkExists = false;
        boolean jumpToExistingAnchors = DocumentWriter.isJumpToExistingAnchors(processingContext);
        if (jumpToExistingAnchors) {
            Document document = range.get_Document();
            Bookmarks existingBookmarks = document.get_Bookmarks();
            Enumeration existingBookmarkElements = existingBookmarks.elements();
            while (existingBookmarkElements.hasMoreElements()) {
                Bookmark existingBookmarkElement = (Bookmark)existingBookmarkElements.nextElement();
                String existingBookmarkName = existingBookmarkElement.get_Name();
                if (bookmarkName.equals(existingBookmarkName)) {
                    WriterUtil.jumpAtBookmark(existingBookmarkElement);
                    bookmarkExists = true;
                }
                existingBookmarkElement.dispose();
            }
            existingBookmarks.dispose();
            document.dispose();
        }
        if (breakType != null) {
            ParagraphWriter.addPageBreak(range, breakType);
        }
        if (orientation != -1) {
            PageSetup pageSetup = range.get_PageSetup();
            pageSetup.set_Orientation(orientation);
            pageSetup.dispose();
        }
        if (!bookmarkExists) {
            boolean bookmarkNameValid = false;
            try {
                Bookmarks bookmarks = range.get_Bookmarks();
                bookmarks.Add(bookmarkName);
                bookmarkNameValid = true;
                bookmarks.dispose();
            }
            finally {
                if (!bookmarkNameValid) {
                    logger.error("Invalid bookmark name: \"" + bookmarkName + "\" ");
                }
            }
        }
        if (logger.isDebugEnabled(150)) {
            logger.debug(150, "[write anchor] added bookmark ");
        }
    }
}

