/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.docgen.writer.wordML.docbook2wordml;

import com.arcway.cockpit.docgen.writer.docbook.model.EOAnchor;
import com.arcway.cockpit.docgen.writer.docbook.model.EOColSpec;
import com.arcway.cockpit.docgen.writer.docbook.model.EOEmphasis;
import com.arcway.cockpit.docgen.writer.docbook.model.EOEntry;
import com.arcway.cockpit.docgen.writer.docbook.model.EOLink;
import com.arcway.cockpit.docgen.writer.docbook.model.EOMediaObject;
import com.arcway.cockpit.docgen.writer.docbook.model.EOPara;
import com.arcway.cockpit.docgen.writer.docbook.model.EOPhrase;
import com.arcway.cockpit.docgen.writer.docbook.model.EORow;
import com.arcway.cockpit.docgen.writer.docbook.model.EOSimpleList;
import com.arcway.cockpit.docgen.writer.docbook.model.EOTBody;
import com.arcway.cockpit.docgen.writer.docbook.model.EOTFoot;
import com.arcway.cockpit.docgen.writer.docbook.model.EOTGroup;
import com.arcway.cockpit.docgen.writer.docbook.model.EOTHead;
import com.arcway.cockpit.docgen.writer.docbook.model.EOTable;
import com.arcway.cockpit.docgen.writer.docbook.model.EOUlink;
import com.arcway.cockpit.docgen.writer.wordML.docbook2wordml.AnchorWriter;
import com.arcway.cockpit.docgen.writer.wordML.docbook2wordml.DocBook2WordMLGenerationContext;
import com.arcway.cockpit.docgen.writer.wordML.docbook2wordml.EmphasisWriter;
import com.arcway.cockpit.docgen.writer.wordML.docbook2wordml.LinkWriter;
import com.arcway.cockpit.docgen.writer.wordML.docbook2wordml.MediaObjectWriter;
import com.arcway.cockpit.docgen.writer.wordML.docbook2wordml.ParagraphWriter;
import com.arcway.cockpit.docgen.writer.wordML.docbook2wordml.PhraseWriter;
import com.arcway.cockpit.docgen.writer.wordML.docbook2wordml.SimpleListWriter;
import com.arcway.cockpit.docgen.writer.wordML.docbook2wordml.UlinkWriter;
import com.arcway.cockpit.docgen.writer.wordML.dom.IParagraphParent;
import com.arcway.cockpit.docgen.writer.wordML.dom.ITableParent;
import com.arcway.cockpit.docgen.writer.wordML.dom.TableWrapper;
import com.arcway.cockpit.frame.client.project.docgenerator.ReportGenerationException;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import java.util.List;

public class TableWriter {
    private static ILogger logger = Logger.getLogger(TableWriter.class);
    private static TableWriter writer;

    public static TableWriter getInstance() {
        if (writer == null) {
            writer = new TableWriter();
        }
        return writer;
    }

    private TableWriter() {
    }

    public void write(EOTable eotable, ITableParent parent, DocBook2WordMLGenerationContext context) throws ReportGenerationException {
        EORow row;
        String style;
        int numberBodyRows;
        List tgroupList = eotable.getTGroup();
        EOTGroup tgroup = (EOTGroup)tgroupList.get(0);
        EOTHead tHead = tgroup.getTableHead();
        EOTBody tBody = tgroup.getTableBody();
        EOTFoot tFoot = tgroup.getTableFoot();
        List tRows = tBody.getRows();
        int columns = tgroup.getCols();
        int numberTableRows = numberBodyRows = tRows.size();
        if (tHead != null) {
            ++numberTableRows;
        }
        if (tFoot != null) {
            ++numberTableRows;
        }
        TableWrapper wrapper = parent.addTable();
        if (logger.isDebugEnabled(180)) {
            logger.debug(180, "[write table] added table ");
        }
        if ((style = eotable.getAttrTabstyle()) != null) {
            wrapper.setStyle(style);
        }
        List colSpecs = tgroup.getColspec();
        int i = 0;
        while (i < colSpecs.size() && i < columns) {
            EOColSpec colSpec = (EOColSpec)colSpecs.get(i);
            double widthInPoints = colSpec.getColumnwidthInPoints();
            wrapper.addColumn(widthInPoints);
            ++i;
        }
        if (logger.isDebugEnabled(180)) {
            logger.debug(180, "[write table] set table properties");
        }
        if (tHead != null) {
            List rowList = tHead.getRows();
            for (Object name : rowList) {
                row = (EORow)name;
                wrapper.addRow(true);
                this.write(row, wrapper, colSpecs, true, context);
                wrapper.controlRow();
            }
        }
        i = 0;
        while (i < numberBodyRows) {
            EORow row2 = (EORow)tRows.get(i);
            wrapper.addRow();
            this.write(row2, wrapper, colSpecs, false, context);
            wrapper.controlRow();
            ++i;
        }
        if (tFoot != null) {
            List rowList = tFoot.getRows();
            for (Object name : rowList) {
                row = (EORow)name;
                wrapper.addRow();
                this.write(row, wrapper, colSpecs, false, context);
                wrapper.controlRow();
            }
        }
        if (!(parent instanceof TableWrapper) && parent instanceof IParagraphParent) {
            ((IParagraphParent)((Object)parent)).addParagraph();
        }
    }

    private void write(EORow eoRow, TableWrapper wrapper, List<?> colspecs, boolean forceBold, DocBook2WordMLGenerationContext context) throws ReportGenerationException {
        List entries = eoRow.getEntryList();
        for (Object name : entries) {
            EOEntry entry = (EOEntry)name;
            String colnameStart = entry.getNamest();
            String colnameEnd = entry.getNameend();
            if (colnameStart != null && colnameEnd != null) {
                wrapper.addCellWithHMergeStart();
                this.write(entry, wrapper, forceBold, context);
                wrapper.controlCell();
                boolean emptyCellFollowing = false;
                for (Object name2 : colspecs) {
                    EOColSpec colspec = (EOColSpec)name2;
                    String colname = colspec.getColname();
                    if (colname.equals(colnameEnd)) {
                        emptyCellFollowing = false;
                    }
                    if (emptyCellFollowing) {
                        wrapper.addCell();
                        wrapper.addParagraph();
                        wrapper.hideMergedParagraph();
                    }
                    if (!colname.equals(colnameStart)) continue;
                    emptyCellFollowing = true;
                }
                wrapper.addCellWithHMergeEnd();
                wrapper.addParagraph();
                wrapper.hideMergedParagraph();
                continue;
            }
            wrapper.addCell();
            this.write(entry, wrapper, forceBold, context);
            wrapper.controlCell();
        }
        if (logger.isDebugEnabled(180)) {
            logger.debug(180, "[write table] wrote table row");
        }
    }

    private void write(EOEntry entry, TableWrapper wrapper, boolean forceBold, DocBook2WordMLGenerationContext context) throws ReportGenerationException {
        List content = entry.getContent(context.getReportJob());
        String style = entry.getRole();
        if ((style == null || style.length() == 0) && forceBold) {
            style = "TableBold";
        }
        for (Object obj : content) {
            if (obj instanceof String) {
                wrapper.addText((String)obj);
                continue;
            }
            if (obj instanceof EOAnchor) {
                AnchorWriter.getInstance().write((EOAnchor)obj, wrapper, context);
                continue;
            }
            if (obj instanceof EOLink) {
                LinkWriter.getInstance().write((EOLink)obj, wrapper, context);
                continue;
            }
            if (obj instanceof EOUlink) {
                UlinkWriter.getInstance().write((EOUlink)obj, wrapper, context);
                continue;
            }
            if (obj instanceof EOEmphasis) {
                EmphasisWriter.getInstance().write((EOEmphasis)obj, wrapper, context);
                continue;
            }
            if (obj instanceof EOUlink) {
                PhraseWriter.getInstance().write((EOPhrase)obj, wrapper, context);
                continue;
            }
            if (obj instanceof EOPara) {
                ParagraphWriter.getInstance().write((EOPara)obj, wrapper, context);
                continue;
            }
            if (obj instanceof EOTable) {
                this.write((EOTable)obj, wrapper, context);
                continue;
            }
            if (obj instanceof EOSimpleList) {
                SimpleListWriter.getInstance().write((EOSimpleList)obj, wrapper, context);
                continue;
            }
            if (!(obj instanceof EOMediaObject)) continue;
            MediaObjectWriter.getInstance().write((EOMediaObject)obj, wrapper, context);
        }
        if (logger.isDebugEnabled(180)) {
            logger.debug(180, "[write table] wrote table entry");
        }
    }
}

