/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.docgen.writer.wordML.docbook2wordml;

import com.arcway.cockpit.docgen.writer.docbook.model.EOPara;
import com.arcway.cockpit.docgen.writer.docbook.model.EOPreface;
import com.arcway.cockpit.docgen.writer.docbook.model.EOSubtitle;
import com.arcway.cockpit.docgen.writer.docbook.model.EOTable;
import com.arcway.cockpit.docgen.writer.docbook.model.EOTitle;
import com.arcway.cockpit.docgen.writer.wordML.StyleMap;
import com.arcway.cockpit.docgen.writer.wordML.docbook2wordml.DocBook2WordMLGenerationContext;
import com.arcway.cockpit.docgen.writer.wordML.docbook2wordml.ParagraphWriter;
import com.arcway.cockpit.docgen.writer.wordML.docbook2wordml.SubTitleWriter;
import com.arcway.cockpit.docgen.writer.wordML.docbook2wordml.TableWriter;
import com.arcway.cockpit.docgen.writer.wordML.docbook2wordml.TitleWriter;
import com.arcway.cockpit.docgen.writer.wordML.dom.ChapterWrapper;
import com.arcway.cockpit.frame.client.project.docgenerator.ReportGenerationException;

public class PrefaceWriter {
    private static PrefaceWriter writer;

    public static PrefaceWriter getInstance() {
        if (writer == null) {
            writer = new PrefaceWriter();
        }
        return writer;
    }

    private PrefaceWriter() {
    }

    public boolean write(EOPreface preface, ChapterWrapper chapterWrapper, StyleMap styleMap, DocBook2WordMLGenerationContext context) throws ReportGenerationException {
        EOSubtitle subtitle;
        boolean hasAnyTitlePageContent = false;
        EOTitle title = preface.getTitle();
        if (title != null) {
            String style = styleMap.findStyle("Title");
            TitleWriter.getInstance().write(title, chapterWrapper.addParagraph(style), context);
            hasAnyTitlePageContent = true;
        }
        if ((subtitle = preface.getSubtitle()) != null) {
            String style = styleMap.findStyle("Subtitle");
            SubTitleWriter.getInstance().write(subtitle, chapterWrapper.addParagraph(style), context);
            hasAnyTitlePageContent = true;
        }
        for (Object obj : preface.getContent()) {
            if (obj instanceof EOPara) {
                ParagraphWriter.getInstance().write((EOPara)obj, chapterWrapper, context);
                hasAnyTitlePageContent = true;
                continue;
            }
            if (!(obj instanceof EOTable)) continue;
            TableWriter.getInstance().write((EOTable)obj, chapterWrapper, context);
            hasAnyTitlePageContent = true;
        }
        return hasAnyTitlePageContent;
    }
}

