/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.docgen.writer.odt.dom;

import com.arcway.cockpit.docgen.writer.odt.StyleMap;
import com.arcway.cockpit.docgen.writer.odt.docbook2odt.DocBook2ODTGenerationContext;
import com.arcway.cockpit.docgen.writer.odt.dom.AnchorWrapper;
import com.arcway.cockpit.docgen.writer.odt.dom.EmphasisWrapper;
import com.arcway.cockpit.docgen.writer.odt.dom.IAnchorParent;
import com.arcway.cockpit.docgen.writer.odt.dom.IEmphasisParent;
import com.arcway.cockpit.docgen.writer.odt.dom.ILinkParent;
import com.arcway.cockpit.docgen.writer.odt.dom.IMediaObjectParent;
import com.arcway.cockpit.docgen.writer.odt.dom.IPhraseParent;
import com.arcway.cockpit.docgen.writer.odt.dom.ISimpleListParent;
import com.arcway.cockpit.docgen.writer.odt.dom.ITableParent;
import com.arcway.cockpit.docgen.writer.odt.dom.IUlinkParent;
import com.arcway.cockpit.docgen.writer.odt.dom.ImageObjectWrapper;
import com.arcway.cockpit.docgen.writer.odt.dom.LinkWrapper;
import com.arcway.cockpit.docgen.writer.odt.dom.MediaObjectWrapper;
import com.arcway.cockpit.docgen.writer.odt.dom.PhraseWrapper;
import com.arcway.cockpit.docgen.writer.odt.dom.SimpleListWrapper;
import com.arcway.cockpit.docgen.writer.odt.dom.StyleFamily;
import com.arcway.cockpit.docgen.writer.odt.dom.TableWrapper;
import com.arcway.cockpit.docgen.writer.odt.dom.UlinkWrapper;
import java.util.Locale;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class ParagraphWrapper
implements IAnchorParent,
ILinkParent,
ISimpleListParent,
IUlinkParent,
IEmphasisParent,
IMediaObjectParent,
ITableParent,
IPhraseParent {
    private final Element paragraph;
    private final Document document;
    private Node paragraphR = null;
    private Node paragraphT = null;
    private Node paragraphPr = null;
    private final Locale projectLocale;
    private final StyleMap styleMap;

    public ParagraphWrapper(Document document, Node parent, String style_displayname, StyleMap styleMap, Locale projectLocale) {
        String style_name;
        this.document = document;
        this.projectLocale = projectLocale;
        this.styleMap = styleMap;
        Element paragraph_ = document.createElement("text:p");
        this.paragraph = (Element)parent.appendChild(paragraph_);
        if (style_displayname != null && style_displayname.length() > 0 && (style_name = styleMap.findStyleByDisplayName(style_displayname, StyleFamily.PARAGRAPH)) != null) {
            this.paragraph.setAttribute("text:style-name", style_name);
        }
    }

    public ParagraphWrapper(Document document, Node parent, Locale projectLocale, StyleMap styleMap) {
        this(document, parent, null, styleMap, projectLocale);
    }

    public void addSectionProperties(Node sectionProperties) {
        if (this.paragraphPr == null) {
            this.paragraphPr = this.document.createElement("w:pPr");
            this.paragraphPr = this.paragraph.appendChild(this.paragraphPr);
        }
        this.paragraphPr.appendChild(sectionProperties);
    }

    public void resetRun() {
        this.paragraphR = this.document.createElement("w:r");
        this.paragraphR = this.paragraph.appendChild(this.paragraphR);
        this.paragraphT = this.document.createElement("w:t");
        this.paragraphT = this.paragraphR.appendChild(this.paragraphT);
    }

    public void setFontSize(String size) {
        this.paragraphR = this.document.createElement("w:r");
        this.paragraphR = this.paragraph.appendChild(this.paragraphR);
        Element runPr = this.document.createElement("w:rPr");
        this.paragraphR.appendChild(runPr);
        Element fontSize = this.document.createElement("w:sz");
        fontSize.setAttribute("w:val", size);
        runPr.appendChild(fontSize);
    }

    public void hideParagraph() {
        Node paraParams = this.document.createElement("w:pPr");
        paraParams = this.paragraph.appendChild(paraParams);
        Element allowEmpty = this.document.createElement("wx:allowEmptyCollapse");
        paraParams.appendChild(allowEmpty);
    }

    public void addText(String text) {
        Text t = this.document.createTextNode(text);
        this.paragraph.appendChild(t);
    }

    @Override
    public SimpleListWrapper addSimpleList() {
        return new SimpleListWrapper(this.document, this.paragraph, this.projectLocale);
    }

    @Override
    public AnchorWrapper addAnchor(String anchorId, String anchorName) {
        return new AnchorWrapper(this.document, this.paragraph, anchorId, anchorName);
    }

    @Override
    public LinkWrapper addLink(String anchorName) {
        return new LinkWrapper(this.document, this.paragraph, anchorName, this.projectLocale);
    }

    @Override
    public UlinkWrapper addUlink(String url) {
        return new UlinkWrapper(this.document, this.paragraph, url);
    }

    @Override
    public EmphasisWrapper addEmphasis() {
        return new EmphasisWrapper(this.document, this.paragraph, this.projectLocale);
    }

    @Override
    public PhraseWrapper addPhrase() {
        return new PhraseWrapper(this.document, this.paragraph, this.projectLocale);
    }

    @Override
    public MediaObjectWrapper addMediaObject() {
        return new MediaObjectWrapper(this.document, this.paragraph);
    }

    @Override
    public ImageObjectWrapper addImageObject(String name, String format, float width, float height, boolean newImage, int imageCounter, String filename) {
        return new ImageObjectWrapper(this.document, this.paragraph, name, format, width, height, newImage, imageCounter, filename);
    }

    @Override
    public TableWrapper addTable(String tabstyle, DocBook2ODTGenerationContext context) {
        return new TableWrapper(this.document, this.paragraph, tabstyle, context);
    }
}

