/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.docgen.writer.odt.dom;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class LengthParser {
    public static final DecimalFormat WidthInCmNumberFormat = new DecimalFormat("0.000cm");

    static {
        DecimalFormatSymbols decimalFormatSymbols = WidthInCmNumberFormat.getDecimalFormatSymbols();
        decimalFormatSymbols.setDecimalSeparator('.');
        WidthInCmNumberFormat.setDecimalFormatSymbols(decimalFormatSymbols);
        WidthInCmNumberFormat.setGroupingUsed(false);
    }

    private LengthParser() {
        assert (false) : "This class is not intended to be instanciated";
    }

    public static Length parseLength(String stringEncodedLength) throws LengthParseException {
        if (stringEncodedLength == null) {
            throw new LengthParseException("The specified length could not be parsed because it is null.");
        }
        LengthUnit unit = null;
        String magnitudeAsString = null;
        for (LengthUnit currentUnit : LengthUnit.lengthUnits) {
            if (!stringEncodedLength.endsWith(currentUnit.getUnitCode())) continue;
            unit = currentUnit;
            magnitudeAsString = stringEncodedLength.substring(0, stringEncodedLength.length() - currentUnit.getUnitCode().length());
            break;
        }
        if (magnitudeAsString == null || unit == null) {
            throw new LengthParseException("The specified length could not be parsed because it does not end with a supported unit: \"" + stringEncodedLength + "\"");
        }
        try {
            String fractionalPartAsString;
            String integralPartAsString;
            int dotIndex = magnitudeAsString.indexOf(46);
            if (dotIndex != -1) {
                integralPartAsString = magnitudeAsString.substring(0, dotIndex);
                fractionalPartAsString = magnitudeAsString.substring(dotIndex + 1);
            } else {
                integralPartAsString = magnitudeAsString;
                fractionalPartAsString = "0";
            }
            int integralPart = Integer.parseInt(integralPartAsString);
            int fractionalPart = Integer.parseInt(fractionalPartAsString);
            int fractionalPartDigits = fractionalPartAsString.length();
            double magnitude = (double)integralPart + (double)fractionalPart / Math.pow(10.0, fractionalPartDigits);
            return new Length(magnitude, unit);
        }
        catch (NumberFormatException e) {
            throw new LengthParseException("The specified length could not be parsed: \"" + stringEncodedLength + "\" detected unit: " + unit.getUnitCode(), e);
        }
    }

    public static class Length {
        private final LengthUnit unit;
        private final double magnitude;

        public Length(double magnitude, LengthUnit unit) {
            this.magnitude = magnitude;
            this.unit = unit;
        }

        public double getLengthInUnit(LengthUnit wantedUnit) {
            assert (wantedUnit.oneUnitsLengthInMm != null);
            assert (this.unit.oneUnitsLengthInMm != null);
            return this.magnitude * (this.unit.oneUnitsLengthInMm / wantedUnit.oneUnitsLengthInMm);
        }
    }

    public static class LengthParseException
    extends Exception {
        public LengthParseException(String message, Throwable cause) {
            super(message, cause);
        }

        public LengthParseException(String message) {
            super(message);
        }

        public LengthParseException(Throwable cause) {
            super(cause);
        }
    }

    public static class LengthUnit {
        private static final Set<LengthUnit> _lengthUnits = new HashSet<LengthUnit>();
        public static final Set<LengthUnit> lengthUnits = Collections.unmodifiableSet(_lengthUnits);
        public static final LengthUnit CM = new LengthUnit("cm", 10.0);
        public static final LengthUnit MM = new LengthUnit("mm", 1.0);
        public static final LengthUnit IN = new LengthUnit("in", 25.4);
        public static final LengthUnit PT = new LengthUnit("pt", LengthUnit.IN.oneUnitsLengthInMm / 72.0);
        public static final LengthUnit PC = new LengthUnit("pc", LengthUnit.PT.oneUnitsLengthInMm * 12.0);
        public static final LengthUnit PX = new LengthUnit("px", null);
        public static final LengthUnit EM = new LengthUnit("em", null);
        private final String unitCode;
        private final Double oneUnitsLengthInMm;

        private LengthUnit(String unit, Double oneUnitsLengthInMm) {
            this.unitCode = unit;
            this.oneUnitsLengthInMm = oneUnitsLengthInMm;
            _lengthUnits.add(this);
        }

        public String getUnitCode() {
            return this.unitCode;
        }
    }
}

