/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.docgen.writer.odt.docbook2odt;

import com.arcway.cockpit.docgen.writer.docbook.model.EOAnchor;
import com.arcway.cockpit.docgen.writer.docbook.model.EOLink;
import com.arcway.cockpit.docgen.writer.docbook.model.EOMember;
import com.arcway.cockpit.docgen.writer.docbook.model.EOSimpleList;
import com.arcway.cockpit.docgen.writer.odt.docbook2odt.AnchorWriter;
import com.arcway.cockpit.docgen.writer.odt.docbook2odt.DocBook2ODTGenerationContext;
import com.arcway.cockpit.docgen.writer.odt.docbook2odt.LinkWriter;
import com.arcway.cockpit.docgen.writer.odt.dom.ISimpleListParent;
import com.arcway.cockpit.docgen.writer.odt.dom.SimpleListWrapper;
import java.util.Iterator;
import java.util.List;

public class SimpleListWriter {
    private static SimpleListWriter writer;

    public static SimpleListWriter getInstance() {
        if (writer == null) {
            writer = new SimpleListWriter();
        }
        return writer;
    }

    private SimpleListWriter() {
    }

    public void write(EOSimpleList list, ISimpleListParent parent, DocBook2ODTGenerationContext context) {
        String listType = list.getType();
        List itemList = list.getItems();
        SimpleListWrapper simpListWrapper = parent.addSimpleList();
        if (listType.equals("inline")) {
            Iterator itemIter = itemList.iterator();
            while (itemIter.hasNext()) {
                EOMember member = (EOMember)itemIter.next();
                this.write(member, simpListWrapper, context);
                if (!itemIter.hasNext()) continue;
                simpListWrapper.addText(", ");
            }
        } else if (!listType.equals("horiz")) {
            listType.equals("vert");
        }
    }

    private void write(EOMember member, SimpleListWrapper wrapper, DocBook2ODTGenerationContext context) {
        List contentList = member.getContent(context.getReportJob());
        for (Object obj : contentList) {
            if (obj instanceof String) {
                wrapper.addText((String)obj);
                continue;
            }
            if (obj instanceof EOAnchor) {
                AnchorWriter.getInstance().write((EOAnchor)obj, wrapper, context);
                continue;
            }
            if (!(obj instanceof EOLink)) continue;
            LinkWriter.getInstance().write((EOLink)obj, wrapper, context);
        }
    }
}

