/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.docgen.writer.odt;

import com.arcway.cockpit.docgen.writer.odt.ManifestFileEntry;
import com.arcway.cockpit.docgen.writer.odt.util.XmlComponentUtil;
import com.arcway.lib.io.FileHelper;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ODFManifestManager {
    public static final String OpenDocumentTextMimeType = "application/vnd.oasis.opendocument.text";
    private static final String MANIFEST_XML = "manifest.xml";
    private static final String META_INF = "META-INF";
    private final File odf__META_INF__manifest_xml;
    private final HashMap<String, ManifestFileEntry> originalManifestFileEntries;
    private final HashMap<String, ManifestFileEntry> additionalManifestFileEntries;

    public ODFManifestManager(File odfRootDirectory) throws ParserConfigurationException, SAXException, IOException {
        this.odf__META_INF__manifest_xml = new File(new File(odfRootDirectory, META_INF), MANIFEST_XML);
        this.originalManifestFileEntries = ODFManifestManager.readManifestFileEntries(this.odf__META_INF__manifest_xml);
        this.additionalManifestFileEntries = new HashMap();
    }

    public void updateManifest() throws ParserConfigurationException, SAXException, IOException {
        Document odfManifestDocument = XmlComponentUtil.readComponentXmlFile(this.odf__META_INF__manifest_xml);
        NodeList fileEntryNodes = odfManifestDocument.getElementsByTagName("manifest:file-entry");
        assert (fileEntryNodes.getLength() > 0);
        int i = 0;
        while (i < fileEntryNodes.getLength()) {
            Element fileEntryElement = (Element)fileEntryNodes.item(i);
            String fullPath = fileEntryElement.getAttribute("manifest:full-path");
            if ("/".equals(fullPath)) {
                fileEntryElement.setAttribute("manifest:media-type", OpenDocumentTextMimeType);
                break;
            }
            ++i;
        }
        Node lastFileEntryNode = fileEntryNodes.item(fileEntryNodes.getLength() - 1);
        Node nextSiblingOfLastFileEntryNode = lastFileEntryNode.getNextSibling();
        for (ManifestFileEntry additionalEntry : this.additionalManifestFileEntries.values()) {
            Element newFileEntryElement = odfManifestDocument.createElement("manifest:file-entry");
            newFileEntryElement.setAttribute("manifest:media-type", additionalEntry.getMediaType());
            newFileEntryElement.setAttribute("manifest:full-path", additionalEntry.getFullPath());
            if (nextSiblingOfLastFileEntryNode == null) {
                lastFileEntryNode.getParentNode().appendChild(newFileEntryElement);
                continue;
            }
            lastFileEntryNode.getParentNode().insertBefore(newFileEntryElement, nextSiblingOfLastFileEntryNode);
        }
        XmlComponentUtil.write(odfManifestDocument, this.odf__META_INF__manifest_xml);
    }

    public void registerNewFile(String odfImageFilePath) {
        String fileExtension = FileHelper.getFileExtension((String)odfImageFilePath);
        this.registerNewFile(ManifestFileEntry.getMediaType(fileExtension), odfImageFilePath);
    }

    public void registerNewFile(String mediaType, String fullPath) {
        assert (mediaType != null);
        assert (fullPath != null);
        assert (!this.originalManifestFileEntries.containsKey(fullPath));
        ManifestFileEntry replacedEntry = this.additionalManifestFileEntries.put(fullPath, new ManifestFileEntry(mediaType, fullPath));
        assert (replacedEntry == null);
    }

    private static HashMap<String, ManifestFileEntry> readManifestFileEntries(File manifestXmlFile) throws ParserConfigurationException, SAXException, IOException {
        HashMap<String, ManifestFileEntry> manifestFileEntries = new HashMap<String, ManifestFileEntry>();
        Document odfManifestDocument = XmlComponentUtil.readComponentXmlFile(manifestXmlFile);
        NodeList fileEntryNodes = odfManifestDocument.getElementsByTagName("manifest:file-entry");
        int i = 0;
        while (i < fileEntryNodes.getLength()) {
            Element fileEntryElement = (Element)fileEntryNodes.item(i);
            String mediaType = fileEntryElement.getAttribute("manifest:media-type");
            String fullPath = fileEntryElement.getAttribute("manifest:full-path");
            if (mediaType != null && fullPath != null) {
                ManifestFileEntry replacedEntry = manifestFileEntries.put(fullPath, new ManifestFileEntry(mediaType, fullPath));
                assert (replacedEntry == null);
            } else assert (false);
            ++i;
        }
        return manifestFileEntries;
    }
}

