/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.cockpitlib.client.filter.gui;

import com.arcway.cockpit.cockpitlib.client.filter.AbstractTextValuesFilter;
import com.arcway.cockpit.cockpitlib.client.filter.gui.AbstractFilterItem;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class TextListFilterItem
extends AbstractFilterItem {
    private static final String FILTER_INFO_SEPARATOR = ", ";
    private final List texts = new ArrayList();
    private final List values = new ArrayList();
    private final List tableItems = new ArrayList();
    private final AbstractTextValuesFilter filter;
    private List passValues;

    public TextListFilterItem(String name, AbstractTextValuesFilter filter) {
        super(name, filter);
        this.filter = filter;
        this.passValues = new ArrayList<String>(filter.getPassValues());
    }

    public void addFilterValue(String text, String value) {
        this.texts.add(text);
        this.values.add(value);
    }

    public void clearFilterValues() {
        this.texts.clear();
        this.values.clear();
    }

    public void setFilterValues(List filterValues) {
        this.texts.clear();
        this.values.clear();
        for (String value : filterValues) {
            this.texts.add(value);
            this.values.add(value);
        }
    }

    @Override
    public String getFilterInfo() {
        if (this.isNoFilterValuesSet()) {
            return null;
        }
        StringBuffer filterInfo = new StringBuffer();
        for (Button button : this.tableItems) {
            if (!button.getSelection()) continue;
            if (filterInfo.length() > 0) {
                filterInfo.append(FILTER_INFO_SEPARATOR);
            }
            filterInfo.append(button.getText());
        }
        return filterInfo.toString();
    }

    @Override
    public void refresh() {
        for (Button button : this.tableItems) {
            this.updateValueCheckState(button);
        }
    }

    @Override
    public Control createContent(Composite parent) {
        Group composite = new Group(parent, 512);
        GridLayout compositeLayout = new GridLayout(1, false);
        compositeLayout.verticalSpacing = 2;
        compositeLayout.horizontalSpacing = 2;
        composite.setLayout((Layout)compositeLayout);
        GridData compositeGD = new GridData(1808);
        composite.setLayoutData((Object)compositeGD);
        composite.setText(this.getName());
        int i = 0;
        while (i < this.texts.size()) {
            Button button = new Button((Composite)composite, 32);
            String text = (String)this.texts.get(i);
            String value = (String)this.values.get(i);
            button.setText(text);
            button.setData((Object)value);
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    TextListFilterItem.this.updateFilter();
                    TextListFilterItem.this.fireValueChanged();
                }
            });
            this.updateValueCheckState(button);
            this.tableItems.add(button);
            ++i;
        }
        composite.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                TextListFilterItem.this.tableItems.clear();
            }
        });
        return composite;
    }

    @Override
    public boolean isNoFilterValuesSet() {
        for (Button item : this.tableItems) {
            if (!item.getSelection()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isAllFilterValuesSet() {
        for (Button item : this.tableItems) {
            if (item.getSelection()) continue;
            return false;
        }
        return true;
    }

    private void updateFilter() {
        this.passValues.clear();
        for (Button button : this.tableItems) {
            if (!button.getSelection()) continue;
            String value = (String)button.getData();
            this.passValues.add(value);
        }
        if (!this.isUserConfirmationNecessary()) {
            this.confirmSelection();
        }
    }

    @Override
    public void doConfirmSelection() {
        this.filter.setPassValues(this.passValues);
    }

    @Override
    public void resetFilterValueToFilterState() {
        this.passValues = new ArrayList<String>(this.filter.getPassValues());
    }

    private void updateValueCheckState(Button button) {
        String value = (String)button.getData();
        button.setSelection(this.passValues.contains(value));
    }

    @Override
    public void filterHasChanged() {
        this.passValues = this.filter.getPassValues();
    }
}

