/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.cockpitlib.client.filter;

import com.arcway.cockpit.cockpitlib.client.filter.AbstractFilter;
import com.arcway.lib.stringtools.StringUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.jface.viewers.Viewer;

public abstract class AbstractDiscreteValueFilter
extends AbstractFilter {
    private static final char SEPARATOR = ';';
    private final HashSet<Integer> passValues = new HashSet();

    @Override
    public boolean doesItemPassFilter(Viewer viewer, Object parentElement, Object element) {
        return this.doesItemPassFilter(element);
    }

    private boolean doesItemPassFilter(Object element) {
        int objectsIndex = this.getDiscreteIndex(element);
        return this.passesFilter(objectsIndex);
    }

    private boolean passesFilter(int index) {
        return this.passValues.contains(index);
    }

    public void initWithSemicolonSeparatedString(String valueString) {
        if (valueString != null && valueString.length() > 0) {
            ArrayList values = StringUtil.split((String)valueString, (char)';');
            this.passValues.clear();
            for (String value : values) {
                this.passValues.add(Integer.valueOf(value));
            }
        } else {
            this.passValues.clear();
        }
    }

    public String getValuesAsSemicolonSeparatedString() {
        if (this.passValues.isEmpty()) {
            return "";
        }
        StringBuilder valueString = new StringBuilder();
        for (Integer passValue : this.passValues) {
            if (valueString.length() > 0) {
                valueString.append(';');
            }
            valueString.append(passValue);
        }
        return valueString.toString();
    }

    public void setPassValues(List<Integer> values) {
        this.passValues.clear();
        this.passValues.addAll(values);
    }

    public List<Integer> getPassValues() {
        return new ArrayList<Integer>(this.passValues);
    }

    @Override
    public String getFilterValue() {
        return this.getValuesAsSemicolonSeparatedString();
    }

    @Override
    public void setFilterValue(String value) {
        this.initWithSemicolonSeparatedString(value);
        super.setFilterValue(value);
    }

    @Override
    public void resetValue() {
        this.setFilterValue("");
    }

    protected abstract int getDiscreteIndex(Object var1);
}

