/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.client.base.datamanager;

import com.arcway.cockpit.client.base.datamanager.DataCacheMgr;
import com.arcway.cockpit.client.base.datamanager.IDataHandler_DataWithID;
import com.arcway.cockpit.client.base.datamanager.IObjectKey;
import com.arcway.lib.java.collections.IHasher_;
import com.arcway.lib.java.maps.HashMap_;
import com.arcway.lib.java.maps.IMapRW_;
import java.util.HashMap;
import java.util.Map;

public class DataCacheMgrWithIDMap<T, T_UID, T_ID>
extends DataCacheMgr<T, T_UID> {
    private final IDataHandler_DataWithID<T, T_UID, T_ID, ?, ?> dataHandler;
    private final IMapRW_<T_ID, T> map_id_item;
    private final Map<IObjectKey, T_ID> map_uid_id;

    public DataCacheMgrWithIDMap(IDataHandler_DataWithID<T, T_UID, T_ID, ?, ?> dataHandler, IHasher_<? super T_ID> idHasher) {
        super(dataHandler);
        this.dataHandler = dataHandler;
        this.map_id_item = new HashMap_(idHasher);
        this.map_uid_id = new HashMap<IObjectKey, T_ID>();
    }

    @Override
    protected void addItem(T item) {
        super.addItem(item);
        T_ID id = this.dataHandler.getIDForItem(item);
        if (id != null) {
            IObjectKey objectKey = this.dataHandler.getObjectKeyForUID(this.dataHandler.getUIDForItem(item));
            this.map_id_item.put(id, item);
            this.map_uid_id.put(objectKey, id);
        }
    }

    @Override
    protected void updateItem(T item) {
        T_ID newID;
        super.updateItem(item);
        IObjectKey objectKey = this.dataHandler.getObjectKeyForUID(this.dataHandler.getUIDForItem(item));
        T_ID oldId = this.map_uid_id.get(objectKey);
        if (oldId != null) {
            this.map_id_item.removeAsEntry(oldId);
            this.map_uid_id.remove(objectKey);
        }
        if ((newID = this.dataHandler.getIDForItem(item)) != null) {
            this.map_id_item.put(newID, item);
            this.map_uid_id.put(objectKey, newID);
        }
    }

    @Override
    protected T removeItem(T_UID itemUID) {
        Object removedItem = super.removeItem(itemUID);
        IObjectKey objectKey = this.dataHandler.getObjectKeyForUID(itemUID);
        T_ID oldID = this.map_uid_id.get(objectKey);
        if (oldID != null) {
            Object mappedItem = this.map_id_item.getByKey(oldID);
            Object uidOfMappedItem = this.dataHandler.getUIDForItem(mappedItem);
            if (this.dataHandler.getObjectKeyForUID(uidOfMappedItem).equals(objectKey)) {
                this.map_id_item.removeAsEntry(oldID);
            }
            this.map_uid_id.remove(objectKey);
        }
        return removedItem;
    }

    @Override
    protected void clear() {
        super.clear();
        this.map_id_item.clear();
        this.map_uid_id.clear();
    }

    protected T getItemByID(T_ID id) {
        if (id != null) {
            return (T)this.map_id_item.getByKey(id);
        }
        return null;
    }
}

