/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.search;

import org.apache.lucene.index.Term;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.WildcardQuery;
import org.eclipse.help.internal.search.QueryWordsExactPhrase;
import org.eclipse.help.internal.search.QueryWordsPhrase;

public class QueryWordsToken {
    public static final int AND = 0;
    public static final int OR = 1;
    public static final int NOT = 2;
    public static final int EXACT_PHRASE = 3;
    public static final int PHRASE = 4;
    public static final int WORD = 5;
    private static final QueryWordsToken fAND = new QueryWordsToken(0, "AND");
    private static final QueryWordsToken fOR = new QueryWordsToken(1, "OR");
    private static final QueryWordsToken fNOT = new QueryWordsToken(2, "NOT");
    public int type;
    public String value;

    protected QueryWordsToken(int type, String value) {
        this.type = type;
        this.value = value;
    }

    public Query createLuceneQuery(String field, float boost) {
        TermQuery q;
        int questionPos = this.value.indexOf(63);
        int starPos = this.value.indexOf(42);
        if (questionPos >= 0 || starPos >= 0) {
            if (questionPos == -1 && starPos == this.value.length() - 1) {
                Term t = new Term("exact_" + field, this.value.substring(0, starPos));
                q = new PrefixQuery(t);
                ((PrefixQuery)q).setBoost(boost);
            } else {
                Term t = new Term("exact_" + field, this.value);
                q = new WildcardQuery(t);
                ((WildcardQuery)q).setBoost(boost);
            }
        } else {
            Term t = new Term(field, this.value);
            q = new TermQuery(t);
            q.setBoost(boost);
        }
        return q;
    }

    public static QueryWordsToken AND() {
        return fAND;
    }

    public static QueryWordsToken OR() {
        return fOR;
    }

    public static QueryWordsToken NOT() {
        return fNOT;
    }

    public static QueryWordsToken word(String word) {
        return new QueryWordsToken(5, word);
    }

    public static QueryWordsPhrase phrase() {
        return new QueryWordsPhrase();
    }

    public static QueryWordsExactPhrase exactPhrase() {
        return new QueryWordsExactPhrase();
    }

    public static QueryWordsExactPhrase exactPhrase(String word) {
        QueryWordsExactPhrase token = new QueryWordsExactPhrase();
        token.addWord(word);
        return token;
    }
}

