/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.repository.interFace.importexport.imporT.importjobeditors.automatic;

import com.arcway.lib.java.collections.HashSet_;
import com.arcway.lib.java.collections.ICollection_;
import com.arcway.lib.java.collections.ISet_;
import com.arcway.lib.java.maps.HashMap_;
import com.arcway.lib.java.maps.IMap_;
import com.arcway.repository.interFace.data.RepositoryObjectTypes;
import com.arcway.repository.interFace.data.attributeset.IRepositoryPropertySetSample;
import com.arcway.repository.interFace.data.data.IRepositoryData;
import com.arcway.repository.interFace.data.object.IRepositoryObject;
import com.arcway.repository.interFace.data.object.IRepositoryObjectReference;
import com.arcway.repository.interFace.data.property.IRepositoryPropertySample;
import com.arcway.repository.interFace.dataaccess.EXNotReproducibleSnapshot;
import com.arcway.repository.interFace.dataaccess.IRepositorySnapshotRO;
import com.arcway.repository.interFace.declaration.type.object.IRepositoryObjectTypeID;
import com.arcway.repository.interFace.declaration.type.property.IRepositoryPropertyTypeID;
import com.arcway.repository.interFace.importexport.imporT.IImportJobEditor;
import com.arcway.repository.interFace.importexport.imporT.importjob.impl.ContextObject;
import com.arcway.repository.interFace.importexport.imporT.importjob.impl.ImportedObject;
import com.arcway.repository.interFace.importexport.imporT.importjob.rw.IImportJob;
import com.arcway.repository.interFace.importexport.imporT.importjob.rw.IObject;
import com.arcway.repository.interFace.importexport.imporT.importjob.rw.IObjectType;
import com.arcway.repository.interFace.registration.type.object.IRepositoryObjectType;
import com.arcway.repository.interFace.registration.type.property.IRepositoryPropertyType;
import com.arcway.repository.lib.high.implementation.access.RepositoryObjectReference;
import com.arcway.repository.lib.high.implementation.access.RepositoryPropertySample;
import com.arcway.repository.lib.high.implementation.access.RepositoryPropertySetSample;
import java.util.Collection;

public class AIJEObjectRecogniserByUID
implements IImportJobEditor {
    private final boolean forImportedObjects;
    private final boolean forContextObjects;
    private final ISet_<IRepositoryObjectTypeID> objectTypesToBeConsidered;

    public AIJEObjectRecogniserByUID(boolean forImportedObjects, boolean forContextObjects) {
        this.forImportedObjects = forImportedObjects;
        this.forContextObjects = forContextObjects;
        this.objectTypesToBeConsidered = null;
    }

    public AIJEObjectRecogniserByUID(Collection<IRepositoryObjectTypeID> objectTypesToBeConsidered, boolean forImportedObjects, boolean forContextObjects) {
        this.forImportedObjects = forImportedObjects;
        this.forContextObjects = forContextObjects;
        this.objectTypesToBeConsidered = new HashSet_(objectTypesToBeConsidered, IRepositoryObjectTypeID.IS_EQUAL_OBJECT_TYPE_ID_HASHER);
    }

    @Override
    public IImportJobEditor.ResultCode editImportJob(IImportJob importJob, IRepositorySnapshotRO snapshot, boolean executionMessagesOccurred) throws EXNotReproducibleSnapshot {
        if (this.forImportedObjects) {
            this.handleObjectTypes(importJob.getImportedObjectTypes(), snapshot);
        }
        if (this.forContextObjects) {
            this.handleObjectTypes(importJob.getContextObjectTypes(), snapshot);
        }
        return IImportJobEditor.ResultCode.COMPLETED_NOMORECALLS;
    }

    private void handleObjectTypes(Collection<? extends IObjectType> objectTypes, IRepositorySnapshotRO snapshot) throws EXNotReproducibleSnapshot {
        for (IObjectType iObjectType : objectTypes) {
            if (this.objectTypesToBeConsidered != null && RepositoryObjectTypes.findMostSpecificSuperObjectType(iObjectType.getObjectType(), this.objectTypesToBeConsidered) == null) continue;
            this.handleObjectType(iObjectType, snapshot);
        }
    }

    private void handleObjectType(IObjectType objectType, IRepositorySnapshotRO snapshot) throws EXNotReproducibleSnapshot {
        IRepositoryObjectType objectTypeDefinition = objectType.getObjectType();
        ICollection_<? extends IRepositoryPropertyType> uidProperties = objectTypeDefinition.getIDAttributeSetType().getPropertyTypes();
        for (IObject iObject : objectType.getObjects()) {
            IRepositoryPropertySetSample objectID = AIJEObjectRecogniserByUID.getObjectID(iObject, uidProperties);
            IRepositoryObjectReference matchingObject = AIJEObjectRecogniserByUID.getMatchingObjectForIDValue(objectID, objectTypeDefinition, snapshot);
            if (matchingObject == null) continue;
            iObject.setMatchingObject(matchingObject);
        }
    }

    private static IRepositoryPropertySetSample getObjectID(IObject object, ICollection_<? extends IRepositoryPropertyType> uidProperties) {
        HashMap_ objectIDPropertiesMap = new HashMap_(IRepositoryPropertyTypeID.IS_EQUAL_PROPERTY_TYPE_ID_HASHER);
        if (object instanceof ImportedObject) {
            ImportedObject importedObject = (ImportedObject)object;
            for (IRepositoryPropertyType uidProperty : uidProperties) {
                IRepositoryPropertyTypeID uidPropertyTypeID = uidProperty.getRepositoryPropertyTypeID();
                IRepositoryData uidPropertyValue = importedObject.getProperty(uidPropertyTypeID).getImportedValue();
                objectIDPropertiesMap.put((Object)uidPropertyTypeID, (Object)new RepositoryPropertySample(uidPropertyValue));
            }
        } else if (object instanceof ContextObject) {
            IRepositoryPropertySetSample propertySetSample = ((ContextObject)object).getObjectSample().getPropertySetSample();
            for (IRepositoryPropertyType uidProperty : uidProperties) {
                IRepositoryPropertyTypeID uidPropertyTypeID = uidProperty.getRepositoryPropertyTypeID();
                objectIDPropertiesMap.put((Object)uidPropertyTypeID, (Object)propertySetSample.getPropertySample(uidPropertyTypeID));
            }
        } else {
            assert (false);
            return null;
        }
        return new RepositoryPropertySetSample((IMap_<IRepositoryPropertyTypeID, IRepositoryPropertySample>)objectIDPropertiesMap);
    }

    private static IRepositoryObjectReference getMatchingObjectForIDValue(IRepositoryPropertySetSample objectID, IRepositoryObjectType requiredObjectType, IRepositorySnapshotRO snapshot) throws EXNotReproducibleSnapshot {
        IRepositoryObject matchingObject = snapshot.findRepositoryObject(requiredObjectType, objectID);
        if (matchingObject != null) {
            return new RepositoryObjectReference(matchingObject);
        }
        return null;
    }
}

