/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.repository.interFace.importexport.imporT.importjob.impl;

import com.arcway.lib.java.maps.HashMap_;
import com.arcway.lib.java.maps.IMapRW_;
import com.arcway.repository.interFace.data.attributeset.IRepositoryPropertySetSample;
import com.arcway.repository.interFace.data.object.IRepositoryObjectReference;
import com.arcway.repository.interFace.dataaccess.EXNotReproducibleSnapshot;
import com.arcway.repository.interFace.declaration.type.data.IRepositoryObjectTypeCategoryID;
import com.arcway.repository.interFace.declaration.type.object.IRepositoryObjectTypeID;
import com.arcway.repository.interFace.declaration.type.property.IRepositoryPropertyTypeID;
import com.arcway.repository.interFace.declaration.type.relation.IRepositoryRelationTypeID;
import com.arcway.repository.interFace.declaration.type.relationcontribution.IRepositoryRelationContributionRoleID;
import com.arcway.repository.interFace.importexport.imporT.importjob.impl.CrossLinkRelationContributionTypeForImportedObject;
import com.arcway.repository.interFace.importexport.imporT.importjob.impl.CrossLinkRelationContributionTypeKey;
import com.arcway.repository.interFace.importexport.imporT.importjob.impl.ImportJobObject;
import com.arcway.repository.interFace.importexport.imporT.importjob.impl.ImportedObjectType;
import com.arcway.repository.interFace.importexport.imporT.importjob.impl.ImportedObjectTypeCategory;
import com.arcway.repository.interFace.importexport.imporT.importjob.impl.OccurringRelationContributionTypeForImportedObject;
import com.arcway.repository.interFace.importexport.imporT.importjob.impl.OccurringRelationContributionTypeKey;
import com.arcway.repository.interFace.importexport.imporT.importjob.impl.Property;
import com.arcway.repository.interFace.importexport.imporT.importjob.rw.IImportedObject;
import com.arcway.repository.interFace.importexport.imporT.importjob.rw.IImportedObjectTypeCategory;
import com.arcway.repository.interFace.registration.type.relationcontribution.IOccurrenceRepositoryRelationContributionType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;

public class ImportedObject
extends ImportJobObject<ImportedObjectType>
implements IImportedObject {
    private final IRepositoryPropertySetSample objectID;
    private final boolean isExplicitelyExportedObject;
    private boolean importFlag = true;
    private int importMode = 1;
    private IRepositoryObjectReference importTarget = null;
    private ImportedObject parent = null;
    private final List<ImportedObject> children = new ArrayList<ImportedObject>();
    private final ImportedObjectTypeCategory importedObjectTypeCategory;
    private boolean isToBeObjectTypeCategoryChanged = false;
    private IRepositoryObjectTypeCategoryID toBeObjectTypeCategory;
    private final List<Property> propertiesList = new ArrayList<Property>();
    private final IMapRW_<IRepositoryPropertyTypeID, Property> propertiesMap = new HashMap_(IRepositoryPropertyTypeID.IS_EQUAL_PROPERTY_TYPE_ID_HASHER);
    private final LinkedHashMap<CrossLinkRelationContributionTypeKey, CrossLinkRelationContributionTypeForImportedObject> crossLinkRelationContributionTypes = new LinkedHashMap();
    private final LinkedHashMap<OccurringRelationContributionTypeKey, OccurringRelationContributionTypeForImportedObject> occurringRelationContributionTypes = new LinkedHashMap();

    public ImportedObject(IRepositoryPropertySetSample objectID, ImportedObjectType objectType, boolean isExplicitelyExportedObject, ImportedObjectTypeCategory importedObjectTypeCategory) {
        super(objectType);
        this.objectID = objectID;
        this.isExplicitelyExportedObject = isExplicitelyExportedObject;
        this.importedObjectTypeCategory = importedObjectTypeCategory;
        this.isToBeObjectTypeCategoryChanged = true;
        this.toBeObjectTypeCategory = importedObjectTypeCategory != null ? importedObjectTypeCategory.getMatchingObjectTypeCategoryID() : null;
    }

    @Override
    public IRepositoryPropertySetSample getObjectID() {
        return this.objectID;
    }

    @Override
    public boolean isExplicitelyExportedObject() {
        return this.isExplicitelyExportedObject;
    }

    @Override
    public boolean getImportFlag() {
        return this.importFlag;
    }

    @Override
    public void setImportFlag(boolean importFlag) throws EXNotReproducibleSnapshot {
        this.importFlag = importFlag;
        this.fireChange();
    }

    @Override
    public int getImportMode() {
        return this.importMode;
    }

    @Override
    public void setImportMode(int importMode) throws EXNotReproducibleSnapshot {
        this.importMode = importMode == 1 || importMode == 2 ? importMode : 1;
        this.fireChange();
    }

    @Override
    public IRepositoryObjectReference getImportTarget() {
        return this.importTarget;
    }

    @Override
    public void setImportTarget(IRepositoryObjectReference importTarget) throws EXNotReproducibleSnapshot {
        this.importTarget = importTarget;
        this.fireChange();
    }

    @Override
    public ImportedObject getParent() {
        return this.parent;
    }

    public void setParent(ImportedObject parent) {
        this.parent = parent;
    }

    public List<ImportedObject> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    public void addChild(ImportedObject child) {
        this.children.add(child);
    }

    public void sortChildren(Comparator<ImportedObject> comparator) {
        Collections.sort(this.children, comparator);
    }

    @Override
    public IImportedObjectTypeCategory getImportedObjectTypeCategory() {
        return this.importedObjectTypeCategory;
    }

    @Override
    public IRepositoryObjectTypeCategoryID getToBeRepositoryObjectTypeCategory() {
        return this.toBeObjectTypeCategory;
    }

    @Override
    public void setToBeRepositoryObjectTypeCategory(IRepositoryObjectTypeCategoryID categoryID) throws EXNotReproducibleSnapshot {
        this.toBeObjectTypeCategory = categoryID;
        this.isToBeObjectTypeCategoryChanged = true;
        this.fireChange();
    }

    @Override
    public boolean isToBeRepositoryObjectTypeCategoryChanged() {
        return this.isToBeObjectTypeCategoryChanged;
    }

    @Override
    public Property getProperty(IRepositoryPropertyTypeID propertyTypeID) {
        return (Property)this.propertiesMap.getByKey((Object)propertyTypeID);
    }

    public List<Property> getProperties() {
        return Collections.unmodifiableList(this.propertiesList);
    }

    public void addProperty(Property property) {
        this.propertiesList.add(property);
        this.propertiesMap.put((Object)property.getRepositoryPropertyType().getRepositoryPropertyTypeID(), (Object)property);
    }

    @Override
    public CrossLinkRelationContributionTypeForImportedObject getCrossLinkRelationContributionType(IRepositoryRelationTypeID relationTypeID, IRepositoryRelationContributionRoleID relationContributionRoleID) {
        return this.crossLinkRelationContributionTypes.get(new CrossLinkRelationContributionTypeKey(relationTypeID, relationContributionRoleID));
    }

    public Collection<CrossLinkRelationContributionTypeForImportedObject> getCrossLinkRelationContributionTypes() {
        return new ArrayList<CrossLinkRelationContributionTypeForImportedObject>(this.crossLinkRelationContributionTypes.values());
    }

    public void addCrossLinkRelationContributionType(CrossLinkRelationContributionTypeForImportedObject relationContributionType) {
        this.crossLinkRelationContributionTypes.put(new CrossLinkRelationContributionTypeKey(relationContributionType.getRelationType().getRelationType().getRepositoryRelationTypeID(), relationContributionType.getRelationContributionType().getRepositoryRelationContributionRoleID()), relationContributionType);
    }

    @Override
    public OccurringRelationContributionTypeForImportedObject getOccurringRelationContributionType(IRepositoryObjectTypeID objectTypeID, IRepositoryPropertyTypeID propertyTypeID) {
        return this.occurringRelationContributionTypes.get(new OccurringRelationContributionTypeKey(objectTypeID, propertyTypeID));
    }

    public Collection<OccurringRelationContributionTypeForImportedObject> getOccurringRelationContributionTypes() {
        return new ArrayList<OccurringRelationContributionTypeForImportedObject>(this.occurringRelationContributionTypes.values());
    }

    public void addOccurringRelationContributionType(OccurringRelationContributionTypeForImportedObject relationContributionType) {
        IOccurrenceRepositoryRelationContributionType occurrenceContributionType = relationContributionType.getOccurringRelationContributionType().getRelatedRelationType().getOccurrenceRelationContributionType();
        this.occurringRelationContributionTypes.put(new OccurringRelationContributionTypeKey(occurrenceContributionType.getRelatedObjectType().getRepositoryObjectTypeID(), occurrenceContributionType.getRelatedPropertyType().getRepositoryPropertyTypeID()), relationContributionType);
    }
}

