/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.repository.interFace.dataaccess;

import com.arcway.lib.java.collections.HashSet_;
import com.arcway.lib.java.collections.IComparator_;
import com.arcway.lib.java.collections.ISetRW_;
import com.arcway.lib.java.collections.ISet_;
import com.arcway.lib.java.maps.IEntry_;
import com.arcway.lib.java.tuples.Tuple;
import com.arcway.repository.interFace.data.RepositoryObjects;
import com.arcway.repository.interFace.data.RepositoryReferences;
import com.arcway.repository.interFace.data.data.IRepositoryData;
import com.arcway.repository.interFace.data.object.IRepositoryObject;
import com.arcway.repository.interFace.data.object.IRepositoryObjectReference;
import com.arcway.repository.interFace.data.object.IRepositoryObjectSample;
import com.arcway.repository.interFace.data.property.IRepositoryPropertySample;
import com.arcway.repository.interFace.dataaccess.EXNotReproducibleSnapshot;
import com.arcway.repository.interFace.dataaccess.IRepositorySnapshotRO;
import com.arcway.repository.interFace.dataaccess.UniquePropertiesStore;
import com.arcway.repository.interFace.declaration.type.object.IRepositoryObjectTypeID;
import com.arcway.repository.interFace.declaration.type.property.IRepositoryPropertyTypeID;
import com.arcway.repository.interFace.exceptions.IMessageSet;
import com.arcway.repository.interFace.exceptions.MessageSet;
import com.arcway.repository.interFace.importexport.exceptions.EXMissingParent;
import com.arcway.repository.interFace.registration.type.property.IRepositoryPropertyType;
import com.arcway.repository.interFace.registration.type.property.RepositoryPropertyTypeIDType;
import com.arcway.repository.interFace.transactions.exceptions.EXObjectIDPropertyAlreadyInUse;
import com.arcway.repository.interFace.transactions.exceptions.EXObjectNamePropertyAlreadyInUse;
import com.arcway.repository.interFace.transactions.exceptions.EXObjectReferenceCannotBeResolved;
import com.arcway.repository.lib.high.implementation.access.RepositoryObjectReference;
import com.arcway.repository.lib.high.implementation.access.RepositoryObjectSample;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class UniquePropertyChecker {
    public static void checkForExistingObjectsWithProperty(IRepositoryPropertySample propertyToCheck, IRepositoryPropertyType propertyType, IRepositoryObject objectCurrentlyChecked, IRepositorySnapshotRO snapshot) throws EXObjectNamePropertyAlreadyInUse, EXObjectIDPropertyAlreadyInUse, EXNotReproducibleSnapshot {
        IRepositoryObject parentObject = RepositoryObjects.getParentObject(objectCurrentlyChecked);
        RepositoryObjectReference objectCurrentlyCheckedReference = new RepositoryObjectReference(objectCurrentlyChecked);
        UniquePropertyChecker.checkForExistingObjectsWithProperty(propertyToCheck, propertyType, (IRepositoryObjectReference)objectCurrentlyCheckedReference, parentObject, snapshot);
    }

    public static void checkForExistingObjectsWithProperty(IRepositoryPropertySample propertyToCheck, IRepositoryPropertyType propertyType, IRepositoryObjectReference objectCurrentlyChecked, IRepositoryObjectReference parentObjectReference, IRepositorySnapshotRO snapshot) throws EXObjectReferenceCannotBeResolved, EXObjectNamePropertyAlreadyInUse, EXObjectIDPropertyAlreadyInUse, EXNotReproducibleSnapshot {
        IRepositoryObject parentObject = RepositoryReferences.getObjectFromReference(parentObjectReference, snapshot);
        UniquePropertyChecker.checkForExistingObjectsWithProperty(propertyToCheck, propertyType, objectCurrentlyChecked, parentObject, snapshot);
    }

    public static void checkForExistingObjectsWithProperty(IRepositoryPropertySample propertyToCheck, IRepositoryPropertyType propertyType, IRepositoryObjectReference objectCurrentlyChecked, IRepositoryObject parentObject, IRepositorySnapshotRO snapshot) throws EXObjectNamePropertyAlreadyInUse, EXObjectIDPropertyAlreadyInUse, EXNotReproducibleSnapshot {
        IRepositoryObjectSample foundObjectByID;
        HashSet_ objectsWithEqualProperty = new HashSet_(IRepositoryObjectReference.REFERENCING_EQUAL_OBJECTS_HASHER);
        objectsWithEqualProperty.add((Object)objectCurrentlyChecked);
        HashSet_ objectsToIgnore = new HashSet_(IRepositoryObjectReference.REFERENCING_EQUAL_OBJECTS_HASHER);
        objectsToIgnore.add((Object)objectCurrentlyChecked);
        IRepositoryObjectTypeID objectTypeID = propertyType.getAttributeSetType().getObjectType().getRepositoryObjectTypeID();
        RepositoryPropertyTypeIDType propertyTypeIDTyp = propertyType.getIDType();
        if (propertyTypeIDTyp.isName()) {
            IRepositoryObjectSample foundObjectByName = UniquePropertyChecker.findExistingObjectWithNameProperty(propertyType, propertyToCheck.getValue(), parentObject, (HashSet_<IRepositoryObjectReference>)objectsToIgnore, snapshot);
            if (foundObjectByName != null) {
                IRepositoryPropertyTypeID namePropertyTypeID = propertyType.getRepositoryPropertyTypeID();
                throw new EXObjectNamePropertyAlreadyInUse((ISet_<IRepositoryObjectReference>)objectsWithEqualProperty, foundObjectByName, objectTypeID, namePropertyTypeID, propertyToCheck.getValue());
            }
        } else if (propertyTypeIDTyp.isID() && (foundObjectByID = UniquePropertyChecker.findExistingObjectWithIDProperty(propertyType, propertyToCheck.getValue(), (HashSet_<IRepositoryObjectReference>)objectsToIgnore, snapshot)) != null) {
            IRepositoryPropertyTypeID idPropertyTypeID = propertyType.getRepositoryPropertyTypeID();
            throw new EXObjectIDPropertyAlreadyInUse((ISet_<IRepositoryObjectReference>)objectsWithEqualProperty, foundObjectByID, objectTypeID, idPropertyTypeID, propertyToCheck.getValue());
        }
    }

    public static IMessageSet checkForPropertyUniqueness(UniquePropertiesStore uniquePropertiesStore, final IRepositorySnapshotRO snapshot) throws EXNotReproducibleSnapshot {
        final MessageSet messages = new MessageSet();
        for (IEntry_ nameSpace2NameProperties : uniquePropertiesStore.getNameSpace2NameProperties()) {
            Tuple parentState2NameProperties = (Tuple)nameSpace2NameProperties.getValue();
            IRepositoryObject parentObject_rw = null;
            Boolean parentIsNew = (Boolean)parentState2NameProperties.getT1();
            if (!parentIsNew.booleanValue()) {
                IRepositoryObjectReference parent = ((UniquePropertiesStore.NameSpace)nameSpace2NameProperties.getKey()).getParentObjectReference();
                try {
                    parentObject_rw = RepositoryReferences.getObjectFromReference(parent, snapshot);
                }
                catch (EXObjectReferenceCannotBeResolved e) {
                    messages.add(new EXMissingParent(parent));
                }
            }
            final IRepositoryObject parentObject = parentObject_rw;
            List nameProperties = (List)parentState2NameProperties.getT2();
            final HashSet_<IRepositoryObjectReference> objectsToIgnore = UniquePropertyChecker.getModifiedObjects(nameProperties);
            UniquePropertyChecker.checkForPropertyUniquenessUsingHashPartitioning(nameProperties, new ISinglePropertyUniquenessChecker(){

                @Override
                public void check(UniquePropertiesStore.UniquePropertiesStoreEntry namePropertyToBeChecked, ArrayList<UniquePropertiesStore.UniquePropertiesStoreEntry> namePropertyToBeCheckedConflictList) throws EXNotReproducibleSnapshot {
                    ISetRW_ objectsWithEqualProperties;
                    boolean equalPropertyFound = false;
                    if (namePropertyToBeCheckedConflictList != null) {
                        objectsWithEqualProperties = UniquePropertyChecker.checkForEqualProperties(namePropertyToBeChecked, namePropertyToBeCheckedConflictList);
                        if (objectsWithEqualProperties != null && !objectsWithEqualProperties.isEmpty()) {
                            equalPropertyFound = true;
                        }
                    } else {
                        objectsWithEqualProperties = null;
                    }
                    boolean temporarilyIgnoredObjectIsModifiedObject = objectsToIgnore.replace((Object)namePropertyToBeChecked.getObject()) != null;
                    IRepositoryObjectSample foundExistingObject = null;
                    if (parentObject != null && (foundExistingObject = UniquePropertyChecker.findExistingObjectWithNameProperty(namePropertyToBeChecked.getPropertyType(), namePropertyToBeChecked.getPropertySample().getValue(), parentObject, (HashSet_<IRepositoryObjectReference>)objectsToIgnore, snapshot)) != null) {
                        equalPropertyFound = true;
                    }
                    if (!temporarilyIgnoredObjectIsModifiedObject) {
                        objectsToIgnore.remove((Object)namePropertyToBeChecked.getObject());
                    }
                    if (equalPropertyFound) {
                        if (objectsWithEqualProperties == null) {
                            objectsWithEqualProperties = new HashSet_(IRepositoryObjectReference.REFERENCING_EQUAL_OBJECTS_HASHER);
                            objectsWithEqualProperties.add((Object)namePropertyToBeChecked.getObject());
                        } else {
                            objectsWithEqualProperties.add((Object)namePropertyToBeChecked.getObject());
                        }
                        IRepositoryObjectTypeID objectTypeID = namePropertyToBeChecked.getPropertyType().getAttributeSetType().getObjectType().getRepositoryObjectTypeID();
                        messages.add(new EXObjectNamePropertyAlreadyInUse((ISet_<IRepositoryObjectReference>)objectsWithEqualProperties, foundExistingObject, objectTypeID, namePropertyToBeChecked.getPropertyType().getRepositoryPropertyTypeID(), namePropertyToBeChecked.getPropertySample().getValue()));
                    }
                }
            });
        }
        for (IEntry_ objectType2IDproperties : uniquePropertiesStore.getTypeID2IDProperties()) {
            List idProperties = (List)objectType2IDproperties.getValue();
            final HashSet_<IRepositoryObjectReference> objectsToIgnore = UniquePropertyChecker.getModifiedObjects(idProperties);
            UniquePropertyChecker.checkForPropertyUniquenessUsingHashPartitioning(idProperties, new ISinglePropertyUniquenessChecker(){

                @Override
                public void check(UniquePropertiesStore.UniquePropertiesStoreEntry idProperty, ArrayList<UniquePropertiesStore.UniquePropertiesStoreEntry> idPropertiesToCompareTo) throws EXNotReproducibleSnapshot {
                    ISetRW_ objectsWithEqualProperties;
                    boolean equalPropertyFound = false;
                    if (idPropertiesToCompareTo != null) {
                        objectsWithEqualProperties = UniquePropertyChecker.checkForEqualProperties(idProperty, idPropertiesToCompareTo);
                        if (objectsWithEqualProperties != null && !objectsWithEqualProperties.isEmpty()) {
                            equalPropertyFound = true;
                        }
                    } else {
                        objectsWithEqualProperties = null;
                    }
                    boolean temporarilyIgnoredObjectIsModifiedObject = objectsToIgnore.replace((Object)idProperty.getObject()) != null;
                    IRepositoryObjectSample foundExistingObject = UniquePropertyChecker.findExistingObjectWithIDProperty(idProperty.getPropertyType(), idProperty.getPropertySample().getValue(), (HashSet_<IRepositoryObjectReference>)objectsToIgnore, snapshot);
                    if (foundExistingObject != null) {
                        equalPropertyFound = true;
                    }
                    if (!temporarilyIgnoredObjectIsModifiedObject) {
                        objectsToIgnore.remove((Object)idProperty.getObject());
                    }
                    if (equalPropertyFound) {
                        if (objectsWithEqualProperties == null) {
                            objectsWithEqualProperties = new HashSet_(IRepositoryObjectReference.REFERENCING_EQUAL_OBJECTS_HASHER);
                            objectsWithEqualProperties.add((Object)idProperty.getObject());
                        } else {
                            objectsWithEqualProperties.add((Object)idProperty.getObject());
                        }
                        IRepositoryObjectTypeID objectTypeID = idProperty.getPropertyType().getAttributeSetType().getObjectType().getRepositoryObjectTypeID();
                        messages.add(new EXObjectIDPropertyAlreadyInUse((ISet_<IRepositoryObjectReference>)objectsWithEqualProperties, foundExistingObject, objectTypeID, idProperty.getPropertyType().getRepositoryPropertyTypeID(), idProperty.getPropertySample().getValue()));
                    }
                }
            });
        }
        return messages;
    }

    private static void checkForPropertyUniquenessUsingHashPartitioning(List<UniquePropertiesStore.UniquePropertiesStoreEntry> allProperties, ISinglePropertyUniquenessChecker singlePropertyUniquenessChecker) throws EXNotReproducibleSnapshot {
        Object[] propertyConflictPartitionBuckets;
        if (allProperties.size() > 4) {
            int numberOfConflictPartitionBuckets = 16;
            while (numberOfConflictPartitionBuckets < allProperties.size() * 2) {
                numberOfConflictPartitionBuckets *= 2;
            }
            int conflictPartitionBucketIndexMask = numberOfConflictPartitionBuckets - 1;
            propertyConflictPartitionBuckets = new Object[numberOfConflictPartitionBuckets];
            IComparator_<IRepositoryData> conflictBucketHasher = allProperties.get(0).getPropertyType().getIDType().getCanonicalizedValueComparator();
            assert (conflictBucketHasher != null);
            for (UniquePropertiesStore.UniquePropertiesStoreEntry property : allProperties) {
                ArrayList<UniquePropertiesStore.UniquePropertiesStoreEntry> conflictPartition;
                IRepositoryData propertyValue = property.getPropertySample().getValue();
                int propertyValueHashCode = conflictBucketHasher.getHashCode((Object)propertyValue);
                int bucketIndex = propertyValueHashCode & conflictPartitionBucketIndexMask;
                Object currentBucketOccupant = propertyConflictPartitionBuckets[bucketIndex];
                if (currentBucketOccupant == null) {
                    propertyConflictPartitionBuckets[bucketIndex] = property;
                    continue;
                }
                if (currentBucketOccupant instanceof UniquePropertiesStore.UniquePropertiesStoreEntry) {
                    conflictPartition = new ArrayList<UniquePropertiesStore.UniquePropertiesStoreEntry>(4);
                    conflictPartition.add((UniquePropertiesStore.UniquePropertiesStoreEntry)currentBucketOccupant);
                    conflictPartition.add(property);
                    propertyConflictPartitionBuckets[bucketIndex] = conflictPartition;
                    continue;
                }
                conflictPartition = (ArrayList<UniquePropertiesStore.UniquePropertiesStoreEntry>)currentBucketOccupant;
                conflictPartition.add(property);
            }
        } else {
            propertyConflictPartitionBuckets = new Object[]{allProperties};
        }
        Object[] objectArray = propertyConflictPartitionBuckets;
        int n = propertyConflictPartitionBuckets.length;
        int n2 = 0;
        while (n2 < n) {
            Object conflictBucketOccupant = objectArray[n2];
            if (conflictBucketOccupant != null) {
                if (conflictBucketOccupant instanceof UniquePropertiesStore.UniquePropertiesStoreEntry) {
                    singlePropertyUniquenessChecker.check((UniquePropertiesStore.UniquePropertiesStoreEntry)conflictBucketOccupant, null);
                } else {
                    ArrayList remainingPartOfConflictPartition = (ArrayList)conflictBucketOccupant;
                    do {
                        UniquePropertiesStore.UniquePropertiesStoreEntry propertyToBeChecked = (UniquePropertiesStore.UniquePropertiesStoreEntry)remainingPartOfConflictPartition.remove(remainingPartOfConflictPartition.size() - 1);
                        if (remainingPartOfConflictPartition.isEmpty()) {
                            singlePropertyUniquenessChecker.check(propertyToBeChecked, null);
                            continue;
                        }
                        singlePropertyUniquenessChecker.check(propertyToBeChecked, remainingPartOfConflictPartition);
                    } while (!remainingPartOfConflictPartition.isEmpty());
                }
            }
            ++n2;
        }
    }

    private static IRepositoryObjectSample findExistingObjectWithNameProperty(IRepositoryPropertyType propertyType, IRepositoryData propertyValue, IRepositoryObject parentObject, HashSet_<IRepositoryObjectReference> objectsToIgnore, IRepositorySnapshotRO snapshot) throws EXNotReproducibleSnapshot {
        RepositoryObjectSample foundObjectAsSample = null;
        IRepositoryObject foundObject = snapshot.findObjectByNameProperty(propertyType, propertyValue, parentObject);
        if (foundObject != null && !UniquePropertyChecker.hasToBeIgnored(foundObject, objectsToIgnore)) {
            foundObjectAsSample = new RepositoryObjectSample(foundObject);
        }
        return foundObjectAsSample;
    }

    private static IRepositoryObjectSample findExistingObjectWithIDProperty(IRepositoryPropertyType propertyType, IRepositoryData propertyValue, HashSet_<IRepositoryObjectReference> objectsToIgnore, IRepositorySnapshotRO snapshot) throws EXNotReproducibleSnapshot {
        RepositoryObjectSample foundObjectAsSample = null;
        IRepositoryObject foundObjectByID = snapshot.findObjectByIDProperty(propertyType, propertyValue);
        if (foundObjectByID != null && !UniquePropertyChecker.hasToBeIgnored(foundObjectByID, objectsToIgnore)) {
            foundObjectAsSample = new RepositoryObjectSample(foundObjectByID);
        }
        return foundObjectAsSample;
    }

    private static boolean hasToBeIgnored(IRepositoryObject foundObject, HashSet_<IRepositoryObjectReference> objectsToIgnore) throws EXNotReproducibleSnapshot {
        RepositoryObjectReference foundObjectReference = new RepositoryObjectReference(foundObject);
        return objectsToIgnore.contains((Object)foundObjectReference);
    }

    private static ISetRW_<IRepositoryObjectReference> checkForEqualProperties(UniquePropertiesStore.UniquePropertiesStoreEntry propertyToCheck, List<UniquePropertiesStore.UniquePropertiesStoreEntry> propertiesToCompareTo) {
        HashSet_ objectsWithEqualProperties = null;
        IRepositoryPropertySample propertyCurrentlyChecked = propertyToCheck.getPropertySample();
        IRepositoryData propertyValueCurrentlyChecked = propertyCurrentlyChecked.getValue();
        IComparator_<IRepositoryData> equalComparator = propertyToCheck.getPropertyType().getIDType().getCanonicalizedValueComparator();
        Iterator<UniquePropertiesStore.UniquePropertiesStoreEntry> itPropertiesToCompareTo = propertiesToCompareTo.iterator();
        while (itPropertiesToCompareTo.hasNext()) {
            UniquePropertiesStore.UniquePropertiesStoreEntry propertyToCompareTo = itPropertiesToCompareTo.next();
            IRepositoryData propertyValueToCompareTo = propertyToCompareTo.getPropertySample().getValue();
            if (equalComparator.sgn((Object)propertyValueCurrentlyChecked, (Object)propertyValueToCompareTo) != 0) continue;
            if (objectsWithEqualProperties == null) {
                objectsWithEqualProperties = new HashSet_(IRepositoryObjectReference.REFERENCING_EQUAL_OBJECTS_HASHER);
            }
            objectsWithEqualProperties.add((Object)propertyToCompareTo.getObject());
            itPropertiesToCompareTo.remove();
        }
        return objectsWithEqualProperties;
    }

    private static HashSet_<IRepositoryObjectReference> getModifiedObjects(List<UniquePropertiesStore.UniquePropertiesStoreEntry> propertiesToCheck) {
        HashSet_ modifiedObjects = new HashSet_(propertiesToCheck.size(), IRepositoryObjectReference.REFERENCING_EQUAL_OBJECTS_HASHER);
        for (UniquePropertiesStore.UniquePropertiesStoreEntry propertyToCheck : propertiesToCheck) {
            if (propertyToCheck.getPropertyOperation() != 2) continue;
            modifiedObjects.add((Object)propertyToCheck.getObject());
        }
        return modifiedObjects;
    }

    private static interface ISinglePropertyUniquenessChecker {
        public void check(UniquePropertiesStore.UniquePropertiesStoreEntry var1, ArrayList<UniquePropertiesStore.UniquePropertiesStoreEntry> var2) throws EXNotReproducibleSnapshot;
    }
}

