/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.repository.interFace.data.lock;

import com.arcway.lib.java.Assert;
import com.arcway.lib.java.To;

public final class RepositoryObjectLockType {
    private static final boolean[][] COMPATIBILITY;
    public static final RepositoryObjectLockType SHARED;
    public static final RepositoryObjectLockType MOVE_SHARED;
    public static final RepositoryObjectLockType MOVE_EXCLUSIVE;
    public static final RepositoryObjectLockType EXCLUSIVE;
    private final String name;

    static {
        boolean[][] blArrayArray = new boolean[4][];
        boolean[] blArray = new boolean[4];
        blArray[0] = true;
        blArray[1] = true;
        blArray[2] = true;
        blArrayArray[0] = blArray;
        boolean[] blArray2 = new boolean[4];
        blArray2[0] = true;
        blArray2[1] = true;
        blArrayArray[1] = blArray2;
        boolean[] blArray3 = new boolean[4];
        blArray3[0] = true;
        blArrayArray[2] = blArray3;
        blArrayArray[3] = new boolean[4];
        COMPATIBILITY = blArrayArray;
        SHARED = new RepositoryObjectLockType("shared");
        MOVE_SHARED = new RepositoryObjectLockType("move shared");
        MOVE_EXCLUSIVE = new RepositoryObjectLockType("move exclusive");
        EXCLUSIVE = new RepositoryObjectLockType("exclusive");
    }

    public static boolean isCompatible(RepositoryObjectLockType a, RepositoryObjectLockType b) {
        return COMPATIBILITY[a.getLevel()][b.getLevel()];
    }

    private RepositoryObjectLockType(String name) {
        Assert.checkArgumentBeeingNotNull((Object)name);
        this.name = name;
    }

    public String toString() {
        return String.valueOf(To.string((Object)this)) + " (" + this.name + ")";
    }

    public boolean shared() {
        return this == SHARED;
    }

    public boolean moveShared() {
        return this == MOVE_SHARED;
    }

    public boolean move_exclusive() {
        return this == MOVE_EXCLUSIVE;
    }

    public boolean exclusive() {
        return this == EXCLUSIVE;
    }

    private int getLevel() {
        final int[] level = new int[]{-1};
        try {
            new Switch(this){

                @Override
                public void caseShared() throws Exception {
                    level[0] = 0;
                }

                @Override
                public void caseMoveShared() throws Exception {
                    level[0] = 1;
                }

                @Override
                public void caseMoveExclusive() throws Exception {
                    level[0] = 2;
                }

                @Override
                public void caseExclusive() throws Exception {
                    level[0] = 3;
                }
            };
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        assert (level[0] >= 0);
        return level[0];
    }

    public static abstract class Switch {
        public Switch(RepositoryObjectLockType conflictType) throws Exception {
            if (conflictType == SHARED) {
                this.caseShared();
            } else if (conflictType == MOVE_SHARED) {
                this.caseMoveShared();
            } else if (conflictType == MOVE_EXCLUSIVE) {
                this.caseMoveExclusive();
            } else if (conflictType == EXCLUSIVE) {
                this.caseExclusive();
            } else {
                Assert.illegalArgument();
            }
        }

        public abstract void caseShared() throws Exception;

        public abstract void caseMoveShared() throws Exception;

        public abstract void caseMoveExclusive() throws Exception;

        public abstract void caseExclusive() throws Exception;
    }
}

