/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.repository.interFace.data;

import com.arcway.lib.java.Assert;
import com.arcway.lib.java.maps.IMap_;
import com.arcway.lib.stringtools.StringUtil;
import com.arcway.repository.interFace.data.RepositorySamples;
import com.arcway.repository.interFace.data.attributeset.IRepositoryAttributeSet;
import com.arcway.repository.interFace.data.attributeset.IRepositoryAttributeSetReference;
import com.arcway.repository.interFace.data.attributeset.IRepositoryPropertySetSample;
import com.arcway.repository.interFace.data.object.IRepositoryObject;
import com.arcway.repository.interFace.data.object.IRepositoryObjectReference;
import com.arcway.repository.interFace.data.property.IRepositoryProperty;
import com.arcway.repository.interFace.data.property.IRepositoryPropertyReference;
import com.arcway.repository.interFace.data.relation.ICrossLinkRepositoryRelation;
import com.arcway.repository.interFace.data.relation.ICrossLinkRepositoryRelationReference;
import com.arcway.repository.interFace.data.relation.ICrossLinkRepositoryRelationsReference;
import com.arcway.repository.interFace.data.relation.IOccurrenceRepositoryRelation;
import com.arcway.repository.interFace.data.relation.IOccurrenceRepositoryRelationReference;
import com.arcway.repository.interFace.data.relation.IRepositoryIterator_ICrossLinkRepositoryRelation;
import com.arcway.repository.interFace.data.relationcontribution.ICrossLinkRepositoryRelationContribution;
import com.arcway.repository.interFace.data.relationcontribution.ICrossLinkRepositoryRelationContributionReference;
import com.arcway.repository.interFace.dataaccess.EXNotReproducibleSnapshot;
import com.arcway.repository.interFace.dataaccess.IRepositorySnapshotRO;
import com.arcway.repository.interFace.declaration.type.attributeset.IRepositoryAttributeSetTypeID;
import com.arcway.repository.interFace.declaration.type.object.IRepositoryObjectTypeID;
import com.arcway.repository.interFace.declaration.type.property.IRepositoryPropertyTypeID;
import com.arcway.repository.interFace.declaration.type.relation.IRepositoryRelationTypeID;
import com.arcway.repository.interFace.declaration.type.relationcontribution.IRepositoryRelationContributionRoleID;
import com.arcway.repository.interFace.registration.type.IRepositoryTypeManagerRO;
import com.arcway.repository.interFace.registration.type.attributeset.IRepositoryAttributeSetType;
import com.arcway.repository.interFace.registration.type.object.IRepositoryObjectType;
import com.arcway.repository.interFace.registration.type.property.IRepositoryPropertyType;
import com.arcway.repository.interFace.registration.type.relation.ICrossLinkRepositoryRelationType;
import com.arcway.repository.interFace.registration.type.relation.IOccurrenceRepositoryRelationType;
import com.arcway.repository.interFace.registration.type.relationcontribution.ICrossLinkRepositoryRelationContributionType;
import com.arcway.repository.interFace.transactions.exceptions.EXAttributeSetReferenceCannotBeResolved;
import com.arcway.repository.interFace.transactions.exceptions.EXCrossLinkRelationContributionReferenceCannotBeResolved;
import com.arcway.repository.interFace.transactions.exceptions.EXCrossLinkRelationReferenceCannotBeResolved;
import com.arcway.repository.interFace.transactions.exceptions.EXMissingCrossLinkTarget;
import com.arcway.repository.interFace.transactions.exceptions.EXObjectReferenceCannotBeResolved;

public class RepositoryReferences {
    public static IRepositoryObject getObjectFromReference(IRepositoryObjectReference objectReference, IRepositorySnapshotRO snapshot) throws EXNotReproducibleSnapshot, EXObjectReferenceCannotBeResolved {
        IRepositoryObjectTypeID objectTypeID = objectReference.getObjectTypeID();
        IRepositoryPropertySetSample objectID = objectReference.getObjectID();
        IRepositoryObjectType objectType = snapshot.getTypeManager().getObjectType(objectTypeID);
        IRepositoryObject foundObject = snapshot.findRepositoryObject(objectType, objectID);
        if (foundObject == null) {
            throw new EXObjectReferenceCannotBeResolved(objectReference);
        }
        return foundObject;
    }

    public static IRepositoryAttributeSet getAttributeSetFromReference(IRepositoryAttributeSetReference attributeSetReference, IRepositorySnapshotRO snapshot) throws EXNotReproducibleSnapshot, EXObjectReferenceCannotBeResolved, EXAttributeSetReferenceCannotBeResolved {
        IRepositoryObjectReference relatedObjectReference = attributeSetReference.getObjectReference();
        IRepositoryObject relatedObject = RepositoryReferences.getObjectFromReference(relatedObjectReference, snapshot);
        IRepositoryAttributeSetTypeID asTypeID = attributeSetReference.getAttributeSetTypeID();
        IRepositoryAttributeSetType attributeSetType = relatedObject.getObjectType().getAttributeSetType(asTypeID);
        IRepositoryAttributeSet attributeSet = relatedObject.getAttributeSet(attributeSetType);
        if (attributeSet == null) {
            throw new EXAttributeSetReferenceCannotBeResolved(asTypeID, relatedObjectReference.getObjectTypeID(), relatedObjectReference.getObjectID());
        }
        return attributeSet;
    }

    public static IRepositoryProperty getPropertyFromReference(IRepositoryPropertyReference propertyReference, IRepositorySnapshotRO snapshot) throws EXNotReproducibleSnapshot, EXObjectReferenceCannotBeResolved {
        IRepositoryPropertyTypeID propertyTypeID = propertyReference.getPropertyTypeID();
        IRepositoryObjectReference relatedObjectReference = propertyReference.getObjectReference();
        IRepositoryObject relatedObject = RepositoryReferences.getObjectFromReference(relatedObjectReference, snapshot);
        IRepositoryAttributeSetType attributeSetType = relatedObject.getObjectType().getAttributeSetType(propertyTypeID);
        IRepositoryPropertyType propertyType = attributeSetType.getPropertyType(propertyTypeID);
        IRepositoryProperty property = relatedObject.getAttributeSet(attributeSetType).getProperty(propertyType);
        return property;
    }

    public static ICrossLinkRepositoryRelation getRelationFromReference(ICrossLinkRepositoryRelationReference relationReference, IRepositorySnapshotRO snapshot) throws EXNotReproducibleSnapshot, EXMissingCrossLinkTarget, EXCrossLinkRelationReferenceCannotBeResolved {
        IMap_<IRepositoryRelationContributionRoleID, IRepositoryPropertySetSample> roleID2ObjectID;
        ICrossLinkRepositoryRelationType relationType = snapshot.getTypeManager().getCrossLinkRelationType(relationReference.getRelationTypeID());
        IRepositoryIterator_ICrossLinkRepositoryRelation iteratorFoundRelations = snapshot.findCrossLinkRelations(relationType, roleID2ObjectID = relationReference.getRoleID2ObjectIDMap());
        if (!iteratorFoundRelations.hasNext()) {
            throw new EXCrossLinkRelationReferenceCannotBeResolved(relationReference);
        }
        ICrossLinkRepositoryRelation foundRepositoryRelation = iteratorFoundRelations.nextIRepositoryRelation();
        Assert.checkArgument((!iteratorFoundRelations.hasNext() ? 1 : 0) != 0);
        return foundRepositoryRelation;
    }

    public static ICrossLinkRepositoryRelationContribution getRelationContributionFromReference(ICrossLinkRepositoryRelationContributionReference relationContributionReference, IRepositorySnapshotRO snapshot) throws EXNotReproducibleSnapshot, EXMissingCrossLinkTarget, EXCrossLinkRelationContributionReferenceCannotBeResolved, EXCrossLinkRelationReferenceCannotBeResolved {
        ICrossLinkRepositoryRelation relation = RepositoryReferences.getRelationFromReference(relationContributionReference.getRelationReference(), snapshot);
        IRepositoryRelationContributionRoleID roleID = relationContributionReference.getRelationContributionRoleID();
        ICrossLinkRepositoryRelationContributionType rcType = relation.getRelationType().getRelationContributionType(roleID);
        ICrossLinkRepositoryRelationContribution relationContribution = relation.getRelationContribution(rcType);
        if (relationContribution == null) {
            IRepositoryPropertySetSample objectID = relationContributionReference.getRelationReference().getObjectID(roleID);
            IRepositoryRelationTypeID relationTypeID = relation.getRelationType().getRepositoryRelationTypeID();
            throw new EXCrossLinkRelationContributionReferenceCannotBeResolved(relationTypeID, objectID, roleID);
        }
        return relationContribution;
    }

    public static IRepositoryIterator_ICrossLinkRepositoryRelation getAllRelationsFromReference(ICrossLinkRepositoryRelationsReference relationsReference, IRepositorySnapshotRO snapshot) throws EXNotReproducibleSnapshot, EXMissingCrossLinkTarget {
        ICrossLinkRepositoryRelationType relationType = snapshot.getTypeManager().getCrossLinkRelationType(relationsReference.getRelationTypeID());
        IRepositoryIterator_ICrossLinkRepositoryRelation iteratorRelations = snapshot.findCrossLinkRelations(relationType, relationsReference.getRoleID2ObjectIDMap());
        return iteratorRelations;
    }

    public static String createCanonicalString(IRepositoryObjectReference repositoryObjectReference) {
        String[] elements = new String[]{repositoryObjectReference.getObjectTypeID().toCanonicalString(), RepositorySamples.createCanonicalString(repositoryObjectReference.getObjectID())};
        String canonicalString = StringUtil.createCanonicalStringConcatenation((String[])elements);
        return canonicalString;
    }

    public static IOccurrenceRepositoryRelation getFromReference(IOccurrenceRepositoryRelationReference relationReference, IRepositorySnapshotRO snapshot) throws EXNotReproducibleSnapshot {
        IOccurrenceRepositoryRelationType relationType = snapshot.getTypeManager().getOccurrenceRelationType(relationReference.getRelationTypeID());
        return snapshot.findOccurrenceRelation(relationType, relationReference.getObjectIDofOccurrenceContainingObject(), relationReference.getOccurrenceID());
    }

    public static IRepositoryPropertyType getPropertyTypeFromReference(IRepositoryPropertyReference propertyReference, IRepositoryTypeManagerRO typeManager) {
        IRepositoryObjectReference repositoryObjectReference = propertyReference.getObjectReference();
        IRepositoryObjectTypeID repositoryObjectTypeID = repositoryObjectReference.getObjectTypeID();
        IRepositoryPropertyTypeID repositoryPropertyTypeID = propertyReference.getPropertyTypeID();
        IRepositoryObjectType repositoryObjectType = typeManager.getObjectType(repositoryObjectTypeID);
        IRepositoryPropertyType propertyType = repositoryObjectType.getAttributeSetType(repositoryPropertyTypeID).getPropertyType(repositoryPropertyTypeID);
        return propertyType;
    }
}

