/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.repository.implementation.transactions;

import com.arcway.lib.java.Assert;
import com.arcway.lib.java.collections.ICollection_;
import com.arcway.lib.java.collections.IList_;
import com.arcway.lib.java.maps.IMap_;
import com.arcway.lib.listener.ListenerManager;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.repository.implementation.transactions.AbstractElementaryAction;
import com.arcway.repository.implementation.transactions.IRepositoryTransactionAdmin;
import com.arcway.repository.implementation.transactions.RepositoryActionStruct;
import com.arcway.repository.interFace.data.attributeset.IRepositoryAttributeSet;
import com.arcway.repository.interFace.data.attributeset.IRepositoryPropertySetSample;
import com.arcway.repository.interFace.data.data.IRepositoryData;
import com.arcway.repository.interFace.data.lock.AbstractRepositoryLockSample;
import com.arcway.repository.interFace.data.object.IRepositoryIterator_IRepositoryObject;
import com.arcway.repository.interFace.data.object.IRepositoryObject;
import com.arcway.repository.interFace.data.object.IRepositoryObjectSample;
import com.arcway.repository.interFace.data.object.IRepositoryObjectTypeCategory;
import com.arcway.repository.interFace.data.relation.ICrossLinkRepositoryRelation;
import com.arcway.repository.interFace.data.relation.ICrossLinkRepositoryRelationSample;
import com.arcway.repository.interFace.data.relation.IOccurrenceRepositoryRelation;
import com.arcway.repository.interFace.data.relation.IOccurrenceRepositoryRelationReference;
import com.arcway.repository.interFace.data.relation.IOccurrenceRepositoryRelationSample;
import com.arcway.repository.interFace.data.relation.IRepositoryIterator_ICrossLinkRepositoryRelation;
import com.arcway.repository.interFace.dataaccess.EXNotReproducibleSnapshot;
import com.arcway.repository.interFace.dataaccess.IRepositoryInterfaceRO;
import com.arcway.repository.interFace.dataaccess.IRepositorySnapshotListener;
import com.arcway.repository.interFace.dataaccess.IRepositorySnapshotRO;
import com.arcway.repository.interFace.dataaccess.IRepositorySnapshotRW;
import com.arcway.repository.interFace.dataaccess.locksandpermissions.exceptions.EXLockDenied;
import com.arcway.repository.interFace.dataaccess.locksandpermissions.exceptions.EXPermissionDenied;
import com.arcway.repository.interFace.declaration.type.data.IRepositoryObjectTypeCategoryID;
import com.arcway.repository.interFace.declaration.type.relationcontribution.IRepositoryRelationContributionRoleID;
import com.arcway.repository.interFace.implementation.workspace.IRepositoryWorkspaceRW;
import com.arcway.repository.interFace.registration.type.IRepositoryTypeManagerRO;
import com.arcway.repository.interFace.registration.type.object.IRepositoryObjectType;
import com.arcway.repository.interFace.registration.type.property.IRepositoryPropertyType;
import com.arcway.repository.interFace.registration.type.relation.ICrossLinkRepositoryRelationType;
import com.arcway.repository.interFace.registration.type.relation.IOccurrenceRepositoryRelationType;
import com.arcway.repository.interFace.transactions.AbstractRepositoryAction;
import com.arcway.repository.interFace.transactions.IRepositoryActionStruct;
import com.arcway.repository.interFace.transactions.IRepositoryElementaryActionFactory;
import com.arcway.repository.interFace.transactions.IRepositoryTransaction;
import com.arcway.repository.interFace.transactions.IRepositoryTransactionContext;
import com.arcway.repository.interFace.transactions.IRepositoryTransactionManager;
import com.arcway.repository.interFace.transactions.IRepositoryTransactionStateChangeListener;
import com.arcway.repository.interFace.transactions.ITransactionExecutionWrapper;
import com.arcway.repository.interFace.transactions.RepositoryMergeState;
import com.arcway.repository.interFace.transactions.RepositoryTransactionState;
import com.arcway.repository.interFace.transactions.exceptions.EXMissingCrossLinkTarget;
import com.arcway.repository.interFace.transactions.exceptions.EXTransactionExecution;
import com.arcway.repository.lib.high.genericmodifications.interFace.transactions.OccurrenceRelationContribution;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class RepositoryTPTransaction
implements IRepositoryTransactionAdmin {
    private static final ILogger logger = Logger.getLogger(RepositoryTPTransaction.class);
    private final IRepositoryTransactionManager manager;
    private final IRepositorySnapshotRW snapshotProxy;
    private RepositoryTransactionState state;
    private final LinkedList currentActionStack = new LinkedList();
    private final Map childActions = new HashMap();
    private final List elementaryActions = new ArrayList();
    private final List listeners = new ArrayList();
    private boolean toBeExecuted = false;
    private boolean toBeClosed = false;
    private RepositoryMergeState mergeState = RepositoryMergeState.OK;
    private RepositoryMergeState predecessorMergeState = RepositoryMergeState.OK;
    private final ReActionExecutionStrategy reActionStrategy = new SimpleReActionStrategy();
    private final ITransactionExecutionWrapper transactionExecutionWrapper;

    public RepositoryTPTransaction(IRepositoryTransactionManager tm, IRepositorySnapshotRW snapshot, ITransactionExecutionWrapper transactionExecutionWrapper) {
        Assert.checkArgumentBeeingNotNull((Object)tm);
        this.manager = tm;
        this.snapshotProxy = new RepositorySnapshotProxy(snapshot);
        this.state = RepositoryTransactionState.OPEN;
        this.childActions.put(null, new ArrayList());
        this.transactionExecutionWrapper = transactionExecutionWrapper;
    }

    public IRepositorySnapshotRO getSnapshot() {
        return this.snapshotProxy;
    }

    public long getTransactionID() {
        return this.manager.getTransactionID((IRepositoryTransaction)this);
    }

    public void appendAction(AbstractRepositoryAction action) throws EXNotReproducibleSnapshot, EXTransactionExecution, EXPermissionDenied, EXLockDenied {
        Assert.checkArgumentBeeingNotNull((Object)action);
        Assert.checkState((boolean)this.state.canActionsBeAppended());
        IRepositoryActionStruct parent = null;
        if (!this.currentActionStack.isEmpty()) {
            parent = (IRepositoryActionStruct)this.currentActionStack.getLast();
            assert (!(parent.getAction() instanceof AbstractElementaryAction)) : "Elementary actions cannot have child actions.";
        } else {
            Assert.checkState((!this.toBeExecuted ? 1 : 0) != 0);
            this.stateTransit(RepositoryTransactionState.EXECUTING);
        }
        IRepositoryActionStruct actionStruct = this.createActionStruct(action, parent);
        List children = (List)this.childActions.get(actionStruct.getParent());
        children.add(actionStruct);
        this.executeActionStruct(actionStruct);
    }

    /*
     * Exception decompiling
     */
    public boolean executeTopLevelActions() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void executeActionStruct(final IRepositoryActionStruct actionStruct) throws EXNotReproducibleSnapshot, EXTransactionExecution, EXPermissionDenied, EXLockDenied {
        final Throwable[] thrownException = new Throwable[1];
        this.transactionExecutionWrapper.run(new Runnable(){

            @Override
            public void run() {
                RepositoryTPTransaction.this.pushActionStack(actionStruct);
                RepositoryTPTransaction.this.reActionStrategy.actionToBeExecuted(actionStruct);
                int elementaryActionIndex = RepositoryTPTransaction.this.elementaryActions.size();
                try {
                    RepositoryTPTransaction.this.executeActionSet(actionStruct.getPreActions());
                    RepositoryTPTransaction.this.executeAction(actionStruct);
                    RepositoryTPTransaction.this.reActionStrategy.actionExecuted(actionStruct);
                }
                catch (EXNotReproducibleSnapshot e) {
                    thrownException[0] = e;
                }
                catch (EXTransactionExecution e) {
                    thrownException[0] = e;
                }
                catch (EXPermissionDenied e) {
                    thrownException[0] = e;
                }
                catch (EXLockDenied e) {
                    thrownException[0] = e;
                }
                catch (Error e) {
                    thrownException[0] = e;
                }
                catch (RuntimeException e) {
                    thrownException[0] = e;
                }
                RepositoryTPTransaction.this.popActionStack();
                if (thrownException[0] != null) {
                    RepositoryTPTransaction.this.cleanUp(actionStruct);
                }
                if (actionStruct.getParent() == null) {
                    if (thrownException[0] != null) {
                        logger.debug("Rolling action (" + actionStruct.getAction().getName() + ") back due to exception.", thrownException[0]);
                        RepositoryTPTransaction.this.stateTransit(RepositoryTransactionState.PARTIAL_ROLLBACK);
                        List children = (List)RepositoryTPTransaction.this.childActions.get(actionStruct.getParent());
                        children.remove(actionStruct);
                        try {
                            int i = RepositoryTPTransaction.this.elementaryActions.size() - 1;
                            while (i >= elementaryActionIndex) {
                                AbstractElementaryAction elementaryAction = (AbstractElementaryAction)((Object)RepositoryTPTransaction.this.elementaryActions.remove(i));
                                elementaryAction.rollback((IRepositoryTransactionContext)RepositoryTPTransaction.this);
                                --i;
                            }
                        }
                        catch (Throwable e) {
                            logger.error(e);
                            RepositoryTPTransaction.this.stateTransit(RepositoryTransactionState.FAILED);
                            throw new RuntimeException("Cannot rollback action.", e);
                        }
                    }
                    RepositoryTPTransaction.this.stateTransit(RepositoryTransactionState.OPEN);
                    RepositoryTPTransaction.this.snapshotProxy.consistentStateReached();
                }
            }
        });
        if (thrownException[0] != null) {
            if (thrownException[0] instanceof EXNotReproducibleSnapshot) {
                throw (EXNotReproducibleSnapshot)thrownException[0];
            }
            if (thrownException[0] instanceof EXTransactionExecution) {
                throw (EXTransactionExecution)thrownException[0];
            }
            if (thrownException[0] instanceof EXPermissionDenied) {
                throw (EXPermissionDenied)thrownException[0];
            }
            if (thrownException[0] instanceof EXLockDenied) {
                throw (EXLockDenied)thrownException[0];
            }
            if (thrownException[0] instanceof Error) {
                throw (Error)thrownException[0];
            }
            if (thrownException[0] instanceof RuntimeException) {
                throw (RuntimeException)thrownException[0];
            }
            throw new RuntimeException(thrownException[0]);
        }
    }

    private IRepositoryActionStruct createActionStruct(AbstractRepositoryAction action, IRepositoryActionStruct parent) {
        RepositoryActionStruct actionStruct;
        assert (action != null);
        if (action instanceof AbstractElementaryAction) {
            actionStruct = new RepositoryActionStruct(action, parent, this);
        } else {
            Set before = this.convertToActionStructSet(this.manager.getPreActions(action));
            Set after = this.convertToActionStructSet(this.manager.getReActions(action));
            actionStruct = new RepositoryActionStruct(action, parent, this, before, after);
            this.childActions.put(actionStruct, new ArrayList());
        }
        return actionStruct;
    }

    private Set convertToActionStructSet(Set actionSet) {
        assert (actionSet != null);
        HashSet<IRepositoryActionStruct> result = new HashSet<IRepositoryActionStruct>();
        for (AbstractRepositoryAction action : actionSet) {
            result.add(this.createActionStruct(action, null));
        }
        return result;
    }

    private void cleanUp(IRepositoryActionStruct action) {
        List children;
        assert (action != null);
        Set preActions = action.getPreActions();
        Iterator iter = preActions.iterator();
        while (iter.hasNext()) {
            this.cleanUp((IRepositoryActionStruct)iter.next());
        }
        Set reActions = action.getReActions();
        Iterator iter2 = reActions.iterator();
        while (iter2.hasNext()) {
            this.cleanUp((IRepositoryActionStruct)iter2.next());
        }
        if (!(action.getAction() instanceof AbstractElementaryAction) && (children = (List)this.childActions.remove(action)) != null) {
            int i = 0;
            while (i < children.size()) {
                IRepositoryActionStruct child = (IRepositoryActionStruct)children.get(i);
                this.cleanUp(child);
                ++i;
            }
        }
        this.reActionStrategy.cleanUp(action);
    }

    private void executeAction(IRepositoryActionStruct actionStruct) throws EXNotReproducibleSnapshot, EXTransactionExecution, EXPermissionDenied, EXLockDenied {
        assert (actionStruct != null);
        if (logger.isTraceEnabled()) {
            logger.trace("Executing: " + actionStruct.getAction().getName());
        }
        actionStruct.getAction().execute((IRepositoryTransactionContext)this);
        if (actionStruct.getAction() instanceof AbstractElementaryAction) {
            AbstractElementaryAction action = (AbstractElementaryAction)actionStruct.getAction();
            this.elementaryActions.add(action);
            IRepositoryTransaction[] conflictingTransactions = this.manager.getConflictingOpenTransactions((IRepositoryTransaction)this, action.getLocks());
            if (conflictingTransactions.length > 0) {
                StringBuffer message = new StringBuffer("Conflict with open transaction(s) with the following transaction ID(s): ");
                int i = 0;
                while (i < conflictingTransactions.length) {
                    if (i > 0) {
                        if (i == conflictingTransactions.length - 1) {
                            message.append(" and ");
                        } else {
                            message.append(", ");
                        }
                    }
                    message.append(conflictingTransactions[i].getTransactionID());
                    ++i;
                }
                message.append('.');
                throw new RuntimeException(message.toString());
            }
        }
    }

    private void executeActionSet(Set actionStructs) throws EXNotReproducibleSnapshot, EXTransactionExecution, EXPermissionDenied, EXLockDenied {
        assert (actionStructs != null);
        for (IRepositoryActionStruct action : actionStructs) {
            this.pushActionStack(action);
            try {
                this.executeActionSet(action.getPreActions());
                this.executeAction(action);
                this.executeActionSet(action.getReActions());
            }
            finally {
                this.popActionStack();
            }
        }
    }

    private void pushActionStack(IRepositoryActionStruct actionStruct) {
        assert (actionStruct != null);
        this.currentActionStack.addLast(actionStruct);
    }

    private IRepositoryActionStruct popActionStack() {
        assert (!this.currentActionStack.isEmpty());
        return (IRepositoryActionStruct)this.currentActionStack.removeLast();
    }

    public IRepositoryActionStruct[] getChildActions(IRepositoryActionStruct action) {
        Assert.checkArgumentBeeingNotNull((Object)action);
        return this.getChildren(action);
    }

    public IRepositoryActionStruct[] getTopLevelActions() {
        return this.getChildren(null);
    }

    public boolean hasChildActions(IRepositoryActionStruct action) {
        Assert.checkArgumentBeeingNotNull((Object)action);
        return this.hasChildren(action);
    }

    public boolean hasTopLevelActions() {
        return this.hasChildren(null);
    }

    private IRepositoryActionStruct[] getChildren(IRepositoryActionStruct action) {
        List children = (List)this.childActions.get(action);
        if (children == null) {
            children = Collections.EMPTY_LIST;
        }
        return children.toArray(new IRepositoryActionStruct[children.size()]);
    }

    private boolean hasChildren(IRepositoryActionStruct action) {
        List children = (List)this.childActions.get(action);
        if (children == null) {
            return false;
        }
        return !children.isEmpty();
    }

    public IRepositoryElementaryActionFactory getElementaryActionFactory() {
        return this.manager.getElementaryActionFactory();
    }

    public void closeTransaction() {
        if (this.state == RepositoryTransactionState.OPEN) {
            this.reActionStrategy.transactionClosing();
            assert (this.state == RepositoryTransactionState.CLOSED || this.state == RepositoryTransactionState.FAILED);
        }
    }

    public RepositoryTransactionState getState() {
        return this.state;
    }

    public void undoTransaction() throws EXNotReproducibleSnapshot, EXPermissionDenied, EXLockDenied, EXTransactionExecution {
        Assert.checkState((this.state == RepositoryTransactionState.CLOSED || this.state == RepositoryTransactionState.FAILED ? 1 : 0) != 0);
        IRepositoryTransaction[] dependencies = this.manager.getSuccessorTransactions((IRepositoryTransaction)this);
        int i = dependencies.length - 1;
        while (i >= 0) {
            IRepositoryTransaction transaction = dependencies[i];
            if (transaction.getState() != RepositoryTransactionState.ROLLED_BACK && transaction.getState() != RepositoryTransactionState.FAILED) {
                transaction.undoTransaction();
            }
            --i;
        }
        this.stateTransit(RepositoryTransactionState.ROLLING_BACK);
        i = this.elementaryActions.size() - 1;
        while (i >= 0) {
            AbstractElementaryAction action = (AbstractElementaryAction)((Object)this.elementaryActions.get(i));
            if (logger.isTraceEnabled()) {
                logger.trace("Rolling back elementary action #" + i + ": " + action.getName());
            }
            try {
                assert (action.isExecuted() || action.isRolledBack() && this.state == RepositoryTransactionState.FAILED);
                if (action.isExecuted()) {
                    action.rollback((IRepositoryTransactionContext)this);
                }
            }
            catch (EXNotReproducibleSnapshot e) {
                logger.error("Undoing transaction failed at action \"" + action.getName() + "\" with index " + i + ".", (Throwable)e);
                this.stateTransit(RepositoryTransactionState.FAILED);
                throw e;
            }
            catch (EXPermissionDenied e) {
                logger.error("Undoing transaction failed at action \"" + action.getName() + "\" with index " + i + ".", (Throwable)e);
                this.stateTransit(RepositoryTransactionState.FAILED);
                throw e;
            }
            catch (EXLockDenied e) {
                logger.error("unhandled catch block", (Throwable)e);
                logger.error("Undoing transaction failed at action \"" + action.getName() + "\" with index " + i + ".", (Throwable)e);
                this.stateTransit(RepositoryTransactionState.FAILED);
                throw e;
            }
            --i;
        }
        this.stateTransit(RepositoryTransactionState.ROLLED_BACK);
        this.snapshotProxy.consistentStateReached();
        assert (this.state == RepositoryTransactionState.ROLLED_BACK || this.state == RepositoryTransactionState.FAILED);
    }

    public void redoTransaction() throws EXNotReproducibleSnapshot, EXTransactionExecution, EXPermissionDenied, EXLockDenied {
        IRepositoryTransaction[] dependencies;
        Assert.checkState((this.state == RepositoryTransactionState.ROLLED_BACK ? 1 : 0) != 0);
        IRepositoryTransaction[] iRepositoryTransactionArray = dependencies = this.manager.getPredecessorTransactions((IRepositoryTransaction)this);
        int n = dependencies.length;
        int n2 = 0;
        while (n2 < n) {
            IRepositoryTransaction transaction = iRepositoryTransactionArray[n2];
            if (transaction.getState() == RepositoryTransactionState.ROLLED_BACK) {
                transaction.redoTransaction();
            }
            ++n2;
        }
        this.stateTransit(RepositoryTransactionState.REDOING);
        int i = 0;
        while (i < this.elementaryActions.size()) {
            AbstractElementaryAction action = (AbstractElementaryAction)((Object)this.elementaryActions.get(i));
            if (logger.isTraceEnabled()) {
                logger.trace("Redoing elementary action #" + i + ": " + action.getName());
            }
            action.execute((IRepositoryTransactionContext)this);
            ++i;
        }
        this.stateTransit(RepositoryTransactionState.CLOSED);
        this.snapshotProxy.consistentStateReached();
        assert (this.state == RepositoryTransactionState.CLOSED);
    }

    public AbstractRepositoryLockSample[] getRequiredLocks() {
        ArrayList<AbstractRepositoryLockSample> locks = new ArrayList<AbstractRepositoryLockSample>();
        int i = 0;
        while (i < this.elementaryActions.size()) {
            AbstractElementaryAction action = (AbstractElementaryAction)((Object)this.elementaryActions.get(i));
            locks.addAll(Arrays.asList(action.getLocks()));
            ++i;
        }
        return locks.toArray(new AbstractRepositoryLockSample[locks.size()]);
    }

    public IRepositoryTransaction[] getPredecessorTransactions() {
        return this.manager.getPredecessorTransactions((IRepositoryTransaction)this);
    }

    public IRepositoryTransaction[] getSuccessorTransactions() {
        return this.manager.getSuccessorTransactions((IRepositoryTransaction)this);
    }

    @Override
    public void addListener(IRepositoryTransactionStateChangeListener listener) {
        Assert.checkArgumentBeeingNotNull((Object)listener);
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    @Override
    public void removeListener(IRepositoryTransactionStateChangeListener listener) {
        assert (listener != null);
        this.listeners.remove(listener);
    }

    private void notifyListeners() {
        for (IRepositoryTransactionStateChangeListener l : this.listeners) {
            try {
                l.stateChanged((IRepositoryTransaction)this);
            }
            catch (RuntimeException e) {
                logger.warn((Throwable)e);
            }
        }
    }

    private void stateTransit(RepositoryTransactionState newState) {
        assert (newState != null);
        RepositoryTransactionState oldState = this.state;
        this.state = this.state.transit(newState);
        if (oldState != this.state) {
            this.notifyListeners();
        }
    }

    @Override
    public IRepositoryTransactionAdmin cloneTransaction(IRepositorySnapshotRW snapshot) {
        Assert.checkState((this.state == RepositoryTransactionState.OPEN || this.state == RepositoryTransactionState.CLOSED || this.state == RepositoryTransactionState.FAILED || this.state == RepositoryTransactionState.ROLLED_BACK ? 1 : 0) != 0);
        RepositoryTPTransaction clone = new RepositoryTPTransaction(this.manager, snapshot, this.transactionExecutionWrapper);
        List topLevelActions = (List)this.childActions.get(null);
        List clonedActions = (List)clone.childActions.get(null);
        for (IRepositoryActionStruct actionStruct : topLevelActions) {
            try {
                clonedActions.add(clone.createActionStruct((AbstractRepositoryAction)actionStruct.getAction().clone(), null));
            }
            catch (CloneNotSupportedException e) {
                logger.error("Action not clonable (\"" + actionStruct.getAction().getName() + "\")", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        clone.toBeExecuted = true;
        clone.toBeClosed = this.state != RepositoryTransactionState.OPEN;
        return clone;
    }

    public RepositoryMergeState getMergeState() {
        return this.mergeState;
    }

    public RepositoryMergeState getPredecessorMergeState() {
        return this.predecessorMergeState;
    }

    @Override
    public void setMergeState(RepositoryMergeState newState) {
        Assert.checkArgumentBeeingNotNull((Object)newState);
        this.mergeState = newState;
    }

    @Override
    public void setPredecessorMergeState(RepositoryMergeState newState) {
        Assert.checkArgumentBeeingNotNull((Object)newState);
        this.predecessorMergeState = newState;
    }

    private static interface ReActionExecutionStrategy {
        public void actionToBeExecuted(IRepositoryActionStruct var1);

        public void cleanUp();

        public void cleanUp(IRepositoryActionStruct var1);

        public void actionExecuted(IRepositoryActionStruct var1) throws EXNotReproducibleSnapshot, EXTransactionExecution, EXPermissionDenied, EXLockDenied;

        public void transactionClosing();
    }

    private class RepositorySnapshotProxy
    implements IRepositorySnapshotRW {
        private final IRepositorySnapshotRW repositorySnapshot;

        public RepositorySnapshotProxy(IRepositorySnapshotRW snapshot) {
            Assert.checkArgumentBeeingNotNull((Object)snapshot);
            this.repositorySnapshot = snapshot;
        }

        private void checkOperationContext() {
            assert (RepositoryTPTransaction.this.state.isExecutionState());
            if (RepositoryTPTransaction.this.state == RepositoryTransactionState.EXECUTING) {
                IRepositoryActionStruct action = (IRepositoryActionStruct)RepositoryTPTransaction.this.currentActionStack.getLast();
                assert (action != null);
                Assert.checkObjectArgumentToBeInstanceOf((Object)action.getAction(), AbstractElementaryAction.class);
            }
        }

        public IRepositoryObject createObject(IRepositoryObject parentObject, IRepositoryObjectSample objectToCreate) throws EXNotReproducibleSnapshot, EXPermissionDenied, EXLockDenied {
            this.checkOperationContext();
            return this.repositorySnapshot.createObject(parentObject, objectToCreate);
        }

        public void modifyObjectTypeCategory(IRepositoryObject objectToModify, IRepositoryObjectTypeCategoryID newCategoryID) throws EXNotReproducibleSnapshot, EXPermissionDenied, EXLockDenied {
            this.checkOperationContext();
            this.repositorySnapshot.modifyObjectTypeCategory(objectToModify, newCategoryID);
        }

        public void modifyAttributeSet(IRepositoryAttributeSet attributeSetToModify, IRepositoryPropertySetSample newAttributeSetValue) throws EXNotReproducibleSnapshot, EXPermissionDenied, EXLockDenied {
            this.checkOperationContext();
            this.repositorySnapshot.modifyAttributeSet(attributeSetToModify, newAttributeSetValue);
        }

        public void deleteObject(IRepositoryObject objectToDelete) throws EXNotReproducibleSnapshot, EXPermissionDenied, EXLockDenied {
            this.checkOperationContext();
            this.repositorySnapshot.deleteObject(objectToDelete);
        }

        public void moveObject(IRepositoryObject objectToMove, IRepositoryObject newParentObject) throws EXNotReproducibleSnapshot, EXPermissionDenied, EXLockDenied {
            this.checkOperationContext();
            this.repositorySnapshot.moveObject(objectToMove, newParentObject);
        }

        public void createRelation(ICrossLinkRepositoryRelationSample relationSample) throws EXNotReproducibleSnapshot, EXPermissionDenied, EXLockDenied {
            this.checkOperationContext();
            this.repositorySnapshot.createRelation(relationSample);
        }

        public void deleteRelation(ICrossLinkRepositoryRelation relation) throws EXNotReproducibleSnapshot, EXPermissionDenied, EXLockDenied {
            this.checkOperationContext();
            this.repositorySnapshot.deleteRelation(relation);
        }

        public IRepositoryInterfaceRO getRepositoryInterface() {
            return this.repositorySnapshot.getRepositoryInterface();
        }

        public IRepositoryObject getRepositoryRootObject() throws EXNotReproducibleSnapshot {
            return this.repositorySnapshot.getRepositoryRootObject();
        }

        public IList_<IRepositoryObjectTypeCategory> getAllObjectTypeCategoriesForObjectType(IRepositoryObjectType repObjectType) {
            return this.repositorySnapshot.getAllObjectTypeCategoriesForObjectType(repObjectType);
        }

        public IRepositoryObjectTypeCategory getObjectTypeCategory(IRepositoryObjectTypeCategoryID repObjectTypeCategoryID) {
            return this.repositorySnapshot.getObjectTypeCategory(repObjectTypeCategoryID);
        }

        public void closeSnapshot() {
            Assert.unsupportedOperation((String)"Call IRepositoryTransaction.closeTransaction() instead.");
        }

        public IRepositoryObject findRepositoryObject(IRepositoryObjectType objectType, IRepositoryPropertySetSample objectID) throws EXNotReproducibleSnapshot {
            return this.repositorySnapshot.findRepositoryObject(objectType, objectID);
        }

        public IRepositoryIterator_IRepositoryObject findAllObjectOfType(IRepositoryObjectType repObjectType) throws EXNotReproducibleSnapshot {
            return this.repositorySnapshot.findAllObjectOfType(repObjectType);
        }

        public IRepositoryObject findObjectByIDProperty(IRepositoryPropertyType idPropertyType, IRepositoryData propertyValue) throws EXNotReproducibleSnapshot {
            return this.repositorySnapshot.findObjectByIDProperty(idPropertyType, propertyValue);
        }

        public IRepositoryObject findObjectByNameProperty(IRepositoryPropertyType namePropertyType, IRepositoryData propertyValue, IRepositoryObject parentObject) throws EXNotReproducibleSnapshot {
            return this.repositorySnapshot.findObjectByNameProperty(namePropertyType, propertyValue, parentObject);
        }

        public IRepositoryIterator_ICrossLinkRepositoryRelation findCrossLinkRelations(ICrossLinkRepositoryRelationType relationType, IMap_<IRepositoryRelationContributionRoleID, IRepositoryPropertySetSample> roleID2ObjectID) throws EXNotReproducibleSnapshot, EXMissingCrossLinkTarget {
            return this.repositorySnapshot.findCrossLinkRelations(relationType, roleID2ObjectID);
        }

        public IRepositoryObjectSample getSnapshotInformation() {
            return this.repositorySnapshot.getSnapshotInformation();
        }

        public IRepositoryTypeManagerRO getTypeManager() {
            return this.repositorySnapshot.getTypeManager();
        }

        public void consistentStateReached() {
            Assert.checkState((boolean)RepositoryTPTransaction.this.currentActionStack.isEmpty());
            this.repositorySnapshot.consistentStateReached();
        }

        public IRepositoryWorkspaceRW getRepositoryWorkspace() {
            return this.repositorySnapshot.getRepositoryWorkspace();
        }

        public boolean isOpen() {
            return this.repositorySnapshot.isOpen();
        }

        public ListenerManager<IRepositorySnapshotListener> getListenerManager() {
            return this.repositorySnapshot.getListenerManager();
        }

        public IOccurrenceRepositoryRelation findOccurrenceRelation(IOccurrenceRepositoryRelationType relationType, IRepositoryPropertySetSample occurenceContainingObjectID, String occurenceID) throws EXNotReproducibleSnapshot {
            return this.repositorySnapshot.findOccurrenceRelation(relationType, occurenceContainingObjectID, occurenceID);
        }

        public void modifyOccurrences(OccurrenceRelationContribution occRelationContribution, ICollection_<IOccurrenceRepositoryRelationReference> occurenceRelationsToDelete, ICollection_<IOccurrenceRepositoryRelationSample> occurenceRelationsToCreate) throws EXLockDenied, EXPermissionDenied, EXNotReproducibleSnapshot {
            this.checkOperationContext();
            this.repositorySnapshot.modifyOccurrences(occRelationContribution, occurenceRelationsToDelete, occurenceRelationsToCreate);
        }
    }

    private class SimpleReActionStrategy
    implements ReActionExecutionStrategy {
        private SimpleReActionStrategy() {
        }

        @Override
        public void actionToBeExecuted(IRepositoryActionStruct action) {
        }

        @Override
        public void actionExecuted(IRepositoryActionStruct action) throws EXNotReproducibleSnapshot, EXTransactionExecution, EXPermissionDenied, EXLockDenied {
            assert (action != null);
            RepositoryTPTransaction.this.executeActionSet(action.getReActions());
        }

        @Override
        public void cleanUp() {
        }

        @Override
        public void cleanUp(IRepositoryActionStruct action) {
        }

        @Override
        public void transactionClosing() {
            RepositoryTPTransaction.this.stateTransit(RepositoryTransactionState.CLOSED);
        }
    }
}

