/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planview.cm.view;

import com.arcway.lib.geometry.Dimension;
import com.arcway.lib.geometry.Rectangle;
import com.arcway.lib.graphics.EXNoMoreHandles;
import com.arcway.lib.graphics.device.Device;
import com.arcway.lib.graphics.image.EXCorruptImageFileContent;
import com.arcway.lib.graphics.image.EXImageDataTypeNotSupported;
import com.arcway.lib.graphics.image.EXImageTooBig;
import com.arcway.lib.graphics.image.EXUnspecifiedImageLoadingError;
import com.arcway.lib.graphics.image.EXUnsupportedColorDepth;
import com.arcway.lib.graphics.image.IImageProcessor;
import com.arcway.lib.graphics.image.IImageProxy;
import com.arcway.lib.graphics.image.IOffscreenBitmap;
import com.arcway.lib.graphics.image.Image;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.resource.JvmExternalResourceInteractionException;
import com.arcway.planagent.planview.view.PVGraphicalSupplement;

public class PVGraphicalSupplementImage
extends PVGraphicalSupplement {
    private static final ILogger LOGGER = Logger.getLogger(PVGraphicalSupplementImage.class);
    private IImageProxy imageProxy;
    private int alpha = 255;

    public void setImage(IImageProxy image) {
        this.imageProxy = image;
    }

    public void setAlpha(int alpha) {
        this.alpha = alpha;
    }

    public void drawFigure(final Device device) {
        final Rectangle bounds = this.getPoints().getBounds();
        assert (bounds != null) : "bounds is NULL.";
        this.drawGhostOutline(device);
        try {
            this.imageProxy.getImage(new IImageProcessor(){

                public void run(Image image) {
                    IOffscreenBitmap offscreenBitmap = image.getOffscreenBitmap();
                    double ratioPicture = (double)image.getWidthInPixels() / (double)image.getHeightInPixels();
                    double ratioBounds = bounds.w() / bounds.h();
                    Rectangle newBounds = bounds;
                    if (ratioPicture > ratioBounds) {
                        newBounds = new Rectangle(bounds.upperLeft.x, bounds.upperLeft.y, new Dimension(bounds.w(), bounds.w() / ratioPicture));
                    } else if (ratioPicture < ratioBounds) {
                        newBounds = new Rectangle(bounds.upperLeft.x, bounds.upperLeft.y, new Dimension(bounds.h() * ratioPicture, bounds.h()));
                    }
                    device.image(offscreenBitmap, newBounds, PVGraphicalSupplementImage.this.alpha);
                }
            });
        }
        catch (EXUnsupportedColorDepth e) {
            LOGGER.error("cannot draw image", (Throwable)e);
        }
        catch (EXNoMoreHandles e) {
            LOGGER.error("cannot draw image", (Throwable)e);
        }
        catch (EXImageTooBig e) {
            LOGGER.error("cannot draw image", (Throwable)e);
        }
        catch (EXImageDataTypeNotSupported e) {
            LOGGER.error("cannot draw image", (Throwable)e);
        }
        catch (EXCorruptImageFileContent e) {
            LOGGER.error("cannot draw image", (Throwable)e);
        }
        catch (JvmExternalResourceInteractionException e) {
            LOGGER.error("cannot draw image", (Throwable)e);
        }
        catch (EXUnspecifiedImageLoadingError e) {
            LOGGER.error("cannot draw image", (Throwable)e);
        }
    }
}

