/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.transactions;

import com.arcway.lib.geometry.GeoVector;
import com.arcway.planagent.planmodel.access.readwrite.IPMGraphicalSupplementRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPlanModelObjectRW;
import com.arcway.planagent.planmodel.actions.ACMoveGraphicalSupplements;
import com.arcway.planagent.planmodel.actions.ActionIterator;
import com.arcway.planagent.planmodel.actions.ActionParameters;
import com.arcway.planagent.planmodel.actions.PredeterminedActionIterator;
import com.arcway.planagent.planmodel.transactions.Transaction;
import java.util.Collection;
import java.util.List;

public class TAMoveGraphicalSupplements
extends Transaction {
    private final List supplements;
    private final GeoVector distance;

    private static IPMGraphicalSupplementRW getFirstSupplement(List l) {
        assert (l != null) : "supplement list is null";
        assert (l.size() > 0) : "supplement list is empty";
        return (IPMGraphicalSupplementRW)l.get(0);
    }

    public TAMoveGraphicalSupplements(List supplements, ActionParameters actionParameters, GeoVector distance) {
        super(TAMoveGraphicalSupplements.getFirstSupplement(supplements), actionParameters);
        assert (distance != null) : "distance object is null";
        this.supplements = supplements;
        this.distance = distance;
    }

    @Override
    public ActionIterator getActionIterator() {
        PredeterminedActionIterator actions = new PredeterminedActionIterator();
        ACMoveGraphicalSupplements moveSupplementAction = new ACMoveGraphicalSupplements(this.getActionContext(), this.supplements, this.distance);
        actions.addAction(moveSupplementAction);
        return actions;
    }

    @Override
    protected Collection<? extends IPMPlanModelObjectRW> getPrimarilyChangedPlanModelObjects() {
        return this.supplements;
    }

    public String toString() {
        return "TAMoveGraphicalSupplements (Supplement list " + this.supplements + ")";
    }
}

