/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.persistent;

import com.arcway.lib.graphics.Color;
import com.arcway.lib.graphics.linestyles.LineStyle;
import com.arcway.planagent.planmodel.appearance.IAppearanceRO;
import com.arcway.planagent.planmodel.appearance.ILineAppearance;
import com.arcway.planagent.planmodel.appearance.ILineAppearanceRO;
import com.arcway.planagent.planmodel.appearance.LineAppearance;
import de.plans.lib.xml.encoding.EAEncodableAttributes;
import de.plans.lib.xml.encoding.EXEncoderException;
import de.plans.lib.xml.encoding.EncodableObjectBase;

public final class EALineAppearance
extends EAEncodableAttributes
implements ILineAppearance {
    private static final String ATTR_TAG_LINESTYLENAME = "stylename";
    private static final String ATTR_TAG_LINETHICKNESS = "thickness";
    private static final String ATTR_TAG_LINECOLOR_RED = "color.red";
    private static final String ATTR_TAG_LINECOLOR_GREEN = "color.green";
    private static final String ATTR_TAG_LINECOLOR_BLUE = "color.blue";
    private static final String ATTR_TAG_LINECOLOR_TRANSPARENT = "color.transparent";
    private static final String ATTR_TAG_CORNERRADIUS = "cornerradius";
    private static final String ATTR_VALUE_CORNERRADIUSINFINITY = "infinity";
    private final LineStyle defaultLineStyle;
    private final String defaultLineStyleName;
    private final double defaultLineThickness;
    private final int defaultLineColorRed;
    private final int defaultLineColorGreen;
    private final int defaultLineColorBlue;
    private final boolean defaultLineColorTransparent;
    private final double defaultCornerRadius;
    private final boolean defaultCornerRadiusInfinity;
    private LineStyle lineStyle;
    private String lineStyleName;
    private double lineThickness;
    private int lineColorRed;
    private int lineColorGreen;
    private int lineColorBlue;
    private boolean lineColorTransparent;
    private double cornerRadius;
    private boolean cornerRadiusInfinity;

    public EALineAppearance(String xmlAttrTag) {
        this(xmlAttrTag, DEFAULT_LINESTYLE);
    }

    public EALineAppearance(EAEncodableAttributes ea, String xmlAttrTag) {
        this(ea, xmlAttrTag, DEFAULT_LINESTYLE);
    }

    public EALineAppearance(String xmlAttrTag, LineStyle defaultLineStyle) {
        super(xmlAttrTag);
        this.defaultLineStyle = defaultLineStyle;
        this.defaultLineStyleName = this.defaultLineStyle.getName();
        this.defaultLineThickness = 0.35277777777777775;
        this.defaultLineColorRed = 0;
        this.defaultLineColorGreen = 0;
        this.defaultLineColorBlue = 0;
        this.defaultLineColorTransparent = false;
        this.defaultCornerRadius = 0.0;
        this.defaultCornerRadiusInfinity = false;
        this.setupAttributes();
    }

    public EALineAppearance(EAEncodableAttributes ea, String xmlAttrTag, LineStyle defaultLineStyle) {
        super(ea, xmlAttrTag);
        this.defaultLineStyle = defaultLineStyle;
        this.defaultLineStyleName = this.defaultLineStyle.getName();
        this.defaultLineThickness = 0.35277777777777775;
        this.defaultLineColorRed = 0;
        this.defaultLineColorGreen = 0;
        this.defaultLineColorBlue = 0;
        this.defaultLineColorTransparent = false;
        this.defaultCornerRadius = 0.0;
        this.defaultCornerRadiusInfinity = false;
        this.setupAttributes();
    }

    private void setupAttributes() {
        this.lineStyle = this.defaultLineStyle;
        this.lineStyleName = this.defaultLineStyleName;
        this.lineThickness = this.defaultLineThickness;
        this.lineColorRed = this.defaultLineColorRed;
        this.lineColorGreen = this.defaultLineColorGreen;
        this.lineColorBlue = this.defaultLineColorBlue;
        this.lineColorTransparent = this.defaultLineColorTransparent;
        this.cornerRadius = this.defaultCornerRadius;
        this.cornerRadiusInfinity = this.defaultCornerRadiusInfinity;
    }

    public void appendAttributesToXML(EncodableObjectBase.WriteContext writeContext) throws EXEncoderException {
        if (this.lineStyle != null) {
            if (!this.lineStyle.equals(this.defaultLineStyle)) {
                this.appendAttrToXML(writeContext, ATTR_TAG_LINESTYLENAME, this.lineStyle.getName());
            }
        } else {
            this.appendAttrToXML(writeContext, ATTR_TAG_LINESTYLENAME, this.lineStyleName);
        }
        if (Math.abs(this.lineThickness - this.defaultLineThickness) > 1.0E-10) {
            this.appendAttrToXML(writeContext, ATTR_TAG_LINETHICKNESS, this.lineThickness);
        }
        if (this.lineColorTransparent != this.defaultLineColorTransparent) {
            this.appendAttrToXML(writeContext, ATTR_TAG_LINECOLOR_TRANSPARENT, this.lineColorTransparent);
        }
        if (!(this.lineColorRed == this.defaultLineColorRed && this.lineColorGreen == this.defaultLineColorGreen && this.lineColorBlue == this.defaultLineColorBlue || this.lineColorTransparent)) {
            this.appendAttrToXML(writeContext, ATTR_TAG_LINECOLOR_RED, this.lineColorRed);
            this.appendAttrToXML(writeContext, ATTR_TAG_LINECOLOR_GREEN, this.lineColorGreen);
            this.appendAttrToXML(writeContext, ATTR_TAG_LINECOLOR_BLUE, this.lineColorBlue);
        }
        if (this.cornerRadiusInfinity) {
            this.appendAttrToXML(writeContext, ATTR_TAG_CORNERRADIUS, ATTR_VALUE_CORNERRADIUSINFINITY);
        } else if (Math.abs(this.cornerRadius - this.defaultCornerRadius) > 1.0E-10) {
            this.appendAttrToXML(writeContext, ATTR_TAG_CORNERRADIUS, this.cornerRadius);
        }
    }

    protected boolean setSubAttributeFromXML(String name, String value) {
        boolean knownAttribute = true;
        if (name.equals(ATTR_TAG_LINESTYLENAME)) {
            LineStyle style = LineStyle.lineStyleDefaultGetByName((String)value);
            if (style != null) {
                this.lineStyle = style;
                this.lineStyleName = style.getName();
            } else {
                this.lineStyle = this.defaultLineStyle;
                this.lineStyleName = value;
            }
        } else if (name.equals(ATTR_TAG_LINETHICKNESS)) {
            this.lineThickness = this.toDouble(value);
        } else if (name.equals(ATTR_TAG_LINECOLOR_RED)) {
            this.lineColorRed = this.toInt(value);
        } else if (name.equals(ATTR_TAG_LINECOLOR_GREEN)) {
            this.lineColorGreen = this.toInt(value);
        } else if (name.equals(ATTR_TAG_LINECOLOR_BLUE)) {
            this.lineColorBlue = this.toInt(value);
        } else if (name.equals(ATTR_TAG_LINECOLOR_TRANSPARENT)) {
            this.lineColorTransparent = this.toBoolean(value);
        } else if (name.equals(ATTR_TAG_CORNERRADIUS)) {
            if (ATTR_VALUE_CORNERRADIUSINFINITY.equals(value)) {
                this.cornerRadiusInfinity = true;
            } else {
                this.cornerRadiusInfinity = false;
                this.cornerRadius = this.toDouble(value);
            }
        } else {
            knownAttribute = false;
        }
        return knownAttribute;
    }

    @Override
    public double getLineThickness() {
        return this.lineThickness;
    }

    @Override
    public Color getLineColor() {
        if (this.lineColorTransparent) {
            return new Color(Color.TRANSPARENT);
        }
        return new Color(this.lineColorRed, this.lineColorGreen, this.lineColorBlue);
    }

    @Override
    public double getCornerRadius() {
        return this.cornerRadius;
    }

    @Override
    public boolean getCornerRadiusInfinity() {
        return this.cornerRadiusInfinity;
    }

    @Override
    public void setLineThickness(double lineThickness) {
        assert (lineThickness > -1.0E-10) : "lineThickness < 0";
        this.lineThickness = lineThickness;
    }

    @Override
    public void setLineColor(Color lineColor) {
        assert (lineColor != null) : "lineColor is null";
        this.lineColorRed = lineColor.r;
        this.lineColorGreen = lineColor.g;
        this.lineColorBlue = lineColor.b;
        this.lineColorTransparent = lineColor.transparent;
    }

    @Override
    public void setCornerRadius(double cornerRadius) {
        assert (cornerRadius > -1.0E-10) : "cornerRadius < 0";
        this.cornerRadiusInfinity = false;
        this.cornerRadius = cornerRadius;
    }

    @Override
    public void setCornerRadiusInfinity() {
        this.cornerRadiusInfinity = true;
    }

    @Override
    public void setLineStyle(LineStyle lineStyle) {
        assert (lineStyle != null) : "lineStyle is null";
        this.lineStyle = lineStyle;
    }

    @Override
    public LineStyle getLineStyle() {
        return this.lineStyle;
    }

    @Override
    public void setAppearanceFrom(IAppearanceRO appearance) {
        if (!(appearance instanceof ILineAppearanceRO)) {
            return;
        }
        ILineAppearanceRO line = (ILineAppearanceRO)appearance;
        this.setCornerRadius(line.getCornerRadius());
        if (line.getCornerRadiusInfinity()) {
            this.setCornerRadiusInfinity();
        }
        this.setLineColor(line.getLineColor());
        this.setLineStyle(line.getLineStyle());
        this.setLineThickness(line.getLineThickness());
    }

    @Override
    public IAppearanceRO getAppearanceAsCopy() {
        return new LineAppearance(this);
    }
}

