/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.implementation;

import com.arcway.lib.geometry.Rectangle;
import com.arcway.planagent.controllinginterface.planagent.IPlanAgentStructuredPlanElement;
import com.arcway.planagent.planmodel.access.readonly.IModelChangeMgrRO;
import com.arcway.planagent.planmodel.access.readonly.IModelChangeRootMgrRO;
import com.arcway.planagent.planmodel.access.readonly.IPMAnchoringPointRO;
import com.arcway.planagent.planmodel.access.readonly.IPMFigureLineShapeRO;
import com.arcway.planagent.planmodel.access.readonly.IPMPlanElementRO;
import com.arcway.planagent.planmodel.access.readonly.IPMPlanRO;
import com.arcway.planagent.planmodel.access.readonly.IPMPointListRO;
import com.arcway.planagent.planmodel.access.readonly.IPMPointRO;
import com.arcway.planagent.planmodel.access.readwrite.IModelChangeMgrRW;
import com.arcway.planagent.planmodel.access.readwrite.IModelChangeRootMgrRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPlanElementRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPlanModelObjectFactoryRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPlanRW;
import com.arcway.planagent.planmodel.access.readwrite.IPlanModelMgrRW;
import com.arcway.planagent.planmodel.anchoring.AnchoringAgent;
import com.arcway.planagent.planmodel.anchoring.AnchoringDecision;
import com.arcway.planagent.planmodel.anchoring.AnchoringProposal;
import com.arcway.planagent.planmodel.anchoring.IAnchoringDestination;
import com.arcway.planagent.planmodel.anchoring.IAnchoringDestinationContributor;
import com.arcway.planagent.planmodel.anchoring.IAnchoringDestinationPoint;
import com.arcway.planagent.planmodel.anchoring.IAnchoringManager;
import com.arcway.planagent.planmodel.anchoring.IAnchoringSource;
import com.arcway.planagent.planmodel.anchoring.IAnchoringSourceContributor;
import com.arcway.planagent.planmodel.appearance.ILineAppearanceRO;
import com.arcway.planagent.planmodel.appearance.ILineEndMarkerAppearanceRO;
import com.arcway.planagent.planmodel.appearance.ILineStartMarkerAppearanceRO;
import com.arcway.planagent.planmodel.implementation.EXPlanModelObjectFactoryException;
import com.arcway.planagent.planmodel.implementation.IPMSemanticalUnit;
import com.arcway.planagent.planmodel.implementation.LoadPlanModelObjectList;
import com.arcway.planagent.planmodel.implementation.ModelChangeMgr;
import com.arcway.planagent.planmodel.implementation.ModelChangeRootMgr;
import com.arcway.planagent.planmodel.implementation.PMPlanElement;
import com.arcway.planagent.planmodel.implementation.PMPlanModelObject;
import com.arcway.planagent.planmodel.implementation.PMPlans;
import com.arcway.planagent.planmodel.implementation.PMViewable;
import com.arcway.planagent.planmodel.implementation.PlanFactoryDispatcher;
import com.arcway.planagent.planmodel.implementation.PlanModelMgr;
import com.arcway.planagent.planmodel.implementation.PlanModelObjectFactoryDispatcher;
import com.arcway.planagent.planmodel.implementation.PlanModelObjectVisitor;
import com.arcway.planagent.planmodel.implementation.StructuredPlanElementModelWrapper;
import com.arcway.planagent.planmodel.nesting.INestable;
import com.arcway.planagent.planmodel.nesting.INestingManager;
import com.arcway.planagent.planmodel.nesting.NestingAgent;
import com.arcway.planagent.planmodel.nonpermanent.PMLegend;
import com.arcway.planagent.planmodel.nonpermanent.PMProjection;
import com.arcway.planagent.planmodel.persistent.EOPlan;
import com.arcway.planagent.planmodel.persistent.EOPlanModelObject;
import com.arcway.planagent.planmodel.persistent.EXPlanCreationException;
import com.arcway.planagent.planmodel.relations.PlanElementRelation;
import com.arcway.planagent.planmodel.routing.IRoutingManager;
import com.arcway.planagent.planmodel.routing.RoutingAgent;
import de.plans.lib.eclipse.PlugInClassExtensionFactoryException;
import de.plans.lib.xml.encoding.EOEncodableObject;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;

public abstract class PMPlan
extends PMViewable
implements IPMSemanticalUnit,
IPlanModelMgrRW,
IPMPlanRO,
IPMPlanRW,
IAnchoringManager {
    private final AnchoringAgent anchoringAgent = new AnchoringAgent(this);
    private final RoutingAgent routingAgent = new RoutingAgent(this.getRoutingManager());
    private final NestingAgent nestingAgent = new NestingAgent(this.getNestingManager());
    private final ModelChangeMgr modelChangeMgr = new ModelChangeMgr();
    private final ModelChangeRootMgr modelChangeRootMgr = new ModelChangeRootMgr();
    private final List<PMProjection> projections = new ArrayList<PMProjection>();
    private final List<PMLegend> legends = new ArrayList<PMLegend>();
    private final ArrayList<PMPlanElement> planElements_sorted = new ArrayList();
    private final Map<String, PMPlanElement> planElements_byUID = new HashMap<String, PMPlanElement>();
    private final EOPlan persistent;

    protected static void setupClass() {
        PlanModelObjectFactoryDispatcher.registerFactory(EOPlan.class, new PlanFactory());
    }

    protected PMPlan(PlanModelMgr planModelMgr, EOPlan eo) {
        super(planModelMgr);
        assert (eo != null);
        this.persistent = eo;
    }

    protected EOPlan getPersistentPlan() {
        return this.persistent;
    }

    @Override
    protected EOPlanModelObject getPersistentPlanModelObject() {
        return this.getPersistentPlan();
    }

    @Override
    protected void linkToParent(PMPlanModelObject parent) {
    }

    @Override
    protected void linkToChild(PMPlanModelObject child) {
        if (child instanceof PMPlanElement) {
            this.addPlanElement_internal(this.getPlanElementCount(), (PMPlanElement)child);
        }
    }

    private void addPlanElement_internal(int index, PMPlanElement newPlanElement) {
        String planElementUID = newPlanElement.getUid();
        PMPlanElement existingPlanElement = this.planElements_byUID.put(planElementUID, newPlanElement);
        if (existingPlanElement != null) {
            this.planElements_byUID.put(planElementUID, existingPlanElement);
            throw new IllegalArgumentException("Plan Element with UID " + planElementUID + " already exists.");
        }
        this.planElements_sorted.add(index, newPlanElement);
    }

    private void removePlanElement_internal(int index) {
        PMPlanElement removedPlanElement_list = this.planElements_sorted.remove(index);
        PMPlanElement removedPlanElement_map = this.planElements_byUID.remove(removedPlanElement_list.getUid());
        assert (removedPlanElement_list == removedPlanElement_map);
    }

    void planElementUIDChanged(String oldUID, String newUID) {
        PMPlanElement planElement = this.planElements_byUID.remove(oldUID);
        assert (planElement != null);
        if (planElement != null) {
            this.planElements_byUID.put(newUID, planElement);
        }
    }

    @Override
    protected void linkCrossLinks(PMPlanModelObject root, LoadPlanModelObjectList objectList) {
    }

    @Override
    protected List<PMPlanModelObject> getChildren() {
        ArrayList<PMPlanModelObject> children = new ArrayList<PMPlanModelObject>(this.getPlanElementCount());
        int i = 0;
        while (i < this.getPlanElementCount()) {
            children.add(this.getPlanElement(i));
            ++i;
        }
        return children;
    }

    protected List<PMPlanElement> getPlanElements() {
        return this.planElements_sorted;
    }

    @Override
    public int getPlanElementCount() {
        return this.planElements_sorted.size();
    }

    public int getPlanElementIndex(PMPlanElement planElement) {
        return this.getPlanElementIndex((Object)planElement);
    }

    @Override
    public int getPlanElementIndex(IPMPlanElementRO planElement) {
        return this.getPlanElementIndex((Object)planElement);
    }

    @Override
    public int getPlanElementIndex(IPMPlanElementRW planElement) {
        return this.getPlanElementIndex((Object)planElement);
    }

    private int getPlanElementIndex(Object planElement) {
        assert (planElement != null);
        assert (planElement instanceof PMPlanElement);
        return this.planElements_sorted.indexOf(planElement);
    }

    public PMPlanElement getPlanElement(int index) {
        assert (index >= 0);
        assert (index < this.getPlanElementCount());
        return this.planElements_sorted.get(index);
    }

    @Override
    public IPMPlanElementRO getPlanElementRO(int index) {
        return this.getPlanElement(index);
    }

    @Override
    public IPMPlanElementRW getPlanElementRW(int index) {
        return this.getPlanElement(index);
    }

    public PMPlanElement getPlanElement(String uid) {
        return this.planElements_byUID.get(uid);
    }

    @Override
    public IPMPlanElementRO getPlanElementRO(String uid) {
        return this.getPlanElement(uid);
    }

    @Override
    public IPMPlanElementRW getPlanElementRW(String uid) {
        return this.getPlanElement(uid);
    }

    public Set getAllContainers(Collection elements) {
        HashSet<INestable> nestingElements = new HashSet<INestable>();
        nestingElements.addAll(this.nestingAgent.getAllNestingElements(elements));
        return nestingElements;
    }

    public Set getAllContained(Collection elements) {
        HashSet<INestable> nestedElements = new HashSet<INestable>();
        nestedElements.addAll(this.nestingAgent.getAllNestedElements(elements));
        return nestedElements;
    }

    public void addPlanElement(PMPlanElement planElement, int i) {
        this.addPlanElement((Object)planElement, i);
    }

    @Override
    public void addPlanElement(IPMPlanElementRW planElement, int i) {
        this.addPlanElement((Object)planElement, i);
    }

    private void addPlanElement(Object planElement, int i) {
        assert (planElement != null);
        assert (planElement instanceof PMPlanElement);
        assert (i >= 0);
        assert (i <= this.getPlanElementCount());
        PMPlanElement pMPlanElement = (PMPlanElement)planElement;
        this.addPlanElement_internal(i, pMPlanElement);
        this.getPersistentPlan().addPlanElement(pMPlanElement.getPersistentPlanElement(), i);
        this.flushGeometryCaches();
    }

    @Override
    public void removePlanElement(int i) {
        assert (i >= 0);
        assert (i < this.getPlanElementCount());
        this.removePlanElement_internal(i);
        this.getPersistentPlan().removePlanElement(i);
        this.flushGeometryCaches();
    }

    @Override
    public Collection<PMProjection> getProjections() {
        return this.projections;
    }

    @Override
    public List<PMLegend> getLegends() {
        return this.legends;
    }

    @Override
    public PMPlan getPlan() {
        return this;
    }

    @Override
    public Collection<PMViewable> getChildViewables() {
        ArrayList<PMViewable> viewables = new ArrayList<PMViewable>(this.planElements_sorted.size() + this.projections.size());
        viewables.addAll(this.planElements_sorted);
        viewables.addAll(this.projections);
        return viewables;
    }

    @Override
    public PMViewable getParentViewable() {
        return null;
    }

    protected PMPlan(PlanModelMgr planModelMgr) {
        super(planModelMgr);
        this.persistent = new EOPlan();
    }

    protected void removeLinks() {
        while (this.getPlanElementCount() > 0) {
            this.removePlanElement(0);
        }
    }

    @Override
    public String getUid() {
        return this.getPersistentPlan().getUid();
    }

    @Override
    public String getType() {
        return this.getPersistentPlan().getType();
    }

    protected void setType(String type) {
        this.getPersistentPlan().setType(type);
    }

    @Override
    public String getName() {
        return this.getPersistentPlan().getName();
    }

    @Override
    public void setName(String name) {
        this.getPersistentPlan().setName(name);
    }

    @Override
    public int getFormat() {
        return this.getPersistentPlan().getFormat();
    }

    @Override
    public void setFormat(int format) {
        this.getPersistentPlan().setFormat(format);
    }

    @Override
    public void setProjections(Collection<PMProjection> projections) {
        this.projections.clear();
        if (projections != null) {
            this.projections.addAll(projections);
            Collections.sort(this.projections, new Comparator(){

                public int compare(Object o1, Object o2) {
                    PMProjection p1 = (PMProjection)o1;
                    PMProjection p2 = (PMProjection)o2;
                    int i1 = PMPlan.this.getPlanElementIndex(p1.getPMPlanElement());
                    int i2 = PMPlan.this.getPlanElementIndex(p2.getPMPlanElement());
                    return i1 - i2;
                }
            });
        }
    }

    @Override
    public void setLegends(List<PMLegend> legends) {
        this.legends.clear();
        if (legends != null) {
            this.legends.addAll(legends);
        }
    }

    @Override
    public IPMSemanticalUnit getSemanticalUnit() {
        return this;
    }

    @Override
    public IPMPlanModelObjectFactoryRW getPlanModelObjectFactoryRW() {
        return this.getPlanModelMgr();
    }

    public ModelChangeRootMgr getModelChangeRootMgr() {
        return this.modelChangeRootMgr;
    }

    @Override
    public IModelChangeRootMgrRO getModelChangeRootMgrRO() {
        return this.getModelChangeRootMgr();
    }

    @Override
    public IModelChangeRootMgrRW getModelChangeRootMgrRW() {
        return this.getModelChangeRootMgr();
    }

    public ModelChangeMgr getModelChangeAgent() {
        return this.modelChangeMgr;
    }

    @Override
    public IModelChangeMgrRO getModelChangeMgrRO() {
        return this.getModelChangeAgent();
    }

    @Override
    public IModelChangeMgrRW getModelChangeMgrRW() {
        return this.getModelChangeAgent();
    }

    public abstract IRoutingManager getRoutingManager();

    public abstract INestingManager getNestingManager();

    @Override
    public List<? extends IAnchoringSourceContributor> getAnchoringSourceContributors() {
        return this.getPlanElements();
    }

    @Override
    public List<? extends IAnchoringDestinationContributor> getAnchoringDestinationContributors() {
        return this.getPlanElements();
    }

    public List<PMPlanElement> getNestableObjects() {
        return this.getPlanElements();
    }

    @Override
    public AnchoringAgent getAnchoringAgent() {
        return this.anchoringAgent;
    }

    @Override
    public RoutingAgent getRoutingAgent() {
        return this.routingAgent;
    }

    @Override
    public NestingAgent getNestingAgent() {
        return this.nestingAgent;
    }

    public PMPlan getCopy(Collection<?> elements, Map<String, String> uidMap) throws EXPlanCreationException {
        PMPlan planCopy = this.getCut(elements);
        uidMap.putAll(planCopy.generateNewUIDs());
        return planCopy;
    }

    @Override
    public IPMPlanRW getCopyRW(Collection<IPMPlanElementRW> elements, Map<String, String> uidMap) throws EXPlanCreationException {
        return this.getCopy(elements, uidMap);
    }

    public PMPlan getCut(Collection<?> elements) throws EXPlanCreationException {
        PlanModelMgr newPlanModelMgr = new PlanModelMgr();
        newPlanModelMgr.copy(this, elements);
        return newPlanModelMgr.getPlan();
    }

    @Override
    public IPMPlanRW getCutRW(Collection<IPMPlanElementRW> elements) throws EXPlanCreationException {
        return this.getCut(elements);
    }

    public Map<String, String> generateNewUIDs() {
        final HashMap<String, String> uidMap = new HashMap<String, String>();
        PlanModelObjectVisitor newUIDGenerator = new PlanModelObjectVisitor(){

            @Override
            protected void visit(PMPlanModelObject pm) {
                String oldUID = pm.getPersistentPlanModelObject().getUidIfAvailable();
                if (oldUID != null) {
                    String newUID = EOPlanModelObject.generateUid();
                    pm.setUID(newUID);
                    uidMap.put(pm.getUid(), oldUID);
                }
            }
        };
        newUIDGenerator.visitAllPlanModelObjects(this);
        return uidMap;
    }

    @Override
    public Rectangle getOuterBoundsWithoutChildren() {
        return null;
    }

    @Override
    public Rectangle getPointUnionWithoutChildren() {
        return null;
    }

    @Override
    public String getViewableName() {
        return this.getName();
    }

    @Override
    public String getViewableTypeID() {
        return this.getType();
    }

    @Override
    public String getViewableUID() {
        return this.getUid();
    }

    protected abstract boolean isAllowedAnchoring(IAnchoringSource var1, IAnchoringDestination var2);

    protected abstract boolean isDesirableAnchoring(IAnchoringSource var1, IAnchoringDestination var2);

    public AnchoringDecision decideAnchoring(IAnchoringSource source, Collection<AnchoringProposal> anchoringProposals) {
        AnchoringDecision decision = null;
        IAnchoringDestination chosenDestination = null;
        double distance = Double.POSITIVE_INFINITY;
        for (AnchoringProposal proposal : anchoringProposals) {
            IAnchoringDestination destination = proposal.getDestination();
            if (!this.isAllowedAnchoring(source, destination)) continue;
            boolean decisionAlreadyMade = false;
            if (this.isDesirableAnchoring(source, destination)) {
                if (chosenDestination == null || !this.isDesirableAnchoring(source, chosenDestination)) {
                    chosenDestination = destination;
                    distance = proposal.getDistance();
                    decisionAlreadyMade = true;
                }
            } else if (chosenDestination == null) {
                chosenDestination = destination;
                distance = proposal.getDistance();
                decisionAlreadyMade = true;
            } else if (this.isDesirableAnchoring(source, chosenDestination)) {
                decisionAlreadyMade = true;
            }
            if (decisionAlreadyMade || !(proposal.getDistance() < distance + 1.0E-10)) continue;
            if (proposal.getDistance() < distance - 1.0E-10) {
                chosenDestination = destination;
                distance = proposal.getDistance();
                continue;
            }
            boolean oneDestinationIsChildOfTheOtherDestination = false;
            if (chosenDestination == null) continue;
            Set<IPMPlanElementRO> allContainedOfDestination = destination.getAnchoringFigure().getPlanElementRO().getAllContainedRO();
            IPMPlanElementRO chosenDestinationPlanElement = chosenDestination.getAnchoringFigure().getPlanElementRO();
            for (IPMPlanElementRO currentChildOfDestination : allContainedOfDestination) {
                if (!currentChildOfDestination.equals(chosenDestinationPlanElement)) continue;
                oneDestinationIsChildOfTheOtherDestination = true;
                chosenDestination = destination;
                distance = proposal.getDistance();
                break;
            }
            if (!oneDestinationIsChildOfTheOtherDestination) {
                Set<IPMPlanElementRO> allContainersOfDestination = destination.getAnchoringFigure().getPlanElementRO().getAllContainersRO();
                for (IPMPlanElementRO currentParentOfDestination : allContainersOfDestination) {
                    if (!currentParentOfDestination.equals(chosenDestinationPlanElement)) continue;
                    oneDestinationIsChildOfTheOtherDestination = true;
                    break;
                }
            }
            if (oneDestinationIsChildOfTheOtherDestination || !(destination instanceof IAnchoringDestinationPoint)) continue;
            oneDestinationIsChildOfTheOtherDestination = true;
            chosenDestination = destination;
            distance = proposal.getDistance();
        }
        if (chosenDestination != null) {
            IAnchoringDestination rootDestination;
            IAnchoringSource rootSource = source.getRootSource();
            if (rootSource == null) {
                rootSource = source;
            }
            if ((rootDestination = chosenDestination.getRootDestination()) == null) {
                rootDestination = chosenDestination;
            }
            decision = new AnchoringDecision(rootSource, rootDestination);
        }
        return decision;
    }

    @Override
    public PlanElementRelation analyzePlanElementRelation(String startPlanElementType, String endPlanElementType, ILineStartMarkerAppearanceRO lineStartMarkerAppearanceRO, ILineEndMarkerAppearanceRO lineEndMarkerAppearanceRO, ILineAppearanceRO lineAppearanceRO) {
        return null;
    }

    @Override
    public List<? extends IPlanAgentStructuredPlanElement> getPlanStructure() {
        StructuredPlanElementModelWrapper wrapper;
        ArrayList<StructuredPlanElementModelWrapper> planStructure = new ArrayList<StructuredPlanElementModelWrapper>(this.getPlanElementCount());
        HashMap<IPMPlanElementRO, StructuredPlanElementModelWrapper> wrappers = new HashMap<IPMPlanElementRO, StructuredPlanElementModelWrapper>();
        int i = 0;
        while (i < this.getPlanElementCount()) {
            IPMPlanElementRO iPMPlanElementRO = this.getPlanElementRO(i);
            wrapper = new StructuredPlanElementModelWrapper(iPMPlanElementRO);
            wrappers.put(iPMPlanElementRO, wrapper);
            planStructure.add(wrapper);
            ++i;
        }
        i = 0;
        while (i < this.getPlanElementCount()) {
            IPMPlanElementRO iPMPlanElementRO = this.getPlanElementRO(i);
            wrapper = (StructuredPlanElementModelWrapper)wrappers.get(iPMPlanElementRO);
            int count = iPMPlanElementRO.getContainmentAsContainerCount();
            int j = 0;
            while (j < count) {
                IPMPlanElementRO contained = iPMPlanElementRO.getContainmentAsContainerRO(j).getContainedPlanElementRO();
                StructuredPlanElementModelWrapper containedWrapper = (StructuredPlanElementModelWrapper)wrappers.get(contained);
                wrapper.reportContainedElement(containedWrapper);
                ++j;
            }
            ++i;
        }
        Collection<? extends IPMFigureLineShapeRO> edges = PMPlans.getAllEdgeFigures(this);
        block8: for (IPMFigureLineShapeRO iPMFigureLineShapeRO : edges) {
            IPMPlanElementRO endPointPlanElementRO;
            String endPointPlanElementType;
            IPMPlanElementRO startPointPlanElementRO;
            String startPointPlanElementType;
            PlanElementRelation planElementRelation;
            IPMPointListRO pointList = iPMFigureLineShapeRO.getPointListRO();
            if (pointList.getPointCount() <= 1) continue;
            IPMPointRO startPoint = pointList.getPointRO(0);
            IPMAnchoringPointRO startPointAnchoring = startPoint.getAnchoringRO();
            IPMPointRO endPoint = pointList.getPointRO(pointList.getPointCount() - 1);
            IPMAnchoringPointRO endPointAnchoring = endPoint.getAnchoringRO();
            if (startPointAnchoring == null || endPointAnchoring == null || (planElementRelation = this.analyzePlanElementRelation(startPointPlanElementType = (startPointPlanElementRO = startPointAnchoring.getAnchoringDestination().getAnchoringFigure().getPlanElementRO()).getType(), endPointPlanElementType = (endPointPlanElementRO = endPointAnchoring.getAnchoringDestination().getAnchoringFigure().getPlanElementRO()).getType(), iPMFigureLineShapeRO.getLineStartMarkerAppearanceRO(), iPMFigureLineShapeRO.getLineEndMarkerAppearanceRO(), iPMFigureLineShapeRO.getLineAppearanceRO())) == null) continue;
            IPMPlanElementRO edgePlanElementRO = iPMFigureLineShapeRO.getPlanElementRO();
            StructuredPlanElementModelWrapper edgeWrapper = (StructuredPlanElementModelWrapper)wrappers.get(edgePlanElementRO);
            switch (planElementRelation.getType()) {
                case 0: {
                    StructuredPlanElementModelWrapper readerWrapper;
                    StructuredPlanElementModelWrapper writerWrapper;
                    if (planElementRelation.getDirection() == 0 || planElementRelation.getDirection() == 2) {
                        writerWrapper = (StructuredPlanElementModelWrapper)wrappers.get(startPointPlanElementRO);
                        readerWrapper = (StructuredPlanElementModelWrapper)wrappers.get(endPointPlanElementRO);
                        writerWrapper.reportReader(edgeWrapper);
                        edgeWrapper.reportReader(readerWrapper);
                    }
                    if (planElementRelation.getDirection() != 1 && planElementRelation.getDirection() != 2) continue block8;
                    writerWrapper = (StructuredPlanElementModelWrapper)wrappers.get(endPointPlanElementRO);
                    readerWrapper = (StructuredPlanElementModelWrapper)wrappers.get(startPointPlanElementRO);
                    writerWrapper.reportReader(edgeWrapper);
                    edgeWrapper.reportReader(readerWrapper);
                    break;
                }
                case 1: {
                    StructuredPlanElementModelWrapper successorWrapper;
                    StructuredPlanElementModelWrapper predecessorWrapper;
                    if (planElementRelation.getDirection() == 0 || planElementRelation.getDirection() == 2) {
                        predecessorWrapper = (StructuredPlanElementModelWrapper)wrappers.get(startPointPlanElementRO);
                        successorWrapper = (StructuredPlanElementModelWrapper)wrappers.get(endPointPlanElementRO);
                        predecessorWrapper.reportSuccessor(edgeWrapper);
                        edgeWrapper.reportSuccessor(successorWrapper);
                    }
                    if (planElementRelation.getDirection() != 1 && planElementRelation.getDirection() != 2) continue block8;
                    predecessorWrapper = (StructuredPlanElementModelWrapper)wrappers.get(endPointPlanElementRO);
                    successorWrapper = (StructuredPlanElementModelWrapper)wrappers.get(startPointPlanElementRO);
                    predecessorWrapper.reportSuccessor(edgeWrapper);
                    edgeWrapper.reportSuccessor(successorWrapper);
                    break;
                }
                case 2: {
                    StructuredPlanElementModelWrapper containedWrapper;
                    StructuredPlanElementModelWrapper containerWrapper;
                    if (planElementRelation.getDirection() == 0 || planElementRelation.getDirection() == 2) {
                        containerWrapper = (StructuredPlanElementModelWrapper)wrappers.get(startPointPlanElementRO);
                        containedWrapper = (StructuredPlanElementModelWrapper)wrappers.get(endPointPlanElementRO);
                        containerWrapper.reportContainedElement(edgeWrapper);
                        edgeWrapper.reportContainedElement(containedWrapper);
                    }
                    if (planElementRelation.getDirection() != 1 && planElementRelation.getDirection() != 2) continue block8;
                    containerWrapper = (StructuredPlanElementModelWrapper)wrappers.get(endPointPlanElementRO);
                    containedWrapper = (StructuredPlanElementModelWrapper)wrappers.get(startPointPlanElementRO);
                    containerWrapper.reportContainedElement(edgeWrapper);
                    edgeWrapper.reportContainedElement(containedWrapper);
                }
            }
        }
        return planStructure;
    }

    @Override
    public void activateResourceCache() {
        this.persistent.activateResourceCache();
    }

    @Override
    public void deactivateResourceCache() {
        this.persistent.deactivateResourceCache();
    }

    @Override
    public boolean isResourceCacheActive() {
        return this.persistent.isResourceCacheActive();
    }

    public void migrateAfterDeserialization() throws EXPlanCreationException {
    }

    static class PlanFactory
    extends PMPlanModelObject.PlanModelObjectFactory {
        PlanFactory() {
        }

        @Override
        public PMPlanModelObject create(PlanModelMgr planModelMgr, EncodableObjectBase eo) throws EXPlanModelObjectFactoryException {
            EOPlan eoPlan = (EOPlan)eo;
            try {
                return PlanFactoryDispatcher.getInstance().create(planModelMgr, eoPlan);
            }
            catch (CoreException e) {
                throw new EXPlanModelObjectFactoryException(e);
            }
            catch (PlugInClassExtensionFactoryException f) {
                throw new EXPlanModelObjectFactoryException(f);
            }
        }

        @Override
        public List<? extends EOEncodableObject> getChildren(EncodableObjectBase eo) {
            EOPlan eoPlan = (EOPlan)eo;
            List<? extends EOEncodableObject> children = super.getChildren(eo);
            int childIndex = 0;
            while (childIndex < eoPlan.getPlanElementCount()) {
                children.add((EOEncodableObject)eoPlan.getPlanElement(childIndex));
                ++childIndex;
            }
            return children;
        }
    }
}

