/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.implementation;

import com.arcway.planagent.planmodel.access.readonly.IPMAnchoringPointToFigureRO;
import com.arcway.planagent.planmodel.access.readonly.IPMFigureRO;
import com.arcway.planagent.planmodel.access.readwrite.IPMAnchoringPointToFigureRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMFigureRW;
import com.arcway.planagent.planmodel.anchoring.IAnchoringDestination;
import com.arcway.planagent.planmodel.anchoring.IAnchoringDestinationFigure;
import com.arcway.planagent.planmodel.implementation.EXPlanModelObjectCrosslinkException;
import com.arcway.planagent.planmodel.implementation.LoadPlanModelObjectLinker;
import com.arcway.planagent.planmodel.implementation.LoadPlanModelObjectList;
import com.arcway.planagent.planmodel.implementation.PMAnchoringPoint;
import com.arcway.planagent.planmodel.implementation.PMFigure;
import com.arcway.planagent.planmodel.implementation.PMPlanModelObject;
import com.arcway.planagent.planmodel.implementation.PMPoint;
import com.arcway.planagent.planmodel.implementation.PlanModelMgr;
import com.arcway.planagent.planmodel.implementation.PlanModelObjectFactoryDispatcher;
import com.arcway.planagent.planmodel.persistent.EOAnchoringPoint;
import com.arcway.planagent.planmodel.persistent.EOAnchoringPointToFigure;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import java.util.List;

public class PMAnchoringPointToFigure
extends PMAnchoringPoint
implements IPMAnchoringPointToFigureRO,
IPMAnchoringPointToFigureRW {
    private PMFigure figure = null;
    private final EOAnchoringPointToFigure persistent;

    protected static void setupClass() {
        PlanModelObjectFactoryDispatcher.registerFactory(EOAnchoringPointToFigure.class, new AnchoringPointToFigureFactory());
    }

    protected PMAnchoringPointToFigure(PlanModelMgr planModelMgr, EOAnchoringPointToFigure eo) {
        super(planModelMgr);
        this.persistent = eo;
    }

    protected EOAnchoringPointToFigure getPersistentAnchoringPointToFigure() {
        return this.persistent;
    }

    @Override
    protected EOAnchoringPoint getPersistentAnchoringPoint() {
        return this.getPersistentAnchoringPointToFigure();
    }

    protected PMAnchoringPointToFigure(PlanModelMgr planModelMgr) {
        super(planModelMgr);
        this.persistent = new EOAnchoringPointToFigure();
    }

    @Override
    protected void linkCrossLinks(PMPlanModelObject root, LoadPlanModelObjectList objectList) throws EXPlanModelObjectCrosslinkException {
        PMFigure fig = (PMFigure)LoadPlanModelObjectLinker.getObjectByUIDAndCheckType(objectList, this.getPersistentAnchoringPointToFigure().getFigureUid(), PMFigure.class, "figure");
        fig.linkCrossLinkToPointToFigureAnchoring(this);
        this.figure = fig;
    }

    @Override
    protected List<? extends Object> getCrosslinked() {
        List crosslinked = super.getCrosslinked();
        crosslinked.add(this.figure);
        return crosslinked;
    }

    public PMFigure getFigure() {
        return this.figure;
    }

    @Override
    public IPMFigureRO getFigureRO() {
        return this.getFigure();
    }

    @Override
    public IPMFigureRW getFigureRW() {
        return this.getFigure();
    }

    public void setFigure(PMFigure figure) {
        this.setFigure((Object)figure);
    }

    @Override
    public void setFigure(IPMFigureRW figure) {
        this.setFigure((Object)figure);
    }

    private void setFigure(Object figure) {
        PMFigure pMFigure;
        assert (figure == null || figure instanceof PMFigure) : "figure is not instance of PMFigure";
        this.figure = pMFigure = (PMFigure)figure;
        if (figure == null) {
            this.getPersistentAnchoringPointToFigure().setFigureUid(null);
        } else {
            this.getPersistentAnchoringPointToFigure().setFigureUid(pMFigure.getPersistentFigure().getUid());
        }
    }

    @Override
    protected void removeLinks() {
        super.removeLinks();
        this.setFigure(null);
    }

    protected PMAnchoringPointToFigure(PlanModelMgr planModelMgr, PMPoint point, PMFigure figure) {
        super(planModelMgr);
        this.persistent = new EOAnchoringPointToFigure();
        this.constructPMAnchoring(point);
        this.setFigure(figure);
    }

    @Override
    public void delete() {
        super.delete();
        if (this.getFigure() != null) {
            this.getFigure().removeAnchoring(this.getFigure().getAnchoringIndex(this));
            this.setFigure(null);
        }
    }

    @Override
    public IAnchoringDestination getAnchoringDestination() {
        return this.getAnchoringDestinationFigure();
    }

    @Override
    public IAnchoringDestinationFigure getAnchoringDestinationFigure() {
        return this.getFigure();
    }

    @Override
    public boolean isDesirable() {
        return this.getPoint().getPlanElement().getPlan().getAnchoringDecider().isDesirableAnchoring(this.getAnchoringSource(), this.getAnchoringDestination());
    }

    @Override
    public boolean isValid() {
        if (this.getPoint() == null || this.getPoint().getAnchoring() != this) {
            return false;
        }
        return this.getFigure() != null && this.getFigure().getAnchoringIndex(this) >= 0;
    }

    static class AnchoringPointToFigureFactory
    extends PMAnchoringPoint.AnchoringPointFactory {
        AnchoringPointToFigureFactory() {
        }

        @Override
        public PMPlanModelObject create(PlanModelMgr planModelMgr, EncodableObjectBase eo) {
            return new PMAnchoringPointToFigure(planModelMgr, (EOAnchoringPointToFigure)eo);
        }

        @Override
        public List getChildren(EncodableObjectBase eo) {
            return super.getChildren(eo);
        }
    }
}

