/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.anchoring;

import com.arcway.lib.geometry.Rectangle;
import com.arcway.planagent.planmodel.anchoring.IAnchoring;
import com.arcway.planagent.planmodel.anchoring.IAnchoringContext;
import com.arcway.planagent.planmodel.anchoring.IAnchoringDestination;
import com.arcway.planagent.planmodel.anchoring.IAnchoringDestinationContributor;
import com.arcway.planagent.planmodel.anchoring.IAnchoringDestinationFigure;
import com.arcway.planagent.planmodel.anchoring.IAnchoringDestinationLine;
import com.arcway.planagent.planmodel.anchoring.IAnchoringDestinationPoint;
import com.arcway.planagent.planmodel.anchoring.IAnchoringDestinationVisitor;
import com.arcway.planagent.planmodel.anchoring.IAnchoringSource;
import com.arcway.planagent.planmodel.anchoring.IAnchoringSourceContributor;
import com.arcway.planagent.planmodel.anchoring.IAnchoringSourceLine;
import com.arcway.planagent.planmodel.anchoring.IAnchoringSourcePoint;
import com.arcway.planagent.planmodel.anchoring.IAnchoringSourceVisitor;
import com.arcway.planagent.planmodel.anchoring.IAnchoringTypedDestinationVisitor;
import com.arcway.planagent.planmodel.anchoring.IAnchoringTypedSourceVisitor;
import com.arcway.planagent.planmodel.anchoring.VisitAnchoringPossibility;
import com.arcway.planagent.planmodel.anchoring.VisitDestinationsAll;
import com.arcway.planagent.planmodel.anchoring.VisitDestinationsForEndPointSources;
import com.arcway.planagent.planmodel.anchoring.VisitDestinationsForLineSources;
import com.arcway.planagent.planmodel.anchoring.VisitDestinationsForNoneEndPointSources;
import com.arcway.planagent.planmodel.anchoring.VisitSourcesAll;
import com.arcway.planagent.planmodel.anchoring.VisitSourcesForFigureDestinations;
import com.arcway.planagent.planmodel.anchoring.VisitSourcesForLineDestinations;
import com.arcway.planagent.planmodel.anchoring.VisitSourcesForPointDestinations;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class AnchoringContributorTraverser {
    public static Collection<IAnchoring> getAllAnchorings(Collection<IAnchoringSourceContributor> sourceContributors, Collection<IAnchoringDestinationContributor> destinationContributors) {
        HashSet<IAnchoring> anchorings = new HashSet<IAnchoring>();
        VisitFindAnchorings visitor = new VisitFindAnchorings(anchorings);
        AnchoringContributorTraverser.traverseSourcesAll(sourceContributors, null, (IAnchoringSourceVisitor)visitor);
        AnchoringContributorTraverser.traverseDestinationsAll(destinationContributors, null, (IAnchoringDestinationVisitor)visitor);
        return anchorings;
    }

    public static boolean traverseSourceContributors(Collection<? extends IAnchoringSourceContributor> sourceContributors, Rectangle area, IAnchoringTypedSourceVisitor visitor) {
        boolean canceled = false;
        Iterator<? extends IAnchoringSourceContributor> i = sourceContributors.iterator();
        while (!canceled && i.hasNext()) {
            IAnchoringSourceContributor sourceContributor = i.next();
            canceled |= AnchoringContributorTraverser.traverseSourceContributor(sourceContributor, area, visitor);
        }
        return canceled;
    }

    public static boolean traverseSourceContributor(IAnchoringSourceContributor sourceContributor, Rectangle area, IAnchoringTypedSourceVisitor visitor) {
        boolean cancled = false;
        if (AnchoringContributorTraverser.isRelevantSourceContributor(sourceContributor, area)) {
            Collection<? extends IAnchoringSourceContributor> childContributors;
            IAnchoringSourcePoint endPoint = sourceContributor.getSourceEndPoint();
            if (!cancled && endPoint != null && AnchoringContributorTraverser.isRelevantSource(endPoint, area)) {
                cancled |= visitor.visitSourceEndPoint(endPoint);
            }
            IAnchoringSourcePoint noneEndPoint = sourceContributor.getSourceNoneEndPoint();
            if (!cancled && noneEndPoint != null && AnchoringContributorTraverser.isRelevantSource(noneEndPoint, area)) {
                cancled |= visitor.visitSourceNoneEndPoint(noneEndPoint);
            }
            IAnchoringSourceLine line = sourceContributor.getSourceLine();
            if (!cancled && line != null && AnchoringContributorTraverser.isRelevantSource(line, area)) {
                cancled |= visitor.visitSourceLine(line);
            }
            if (!cancled && (childContributors = sourceContributor.getChildSourceContributors()) != null) {
                Iterator<? extends IAnchoringSourceContributor> i = childContributors.iterator();
                while (!cancled && i.hasNext()) {
                    IAnchoringSourceContributor childContributor = i.next();
                    cancled |= AnchoringContributorTraverser.traverseSourceContributor(childContributor, area, visitor);
                }
            }
        }
        return cancled;
    }

    public static boolean traverseSourcesAll(IAnchoringSourceContributor sourceContributor, Rectangle area, IAnchoringSourceVisitor visitor) {
        VisitSourcesAll typedVisitor = new VisitSourcesAll(visitor);
        return AnchoringContributorTraverser.traverseSourceContributor(sourceContributor, area, typedVisitor);
    }

    public static boolean traverseSourceContributorForFigureDestinations(IAnchoringSourceContributor sourceContributor, Rectangle area, IAnchoringSourceVisitor visitor) {
        VisitSourcesForFigureDestinations typedVisitor = new VisitSourcesForFigureDestinations(visitor);
        return AnchoringContributorTraverser.traverseSourceContributor(sourceContributor, area, typedVisitor);
    }

    public static boolean traverseSourceContributorForPointDestinations(IAnchoringSourceContributor sourceContributor, Rectangle area, IAnchoringSourceVisitor visitor) {
        VisitSourcesForPointDestinations typedVisitor = new VisitSourcesForPointDestinations(visitor);
        return AnchoringContributorTraverser.traverseSourceContributor(sourceContributor, area, typedVisitor);
    }

    public static boolean traverseSourceContributorForLineDestinations(IAnchoringSourceContributor sourceContributor, Rectangle area, IAnchoringSourceVisitor visitor) {
        VisitSourcesForLineDestinations typedVisitor = new VisitSourcesForLineDestinations(visitor);
        return AnchoringContributorTraverser.traverseSourceContributor(sourceContributor, area, typedVisitor);
    }

    public static boolean traverseSourcesAll(Collection<? extends IAnchoringSourceContributor> sourceContributors, Rectangle area, IAnchoringSourceVisitor visitor) {
        VisitSourcesAll typedVisitor = new VisitSourcesAll(visitor);
        return AnchoringContributorTraverser.traverseSourceContributors(sourceContributors, area, typedVisitor);
    }

    public static boolean traverseSourceContributorForFigureDestinations(Collection<IAnchoringSourceContributor> sourceContributors, Rectangle area, IAnchoringSourceVisitor visitor) {
        VisitSourcesForFigureDestinations typedVisitor = new VisitSourcesForFigureDestinations(visitor);
        return AnchoringContributorTraverser.traverseSourceContributors(sourceContributors, area, typedVisitor);
    }

    public static boolean traverseSourceContributorForPointDestinations(Collection<IAnchoringSourceContributor> sourceContributors, Rectangle area, IAnchoringSourceVisitor visitor) {
        VisitSourcesForPointDestinations typedVisitor = new VisitSourcesForPointDestinations(visitor);
        return AnchoringContributorTraverser.traverseSourceContributors(sourceContributors, area, typedVisitor);
    }

    public static boolean traverseSourceContributorForLineDestinations(Collection<IAnchoringSourceContributor> sourceContributors, Rectangle area, IAnchoringSourceVisitor visitor) {
        VisitSourcesForLineDestinations typedVisitor = new VisitSourcesForLineDestinations(visitor);
        return AnchoringContributorTraverser.traverseSourceContributors(sourceContributors, area, typedVisitor);
    }

    public static boolean traverseDestinationContributors(Collection<? extends IAnchoringDestinationContributor> destinationContributors, Rectangle area, IAnchoringTypedDestinationVisitor visitor) {
        boolean cancled = false;
        Iterator<? extends IAnchoringDestinationContributor> i = destinationContributors.iterator();
        while (!cancled && i.hasNext()) {
            IAnchoringDestinationContributor destinationContributor = i.next();
            cancled |= AnchoringContributorTraverser.traverseDestinationContributor(destinationContributor, area, visitor);
        }
        return cancled;
    }

    public static boolean traverseDestinationContributor(IAnchoringDestinationContributor destinationContributor, Rectangle area, IAnchoringTypedDestinationVisitor visitor) {
        boolean cancled = false;
        if (AnchoringContributorTraverser.isRelevantDestinationContributor(destinationContributor, area)) {
            Collection<? extends IAnchoringDestinationContributor> childContributors;
            IAnchoringDestinationFigure figure = destinationContributor.getDestinationFigure();
            if (!cancled && figure != null && AnchoringContributorTraverser.isRelevantDestination(figure, area)) {
                cancled |= visitor.visitDestinationFigure(figure);
            }
            IAnchoringDestinationPoint point = destinationContributor.getDestinationPoint();
            if (!cancled && point != null && AnchoringContributorTraverser.isRelevantDestination(point, area)) {
                cancled |= visitor.visitDestinationPoint(point);
            }
            IAnchoringDestinationLine line = destinationContributor.getDestinationLine();
            if (!cancled && line != null && AnchoringContributorTraverser.isRelevantDestination(line, area)) {
                cancled |= visitor.visitDestinationLine(line);
            }
            if (!cancled && (childContributors = destinationContributor.getChildDestinationContributors()) != null) {
                Iterator<? extends IAnchoringDestinationContributor> i = childContributors.iterator();
                while (!cancled && i.hasNext()) {
                    IAnchoringDestinationContributor childContributor = i.next();
                    cancled |= AnchoringContributorTraverser.traverseDestinationContributor(childContributor, area, visitor);
                }
            }
        }
        return cancled;
    }

    public static boolean traverseDestinationsAll(IAnchoringDestinationContributor destinationContributor, Rectangle area, IAnchoringDestinationVisitor visitor) {
        VisitDestinationsAll typedVisitor = new VisitDestinationsAll(visitor);
        return AnchoringContributorTraverser.traverseDestinationContributor(destinationContributor, area, typedVisitor);
    }

    public static boolean traverseDestinationContributorForEndPointSources(IAnchoringDestinationContributor destinationContributor, Rectangle area, IAnchoringDestinationVisitor visitor) {
        VisitDestinationsForEndPointSources typedVisitor = new VisitDestinationsForEndPointSources(visitor);
        return AnchoringContributorTraverser.traverseDestinationContributor(destinationContributor, area, typedVisitor);
    }

    public static boolean traverseDestinationContributorForNoneEndPointSources(IAnchoringDestinationContributor destinationContributor, Rectangle area) {
        VisitDestinationsForNoneEndPointSources typedVisitor = new VisitDestinationsForNoneEndPointSources();
        return AnchoringContributorTraverser.traverseDestinationContributor(destinationContributor, area, typedVisitor);
    }

    public static boolean traverseDestinationContributorForLineSources(IAnchoringDestinationContributor destinationContributor, Rectangle area) {
        VisitDestinationsForLineSources typedVisitor = new VisitDestinationsForLineSources();
        return AnchoringContributorTraverser.traverseDestinationContributor(destinationContributor, area, typedVisitor);
    }

    public static boolean traverseDestinationsAll(Collection<? extends IAnchoringDestinationContributor> destinationContributors, Rectangle area, IAnchoringDestinationVisitor visitor) {
        VisitDestinationsAll typedVisitor = new VisitDestinationsAll(visitor);
        return AnchoringContributorTraverser.traverseDestinationContributors(destinationContributors, area, typedVisitor);
    }

    public static boolean traverseDestinationContributorForEndPointSources(Collection<? extends IAnchoringDestinationContributor> destinationContributors, Rectangle area, IAnchoringDestinationVisitor visitor) {
        VisitDestinationsForEndPointSources typedVisitor = new VisitDestinationsForEndPointSources(visitor);
        return AnchoringContributorTraverser.traverseDestinationContributors(destinationContributors, area, typedVisitor);
    }

    public static boolean traverseDestinationContributorForNoneEndPointSources(Collection<? extends IAnchoringDestinationContributor> destinationContributors, Rectangle area) {
        VisitDestinationsForNoneEndPointSources typedVisitor = new VisitDestinationsForNoneEndPointSources();
        return AnchoringContributorTraverser.traverseDestinationContributors(destinationContributors, area, typedVisitor);
    }

    public static boolean traverseDestinationContributorForLineSources(Collection<? extends IAnchoringDestinationContributor> destinationContributors, Rectangle area) {
        VisitDestinationsForLineSources typedVisitor = new VisitDestinationsForLineSources();
        return AnchoringContributorTraverser.traverseDestinationContributors(destinationContributors, area, typedVisitor);
    }

    public static boolean traverseAllAnchoringPossibilitesForSourceContributors(Collection<? extends IAnchoringSourceContributor> sourceContributors, Collection<? extends IAnchoringDestinationContributor> destinationContributors, VisitAnchoringPossibility possibilityVisitor, IAnchoringContext anchoringContext) {
        VisitMatchingDestinations visitor = new VisitMatchingDestinations(destinationContributors, possibilityVisitor, anchoringContext);
        return AnchoringContributorTraverser.traverseSourceContributors(sourceContributors, null, visitor);
    }

    private static Rectangle isSourceRelevantForPossibilites(IAnchoringSource source, IAnchoringContext anchoringContext) {
        IAnchoring anchoring;
        Rectangle bounds = null;
        IAnchoringSource rootSource = source.getRootSource();
        if (rootSource == null) {
            rootSource = source;
        }
        if ((anchoring = rootSource.getIAnchoring()) == null && (bounds = source.getAnchoringSourceOuterBounds()) != null) {
            bounds = bounds.expand(anchoringContext.getAnchoringTolerance());
        }
        return bounds;
    }

    public static boolean traverseAllAnchoringPossibilitesForDestinationContributors(Collection<IAnchoringDestinationContributor> destinationContributors, Collection<IAnchoringSourceContributor> sourceContributors, VisitAnchoringPossibility possibilityVisitor, IAnchoringContext anchoringContext) {
        VisitMatchingSources visitor = new VisitMatchingSources(sourceContributors, possibilityVisitor, anchoringContext);
        return AnchoringContributorTraverser.traverseDestinationContributors(destinationContributors, null, visitor);
    }

    private static Rectangle isDestinationRelevantForPossibilites(IAnchoringDestination destination, IAnchoringContext anchoringContext) {
        Rectangle bounds = destination.getAnchoringDestinationOuterBounds();
        if (bounds != null) {
            bounds = bounds.expand(anchoringContext.getAnchoringTolerance());
        }
        return bounds;
    }

    private static boolean isRelevantSourceContributor(IAnchoringSourceContributor source, Rectangle area) {
        boolean isRelevant = area != null ? AnchoringContributorTraverser.isRelevant(source.getSourceContributorOuterBounds(), area) : true;
        return isRelevant;
    }

    private static boolean isRelevantSource(IAnchoringSource source, Rectangle area) {
        boolean isRelevant = area != null ? AnchoringContributorTraverser.isRelevant(source.getAnchoringSourceOuterBounds(), area) : true;
        return isRelevant;
    }

    private static boolean isRelevantDestinationContributor(IAnchoringDestinationContributor destination, Rectangle area) {
        boolean isRelevant = area != null ? AnchoringContributorTraverser.isRelevant(destination.getDestinationContributorOuterBounds(), area) : true;
        return isRelevant;
    }

    private static boolean isRelevantDestination(IAnchoringDestination destination, Rectangle area) {
        boolean isRelevant = area != null ? AnchoringContributorTraverser.isRelevant(destination.getAnchoringDestinationOuterBounds(), area) : true;
        return isRelevant;
    }

    private static boolean isRelevant(Rectangle objectBounds, Rectangle area) {
        boolean isRelevant = objectBounds != null ? objectBounds.intersects(area) : false;
        return isRelevant;
    }

    public static boolean isDestinationContained(Collection<? extends IAnchoringDestinationContributor> destinationContributors, IAnchoringDestination destination) {
        IsDestinationContainedVisitor visitor = new IsDestinationContainedVisitor(destination);
        boolean contained = AnchoringContributorTraverser.traverseDestinationsAll(destinationContributors, null, (IAnchoringDestinationVisitor)visitor);
        return contained;
    }

    public static boolean isSourceContained(Collection<? extends IAnchoringSourceContributor> sourceContributors, IAnchoringSource source) {
        IsSourceContainedVisitor visitor = new IsSourceContainedVisitor(source);
        boolean contained = AnchoringContributorTraverser.traverseSourcesAll(sourceContributors, null, (IAnchoringSourceVisitor)visitor);
        return contained;
    }

    private static class IsDestinationContainedVisitor
    implements IAnchoringDestinationVisitor {
        private final IAnchoringDestination destination;

        public IsDestinationContainedVisitor(IAnchoringDestination destination) {
            this.destination = destination;
        }

        @Override
        public boolean visit(IAnchoringDestination dest) {
            return dest == this.destination;
        }
    }

    private static class IsSourceContainedVisitor
    implements IAnchoringSourceVisitor {
        private final IAnchoringSource source;

        public IsSourceContainedVisitor(IAnchoringSource source) {
            this.source = source;
        }

        @Override
        public boolean visit(IAnchoringSource src) {
            return src == this.source;
        }
    }

    private static class VisitDestinationPossibility
    implements IAnchoringDestinationVisitor {
        private final IAnchoringSource source;
        private final VisitAnchoringPossibility possibilityVisitor;

        public VisitDestinationPossibility(IAnchoringSource source, VisitAnchoringPossibility possibilityVisitor) {
            this.source = source;
            this.possibilityVisitor = possibilityVisitor;
        }

        @Override
        public boolean visit(IAnchoringDestination destination) {
            return this.possibilityVisitor.visit(this.source, destination);
        }
    }

    private static class VisitFindAnchorings
    implements IAnchoringSourceVisitor,
    IAnchoringDestinationVisitor {
        private final Set<IAnchoring> anchorings;

        public VisitFindAnchorings(Set<IAnchoring> anchorings) {
            assert (anchorings != null);
            this.anchorings = anchorings;
        }

        @Override
        public boolean visit(IAnchoringSource source) {
            IAnchoring anchoring = source.getIAnchoring();
            if (anchoring != null) {
                this.anchorings.add(anchoring);
            }
            return false;
        }

        @Override
        public boolean visit(IAnchoringDestination destination) {
            this.anchorings.addAll(destination.getIAnchorings());
            return false;
        }
    }

    private static class VisitMatchingDestinations
    implements IAnchoringTypedSourceVisitor {
        private final Collection<? extends IAnchoringDestinationContributor> destinationContributors;
        private final VisitAnchoringPossibility possibilityVisitor;
        private final IAnchoringContext anchoringContext;

        public VisitMatchingDestinations(Collection<? extends IAnchoringDestinationContributor> destinationContributors, VisitAnchoringPossibility possibilityVisitor, IAnchoringContext anchoringContext) {
            this.destinationContributors = destinationContributors;
            this.possibilityVisitor = possibilityVisitor;
            this.anchoringContext = anchoringContext;
        }

        @Override
        public boolean visitSourceEndPoint(IAnchoringSourcePoint point) {
            boolean cancled = false;
            Rectangle bounds = AnchoringContributorTraverser.isSourceRelevantForPossibilites(point, this.anchoringContext);
            if (bounds != null) {
                VisitDestinationPossibility visitor = new VisitDestinationPossibility(point, this.possibilityVisitor);
                cancled |= AnchoringContributorTraverser.traverseDestinationContributorForEndPointSources(this.destinationContributors, bounds, (IAnchoringDestinationVisitor)visitor);
            }
            return cancled;
        }

        @Override
        public boolean visitSourceNoneEndPoint(IAnchoringSourcePoint point) {
            boolean cancled = false;
            Rectangle bounds = AnchoringContributorTraverser.isSourceRelevantForPossibilites(point, this.anchoringContext);
            if (bounds != null) {
                cancled |= AnchoringContributorTraverser.traverseDestinationContributorForNoneEndPointSources(this.destinationContributors, bounds);
            }
            return cancled;
        }

        @Override
        public boolean visitSourceLine(IAnchoringSourceLine line) {
            boolean cancled = false;
            Rectangle bounds = AnchoringContributorTraverser.isSourceRelevantForPossibilites(line, this.anchoringContext);
            if (bounds != null) {
                cancled |= AnchoringContributorTraverser.traverseDestinationContributorForLineSources(this.destinationContributors, bounds);
            }
            return cancled;
        }
    }

    private static class VisitMatchingSources
    implements IAnchoringTypedDestinationVisitor {
        private final Collection<IAnchoringSourceContributor> sourceContributors;
        private final VisitAnchoringPossibility possibilityVisitor;
        private final IAnchoringContext anchoringContext;

        public VisitMatchingSources(Collection<IAnchoringSourceContributor> sourceContributors, VisitAnchoringPossibility possibilityVisitor, IAnchoringContext anchoringContext) {
            this.sourceContributors = sourceContributors;
            this.possibilityVisitor = possibilityVisitor;
            this.anchoringContext = anchoringContext;
        }

        @Override
        public boolean visitDestinationFigure(IAnchoringDestinationFigure figure) {
            boolean cancled = false;
            Rectangle bounds = AnchoringContributorTraverser.isDestinationRelevantForPossibilites(figure, this.anchoringContext);
            if (bounds != null) {
                VisitSourcePossibility visitor = new VisitSourcePossibility(figure, this.possibilityVisitor);
                cancled |= AnchoringContributorTraverser.traverseSourceContributorForFigureDestinations(this.sourceContributors, bounds, (IAnchoringSourceVisitor)visitor);
            }
            return cancled;
        }

        @Override
        public boolean visitDestinationPoint(IAnchoringDestinationPoint point) {
            boolean cancled = false;
            Rectangle bounds = AnchoringContributorTraverser.isDestinationRelevantForPossibilites(point, this.anchoringContext);
            if (bounds != null) {
                VisitSourcePossibility visitor = new VisitSourcePossibility(point, this.possibilityVisitor);
                cancled |= AnchoringContributorTraverser.traverseSourceContributorForPointDestinations(this.sourceContributors, bounds, (IAnchoringSourceVisitor)visitor);
            }
            return cancled;
        }

        @Override
        public boolean visitDestinationLine(IAnchoringDestinationLine line) {
            boolean cancled = false;
            Rectangle bounds = AnchoringContributorTraverser.isDestinationRelevantForPossibilites(line, this.anchoringContext);
            if (bounds != null) {
                VisitSourcePossibility visitor = new VisitSourcePossibility(line, this.possibilityVisitor);
                cancled |= AnchoringContributorTraverser.traverseSourceContributorForLineDestinations(this.sourceContributors, bounds, (IAnchoringSourceVisitor)visitor);
            }
            return cancled;
        }
    }

    private static class VisitSourcePossibility
    implements IAnchoringSourceVisitor {
        private final IAnchoringDestination destination;
        private final VisitAnchoringPossibility possibilityVisitor;

        public VisitSourcePossibility(IAnchoringDestination destination, VisitAnchoringPossibility possibilityVisitor) {
            this.destination = destination;
            this.possibilityVisitor = possibilityVisitor;
        }

        @Override
        public boolean visit(IAnchoringSource source) {
            IAnchoring anchoring;
            boolean cancled = false;
            IAnchoringSource rootSource = source.getRootSource();
            if (rootSource == null) {
                rootSource = source;
            }
            if ((anchoring = rootSource.getIAnchoring()) == null) {
                cancled |= this.possibilityVisitor.visit(source, this.destination);
            }
            return cancled;
        }
    }
}

