/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.actions;

import com.arcway.lib.java.New;
import com.arcway.planagent.planmodel.access.readwrite.IPMFigureRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMGraphicalSupplementRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMLineRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPointListRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPointRW;
import com.arcway.planagent.planmodel.actions.ACRemovePoint;
import com.arcway.planagent.planmodel.actions.Action;
import com.arcway.planagent.planmodel.actions.ActionContext;
import com.arcway.planagent.planmodel.reactions.PositionAndPoint;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;

public class ACRemoveEndPoint
extends ACRemovePoint {
    private IPMLineRW line;
    private IPMPointListRW pointList;
    private IPMPointRW targetPoint;
    private boolean isEndPoint;
    private int indexLine;
    private int indexPoint;

    public ACRemoveEndPoint(ActionContext actionContext, IPMPointRW point) {
        super(actionContext, point);
        assert (this.getPoint().getLine1stRW() == null && this.getPoint().getLine2ndRW() != null || this.getPoint().getLine1stRW() != null && this.getPoint().getLine1stRW() == null) : "point is no endpoint";
    }

    @Override
    protected void initializeState() {
        super.initializeState();
        if (this.getPoint().getLine1stRW() == null && this.getPoint().getLine2ndRW() != null) {
            this.line = this.getPoint().getLine2ndRW();
            this.targetPoint = this.line.getPoint2ndRW();
            assert (this.targetPoint != null) : "wrong order in pointList";
            this.isEndPoint = false;
        } else {
            assert (this.getPoint().getLine1stRW() != null && this.getPoint().getLine1stRW() == null) : "pointlist changed between constructor and initializeState";
            this.line = this.getPoint().getLine1stRW();
            this.targetPoint = this.line.getPoint1stRW();
            assert (this.targetPoint != null) : "wrong order in pointList";
            this.isEndPoint = true;
        }
        this.pointList = this.getPoint().getPointListRW();
        this.indexLine = this.pointList.getLineIndex(this.line);
        this.indexPoint = this.pointList.getPointIndex(this.getPoint());
    }

    @Override
    protected void setStateToPost() {
        if (this.isEndPoint) {
            this.targetPoint.setLine2nd(null);
        } else {
            this.targetPoint.setLine1st(null);
        }
        this.pointList.removeLine(this.indexLine);
        this.pointList.removePoint(this.indexPoint);
    }

    @Override
    protected void setStateToPre() {
        if (this.isEndPoint) {
            this.targetPoint.setLine2nd(this.line);
        } else {
            this.targetPoint.setLine1st(this.line);
        }
        this.pointList.addLine(this.line, this.indexLine);
        this.pointList.addPoint(this.getPoint(), this.indexPoint);
    }

    @Override
    public boolean isDupe(Action a) {
        ACRemoveEndPoint dupeA;
        boolean isDupe = false;
        if (a instanceof ACRemoveEndPoint && (dupeA = (ACRemoveEndPoint)a).getPoint() == this.getPoint()) {
            isDupe = true;
        }
        return isDupe;
    }

    @Override
    public Collection getEntriesForCompressedReactionList() {
        if (this.line.getPlanObjectRW() instanceof IPMFigureRW) {
            IPMFigureRW changedFigure = (IPMFigureRW)this.line.getPlanObjectRW();
            ArrayList<PositionAndPoint> oldGeometry = new ArrayList<PositionAndPoint>();
            return Collections.singleton(this.getActionContext().getActionTypeAgentManager().getReactionChangeGeometryFigureAgent().getEntryForCompressedList(changedFigure, oldGeometry, this.getActionContext()));
        }
        if (this.line.getPlanObjectRW() instanceof IPMGraphicalSupplementRW) {
            HashMap changedSupplements = New.hashMap((int)1);
            changedSupplements.put((IPMGraphicalSupplementRW)this.line.getPlanObjectRW(), null);
            return Collections.singleton(this.getActionContext().getActionTypeAgentManager().getReactionModifySupplementAgent().getEntryForCompressedList(changedSupplements, this.getActionContext()));
        }
        assert (false) : "point not part of supplement or figure";
        return null;
    }

    public String toString() {
        return "ACRemoveEndPoint ()";
    }
}

