/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.actions;

import com.arcway.planagent.planmodel.access.readwrite.IModelChangeRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMAnchorRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMAnchoringPointRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMAnchoringPointToAnchorRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPointRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMSemanticalUnitRW;
import com.arcway.planagent.planmodel.actions.ACCreateAnchoringPoint;
import com.arcway.planagent.planmodel.actions.Action;
import com.arcway.planagent.planmodel.actions.ActionContext;
import java.util.HashSet;
import java.util.Set;

public class ACCreateAnchoringPointToAnchor
extends ACCreateAnchoringPoint {
    private final IPMAnchorRW anchor;
    private IPMAnchoringPointToAnchorRW anchoringPointToAnchor;

    public ACCreateAnchoringPointToAnchor(ActionContext actionContext, IPMPointRW point, IPMAnchorRW anchor) {
        super(actionContext, point);
        assert (anchor != null) : "ref to figure is null";
        this.anchor = anchor;
    }

    @Override
    protected void initializeState() {
        this.anchoringPointToAnchor = this.getIPlanModelObjectFactoryRW().createPMAnchoringPointToAnchorRW();
        super.initializeState();
        this.anchoringPointToAnchor.setAnchor(this.anchor);
    }

    @Override
    protected void setStateToPost() {
        super.setStateToPost();
        this.anchor.addAnchoring(this.anchoringPointToAnchor, this.anchor.getAnchoringCount());
    }

    @Override
    protected void setStateToPre() {
        super.setStateToPre();
        assert (this.anchor.getAnchoringIndex(this.anchoringPointToAnchor) == this.anchor.getAnchoringCount() - 1) : "anchoring is not at the expected index";
        this.anchor.removeAnchoring(this.anchor.getAnchoringCount() - 1);
    }

    @Override
    public boolean isDupe(Action a) {
        ACCreateAnchoringPointToAnchor dupeA;
        boolean isDupe = false;
        if (a instanceof ACCreateAnchoringPointToAnchor && (dupeA = (ACCreateAnchoringPointToAnchor)a).getPoint() == this.getPoint() && dupeA.getAnchor() == this.getAnchor()) {
            isDupe = true;
        }
        return isDupe;
    }

    public Set getChanges() {
        HashSet<IModelChangeRW> changes = new HashSet<IModelChangeRW>(1);
        changes.add(this.getIPlanModelObjectFactoryRW().createModelChange(this.anchoringPointToAnchor, 1));
        return changes;
    }

    @Override
    public IPMSemanticalUnitRW getSemanticalUnit() {
        assert (this.getPoint().getPlanElementRW().getPlanRW() == this.anchor.getPlanElementRW().getPlanRW()) : "the plan should be unique";
        return this.getPoint().getPlanElementRW().getPlanRW();
    }

    public IPMAnchorRW getAnchor() {
        return this.anchor;
    }

    @Override
    public IPMAnchoringPointRW getAnchoringPoint() {
        return this.anchoringPointToAnchor;
    }

    public String toString() {
        return "ACCreateAnchoringPointToAnchor (anchor " + this.anchor + ")";
    }
}

