/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.actions;

import com.arcway.planagent.planmodel.access.readwrite.IModelChangeRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMContainmentRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPlanElementRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMSemanticalUnitRW;
import com.arcway.planagent.planmodel.actions.Action;
import com.arcway.planagent.planmodel.actions.ActionContext;
import com.arcway.planagent.planmodel.actions.ActionIterator;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class ACAddContainedPlanElement
extends Action {
    private final IPMPlanElementRW containedPlanElement;
    private final IPMPlanElementRW containingPlanElement;
    private IPMContainmentRW containment;
    private int containedIndex;
    private int containingIndex;

    public ACAddContainedPlanElement(ActionContext actionContext, IPMPlanElementRW containedPlanElement, IPMPlanElementRW containingPlanElement) {
        super(actionContext);
        assert (containedPlanElement != null) : "ref to containedPlanElement is null";
        assert (containingPlanElement != null) : "ref to containerPlanElement is null";
        assert (containedPlanElement != containingPlanElement) : "PE can not contain itself";
        this.containedPlanElement = containedPlanElement;
        this.containingPlanElement = containingPlanElement;
    }

    @Override
    protected void initializeState() {
        assert (!this.checkForCycleFromContainedToContaining(this.containedPlanElement, this.containingPlanElement)) : "containment already exists";
        assert (!this.checkForCycleFromContainedToContainer(this.containedPlanElement, this.containingPlanElement)) : "the future containingPlanElement is already existing containedPlanElement of the future containedPlanElement - no cycle allowed";
        this.containment = this.getIPlanModelObjectFactoryRW().createPMContainmentRW();
        this.containment.setContainedPlanElement(this.containedPlanElement);
        this.containedIndex = this.containedPlanElement.getContainmentAsContainedCount();
        this.containment.setContainingPlanElement(this.containingPlanElement);
        this.containingIndex = this.containingPlanElement.getContainmentAsContainerCount();
    }

    @Override
    protected void setStateToPost() {
        this.containedPlanElement.addContainmentsAsContained(this.containment, this.containedIndex);
        this.containingPlanElement.addContainmentsAsContainer(this.containment, this.containingIndex);
    }

    @Override
    protected void setStateToPre() {
        assert (this.containedIndex == this.containedPlanElement.getContainmentAsContainedIndex(this.containment)) : "the containment is not at the expected index";
        this.containedPlanElement.removeContainmentsAsContained(this.containedIndex);
        assert (this.containingIndex == this.containingPlanElement.getContainmentAsContainerIndex(this.containment)) : "the containment is not at the expected index";
        this.containingPlanElement.removeContainmentsAsContainer(this.containingIndex);
    }

    @Override
    public boolean isDupe(Action a) {
        ACAddContainedPlanElement dupeA;
        boolean isDupe = false;
        if (a instanceof ACAddContainedPlanElement && (dupeA = (ACAddContainedPlanElement)a).getContainedPlanElement() == this.getContainedPlanElement() && dupeA.getContainingPlanElement() == this.getContainingPlanElement()) {
            isDupe = true;
        }
        return isDupe;
    }

    @Override
    public boolean isNop() {
        return false;
    }

    @Override
    public ActionIterator getPreActionIterator() {
        return ActionIterator.EMPTY_ACTION_ITERATOR;
    }

    public Set getChanges() {
        HashSet<IModelChangeRW> changes = new HashSet<IModelChangeRW>(1);
        changes.add(this.getIPlanModelObjectFactoryRW().createModelChange(this.containment, 1));
        return changes;
    }

    public Collection getEntriesForCompressedReactionList() {
        return Collections.singleton(this.getActionContext().getActionTypeAgentManager().getReactionAddContainmentAgent().getEntryForCompressedList(this.getCreatedContainment(), this.getActionContext()));
    }

    @Override
    public IPMSemanticalUnitRW getSemanticalUnit() {
        assert (this.containedPlanElement.getPlanRW() == this.containingPlanElement.getPlanRW()) : "The PlanElements are not from the same plan";
        return this.containedPlanElement.getPlanRW();
    }

    public IPMPlanElementRW getContainedPlanElement() {
        return this.containedPlanElement;
    }

    public IPMPlanElementRW getContainingPlanElement() {
        return this.containingPlanElement;
    }

    public IPMContainmentRW getCreatedContainment() {
        return this.containment;
    }

    public String toString() {
        return "ACAddContainedPlanElement (contained plan element " + this.containedPlanElement + ", containing plan element " + this.containingPlanElement + ")";
    }

    private boolean checkForCycleFromContainedToContainer(IPMPlanElementRW containedPE, IPMPlanElementRW containingPE) {
        int i = 0;
        while (i < containedPE.getContainmentAsContainerCount()) {
            if (containedPE.getContainmentAsContainerRW(i).getContainedPlanElementRW() == containingPE) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean checkForCycleFromContainedToContaining(IPMPlanElementRW containedPE, IPMPlanElementRW containingPE) {
        int i = 0;
        while (i < containedPE.getContainmentAsContainedCount()) {
            if (containedPE.getContainmentAsContainedRW(i).getContainingPlanElementRW() == containingPE) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

