/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel;

import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.planagent.planmodel.FMCAPlanModelPlugin;
import com.arcway.planagent.planmodel.access.readonly.IPMPlanRO;
import com.arcway.planagent.planmodel.implementation.PMPlan;
import com.arcway.planagent.planmodel.implementation.PlanModelMgr;
import com.arcway.planagent.planmodel.persistent.EXPlanCreationException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;

public class PlanModelExtensionMgr {
    private static final ILogger logger = Logger.getLogger(PlanModelExtensionMgr.class);
    private static PlanModelExtensionMgr singelton;
    private static final String EXTENSION_POINT_ID_PLANELEMENTTYPES = "planelementtype";
    private static final String CONFIG_ELEMENT_ID_PLANELEMENTTYPES = "plan-element";
    private static final String PROPERTY_NAME_ELEMENT_TYPE = "id";
    private static final String PROPERTY_NAME_TEMPLATE_FILE = "template";
    private Map<String, Collection<IPMPlanRO>> planElementTemplates;
    private Set<String> planElementTypeIDs;

    private PlanModelExtensionMgr() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PlanModelExtensionMgr getDefault() {
        Class<PlanModelExtensionMgr> clazz = PlanModelExtensionMgr.class;
        synchronized (PlanModelExtensionMgr.class) {
            if (singelton == null) {
                singelton = new PlanModelExtensionMgr();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return singelton;
        }
    }

    private String getPlugInID() {
        return FMCAPlanModelPlugin.getPluginID();
    }

    public IPMPlanRO getFirstTemplate(String planTypeID, String planElementTypeID) {
        PMPlan template = null;
        for (PMPlan pmPlan : this.getTemplates(planElementTypeID)) {
            PMPlan currentTemplate = pmPlan;
            if (!planTypeID.equals(currentTemplate.getType())) continue;
            template = currentTemplate;
        }
        return template;
    }

    public IPMPlanRO getFirstTemplate(String planElementTypeID) {
        IPMPlanRO template = null;
        Iterator<PMPlan> i = this.getTemplates(planElementTypeID).iterator();
        while (template == null && i.hasNext()) {
            IPMPlanRO currentTemplate;
            template = currentTemplate = (IPMPlanRO)i.next();
        }
        return template;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getPlanElementTypeIDs() {
        if (this.planElementTypeIDs == null) {
            PlanModelExtensionMgr planModelExtensionMgr = this;
            synchronized (planModelExtensionMgr) {
                if (this.planElementTypeIDs == null) {
                    this.readTemplatesExtensionPoint();
                }
            }
        }
        return this.planElementTypeIDs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<PMPlan> getTemplates(String planElementTypeID) {
        if (this.planElementTemplates == null) {
            PlanModelExtensionMgr planModelExtensionMgr = this;
            synchronized (planModelExtensionMgr) {
                if (this.planElementTemplates == null) {
                    this.readTemplatesExtensionPoint();
                }
            }
        }
        ArrayList<PMPlan> copiedTemplates = new ArrayList<PMPlan>();
        Collection<IPMPlanRO> originalTemplates = this.planElementTemplates.get(planElementTypeID);
        if (originalTemplates != null) {
            for (IPMPlanRO ipmPlanRO : originalTemplates) {
                PMPlan originalTemplate = (PMPlan)ipmPlanRO;
                try {
                    PMPlan copiedTemplate = originalTemplate.getCopy(null, new HashMap<String, String>());
                    copiedTemplates.add(copiedTemplate);
                }
                catch (EXPlanCreationException e) {
                    logger.error("unable to create template", (Throwable)e);
                }
            }
        }
        return copiedTemplates;
    }

    private void readTemplatesExtensionPoint() {
        IExtension[] extensions;
        this.planElementTemplates = new HashMap<String, Collection<IPMPlanRO>>();
        this.planElementTypeIDs = new TreeSet<String>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        assert (registry != null) : "registry must not be null";
        IExtensionPoint extensionPoint = registry.getExtensionPoint(this.getPlugInID(), EXTENSION_POINT_ID_PLANELEMENTTYPES);
        assert (extensionPoint != null) : "extensionPoint must not be null";
        IExtension[] iExtensionArray = extensions = extensionPoint.getExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] configElements;
            IExtension currentExtension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = configElements = currentExtension.getConfigurationElements();
            int n3 = configElements.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement currentConfigElement = iConfigurationElementArray[n4];
                if (CONFIG_ELEMENT_ID_PLANELEMENTTYPES.equals(currentConfigElement.getName())) {
                    String planElementTypeID = currentConfigElement.getAttribute(PROPERTY_NAME_ELEMENT_TYPE);
                    String templateFileName = currentConfigElement.getAttribute(PROPERTY_NAME_TEMPLATE_FILE);
                    this.planElementTypeIDs.add(planElementTypeID);
                    PlanModelMgr pmmgr = new PlanModelMgr();
                    try (InputStream templateResIs = Platform.getBundle((String)currentExtension.getNamespace()).getResource(templateFileName).openStream();){
                        pmmgr.load(templateResIs);
                    }
                    catch (EXPlanCreationException e) {
                        logger.error("unable to load template " + templateFileName, (Throwable)e);
                    }
                    catch (IOException e) {
                        logger.error("unable to load template " + templateFileName, (Throwable)e);
                    }
                    PMPlan plan = pmmgr.getPlan();
                    if (plan != null) {
                        Collection<IPMPlanRO> templates = this.planElementTemplates.get(planElementTypeID);
                        if (templates == null) {
                            templates = new ArrayList<IPMPlanRO>();
                            this.planElementTemplates.put(planElementTypeID, templates);
                        }
                        templates.add(plan);
                    }
                }
                ++n4;
            }
            ++n2;
        }
    }
}

