/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.fmc.pn.reactions;

import com.arcway.lib.geometry.Points;
import com.arcway.lib.geometry.Rectangle;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.planagent.planmodel.access.readwrite.IPMFigurePlaneRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMFigureRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMGraphicalSupplementRW;
import com.arcway.planagent.planmodel.actions.ACRemoveGraphicalSupplement;
import com.arcway.planagent.planmodel.actions.Action;
import com.arcway.planagent.planmodel.actions.ActionContext;
import com.arcway.planagent.planmodel.actions.ActionIterator;
import com.arcway.planagent.planmodel.actions.PredeterminedActionIterator;
import com.arcway.planagent.planmodel.appearance.ILineMarkerAppearanceRO;
import com.arcway.planagent.planmodel.appearance.LineMarkerAppearance;
import com.arcway.planagent.planmodel.cm.access.readwrite.IPMGraphicalSupplementMarkerRW;
import com.arcway.planagent.planmodel.cm.actions.ACCreateGraphicalSupplementMarker;
import com.arcway.planagent.planmodel.fmc.pn.access.readwrite.IPMPlanElementFMCPNPlaceRW;
import com.arcway.planagent.planmodel.reactions.FigureMovements;
import com.arcway.planagent.planmodel.reactions.IRAChangeGeometryFigure;
import com.arcway.planagent.planmodel.reactions.IRAMoveFigure;
import com.arcway.planagent.planmodel.reactions.PositionAndPoint;
import java.util.List;

public class RAFixFMCPNPlaceSupplement
implements IRAChangeGeometryFigure,
IRAMoveFigure {
    private static final ILogger logger = Logger.getLogger(RAFixFMCPNPlaceSupplement.class);

    public ActionIterator createReactionsFigureGeometryChanged(IPMFigureRW figure, List<PositionAndPoint> oldGeometry, ActionContext actionContext) {
        if (logger.isTraceEnabled()) {
            logger.trace("RAFixAnchoringsAfterFigureModify createReactions(" + figure + ") - start");
        }
        PredeterminedActionIterator actions = new PredeterminedActionIterator(6);
        this.addFixActions(figure, actionContext, actions);
        if (actions.isEmpty()) {
            actions = null;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("getReActionIterator(Action) - end - return value = " + actions);
        }
        return actions;
    }

    public ActionIterator createReactionsFiguresMoved(FigureMovements figureMovements, ActionContext context) {
        PredeterminedActionIterator actions = new PredeterminedActionIterator(6 * figureMovements.size());
        for (IPMFigureRW figure : figureMovements) {
            this.addFixActions(figure, context, actions);
        }
        if (actions.isEmpty()) {
            actions = null;
        }
        return actions;
    }

    private void addFixActions(IPMFigureRW figure, ActionContext actionContext, PredeterminedActionIterator actions) {
        IPMFigurePlaneRW outline = null;
        IPMGraphicalSupplementMarkerRW marker = null;
        boolean route = true;
        if (route && !(figure.getPlanElementRW() instanceof IPMPlanElementFMCPNPlaceRW)) {
            route &= false;
        }
        if (route && !(figure instanceof IPMFigurePlaneRW)) {
            route &= false;
        }
        if (route) {
            IPMFigurePlaneRW plane = (IPMFigurePlaneRW)figure;
            if (!plane.getRole().equals("outline")) {
                route &= false;
            }
            if (route &= (marker = ((IPMPlanElementFMCPNPlaceRW)plane.getPlanElementRW()).getMarkerSupplementRW()) != null) {
                outline = plane;
            }
        }
        if (outline != null) {
            Rectangle bounds = outline.getPointListRW().getPoints().getBounds();
            Points xPoints = new Points();
            xPoints.add(bounds.center());
            int[] markerForce = new int[]{};
            double smaller = Math.min(bounds.w(), bounds.h());
            assert (marker != null) : "marker is NULL.";
            LineMarkerAppearance tokenAppearance = new LineMarkerAppearance((ILineMarkerAppearanceRO)marker.getMarkerAppearance());
            tokenAppearance.setLineMarkerSize(smaller / 7.0);
            ACRemoveGraphicalSupplement removeTheSupplementAction = new ACRemoveGraphicalSupplement(actionContext, (IPMGraphicalSupplementRW)marker);
            actions.addAction((Action)removeTheSupplementAction);
            ACCreateGraphicalSupplementMarker addTheSupplementAction = new ACCreateGraphicalSupplementMarker(actionContext, xPoints, markerForce, (IPMFigureRW)outline, "token", (ILineMarkerAppearanceRO)tokenAppearance);
            actions.addAction((Action)addTheSupplementAction);
        }
    }
}

