/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.fmc.pn.implementation;

import com.arcway.planagent.controllinginterface.planagent.FlowType;
import com.arcway.planagent.planmodel.access.readonly.IPMLineRO;
import com.arcway.planagent.planmodel.access.readonly.IPMPointListRO;
import com.arcway.planagent.planmodel.access.readonly.IPMPointRO;
import com.arcway.planagent.planmodel.anchoring.IAnchoring;
import com.arcway.planagent.planmodel.anchoring.IAnchoringDecider;
import com.arcway.planagent.planmodel.anchoring.IAnchoringDestination;
import com.arcway.planagent.planmodel.anchoring.IAnchoringDestinationFigure;
import com.arcway.planagent.planmodel.anchoring.IAnchoringDestinationPoint;
import com.arcway.planagent.planmodel.anchoring.IAnchoringPoint2Figure;
import com.arcway.planagent.planmodel.anchoring.IAnchoringPoint2Point;
import com.arcway.planagent.planmodel.anchoring.IAnchoringSource;
import com.arcway.planagent.planmodel.anchoring.IAnchoringSourcePoint;
import com.arcway.planagent.planmodel.appearance.ILineAppearanceRO;
import com.arcway.planagent.planmodel.appearance.ILineEndMarkerAppearanceRO;
import com.arcway.planagent.planmodel.appearance.ILineMarkerAppearanceRO;
import com.arcway.planagent.planmodel.appearance.ILineStartMarkerAppearanceRO;
import com.arcway.planagent.planmodel.cm.routing.CurveLineRouter;
import com.arcway.planagent.planmodel.cm.routing.ElongationToFigureCenterRouter;
import com.arcway.planagent.planmodel.cm.routing.KeepVerticalPositionOnFigureRouter;
import com.arcway.planagent.planmodel.cm.routing.RemoveAnchoringRouter;
import com.arcway.planagent.planmodel.cm.routing.SetPointToPointRouter;
import com.arcway.planagent.planmodel.fmc.pn.access.readonly.IPMPlanElementFMCPNMediumRO;
import com.arcway.planagent.planmodel.fmc.pn.access.readonly.IPMPlanElementFMCPNPlaceRO;
import com.arcway.planagent.planmodel.fmc.pn.check.PNValidityMatrix;
import com.arcway.planagent.planmodel.fmc.pn.relation.FMCPNRelationMatrix;
import com.arcway.planagent.planmodel.implementation.PMPlan;
import com.arcway.planagent.planmodel.implementation.PlanModelMgr;
import com.arcway.planagent.planmodel.nesting.INestable;
import com.arcway.planagent.planmodel.nesting.INestingManager;
import com.arcway.planagent.planmodel.persistent.EOPlan;
import com.arcway.planagent.planmodel.relations.PlanElementRelation;
import com.arcway.planagent.planmodel.routing.IRouter;
import com.arcway.planagent.planmodel.routing.IRoutingManager;
import com.arcway.planagent.planmodel.routing.IRoutingParameters;
import com.arcway.planagent.planmodel.transactions.AllowAllTransactionsTransactionValidator;
import com.arcway.planagent.planmodel.transactions.ITransactionValidator;

public class PMPlanFMCPN
extends PMPlan
implements IAnchoringDecider,
IRoutingManager,
INestingManager {
    public static final String PLAN_TYPE_ID = "fmc.pn";
    private static String XML_TYPE = "fmc.pn";

    public PMPlanFMCPN(PlanModelMgr planModelMgr, EOPlan eo) {
        super(planModelMgr, eo);
    }

    public PMPlanFMCPN(PlanModelMgr planModelMgr) {
        super(planModelMgr);
        this.setType(XML_TYPE);
    }

    public String[] getSupportedPlanElementTypeIDs() {
        return new String[]{"fmc.pn.transition", "fmc.pn.place", "fmc.pn.message", "fmc.pn.competency", "fmc.pn.medium", "fmc.cm.lineshapecomment", "fmc.cm.planecomment", "fmc.cm.legend", "fmc.cm.dotscomment"};
    }

    public IRoutingManager getRoutingManager() {
        return this;
    }

    public INestingManager getNestingManager() {
        return this;
    }

    public IAnchoringDecider getAnchoringDecider() {
        return this;
    }

    public boolean isDesirableAnchoring(IAnchoringSource source, IAnchoringDestination destination) {
        boolean isDesirable = false;
        return isDesirable |= PNValidityMatrix.isTouchValid();
    }

    protected boolean isAllowedAnchoring(IAnchoringSource source, IAnchoringDestination destination) {
        boolean isAllowed = false;
        if (source instanceof IAnchoringSourcePoint) {
            if (destination instanceof IAnchoringDestinationFigure) {
                isAllowed |= PNValidityMatrix.isPointToFigureAnchoringPossible((IAnchoringSourcePoint)source, (IAnchoringDestinationFigure)destination);
            }
            if (destination instanceof IAnchoringDestinationPoint) {
                isAllowed |= PNValidityMatrix.isPointToPointAnchoringPossible();
            }
        }
        return isAllowed;
    }

    public IRouter getRouter(IAnchoring anchoring, IRoutingParameters routingParameters) {
        Object router;
        if (anchoring instanceof IAnchoringPoint2Figure) {
            IPMPointRO sourcePoint;
            IPMPointListRO sourcePointList;
            IAnchoringPoint2Figure anchoringPoint2Figure;
            IAnchoringSourcePoint anchoringSourcePoint;
            boolean toCenterRouter = false;
            if (anchoring.getAnchoringDestination().getAnchoringFigure().getPlanElementRO() instanceof IPMPlanElementFMCPNPlaceRO && (anchoringSourcePoint = (anchoringPoint2Figure = (IAnchoringPoint2Figure)anchoring).getAnchoringSourcePoint()) instanceof IPMPointRO && (sourcePointList = (sourcePoint = (IPMPointRO)anchoringSourcePoint).getPointListRO()).getPointCount() >= 2) {
                IPMPointRO startPoint = sourcePointList.getPointRO(0);
                IPMPointRO endPoint = sourcePointList.getPointRO(sourcePointList.getPointCount() - 1);
                IPMLineRO line = null;
                if (sourcePoint == startPoint) {
                    line = startPoint.getLine2ndRO();
                } else if (sourcePoint == endPoint) {
                    line = endPoint.getLine1stRO();
                }
                if (line != null && line.getForce() == 1) {
                    toCenterRouter = true;
                }
            }
            router = toCenterRouter ? new ElongationToFigureCenterRouter() : (anchoring.getAnchoringSource().getAnchoringFigure().getPlanElementRO() instanceof IPMPlanElementFMCPNMediumRO ? new KeepVerticalPositionOnFigureRouter() : (routingParameters.isBendingActive() ? new CurveLineRouter() : (anchoring.getAnchoringDestination().getAnchoringFigure().getPlanElementRO() instanceof IPMPlanElementFMCPNPlaceRO ? new ElongationToFigureCenterRouter() : new CurveLineRouter())));
        } else {
            router = anchoring instanceof IAnchoringPoint2Point ? new SetPointToPointRouter() : new RemoveAnchoringRouter();
        }
        return router;
    }

    public boolean decideNesting(INestable inner, INestable outer) {
        boolean nestingAllowed = false;
        return nestingAllowed;
    }

    public ITransactionValidator getTransactionValidator() {
        return AllowAllTransactionsTransactionValidator.getInstance();
    }

    public PlanElementRelation analyzePlanElementRelation(String startPlanElementType, String endPlanElementType, ILineStartMarkerAppearanceRO lineStartMarkerAppearanceRO, ILineEndMarkerAppearanceRO lineEndMarkerAppearanceRO, ILineAppearanceRO lineAppearanceRO) {
        int direction = FMCPNRelationMatrix.getRelationDirection((ILineMarkerAppearanceRO)lineStartMarkerAppearanceRO, (ILineMarkerAppearanceRO)lineEndMarkerAppearanceRO);
        if (direction != -1 && FMCPNRelationMatrix.isCausality(startPlanElementType, endPlanElementType)) {
            return new PlanElementRelation(1, direction);
        }
        return null;
    }

    public FlowType getFlowType() {
        return FlowType.VERTICAL;
    }
}

