/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.cm.reactions;

import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.planagent.planmodel.access.readwrite.IPMPlanElementRW;
import com.arcway.planagent.planmodel.actions.Action;
import com.arcway.planagent.planmodel.actions.ActionContext;
import com.arcway.planagent.planmodel.actions.ActionIterator;
import com.arcway.planagent.planmodel.actions.PredeterminedActionIterator;
import com.arcway.planagent.planmodel.base.access.readwrite.IPMPlanElementWithDescriptionSupplementRW;
import com.arcway.planagent.planmodel.cm.access.readwrite.IPMGraphicalSupplementTextRW;
import com.arcway.planagent.planmodel.cm.actions.ACSetTextGraphicalSupplementText;
import com.arcway.planagent.planmodel.reactions.IRASetPlanElementDescription;

public class RAFixFMCBDDescriptionSupplementAfterPlanElementDescriptionChange
implements IRASetPlanElementDescription {
    private static final ILogger logger = Logger.getLogger(RAFixFMCBDDescriptionSupplementAfterPlanElementDescriptionChange.class);

    private boolean needsToSetText(String name, String oldText) {
        return !oldText.equals(name);
    }

    public ActionIterator createReactionsPlanElementDescriptionSet(IPMPlanElementRW planElement, String newName, ActionContext context) {
        if (logger.isTraceEnabled()) {
            logger.trace("RIFixDescriptionSupplementAfterPlanElementDescriptionChangeAgent createReactions(" + planElement + ") - start");
        }
        PredeterminedActionIterator actions = new PredeterminedActionIterator(1);
        if (planElement instanceof IPMPlanElementWithDescriptionSupplementRW) {
            IPMPlanElementWithDescriptionSupplementRW planElementWithNameSupplement = (IPMPlanElementWithDescriptionSupplementRW)planElement;
            String name = planElementWithNameSupplement.getDescription();
            IPMGraphicalSupplementTextRW nameSupplement = planElementWithNameSupplement.getDescriptionSupplementRW();
            if (nameSupplement != null && this.needsToSetText(name, nameSupplement.getText())) {
                actions.addAction((Action)new ACSetTextGraphicalSupplementText(context, nameSupplement, name));
            }
        }
        if (logger.isTraceEnabled()) {
            logger.trace("createReactions(IPMPlanElementRW, String, ActionContext) - end - return value = " + actions);
        }
        return actions;
    }
}

