/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.cm.persistent;

import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.planagent.planmodel.appearance.IAppearanceRO;
import com.arcway.planagent.planmodel.appearance.ILineAppearance;
import com.arcway.planagent.planmodel.appearance.ILineAppearanceRO;
import com.arcway.planagent.planmodel.appearance.LineAppearance;
import com.arcway.planagent.planmodel.cm.appearance.IStickmanAppearance;
import com.arcway.planagent.planmodel.cm.appearance.IStickmanAppearanceRO;
import com.arcway.planagent.planmodel.cm.appearance.StickmanAppearance;
import com.arcway.planagent.planmodel.persistent.EALineAppearance;
import de.plans.lib.xml.encoding.EAEncodableAttributes;
import de.plans.lib.xml.encoding.EXEncoderException;
import de.plans.lib.xml.encoding.EncodableObjectBase;

public class EAStickmanAppearance
extends EAEncodableAttributes
implements IStickmanAppearance {
    private static final ILogger logger = Logger.getLogger(EAStickmanAppearance.class);
    private double size = 6.5;
    private final EALineAppearance lineAppearance = new EALineAppearance((EAEncodableAttributes)this, "line");

    public EAStickmanAppearance(String xmlAttrTag) {
        super(xmlAttrTag);
        if (logger.isDebugEnabled()) {
            logger.debug(51, "EAStickmanAppearance(String xmlAttrTag = " + xmlAttrTag + ") - start");
        }
        if (logger.isDebugEnabled()) {
            logger.debug(51, "EAStickmanAppearance(String) - end");
        }
    }

    public EAStickmanAppearance(EAEncodableAttributes ea, String xmlAttrTag) {
        super(ea, xmlAttrTag);
        if (logger.isDebugEnabled()) {
            logger.debug(51, "EAStickmanAppearance(EAEncodableAttributes ea = " + ea + ", String xmlAttrTag = " + xmlAttrTag + ") - start");
        }
        if (logger.isDebugEnabled()) {
            logger.debug(51, "EAStickmanAppearance(EAEncodableAttributes, String) - end");
        }
    }

    public void appendAttributesToXML(EncodableObjectBase.WriteContext writeContext) throws EXEncoderException {
        if (logger.isDebugEnabled()) {
            logger.debug(51, "appendAttributesToXML(OutputStream outp = " + writeContext + ") - start");
        }
        assert (writeContext != null) : "outp is NULL.";
        if (Math.abs(this.size - 6.5) >= 1.0E-10) {
            this.appendAttrToXML(writeContext, "size", this.size);
        }
        this.lineAppearance.appendAttributesToXML(writeContext);
        if (logger.isDebugEnabled()) {
            logger.debug(51, "appendAttributesToXML(OutputStream) - end");
        }
    }

    protected boolean setSubAttributeFromXML(String name, String value) {
        boolean knownAttribute;
        if (logger.isDebugEnabled()) {
            logger.debug(51, "setSubAttributeFromXML(String name = " + name + ", String value = " + value + ") - start");
        }
        if (!(knownAttribute = this.lineAppearance.setAttributeFromXML(name, value))) {
            if ("size".equals(name)) {
                this.size = this.toDouble(value);
                knownAttribute = true;
            } else {
                knownAttribute = false;
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug(51, "setSubAttributeFromXML(String, String) - end - return value = " + knownAttribute);
        }
        return knownAttribute;
    }

    @Override
    public double getSize() {
        if (logger.isDebugEnabled()) {
            logger.debug(51, "getSize() - start");
        }
        if (logger.isDebugEnabled()) {
            logger.debug(51, "getSize() - end - return value = " + this.size);
        }
        return this.size;
    }

    public ILineAppearance getLineAppearance() {
        return (ILineAppearance)this.getLineAppearanceRO();
    }

    @Override
    public ILineAppearanceRO getLineAppearanceRO() {
        if (logger.isDebugEnabled()) {
            logger.debug(51, "getLineAppearanceRO() - start");
        }
        if (logger.isDebugEnabled()) {
            logger.debug(51, "getLineAppearanceRO() - end - return value = " + this.lineAppearance);
        }
        return this.lineAppearance;
    }

    @Override
    public void setSize(double size) {
        if (logger.isDebugEnabled()) {
            logger.debug(51, "setSize(double size = " + size + ") - start");
        }
        assert (size >= 0.0) : "size is less than 0";
        this.size = size;
        if (logger.isDebugEnabled()) {
            logger.debug(51, "setSize(double) - end");
        }
    }

    @Override
    public void setLineAppearance(ILineAppearanceRO lineAppearance) {
        LineAppearance.copy((ILineAppearanceRO)lineAppearance, (ILineAppearance)this.lineAppearance);
    }

    public void setAppearanceFrom(IAppearanceRO appearance) {
        if (!(appearance instanceof IStickmanAppearanceRO)) {
            return;
        }
        IStickmanAppearanceRO stickman = (IStickmanAppearanceRO)appearance;
        this.setSize(stickman.getSize());
        this.setLineAppearance((ILineAppearanceRO)new LineAppearance(stickman.getLineAppearanceRO()));
    }

    public IAppearanceRO getAppearanceAsCopy() {
        return new StickmanAppearance(this);
    }
}

