/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.bpmn.bpd.reactions;

import com.arcway.lib.geometry.Geo;
import com.arcway.lib.geometry.GeoVector;
import com.arcway.lib.geometry.Point;
import com.arcway.lib.java.tuples.Tuple;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.planagent.planmodel.access.readwrite.IPMFigureLineShapeRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMFigurePlaneRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMFigureRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPointRW;
import com.arcway.planagent.planmodel.actions.ACMovePoint;
import com.arcway.planagent.planmodel.actions.Action;
import com.arcway.planagent.planmodel.actions.ActionContext;
import com.arcway.planagent.planmodel.actions.ActionIterator;
import com.arcway.planagent.planmodel.actions.PredeterminedActionIterator;
import com.arcway.planagent.planmodel.bpmn.bpd.access.readwrite.IPMPlanElementBPMNBPDDataObjectNewRW;
import com.arcway.planagent.planmodel.reactions.IRAChangeGeometryFigure;
import com.arcway.planagent.planmodel.reactions.PositionAndPoint;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RAResizeDataObject
implements IRAChangeGeometryFigure {
    private static final ILogger logger = Logger.getLogger(RAResizeDataObject.class);

    public ActionIterator createReactionsFigureGeometryChanged(IPMFigureRW figure, List<PositionAndPoint> oldGeometry, ActionContext context) {
        if (logger.isTraceEnabled()) {
            logger.trace("RAResizeDataObject createReactions(" + figure + ") - start");
        }
        PredeterminedActionIterator actions = new PredeterminedActionIterator();
        RAResizeDataObject.addFixActions(figure, context, actions);
        if (actions.isEmpty()) {
            actions = null;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("getReActionIterator(Action) - end - return value = " + actions);
        }
        return actions;
    }

    private static void addFixActions(IPMFigureRW figure, ActionContext actionContext, PredeterminedActionIterator actions) {
        IPMFigurePlaneRW outlineFigure = null;
        if (!(figure.getPlanElementRW() instanceof IPMPlanElementBPMNBPDDataObjectNewRW)) {
            return;
        }
        if (!(figure instanceof IPMFigurePlaneRW)) {
            return;
        }
        outlineFigure = (IPMFigurePlaneRW)figure;
        if (!outlineFigure.getRole().equals("outline")) {
            return;
        }
        IPMPointRW upperLeftOutline = null;
        IPMPointRW lowerRightOutline = null;
        int i = 0;
        while (i < outlineFigure.getPointListRW().getPointCount()) {
            IPMPointRW currentPoint = outlineFigure.getPointListRW().getPointRW(i);
            if (upperLeftOutline == null) {
                upperLeftOutline = currentPoint;
            } else if (currentPoint.getPosition().y + 1.0E-10 < upperLeftOutline.getPosition().y) {
                upperLeftOutline = currentPoint;
            } else if (Geo.equals((double)currentPoint.getPosition().y, (double)upperLeftOutline.getPosition().y) && currentPoint.getPosition().x - 1.0E-10 < upperLeftOutline.getPosition().x) {
                upperLeftOutline = currentPoint;
            }
            if (lowerRightOutline == null) {
                lowerRightOutline = currentPoint;
            } else if (currentPoint.getPosition().y - 1.0E-10 > lowerRightOutline.getPosition().y) {
                lowerRightOutline = currentPoint;
            } else if (Geo.equals((double)currentPoint.getPosition().y, (double)lowerRightOutline.getPosition().y) && currentPoint.getPosition().x - 1.0E-10 > lowerRightOutline.getPosition().x) {
                lowerRightOutline = currentPoint;
            }
            ++i;
        }
        assert (upperLeftOutline != null) : "upper left point of outline figure has not been calculated";
        assert (lowerRightOutline != null) : "lower right point of outline figure has not been calculated";
        IPMFigurePlaneRW oldDataObjectFigure = ((IPMPlanElementBPMNBPDDataObjectNewRW)outlineFigure.getPlanElementRW()).getDataObjectFigureRW();
        IPMPointRW upperLeftFigure = null;
        IPMPointRW lowerRightFigure = null;
        int i2 = 0;
        while (i2 < oldDataObjectFigure.getPointListRW().getPointCount()) {
            IPMPointRW currentPoint = oldDataObjectFigure.getPointListRW().getPointRW(i2);
            if (upperLeftFigure == null) {
                upperLeftFigure = currentPoint;
            } else if (currentPoint.getPosition().y + 1.0E-10 < upperLeftFigure.getPosition().y) {
                upperLeftFigure = currentPoint;
            } else if (Geo.equals((double)currentPoint.getPosition().y, (double)upperLeftFigure.getPosition().y) && currentPoint.getPosition().x - 1.0E-10 < upperLeftFigure.getPosition().x) {
                upperLeftFigure = currentPoint;
            }
            if (lowerRightFigure == null) {
                lowerRightFigure = currentPoint;
            } else if (currentPoint.getPosition().y - 1.0E-10 > lowerRightFigure.getPosition().y) {
                lowerRightFigure = currentPoint;
            } else if (Geo.equals((double)currentPoint.getPosition().y, (double)lowerRightFigure.getPosition().y) && currentPoint.getPosition().x - 1.0E-10 > lowerRightFigure.getPosition().x) {
                lowerRightFigure = currentPoint;
            }
            ++i2;
        }
        assert (upperLeftFigure != null) : "upper left point of geometry figure has not been calculated";
        assert (lowerRightFigure != null) : "lower right point of geometry figure has not been calculated";
        GeoVector moveLeft = new GeoVector(upperLeftOutline.getPosition().x - upperLeftFigure.getPosition().x, 0.0);
        GeoVector moveRight = new GeoVector(lowerRightOutline.getPosition().x - lowerRightFigure.getPosition().x, 0.0);
        GeoVector moveUp = new GeoVector(0.0, upperLeftOutline.getPosition().y - upperLeftFigure.getPosition().y);
        GeoVector moveDown = new GeoVector(0.0, lowerRightOutline.getPosition().y - lowerRightFigure.getPosition().y);
        ArrayList<IPMPointRW> upperPoints = new ArrayList<IPMPointRW>();
        Check upperPointCheck = new Check(){

            @Override
            public boolean check(IPMPointRW toBeRemovedPoint, IPMPointRW nextPoint) {
                return nextPoint.getPosition().y - 1.0E-10 < toBeRemovedPoint.getPosition().y;
            }
        };
        ArrayList<IPMPointRW> leftPoints = new ArrayList<IPMPointRW>();
        Check leftPointCheck = new Check(){

            @Override
            public boolean check(IPMPointRW toBeRemovedPoint, IPMPointRW nextPoint) {
                return nextPoint.getPosition().x - 1.0E-10 < toBeRemovedPoint.getPosition().x;
            }
        };
        ArrayList<IPMPointRW> lowerPoints = new ArrayList<IPMPointRW>();
        Check lowerPointCheck = new Check(){

            @Override
            public boolean check(IPMPointRW toBeRemovedPoint, IPMPointRW nextPoint) {
                return nextPoint.getPosition().y + 1.0E-10 > toBeRemovedPoint.getPosition().y;
            }
        };
        ArrayList<IPMPointRW> rightPoints = new ArrayList<IPMPointRW>();
        Check rightPointCheck = new Check(){

            @Override
            public boolean check(IPMPointRW toBeRemovedPoint, IPMPointRW nextPoint) {
                return nextPoint.getPosition().x + 1.0E-10 > toBeRemovedPoint.getPosition().x;
            }
        };
        int i3 = 0;
        while (i3 < oldDataObjectFigure.getPointListRW().getPointCount()) {
            IPMPointRW currentPoint = oldDataObjectFigure.getPointListRW().getPointRW(i3);
            if (!moveUp.isZero()) {
                upperPoints.add(currentPoint);
                if (upperPoints.size() > 3) {
                    RAResizeDataObject.removeSmallest(upperPoints, upperPointCheck);
                }
            }
            if (!moveLeft.isZero()) {
                leftPoints.add(currentPoint);
                if (leftPoints.size() > 2) {
                    RAResizeDataObject.removeSmallest(leftPoints, leftPointCheck);
                }
            }
            if (!moveDown.isZero()) {
                lowerPoints.add(currentPoint);
                if (lowerPoints.size() > 2) {
                    RAResizeDataObject.removeSmallest(lowerPoints, lowerPointCheck);
                }
            }
            if (!moveRight.isZero()) {
                rightPoints.add(currentPoint);
                if (rightPoints.size() > 3) {
                    RAResizeDataObject.removeSmallest(rightPoints, rightPointCheck);
                }
            }
            ++i3;
        }
        assert (upperPoints.size() == 3 || upperPoints.size() == 0) : "upper point list doesn't have 3 elements";
        assert (leftPoints.size() == 2 || leftPoints.size() == 0) : "left point list doesn't have 2 elements";
        assert (lowerPoints.size() == 2 || lowerPoints.size() == 0) : "lower point list doesn't have 2 elements";
        assert (rightPoints.size() == 3 || rightPoints.size() == 0) : "right point list doesn't have 3 elementsd";
        HashMap<IPMPointRW, Point> newPoints = new HashMap<IPMPointRW, Point>(10);
        ArrayList<Tuple> modifyPointsTuples = new ArrayList<Tuple>(4);
        modifyPointsTuples.add(new Tuple(upperPoints, (Object)moveUp));
        modifyPointsTuples.add(new Tuple(leftPoints, (Object)moveLeft));
        modifyPointsTuples.add(new Tuple(lowerPoints, (Object)moveDown));
        modifyPointsTuples.add(new Tuple(rightPoints, (Object)moveRight));
        for (Tuple tuple : modifyPointsTuples) {
            List pointList = (List)tuple.getT1();
            GeoVector direction = (GeoVector)tuple.getT2();
            if (direction.isZero()) continue;
            for (IPMPointRW currentPoint : pointList) {
                Point newPoint = (Point)newPoints.get(currentPoint);
                if (newPoint == null) {
                    newPoint = new Point(currentPoint.getPosition().x, currentPoint.getPosition().y);
                }
                newPoint = newPoint.movePoint(direction);
                newPoints.put(currentPoint, newPoint);
            }
        }
        for (Map.Entry entry : newPoints.entrySet()) {
            GeoVector vector = new GeoVector(((IPMPointRW)entry.getKey()).getPosition(), (Point)entry.getValue());
            ACMovePoint moveUpper = new ACMovePoint(actionContext, (IPMPointRW)entry.getKey(), vector, false);
            actions.addAction((Action)moveUpper);
        }
        GeoVector geoVector = GeoVector.add((GeoVector)moveUp, (GeoVector)moveRight);
        if (!geoVector.isZero()) {
            IPMFigureLineShapeRW oldEdgeFigure = ((IPMPlanElementBPMNBPDDataObjectNewRW)outlineFigure.getPlanElementRW()).getEdgeFigureRW();
            assert (oldEdgeFigure != null) : "edge figure is null";
            int i4 = 0;
            while (i4 < oldEdgeFigure.getPointListRW().getPointCount()) {
                ACMovePoint moveEdge = new ACMovePoint(actionContext, oldEdgeFigure.getPointListRW().getPointRW(i4), geoVector, false);
                actions.addAction((Action)moveEdge);
                ++i4;
            }
        }
    }

    private static void removeSmallest(List<IPMPointRW> pointList, Check check) {
        IPMPointRW toBeRemovedPoint = pointList.get(0);
        int toBeRemovedIndex = 0;
        int index = 1;
        while (index < pointList.size()) {
            IPMPointRW nextPoint = pointList.get(index);
            if (!check.check(toBeRemovedPoint, nextPoint)) {
                toBeRemovedPoint = nextPoint;
                toBeRemovedIndex = index;
            }
            ++index;
        }
        pointList.remove(toBeRemovedIndex);
    }

    private static interface Check {
        public boolean check(IPMPointRW var1, IPMPointRW var2);
    }
}

